#!/bin/sh

#############################################################################
#  Script Name : datarefresh.sh                                             #
#  Purpose     : This script is for refreshing cms data warehouse data      #
#                from CMS database.                                         #
#  Created by  : Suresh Neravati                                            #
#  Created on  : 07/26/2017                                                 #
#############################################################################

filetimestamp=$(date +%Y%m%d%H%M%S)
LOG_BASE=/opt/db/scripts/dwlogs
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
PGPD="${DB_ADMIN_PW:-n2bbsys}"
DB_TYPE="${DB_TYPE:-postgres}"
DB_VER="${DB_VERSION:-9.5}"
PSQLHOME="/usr/pgsql-${DB_VER}/bin"
DB_NAME="ttv"
SUSER="wfsdw"
HOST_NAME="${HOST_NAME:-dbserver}"
PGP="wfsdw"
AZURE_DB="${AZURE_DB:-edb1}"

if [ "X${DB_TYPE}" = "X" ]; then
     SUSR="postgres"
elif [ "X${DB_TYPE}" = "Xpostgres" ]; then
     SUSR="postgres"
elif [ "X${DB_TYPE}" = "Xedb" ]; then
     SUSR="edb"
elif [ "X${DB_TYPE}" = "Xazure" ]; then
     SUSR="postgres@$AZURE_DB"
     SUSER="wfsdw@$AZURE_DB"
fi
PORT=${DB_PORT:-5432}
NODE_NUM=$(/opt/puppetlabs/bin/facter node.cname | sed "s/app//g")
if ! [[ "${NODE_NUM}" =~ ^[0-9]+$ ]] ; then
  echo "Error: NODE_NUM is not a number, not calculated correctly. Exiting the script..." 
  exit 1
fi

SLP_TIME=$(PGPASSWORD=${PGP} ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "SELECT max(trunc(random() * 9 * 2 * $NODE_NUM + 1)) FROM generate_series(1,5);" | sed 's/^ *//')
PGPASSWORD=${PGPD} ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSR} -q -t -c "select pg_sleep(${SLP_TIME});"
if [ ! -d "$LOG_BASE" ]; then
   echo -e "\nCreating log directory for ETL job logs ....\n "
   mkdir -p $LOG_BASE
   chown nobody.nobody $LOG_BASE
fi
(
echo -e "\n**************************************************************"
echo " Data warehouse ETL script started at $(date)"
echo -e "**************************************************************\n"
CHECK_CNT=$(PGPASSWORD=${PGPD} ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSR} -q -t -c "select count(*) from pg_stat_activity where upper(query) like '%LOADDATA%' and query not like '%pg_stat_activity%';" | sed 's/^ *//')
if [ ${CHECK_CNT} -eq 1 ] ; then
   echo -e "\nThe data warehouse datarefesh script is already running.  You can not run the script again.\n"
   exit 1
fi
echo -e "\nRefreshing Data Warehouse Database DIM and FACT Tables with Production Database Data. PLEASE WAIT!\n"
PGPASSWORD=${PGP} ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} << EOM
set work_mem='2GB'; select case when wfsdw.funcmd_loaddata()=0 then 'successful' else 'failed' end as "RETURN STATUS"; 
EOM

echo -e "\nWarehouse data refresh completed.\n"
#Delete log files older than 30 days
find $LOG_BASE/*.log -mtime +30 -exec rm {} \;

echo -e "\n**************************************************************"
echo " Script ended at $(date)"
echo -e "**************************************************************\n"
) 2>&1 | tee $LOG_BASE/DRLog_$filetimestamp.log

if grep -q "failed\|ERROR\|SP2-\|Permission denied\|SQL-\|Warning" $LOG_BASE/DRLog_$filetimestamp.log
then
    mv $LOG_BASE/DRLog_$filetimestamp.log $LOG_BASE/DRLog_${filetimestamp}_error.log
fi
exit 0