\set VERBOSITY terse
CREATE OR REPLACE FUNCTION SP_FILLDATE() RETURNS smallint AS $func_SpFillDate$ 
DECLARE
     vDate    date ;
     endDate  date ;
     rec_cnt  numeric(10);
BEGIN
  select date '1990-01-01' into vDate;
  select date '2050-12-31' into endDate;
  SELECT count(*) INTO rec_cnt FROM WFSDW.DIM_DATE;
  IF rec_cnt = 0 THEN
     LOOP 
        INSERT INTO WFSDW.DIM_DATE (DATEWK, CALENDERDATE, DAYOFWEEKNAME,DAYOFWEEKNUM,
                                   DAYOFMONTH, WEEKOFYEAR, MONTHNAME, MONTHNUM,
                                   QUARTER,YEARNUM,CREATEDATE)
        VALUES( to_char(vDate,'YYYYMMDD')::numeric , vDate, to_char(vDate,'Day'), to_char(vDate, 'D')::numeric,
                to_char(vDate,'DD')::numeric, to_char(vDate,'WW')::numeric, to_Char(vDate,'Month'), to_char(vDate,'MM')::numeric,
                to_char(vDate, 'Q')::numeric, to_char(vDate, 'YYYY')::numeric, now() ); 
        IF vDate = endDate Then
            EXIT;
        END IF;
        vDate := vDate + 1;
    END LOOP;
    raise notice 'DIM_DATE Data Loaded successfully';
  END IF;
  RETURN 0;
EXCEPTION
   WHEN others THEN
        raise notice '% - Wrong Date format please check the parameters',sqlerrm;
        RETURN 1;
END;
$func_SpFillDate$ LANGUAGE plpgsql;

DO $$declare
   results    smallint;
begin
   select WFSDW.SP_FILLDATE() into results;
end$$;


CREATE OR REPLACE FUNCTION SP_FILLTIME() RETURNS smallint AS $func_SpFillTime$ 
DECLARE
     vTime    timestamp;
     endTime  timestamp;
     rec_cnt  numeric(10);
BEGIN
  select timestamp '1990-01-01 00:00:00' into vTime;
  select timestamp '1990-01-01 23:59:59' into endTime;
  SELECT count(*) INTO rec_cnt FROM WFSDW.DIM_TIME;
  IF rec_cnt = 0 THEN
     LOOP
        INSERT INTO WFSDW.DIM_TIME (TIMEWK,
                              TIMEOFDAY,
                              STANDARDDISPLAY,
                              MILITARYDISPLAY,
                              STANDARDHOUR,
                              MILITARYHOUR,
                              MERIDIAN,
                              MINUTES,
                              MINUTESAFTERMIDNIGHT,
                              SECONDS,
                              SECONDSINHOUR,
                              SECONDSAFTERMIDNIGHT,
                              CREATEDATE)
        VALUES( to_Char(vTime,'HH24MISS')::numeric ,
                vTime,
                to_char(vTime,'HH:MI:SS AM'),
                to_char(vTime, 'HH24:MI:SS'),
                to_char(vTime,'HH')::numeric,
                to_char(vTime,'HH24')::numeric,
                to_Char(vTime,'AM'),
                to_char(vTime,'MI')::numeric,
                (to_char(vTime, 'HH24')::numeric * to_char(vTime, 'MI')::numeric),
                to_char(vTime, 'SS')::numeric,
                (to_char(vTime, 'MI')::numeric * to_char(vTime, 'SS')::numeric),
                (to_char(vTime, 'HH24')::numeric * to_char(vTime, 'MI')::numeric * to_char(vTime, 'SS')::numeric),
                now()); 
        IF vTime = endTime Then
            EXIT;
        END IF;
        SELECT vTime + interval '1 second' INTO vTime;
    END LOOP;
    raise notice 'DIM_TIME Data Loaded successfully';
  END IF;
  RETURN 0;
EXCEPTION
   WHEN others THEN
        raise notice '% - Wrong Time format please check the parameters',sqlerrm;
        RETURN 1;
END;
$func_SpFillTime$ LANGUAGE plpgsql;

DO $$declare
   results    smallint;
begin
   select WFSDW.SP_FILLTIME() into results;
end$$;



CREATE OR REPLACE FUNCTION SP_FILLMONTH() RETURNS smallint AS $func_SpFillMonth$
DECLARE
     rec_cnt  numeric(10);
BEGIN
  SELECT count(*) INTO rec_cnt FROM WFSDW.DIM_MONTH;
  IF rec_cnt = 0 THEN
    INSERT INTO WFSDW.DIM_MONTH(MonthWK, MonthName, MonthNum, Quarter, YearNum, CreateDate)
    SELECT to_Char(CalenderDate,'YYYYMM')::numeric , MonthName, MonthNum, Quarter, YearNum, now()
      FROM WFSDW.DIM_DATE
     GROUP BY to_Char(CalenderDate,'YYYYMM'), MonthName, MonthNum, Quarter, YearNum;
    raise notice 'DIM_MONTH Data Loaded successfully';
  END IF;
  RETURN 0;
EXCEPTION
   WHEN others THEN
        raise notice '% - Wrong Time format please check the parameters',sqlerrm;
        RETURN 1;
END;
$func_SpFillMonth$ LANGUAGE plpgsql;

DO $$declare
   results    smallint;
begin
   select WFSDW.SP_FILLMONTH() into results;
end$$;

