#!/bin/sh
#########################################################################################################################
#  Schema Name:    wfsdw                                                                                                #
#  Script purpose: Create the wfsdw schema database objects like                                                        #
#                  tables, views, sequences, triggers and constraints etc.                                              #
#                                                                                                                       #
#  Created by:     Suresh Neravati 11/3/2016                                                                            #
#  NOTE:           This script is converted from cms5.2 edb script to cms6.0 Postgresql format.                         #
#                                                                                                                       #
#  Modifications:                                                                                                       #
#  CMSVer     DWDBVer       ModifiedBy         ModifiedDate    Details                                                  #
#  ------   -----------     -------------      ------------   -------                                                   #
#  6.0        6.0.0         Suresh Neravati    11/03/2016      Converted script from Enterprisedb to Postgresql format. #
#  6.1        6.1.0         Suresh Neravati    12/12/2017      Refactored ETL script for better exception handling      # 
#  7.0        7.0.0         Suresh Neravati    03/16/2018      Converted script from edb to Postgresql10.               #
#  7.2        7.2.0         Bo                 06/25/2019      Support azure db Installation                            #
#########################################################################################################################
#HOST_NAME=`hostname`
CURRENT_PATH=`pwd`
DB_NAME=$1
HOST_NAME=$2
DB_TYPE=$3
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
PGPD="${DB_ADMIN_PW:-n2bbsys}"
PGP="wfsdw"
DB_TYPE="${DB_TYPE:-postgres}"
DB_VER="${DB_VERSION:-9.5}"
PSQLHOME="/usr/pgsql-${DB_VER}/bin"
SSCHEMA="wfs"
DW_DBVERSION="7.0.0"
AZURE_DB="${AZURE_DB:-edb1}"
DB_USER="wfsdw"
WFS_USER="wfs"

if [ "X$1" = "X"  ]; then
     DB_NAME="ttv"
fi
if [ "X$2" = "X"  ]; then
     HOST_NAME="${HOST_NAME:-dbserver}"
fi

SUDB="postgres"
SUSER="postgres"
SUSERTOGRANT="postgres"
if [ "X${DB_TYPE}" = "Xedb" ]; then
     SUDB="edb"
     SUSER="edb"
     SUSERTOGRANT="edb"
elif [ "X${DB_TYPE}" = "Xazure" ]; then
     SUSER="postgres@$AZURE_DB"
     DB_USER="wfsdw@$AZURE_DB"
     WFS_USER="wfs@$AZURE_DB"
fi
PORT=${DB_PORT:-5432}
export PGPASSWORD=${PGPD}

function create_cron()
{
   crontab -l >  ${CURRENT_PATH}/crontab_old
   grep -q "^.*datarefresh.*" ${CURRENT_PATH}/crontab_old
   if [ $? -ne 0 ]; then
      echo "Setting up cron job to refresh Data Warehouse, please wait...."
      sed "s/DB_NAME/${DB_NAME}/" < ${CURRENT_PATH}/crontabwfsdw.bak > ${CURRENT_PATH}/crontabwfsdw
      cat ${CURRENT_PATH}/crontabwfsdw >> ${CURRENT_PATH}/crontab_old
      crontab ${CURRENT_PATH}/crontab_old
      echo "Added the Warehouse ETL job to the crontab successfully....."
   fi
}

if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "SELECT count(*) from pg_tables where schemaname='wfsdw';" | sed 's/^ *//'` -gt 0 ]]; then
   echo -e "\nData Warehouse schema already exists...\n"
   export PGPASSWORD=${PGP};
   if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "SELECT COUNT(*) FROM WFSDW.SYSTEM_SETTINGS WHERE SETTING_TYPE='RELEASE' AND SETTING_VALUE='2.7';" | sed 's/^ *//'` -eq 1 ]]; then
      ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "ALTER TABLE WFSDW.SYSTEM_SETTINGS ADD COLUMN CREATEDATE TIMESTAMP(6) DEFAULT (CURRENT_TIMESTAMP) NOT NULL"
   fi
   export PGPASSWORD=${PGPD}
   DWDBVERSION=`${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "SELECT setting_value FROM WFSDW.SYSTEM_SETTINGS WHERE setting_type = 'RELEASE'"| sed 's/^ *//'`
   if [ "${DWDBVERSION}" = "${DW_DBVERSION}" ]; then
      echo -e "\nDW schema has no changes to upgrade.\n"
      create_cron
      exit 0
   else
      if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "SELECT count(*) FROM pg_roles WHERE rolname='wfs';"| sed 's/^ *//'` -eq 0 ]]; then
         echo -e "ERROR: Database ${DB_NAME} does not exists, run the installcms.sh script to create the cms database first."
         exit 1
      fi
      echo "Continueing the installation, please wait ......"
   fi
fi

if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "SELECT count(*) FROM pg_roles WHERE rolname='wfsdw';"| sed 's/^ *//'` -eq 0 ]]; then
   echo -e "\nCreating User wfsdw....\n"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "CREATE ROLE wfsdw;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "ALTER USER wfsdw PASSWORD 'wfsdw';"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "ALTER USER wfsdw with login;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "GRANT wfsdw TO ${SUSERTOGRANT};"
fi
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "select count(*) from information_schema.schemata where schema_name='wfsdw';"| sed 's/^ *//'` -eq 0 ]]; then
   echo -e "\nCreating Schema wfsdw....\n"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "CREATE SCHEMA wfsdw AUTHORIZATION wfsdw;"
fi
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "select count(*) from information_schema.schemata where schema_name='wfsdw';"| sed 's/^ *//'` -eq 0 ]]; then
   echo "wfsdw schema not exists, exiting the script....."
   exit 1
fi
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "GRANT create ON DATABASE "${DB_NAME}" TO wfsdw;"
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "GRANT all on schema wfsdw to wfsdw;"
echo -e "\n******* wfsdw schema created with permissions successfully *******\n"

PGPASSWORD="Wf\$1234" ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${WFS_USER} <<EOF
grant usage on schema wfs to wfsdw;
GRANT select, insert, update, delete on ${SSCHEMA}.install_table to wfsdw;
EOF

export PGPASSWORD=${PGP}
echo -e "\nCreating DW Schema Objects, please wait ....\n"
sh ${CURRENT_PATH}/createwfsdw.sh ${DB_NAME} ${CURRENT_PATH} ${HOST_NAME} ${PORT} ${SSCHEMA} ${PSQLHOME} ${DB_TYPE}
create_cron

exit 0