#!/bin/sh
##########################################################################
#   Script_name : masterportal.sh                                        #
#   Purpose     : creates database schema for Portal and its db objects  #
#   Created by  : Suresh Neravati                                        #
#   Created on  : 10/14/2016                                             #
##########################################################################
#INSTALL_DIR=`pwd`
INSTALL_DIR="$1"
DB_NAME=$2
HOST_NAME=$3
DB_TYPE=$4
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
PGPD="${DB_ADMIN_PW:-n2bbsys}"
PGP="portal1234"
DB_TYPE="${DB_TYPE:-postgres}"
DB_VER=${DB_VERSION:-9.5}
PSQLHOME="/usr/pgsql-${DB_VER}/bin"
AZURE_DB="${AZURE_DB:-edb1}"

if [ "X$2" = "X"  ]; then
     DB_NAME="ttv"
fi
if [ "X$3" = "X"  ]; then
     HOST_NAME="${HOST_NAME:-dbserver}"
fi
TBS_NAME="portal_data"

SUDB="postgres"
SUSER="postgres"
SUSERTOGRANT="postgres"
if [ "X${DB_TYPE}" = "Xedb" ]; then
     SUDB="edb"
     SUSER="edb"
     SUSERTOGRANT="edb"
elif [ "X${DB_TYPE}" = "Xazure" ]; then
     SUSER="postgres@$AZURE_DB"
fi
PORT=${DB_PORT:-5432}
export PGPASSWORD=${PGPD}
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "SELECT count(*) FROM pg_roles WHERE rolname='wfs';"| sed 's/^ *//'` -eq 0 ]]; then
   echo -e "ERROR: Database ${DB_NAME} does not exists, run the installcms.sh script to create the cms database first."
   exit 1
fi
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "SELECT count(*) FROM pg_roles WHERE rolname='portal';"| sed 's/^ *//'` -eq 0 ]]; then
   echo -e "\nCreating User portal....\n"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "CREATE ROLE portal;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "ALTER USER portal PASSWORD 'portal1234';"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "ALTER USER portal with login;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "GRANT portal TO ${SUSERTOGRANT};"
fi
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "select count(*) from information_schema.schemata where schema_name='portal';"| sed 's/^ *//'` -eq 0 ]]; then
   echo -e "\nCreating schema portal....\n"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "CREATE SCHEMA portal AUTHORIZATION portal;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "GRANT create ON DATABASE "${DB_NAME}" TO portal;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "GRANT all on schema portal to portal;"
   echo -e "\n******* portal schema created with permissions successfully *******\n"
fi
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "select count(*) from information_schema.schemata where schema_name='portal';"| sed 's/^ *//'` -eq 0 ]]; then
   echo "portal schema is not exists, exiting the script....."
   exit 1
fi
exit 0