#!/bin/bash
## Customer Defined Startup Parameters for CMS
TIMESTAMP=`date '+%y%m%d_%H%M%S'`
JBOSS_LOG="$JBOSS_HOME/standalone/log"
## The Complete Official List of Java Hotspot JVM Options for jdk 8: https://docs.oracle.com/javase/8/docs/technotes/tools/unix/java.html.

## Performance Options
# Notes: the -Xmx setting will be overridden by the memory profile of the current system
JAVA_OPTS="$JAVA_OPTS -Xmx4096m"										# Specifie the maximum size (in bytes) of the memory allocation pool in bytes.
#JAVA_OPTS="$JAVA_OPTS -Xms2048m"										# Sets the initial size (in bytes) of the heap.
#JAVA_OPTS="$JAVA_OPTS -Xmn1024m"										# Sets the initial and maximum size (in bytes) of the heap for the young generation (nursery).
#JAVA_OPTS="$JAVA_OPTS -XX:SurvivorRatio=8"								# Sets the ratio between eden space size and survivor space size.
JAVA_OPTS="$JAVA_OPTS -XX:MaxMetaspaceSize=512m"						# Specifie the maximum size (in bytes) of the meta space in bytes.
JAVA_OPTS="$JAVA_OPTS -XX:+UseLargePages"								# Enables the use of large page memory.
JAVA_OPTS="$JAVA_OPTS -XX:LargePageSizeInBytes=2m"						# Sets the large page size used for the Java heap.

## Garbage First (G1) Garbage Collection Options
JAVA_OPTS="$JAVA_OPTS -XX:+UseG1GC"										# Enables the use of the garbage-first (G1) garbage collector.
#JAVA_OPTS="$JAVA_OPTS -XX:MaxGCPauseMillis=200"						# Sets a target value for desired maximum pause time. The default value is 200 milliseconds.
#JAVA_OPTS="$JAVA_OPTS -XX:G1HeapRegionSize=n"							# Sets the size of a G1 region. The value will be a power of two and can range from 1MB to 32MB. The goal is to have around 2048 regions based on the minimum Java heap size.
#JAVA_OPTS="$JAVA_OPTS -XX:G1NewSizePercent=5"							# Sets the percentage of the heap to use as the minimum for the young generation size.
#JAVA_OPTS="$JAVA_OPTS -XX:G1MaxNewSizePercent=60"						# Sets the percentage of the heap size to use as the maximum for young generation size.
#JAVA_OPTS="$JAVA_OPTS -XX:InitiatingHeapOccupancyPercent=45"			# Sets the Java heap occupancy threshold that triggers a marking cycle.  
#JAVA_OPTS="$JAVA_OPTS -XX:G1ReservePercent=10"							# Sets the percentage of reserve memory to keep free so as to reduce the risk of to-space overflows.
#JAVA_OPTS="$JAVA_OPTS -XX:G1MixedGCLiveThresholdPercent=65"			# Sets the occupancy threshold for an old region to be included in a mixed garbage collection cycle.

### Debugging Options

#JAVA_OPTS="$JAVA_OPTS -verbose:class"									# Displays information about each loaded class.	
#JAVA_OPTS="$JAVA_OPTS -XX:NativeMemoryTracking=detail"					# Specifies the mode for tracking JVM native memory usage.

## Heap Dump
JAVA_OPTS="$JAVA_OPTS -XX:HeapDumpPath=$JBOSS_LOG/HEAP_$TIMESTAMP.log"	# Path and file name for writing the heap dump provided by the heap profiler (HPROF).
JAVA_OPTS="$JAVA_OPTS -XX:+HeapDumpOnOutOfMemoryError"					# Dump heap to file when java.lang.OutOfMemoryError is thrown.

## GC Logs
JAVA_OPTS="$JAVA_OPTS -verbose:gc"										# Displays information about each garbage collection (GC) event.
JAVA_OPTS="$JAVA_OPTS -Xloggc:$JBOSS_LOG/GC_$TIMESTAMP.log"				# Sets the file to which verbose GC events information should be redirected for logging. This option overrides -verbose:gc if both are given on the command line.
JAVA_OPTS="$JAVA_OPTS -XX:+PrintGC"										# Enables printing of messages at every GC
JAVA_OPTS="$JAVA_OPTS -XX:+PrintGCDetails"								# Enables printing of detailed messages at every GC.
JAVA_OPTS="$JAVA_OPTS -XX:+PrintGCDateStamps"							# Enables printing of a date stamp at every GC. Use "-XX:+PrintGCTimeStamps" to time stamps only
#JAVA_OPTS="$JAVA_OPTS -XX:+PrintAdaptiveSizePolicy"					# Enables printing of information about adaptive generation sizing.
#JAVA_OPTS="$JAVA_OPTS -XX:+PrintTenuringDistribution"					# Enables printing of tenuring age information.
#JAVA_OPTS="$JAVA_OPTS -XX:+PrintGCApplicationStoppedTime"				#Enables printing of how much time the pause (for example, a GC pause) lasted. By default, this option is disabled.
#JAVA_OPTS="$JAVA_OPTS -XX:+PrintGCApplicationConcurrentTime"			#Enables printing of how much time elapsed since the last pause (for example, a GC pause). By default, this option is disabled.
#JAVA_OPTS="$JAVA_OPTS -XX:-PrintCommandLineFlags"						#Enables printing of ergonomically selected JVM flags that appeared on the command line.

# Log File Rotation
#JAVA_OPTS="$JAVA_OPTS -XX:+UseGCLogFileRotation"						# Prevent large gclog file for long running app. Requires -Xloggc:<filename>
#JAVA_OPTS="$JAVA_OPTS -XX:NumberOfGCLogFiles=10"						# Number of gclog files in rotation. Only valid with UseGCLogFileRotation.
#JAVA_OPTS="$JAVA_OPTS -XX:GCLogFileSize=100M"							# GC log file size, Default: Only valid with UseGCLogFileRotation.


## Behavioral Options
JAVA_OPTS="$JAVA_OPTS -XX:StackShadowPages=20"							# Sets the Number of shadow zone (for overflow checking).


## Database Connectors
JAVA_OPTS="$JAVA_OPTS -Dhibernate.dialect=org.hibernate.dialect.PostgreSQLDialect"      # PostgreSQL


## JacORB Configuration Options
JAVA_OPTS="$JAVA_OPTS -Djacorb.connection.server.keepalive=true"		# The property is used to enable SO_KEEPALIVE on server sockets.

export JAVA_OPTS