#!/bin/bash

DB_SETTINGS="/opt/db/scripts/install/settings"

if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi

SUDB="postgres"
SUSER="${DB_USER:-postgres}"
DB_VER="${DB_VERSION:-10}"
PSQLHOME="/usr/pgsql-${DB_VER}/bin"
PORT=${DB_PORT:-5432}
DB_TYPE="${DB_TYPE:-postgres}"
AZURE_DB="${AZURE_DB:-edb1}"

if [ "X${DB_TYPE}" = "Xedb" ]; then
     SUDB="edb"
     SUSER="edb"
     SUSERTOGRANT="edb"
elif [ "X${DB_TYPE}" = "Xazure" ]; then
     SUSER="postgres@$AZURE_DB"
     DB_USER="wfsdw@$AZURE_DB"
     WFS_USER="wfs@$AZURE_DB"
fi

dbserver_check() {
    if [[ -f "${PSQLHOME}/psql" ]] ; then
        local count=0
        local delay=1
        local timeout=600
        local dbstate=1
        printf "  Checking Database..."
        while [[ $count -le $timeout && $dbstate > 0 ]] ; do
            sleep $delay
            `PGPASSWORD=${DB_ADMIN_PW:-'n2bbsys'} ${PSQLHOME}/psql -d ${SUDB} -U ${SUSER} -h dbserver -p ${PORT} -c "select now()" >  /dev/null 2>&1`
            dbstate=`echo $?`
            if [[ $count -ge $timeout && $dbstate > 0 ]]; then
                echo "Failed: Unable to connect to the Database after $timeout Seconds"
                exit 1
            elif [[ $? > 0 ]]  ; then
                printf "."
                count=$(( $count + $delay ))
            else
                count=$(( $count + $timeout ))
            fi
        done
        printf "\n"

        nslookup db2 > /dev/null
        if [ $? -eq 0 ]; then
            local repchk_cnt=0
            local repchk_delay=1
            local repchk_timeout=600
            local repchk_dbstate=""
            printf "  Checking Database Replication status..."
            while [[ $repchk_cnt -le $repchk_timeout && $repchk_dbstate != "streaming" ]] ; do
                sleep $repchk_delay
                repchk_dbstate=$( PGPASSWORD=${DB_ADMIN_PW:-'n2bbsys'} ${PSQLHOME}/psql -d ${SUDB} -U ${SUSER} -h dbserver -p ${PORT} -q -t -c "select distinct state from pg_stat_replication;"| sed 's/^ *//' ) 
                if [[ $repchk_cnt -ge $repchk_timeout && ${repchk_dbstate} != "streaming" ]]; then
                    echo "Failed: Database streaming is not found, exiting the script after ${repchk_timeout} seconds delay..."
                    exit 1
                elif [[ ${repchk_dbstate} != "streaming" ]]  ; then
                    printf "."
                    repchk_cnt=$(( $repchk_cnt + $repchk_delay ))
                else
                    repchk_cnt=$(( $repchk_cnt + $repchk_timeout ))
                fi
            done
            printf "\n"
        fi

    else
        echo "Warning: psql missing from appliance, continuing to start cms"
    fi
}

es_check() {
    printf "  Checking Elasticsearch..."
    local time=0
    local timeout=300
    while [ "$(curl -s -o /dev/null -w '%{http_code}' http://es-nodes.service.consul:9200/)" != "200" ]; do
        if [ $time -gt $timeout ] ; then
            echo "Failed: Could not connect to Elasticsearch after $timeout seconds. Aborting"
            exit 1
        fi
        sleep 10
        time=$((time + 10))
        printf "."
    done
    printf "\n"
}

# Run EPG SQL setup script
pgsql_load_epg() {
    if [[ -f /opt/db/scripts/install/installepg/installepgmgr.sh ]]; then
        echo -e "  Running Database EPG setup script... "
        cd /opt/db/scripts/install/installepg
        sh installepgmgr.sh
        if [[ $? -gt 0 ]]; then
            exit 1
        fi
    else
        echo "Failed: Unable to find the Database EPG setup script."
        exit 1
    fi
}

# Run Portal SQL setup script
pgsql_load_portal() {
    if [[ -f /opt/db/scripts/install/installportal/installportal.sh ]]; then
        echo -e "  Running Database Portal setup script... "
        cd /opt/db/scripts/install/installportal
        sh installportal.sh
        if [[ $? -gt 0 ]]; then
            exit 1
        fi
    else
        echo "Failed: Unable to find the Database Portal setup script."
        exit 1
    fi
}

# Run Portal SQL setup script
pgsql_load_dw() {
    if [[ -f /opt/db/scripts/install/installdw/installdw.sh ]]; then
        echo -e "  Running Database Data Warehouse setup script... "
        cd /opt/db/scripts/install/installdw
        sh installdw.sh
        if [[ $? -gt 0 ]]; then
            exit 1
        fi
    else
        echo "Failed: Unable to find the Database Data Warehouse setup script."
        exit 1
    fi
}

# Run CMS SQL setup script
pgsql_load_cms() {
    if [[ -f /opt/db/scripts/install/installcms/installcms.sh ]]; then
        echo -e "  Running Database CMS setup script... "
        cd /opt/db/scripts/install/installcms
        sh installcms.sh
        if [[ $? -gt 0 ]]; then
            exit 1
        else
            pgsql_load_epg
            pgsql_load_portal
            pgsql_load_dw
        fi
    else
        echo "Failed: Unable to find the Database CMS setup script."
        exit 1
    fi
}

# Run CMS ES setup script
es_load_cms() {
    if [[ -f /opt/tandbergtv/cms/scripts/sync_utils/bin/create_elasticsearch_indices.sh ]]; then
        echo -e "  Running CMS Elasticsearch Indices setup script... "
        cd /opt/tandbergtv/cms/scripts/sync_utils/bin/
        sh create_elasticsearch_indices.sh -a -i cms
        if [[ $? -gt 0 ]]; then
            echo "Failed: An issue occurred while creating CMS Elasticsearch Indices."
            exit 1
        else
            echo -e "Success\n"
        fi
    else
        echo "Failed: Unable to find the CMS Elasticsearch Indices setup script."
        exit 1
    fi
}

consul_register() {
	/usr/bin/consul-register cms -t service -p 8443 --http http://localhost:8080/services/cms/health --script '/usr/bin/systemctl status cms' --tcp localhost:8443
    #Fileuploader change port from 8080 to 8081 in CMS 7.1
	if [[ $(jq -r .cms.has_ct /opt/cms/staging/config/cms.json) != true ]]; then
    	/usr/bin/consul-register-check fileuploader http http://localhost:8081/fileuploader/health -a cms
	fi
}

azure_support() {
#To support db connection on azure platform
check_db_type=$(awk -F '=' '{if($1 == "DB_TYPE")print $2}' $DB_SETTINGS)
check_azure_dbname=$(awk -F '=' '{if($1 == "AZURE_DB")print $2}' $DB_SETTINGS)
if [ x"$check_db_type" == xazure ] && [ ! -z $check_azure_dbname ];then
   sed -i "s@<user-name>wfs</user-name>@<user-name>wfs\@"$check_azure_dbname"</user-name>@g" /opt/tandbergtv/cms/conf/jboss/standalone.xml
   sed -i "s@<user-name>epgmanager</user-name>@<user-name>epgmanager\@"$check_azure_dbname"</user-name>@g" /opt/tandbergtv/cms/conf/jboss/standalone.xml
   echo "DB Accounts will be change to wfs@HOSTNAME format to support azure DB"
fi
}

azure_support
dbserver_check
pgsql_load_cms
es_check
es_load_cms
consul_register
