# Parameters: none
#
# Actions:
#
# Requires: see Modulefile
#
##############################################

class services::adiserver {
  if $node['clustergroup'] == 'app' {
    if $cms['has_ct'] != true {
      notify {"Starting ADI Server":}
      ->
      exec { "register-adiserver":
        command => "/usr/bin/consul-register adiserver -t service --script '/usr/bin/systemctl status adiserver'",
        logoutput => true,
      }
      ->
      service { 'adiserver':
        ensure => running,
        enable => true,
      }
    }
  }
  if $node['clustergroup'] == 'ct' {
      notify {"Starting ADI Server":}
      ->
      exec { "register-adiserver":
        command => "/usr/bin/consul-external-register -s adiserver ${node['cname']} ${cms['configname']} ${networking['ip']} --http http://${networking['ip']}:8081/servicecheck/adiserver/health -c http://watchpoint-app:8501",
        logoutput => true,
       }
      ->
      service { 'adiserver':
          ensure => stopped,
          enable => true,
      }
    }
}