# Class: starting_cms 
#
# This module manages starting cms services
#
# Parameters: none
#
# Actions:
#
# Requires: see Modulefile
#
##############################################

class services::cms {
  notify {"Loading CMS":}
    ->
  exec { 'update-portal-config':
    onlyif => "/usr/bin/test -f /opt/tandbergtv/cms/scripts/portal/portal-support.sh",
    command => '/bin/bash /opt/tandbergtv/cms/scripts/portal/portal-support.sh',
    logoutput => true,
  }

  ->
  exec { "upgrade-cms-standalone.xml":
    command   => "/usr/bin/python /opt/tandbergtv/cms/scripts/upgrade/cms-standalone-xml-upgrade.py",
    logoutput => true,
    timeout   => 0,
    user      => 'nobody',
    group     => 'nobody',
  }
  ->
  exec { "load-cms":
    command   => "/bin/bash /etc/puppetlabs/code/modules/services/files/load_cms.sh",
    logoutput => true,
    timeout   => 0,
  }
  ->
  notify {"Starting CMS":}
  ->
  if ($cms['has_ct'] == true) {
      service { 'cms':
        ensure => stopped,
        enable => true,
      }
  }
  else {
      service { 'cms':
        ensure => running,
        enable => true,
      }
  }
}