# Class: starting_cms 
#
# This module manages starting cms services
#
# Parameters: none
#
# Actions:
#
# Requires: see Modulefile
#
##############################################

class services::cmstomcat {
  if $node['clustergroup'] != 'ct' {
    if $cms['has_ct'] != true {
      notify {"Starting Tomcat":}
  
      exec { 'Remove cmstomcat initV file if systemd file exist':
        onlyif  => '/usr/bin/test -e /etc/systemd/system/cmstomcat.service',
        command => '/usr/bin/rm -f /etc/init.d/cmstomcat',
        logoutput => true,
      }
      
      exec { 'expand-prepack':
        onlyif => "/usr/bin/test -f /opt/tandbergtv/cms/scripts/prepack-scripts/cluster_expand.sh",
        command => '/bin/bash /opt/tandbergtv/cms/scripts/prepack-scripts/cluster_expand.sh',
        logoutput => true,
        notify => Service['cmstomcat'],
      }
  
      exec { "register-cmstomcat":
        command => "/usr/bin/consul-register cmstomcat -t service -p 8081 --script '/usr/bin/systemctl status cmstomcat' --tcp localhost:8081",
        logoutput => true,
      }
  
      exec { "register-watchfolder":
        command => "/usr/bin/consul-register-check watchfolder http http://localhost:8081/watchfolder/health -a cmstomcat",
        logoutput => true,
      }
      
      #Fileuploader in APP node is registered as a consul check in load_cms.sh
      
      service { 'cmstomcat': 
        ensure => running,
        enable => true,
      }
    }
  }
  else {
    notify {"Starting Tomcat on CT node":}
    
    exec { 'expand-prepack':
      onlyif => "/usr/bin/test -f /opt/tandbergtv/cms/scripts/prepack-scripts/cluster_expand.sh",
      command => '/bin/bash /opt/tandbergtv/cms/scripts/prepack-scripts/cluster_expand.sh',
      logoutput => true,
      notify => Service['cmstomcat'],
    }
    
    exec { "register-cmstomcat":
      command => "/usr/bin/consul-external-register -s cmstomcat ${node['cname']} ${cms['configname']} ${networking['ip']} --tcp ${networking['ip']}:8081 -c http://watchpoint-app:8501",
      logoutput => true,
    }

    exec { "register-watchfolder":
      command => "/usr/bin/consul-external-register -s watchfolder ${node['cname']} ${cms['configname']} ${networking['ip']} --http http://${networking['ip']}:8081/watchfolder/health -c http://watchpoint-app:8501",
      logoutput => true,
    }

    exec { "register-fileuploader":
      command => "/usr/bin/consul-external-register -s fileuploader ${node['cname']} ${cms['configname']} ${networking['ip']} --http http://${networking['ip']}:8081/fileuploader/health -c http://watchpoint-app:8501",
      logoutput => true,
    }

    service { 'cmstomcat': 
      ensure => stopped,
      enable => true,
    }      
  }  
}