# Class: starting_cms
#
# This module manages starting cms services
#
# Parameters: none
#
# Actions:
#
# Requires: see Modulefile
#
##############################################

class services::rabbitmq {
  notify {"Creating config files":}

  exec { 'create-rabbitmq-config-file':
    command => '/etc/rabbitmq/scripts/create_env_conf.sh',
    timeout   => 0,
    logoutput => true,
  }

  exec { 'make sure /etc/rabbitmq is owned by rabbitmq user':
    command => '/usr/bin/chown -R rabbitmq:rabbitmq /etc/rabbitmq',
    timeout   => 0,
    logoutput => true,
  }

  notify {"Starting RabbitMQ Server":}

  service { 'rabbitmq-server':
    enable => true,
  }

  exec { 'rabbitmq-daemon-reload':
    command   => '/usr/bin/systemctl daemon-reload',
    timeout   => 0,
    logoutput => true,
  }

  exec { 'start-rabbitmq-server':
    command   => '/usr/bin/systemctl restart rabbitmq-server &',
    timeout   => 0,
    logoutput => true,
  }
  
  exec { 'register-rabbitmq-server':
    command => "/usr/bin/consul-register rabbitmq-server -t service -p 5672 --script '/usr/bin/systemctl status rabbitmq-server' --tcp localhost:5672 --tcp localhost:15672 --tcp localhost:25672",
    logoutput => true,
  }    
  
  exec { 'register-rabbitmq-cluster':
    command   => "/usr/bin/consul-register rabbitmq-cluster --script '/opt/consul/scripts/rabbitmq_consul_reg.py'",
    logoutput => true,
  }    

}

