# Class: starting_cms 
#
# This module manages starting cms services
#
# Parameters: none
#
# Actions:
#
# Requires: see Modulefile
#
##############################################

class services::snmp_subagent {
  notify {"Starting SNMPD":}
    
  exec { 'start-snmpd':
    command => '/sbin/service snmpd restart',
    timeout => '60',
  } 
  ->
  notify {"Starting CMS SNMP Subagent":}
  ->
  exec { 'start-cms-snmp-subagent':
    command => '/sbin/service cms-snmp-subagent restart',
    timeout => '60',
  } 
  ->
  service { 'cms-snmp-subagent': 
    ensure => running,
    enable => true,
  }
  
  exec { 'register-cms-snmp-subagent':
    command => "/usr/bin/consul-register cms-snmp-subagent -t service --script '/usr/bin/systemctl status cms-snmp-subagent'",
    logoutput => true,
  }    

}