# Class: starting_cms 
#
# This module manages starting cms services
#
# Parameters: none
#
# Actions:
#
# Requires: see Modulefile
#
##############################################

class services::workflow {
  notify {"Loading Workflow":}
  ->
  exec { "upgrade-workflow-standalone.xml":
    command   => "/usr/bin/python /opt/tandbergtv/cms/scripts/upgrade/workflow-standalone-xml-upgrade.py",
    user      => "nobody",
    logoutput => true,
    timeout   => 0,
  }
  ->
  exec { "load-workflow":
    command   => "/bin/bash /etc/puppetlabs/code/modules/services/files/load_workflow.sh",
    logoutput => true,
    timeout   => 0,
  }
  ->
  notify {"Starting Workflow":}
  ->
  if ($cms['has_ct'] == true) {
     service { 'workflow':
       ensure => stopped,
       enable => true,
     }
  }
  else {
     service { 'workflow': 
       ensure => running,
       enable => true,
     } 
  }
}
