# Class: starting_cms 
#
# This module manages starting cms services
#
# Parameters: none
#
# Actions:
#
# Requires: see Modulefile
#
##############################################

class services::xportmanager {
  if $node['clustergroup'] != 'ct' {
    if $cms['has_ct'] != true {
      notify {"Starting Xport Manager":}

      exec { 'Remove xportmanager initV file if systemd file exist':
        onlyif  => '/usr/bin/test -e /etc/systemd/system/xportmanager.service',
        command => '/usr/bin/rm -f /etc/init.d/xportmanager',
        logoutput => true,
      }
      
      exec { 'start-xportmanager':
        unless => "/usr/bin/pgrep -f 'xport/manager'",
        command => '/sbin/service xportmanager restart',
      }

      service { 'xportmanager':
        ensure => running,
        enable => true,
      }
  
      exec { 'register-xportmanager':
        command => "/usr/bin/consul-register xportmanager -t service -p 5112 --script '/usr/bin/systemctl status xportmanager' --tcp localhost:5112",
        logoutput => true,
      } 
    }
  }
  else {
    notify {"Starting Xport Manager on CT node":}

    exec { 'start-xportmanager':
      unless => "/usr/bin/pgrep -f 'xport/manager'",
      command => '/sbin/service xportmanager restart',
    }

    service { 'xportmanager':
      ensure => stopped,
      enable => true,
    }  

    exec { "register-xportmanager":
      command => "/usr/bin/consul-external-register -s xportmanager ${node['cname']} ${cms['configname']} ${networking['ip']} --http http://${networking['ip']}:8081/servicecheck/xportmanager/health -f 120s -c http://watchpoint-app:8501",
      logoutput => true,
    }
  }   
}
