# Class: starting_cms 
#
# This module manages starting cms services
#
# Parameters: none
#
# Actions:
#
# Requires: see Modulefile
#
##############################################

class services::xporttomcat {
  if $node['clustergroup'] != 'ct' {
    if $cms['has_ct'] != true {
      notify {"Starting Xport-Tomcat":}
    
      exec { 'Remove xporttomcat initV file if systemd file exist':
        onlyif  => '/usr/bin/test -e /etc/systemd/system/xporttomcat.service',
        command => '/usr/bin/rm -f /etc/init.d/xporttomcat',
        logoutput => true,
      }
      
      exec { 'start-xporttomcat':
        unless => "/usr/bin/pgrep -f 'xport/tomcat'",
        command => '/sbin/service xporttomcat restart',
      } 
    
      service { 'xporttomcat':
        ensure => running,
        enable => true,
      }
      
      exec { 'register-xporttomcat':
        command => "/usr/bin/consul-register xporttomcat -t service -p 8601 --script '/usr/bin/systemctl status xporttomcat' --tcp localhost:8601",
        logoutput => true,
      }
    }
  }
  else {
    notify {"Starting Xport-Tomcat on CT node":}
  
    exec { 'start-xporttomcat':
      unless => "/usr/bin/pgrep -f 'xport/tomcat'",
      command => '/sbin/service xporttomcat restart',
    } 
  
    service { 'xporttomcat':
      ensure => stopped,
      enable => true,
    }

    exec { "register-xporttomcat":
      command => "/usr/bin/consul-external-register -s xporttomcat ${node['cname']} ${cms['configname']} ${networking['ip']} --http http://${networking['ip']}:8081/servicecheck/xporttomcat/health -f 120s -c http://watchpoint-app:8501",
      logoutput => true,
    }
  }   
}
