\set VERBOSITY terse
PREPARE get_lrr AS SELECT :'lrr'::text;

do $$declare
  vsql text;
BEGIN
  EXECUTE 'DROP TABLE IF EXISTS delete_mdr_log';
  EXECUTE 'CREATE TABLE IF NOT EXISTS delete_mdr_log( Message varchar(4000), recordTime timestamp default now()::timestamp )';
END$$;

DROP FUNCTION IF EXISTS purgemdrobject(varchar, varchar, varchar);
CREATE OR REPLACE FUNCTION purgemdrobject(vsql varchar,errmsg varchar default null, mask varchar default 'N') RETURNS smallint AS $func_purgemdrobject$
DECLARE
   verrmsg text;
BEGIN
   EXECUTE vsql;
   return 0;
EXCEPTION
   WHEN others THEN
      select substring(errmsg,1,200) into verrmsg;
      verrmsg := sqlstate||' - Error : "'||verrmsg ||'", '||sqlerrm||'-- '||vsql;
      if upper(mask) != 'Y' then
         EXECUTE 'INSERT INTO delete_log values('''||verrmsg||''',now()::timestamp)';
         raise notice 'Error: % ',verrmsg;
         raise exception 'Error: % ',verrmsg;
      end if;
      return 1;
END;
$func_purgemdrobject$ LANGUAGE plpgsql;

--DROP FUNCTION IF EXISTS insert_purge_log_msg( varchar, varchar, timestamp, varchar);
CREATE OR REPLACE FUNCTION insert_purge_log_msg(vtblname varchar, vsql varchar, vpurgetime timestamp default now()::timestamp, mask_msg varchar default 'N') RETURNS smallint AS $func_insert_purge_log_msg$
DECLARE
    verrmsg varchar;
    tmp_result   smallint;
BEGIN
    EXECUTE 'INSERT INTO '||vtblname||' (Message, recordTime) VALUES('''||vsql||''',now()::timestamp)';
    --dbms_output.put_line(vsql);
    return 0;
EXCEPTION
  WHEN others THEN
    select substr(vsql ||'  - Error : '||sqlerrm,1,200) into verrmsg;
    if upper(mask_msg) != 'Y' then
      EXECUTE 'INSERT INTO delete_log values('''||verrmsg||''',now()::timestamp)';
      raise notice 'Error: % ',verrmsg;
      raise exception 'Error: % ',verrmsg;
    end if;
    return 1;
END;
$func_insert_purge_log_msg$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION purge_cms_mdr() RETURNS smallint AS $func_purge_cms_mdr$
DECLARE
    wk_message         varchar(500);
    vsql               varchar;
    tmp_result         smallint;
    err_msg            varchar;
    latest_revs_retain numeric;
    rec_count          numeric;
BEGIN
  EXECUTE 'EXECUTE get_lrr' INTO latest_revs_retain;
  IF ( latest_revs_retain > 0 ) THEN

    VSQL:='INSERT INTO DELETE_MDR_LOG (Message, recordTime) VALUES(''Purge MDM Revisons script started'',now()::timestamp)';
    SELECT purgemdrobject(vsql,'INSERT DELETE_MDR_LOG') INTO tmp_result;

    -- Drop and recreate the table tmpPurgeRequestId to store all delete candidate records
    vsql:='Drop table if exists tmp_purge_mdm_revisions';
    SELECT purgemdrobject(VSQL,'DROP tmp_purge_mdm_revisions','Y') INTO tmp_result;

    VSQL:='CREATE TABLE IF NOT EXISTS tmp_purge_mdm_revisions (id_ numeric, mdmdocid numeric, minrevision numeric, maxrevision numeric)';
    SELECT purgemdrobject(VSQL,'CREATE tmp_purge_mdm_revisions','Y') INTO tmp_result;

    VSQL:='INSERT INTO tmp_purge_mdm_revisions (id_, mdmdocid, minrevision, maxrevision) 
      SELECT t.id_, t.mdmdocid, min(rar.revisionnumber), max(rar.revisionnumber)
        FROM wfs.mdm_rootassetrevision rar
        JOIN wfs.pmm_title t on (t.titlestatusid <> 5 and rar.asset_id = t.mdmdocid)
       GROUP BY t.id_, t.mdmdocid
      HAVING (max(rar.revisionnumber) - min(rar.revisionnumber)) >= '|| latest_revs_retain ;
    SELECT purgemdrobject(VSQL,'insert into tmp_purge_mdm_revisions','Y') INTO tmp_result;

    SELECT count(*) INTO rec_count FROM tmp_purge_mdm_revisions;

    IF ( rec_count > 0 ) THEN
       VSQL:='DELETE FROM mdm_metadata_revision mdr WHERE EXISTS (SELECT 1 FROM tmp_purge_mdm_revisions 
                   WHERE mdmdocid = mdr.document_id AND mdr.revision BETWEEN minrevision AND (maxrevision-'||latest_revs_retain::text||'))';
       SELECT purgemdrobject(VSQL,'DELETE mdm_metadata_revision','Y') INTO tmp_result;
       SELECT insert_purge_log_msg ('delete_mdr_log','deleted mdm_metadata_revision') INTO tmp_result;

       VSQL:='DELETE FROM mdm_rootassetrevision rar WHERE EXISTS (SELECT 1 FROM tmp_purge_mdm_revisions 
                   WHERE mdmdocid = rar.asset_id AND rar.revisionnumber BETWEEN minrevision AND (maxrevision-'||latest_revs_retain::text||'))';
       SELECT purgemdrobject(VSQL,'DELETE mdm_rootassetrevision','Y') INTO tmp_result;
       SELECT insert_purge_log_msg ('delete_mdr_log','deleted mdm_rootassetrevision') INTO tmp_result;

       VSQL:='DELETE FROM pmm_progressitem pi WHERE EXISTS (SELECT 1 FROM tmp_purge_mdm_revisions 
                   WHERE id_= pi.titleid AND TO_NUMBER(pi.titleversion) BETWEEN minrevision AND (maxrevision-'||latest_revs_retain::text||'))';
       SELECT purgemdrobject(VSQL,'DELETE pmm_progressitem','Y') INTO tmp_result;
       SELECT insert_purge_log_msg ('delete_mdr_log','deleted pmm_progressitem') INTO tmp_result;

       VSQL:='DELETE FROM pmm_titleassetstatus tas WHERE EXISTS (SELECT 1 FROM tmp_purge_mdm_revisions 
                   WHERE id_=tas.titleid AND TO_NUMBER(tas.assetversion) BETWEEN minrevision AND (maxrevision-'||latest_revs_retain::text||'))';
       SELECT purgemdrobject(VSQL,'DELETE pmm_titleassetstatus','Y') INTO tmp_result;
       SELECT insert_purge_log_msg ('delete_mdr_log','deleted pmm_titleassetstatus') INTO tmp_result;
    END IF;

    SELECT insert_purge_log_msg ('delete_mdr_log','Purge Metadata Revision scripts completed successfully') INTO tmp_result;
  END IF;
  return 0;
EXCEPTION
    WHEN OTHERS THEN
    SELECT SUBSTR('Error : '||'-'||SQLERRM, 1, 500) INTO err_msg;
    VSQL    := 'INSERT INTO DELETE_MDR_LOG (MESSAGE, RECORDTIME) VALUES('''||err_msg||''', now()::timestamp)';
    SELECT CREATEOBJECT(VSQL,'insert DELETE_MDR_LOG ERROR!') INTO tmp_result;
    return 1;
END;
$func_purge_cms_mdr$ LANGUAGE plpgsql;

DO $$declare
   results smallint;
begin
   select purge_cms_mdr() into results;
end$$;

