#!/bin/sh 
##############################################################
# Name of the file : purge_cms_titles.sh                     #
##############################################################
# Description : Script to purge the CMS(v1.5) Titles         #
# Parameters  : 1) Number of titles to be deleted            # 
#               2) Title Retention Margin in days            #
#                                                            #
# Created by  : Suresh Neravati                              #
# Version #   : 1.0                                          #
# Date        : 10/19/2011                                   #
# 06-20-2014 sgf: Port the code to PG.                       #
##############################################################
DB_TYPE="edb"
DB_NAME="ttv"
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
TITLES_TOBE_DELETED=$1
TITLE_RETENSION_MARGIN=$2
PDIR="/opt/db/scripts/cms"
HOST_NAME="dbserver"
PGP="Wf\$1234"
DB_NAME="ttv"
CAN_RUN_USER="root"
DB_VER=${DB_VERSION:-10}
PSQLHOME="/usr/pgsql-${DB_VER}/bin"

# only ${CAN_RUN_USER} user can run this script.
if [ `whoami` !=  "${CAN_RUN_USER}" ]; then
  echo "**************************************************************"
  echo " You can run this script as ${CAN_RUN_USER} user only,"
  echo " Please try again as ${CAN_RUN_USER} user....!"
  echo "**************************************************************"
  exit 1
fi
PORT=${DB_PORT:-5444}
export PGPASSWORD=${PGP}
if [ "X${TITLES_TOBE_DELETED}" = "X" ] || [ "X${TITLE_RETENSION_MARGIN}" = "X" ]; 
then
  echo "Run the script with right parameters"
  exit 1
fi
if ! [[ "${TITLES_TOBE_DELETED}" =~ ^[0-9]+$ ]] ; then
  echo "Parameter-1 is not a number"; 
  exit 1
fi
if ! [[ "${TITLE_RETENSION_MARGIN}" =~ ^[0-9]+$ ]] ; then
  echo "Parameter-2 is not a number"; 
  exit 1
fi
DB_USER="wfs"
if [ "X${DB_TYPE}" = "Xazure" ]; then
     DB_USER="wfs@$AZURE_DB"
fi

echo "*******************************************************"
echo "**** Script started at $(date) "
echo "*******************************************************"
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "DROP FUNCTION if exists insert_purge_log_msg (varchar,varchar,timestamp,varchar);" 
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "DROP FUNCTION if exists purge_cms_titles();"
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} --set trm=${TITLE_RETENSION_MARGIN} --set ttbd=${TITLES_TOBE_DELETED} -f ${PDIR}/purge_cms_titles.sql
psql_exit_status=$?
if [ "${psql_exit_status}" -eq 0  ]; then
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ttv -U ${DB_USER} -c "select * from wfs.purge_log;"
else
   echo "Error while executing the title purge script, exiting...."
fi
echo "*******************************************************"
echo "**** Script ended at $(date) "
echo "*******************************************************"
exit 0 
