\set VERBOSITY terse
PREPARE get_dkd AS SELECT :'dkd'::text;

do $$declare
  vsql text;
BEGIN
  EXECUTE 'DROP TABLE if exists delete_log';
  EXECUTE 'CREATE TABLE IF NOT EXISTS delete_log( Message varchar(4000), recordTime timestamp default now()::timestamp )';
END$$;

--DROP FUNCTION IF EXISTS purgewoobject(varchar2,varchar2,varchar2);
DROP FUNCTION IF EXISTS purgewoobject(varchar,varchar,varchar);
CREATE OR REPLACE FUNCTION purgewoobject(vsql varchar,errmsg varchar default null, mask varchar default 'N') RETURNS smallint AS $func_purgewoobject$
DECLARE
   verrmsg text;
BEGIN
   EXECUTE vsql;
   return 0;
EXCEPTION 
   WHEN others THEN 
      select substring(errmsg,1,200) into verrmsg;
      verrmsg := sqlstate||' - Error : "'||verrmsg ||'", '||sqlerrm||'-- '||vsql;
      if upper(mask) != 'Y' then
         EXECUTE 'INSERT INTO delete_log values('''||REPLACE(verrmsg,'''')||''',now()::timestamp)';
         raise notice 'Error: % ',verrmsg;
         raise exception 'Error: % ',verrmsg;
      end if;
      return 1;
END; 
$func_purgewoobject$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION  insert_purge_log_msg(vtblname varchar, vsql varchar, vpurgetime timestamp default now()::timestamp, mask_msg varchar default 'N') RETURNS smallint AS $func_insert_purge_log_msg$
DECLARE
    verrmsg varchar;
    tmp_result   smallint;
BEGIN
    EXECUTE 'INSERT INTO '||vtblname||' (Message, recordTime) VALUES('''||vsql||''',now()::timestamp)';
    --dbms_output.put_line(vsql);
    return 0;
EXCEPTION
  WHEN others THEN
    select substr(vsql ||'  - Error : '||sqlerrm,1,200) into verrmsg;
    if upper(mask_msg) != 'Y' then
      EXECUTE 'INSERT INTO delete_log values('''||REPLACE(verrmsg,'''')||''',now()::timestamp)';
      raise notice 'Error: % ',verrmsg;
      raise exception 'Error: % ',verrmsg;
    end if;
    return 1;
END;
$func_insert_purge_log_msg$ LANGUAGE plpgsql;

do $$
begin
   execute drop_purge_table_cons();
EXCEPTION
   WHEN OTHERS THEN
      raise notice 'Error while dropping the purge table constraints - %', sqlerrm ;
      raise exception 'Error while dropping the purge table constraints: % ',sqlerrm;
end$$;

CREATE OR REPLACE FUNCTION purge_cms_wos() RETURNS smallint AS $func_purge_cms_wos$
DECLARE
    wk_message       varchar(500);
    vsql             varchar;
    tmp_result       smallint;
    err_msg          varchar;
    retention_str    varchar;
    retentiondays    text;
BEGIN
   EXECUTE 'EXECUTE get_dkd' INTO retentiondays;
   IF ( retentiondays::numeric > 0 ) THEN

      VSQL:='INSERT INTO delete_log (Message, recordTime) VALUES(''Script started'',now()::timestamp)';
      SELECT purgewoobject(vsql,'INSERT INTO delete_log') INTO tmp_result;

      --PURGE_WFS.ENABLE_DISABLE_FOREIGNKEYS ('DISABLE');

      -- Drop and recreate the table tmppurgewo to store all delete candidate records
      vsql:='Drop table if exists tmppurgewo';
      SELECT purgewoobject(vsql,'DROP table tmppurgewo','Y') INTO tmp_result;

      VSQL:='CREATE TABLE tmppurgewo(jp_id,jt_id) AS 
               WITH RECURSIVE wo_path_graph AS (SELECT jp, jt, 1 as level FROM JBPM_TOKEN JT
                  JOIN JBPM_PROCESSINSTANCE JP on (JT.PROCESSINSTANCE_ = JP.ID_ AND JP.SUPERPROCESSTOKEN_ IS NULL AND jt.parent_ is null 
                                        AND ( JT.OPERATIONALSTATUS IN (5,6) or JP.ISACTIVE=0 )) AND JP.CREATEDATE < ( date ''today'' - interval '''||retentiondays||' days'')
               UNION ALL 
                SELECT jpi, jti, wo_path_graph.level+1 as level FROM JBPM_TOKEN jti 
                  JOIN JBPM_PROCESSINSTANCE jpi ON (jti.PROCESSINSTANCE_ = jpi.ID_ AND ( JTI.OPERATIONALSTATUS IN (5,6) or JPI.ISACTIVE=0 ))
                  JOIN WO_PATH_GRAPH ON ((JPi.SUPERPROCESSTOKEN_= (wo_path_graph.jt).ID_)))
                SELECT (wo_path_graph.jp).id_ AS wo_id, (wo_path_graph.jt).id_  AS token_id
                  FROM wo_path_graph'; 
      SELECT purgewoobject(VSQL,'CREATE tmppurgewo') INTO tmp_result;

      EXECUTE 'CREATE INDEX idx_tmppurgewo_jp_id ON tmppurgewo(jp_id)';
      EXECUTE 'CREATE INDEX idx_tmppurgewo_jt_id ON tmppurgewo(jt_id)';
     
      VSQL := 'DELETE FROM TTV_MONITOREDDRIVEHISTORY WHERE createdate < ( date ''today'' - interval '''||retentiondays||' days'' )';
      SELECT purgewoobject(VSQL,'delete ttv_monitoreddrivehistory') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished ttv_monitoreddrivehistory') INTO tmp_result;

      VSQL := 'DELETE FROM TTV_MESSAGELOG WHERE LOGID IN  (select jl.id_ from jbpm_log jl, tmppurgewo tw where tw.jt_id = jl.token_)';
      SELECT purgewoobject(VSQL,'delete ttv_messagelog') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished ttv_messagelog') INTO tmp_result;

      VSQL := 'DELETE FROM JBPM_LOG WHERE token_ IN ( SELECT jt_id from tmppurgewo)';
      SELECT purgewoobject(VSQL,'delete jbpm_log') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished jbpm_log') INTO tmp_result;

      vsql := 'DELETE FROM jbpm_variableinstance WHERE processinstance_ IN (SELECT jp_id FROM tmppurgewo)';
      SELECT purgewoobject(VSQL,'delete jbpm_variableinstance') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished jbpm_variableinstance') INTO tmp_result;

      VSQL := 'DELETE FROM jbpm_comment WHERE token_  IN (SELECT jt_id from tmppurgewo)';
      SELECT purgewoobject(VSQL,'delete jbpm_comment') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished jbpm_comment') INTO tmp_result;

      VSQL := 'DELETE FROM jbpm_tokenvariablemap WHERE token_  IN (   SELECT jt_id from tmppurgewo)';
      SELECT purgewoobject(VSQL,'delete jbpm_tokenvariablemap') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished jbpm_tokenvariablemap') INTO tmp_result;

      VSQL := 'DELETE FROM jbpm_taskinstance WHERE TOKEN_ IN ( SELECT jt_id from tmppurgewo)';
      SELECT purgewoobject(VSQL,'delete jbpm_taskinstance') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished jbpm_taskinstance') INTO tmp_result;

      VSQL := 'DELETE FROM jbpm_moduleinstance WHERE processinstance_ IN (SELECT jp_id FROM tmppurgewo)';
      SELECT purgewoobject(VSQL,'delete jbpm_moduleinstance') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished jbpm_moduleinstance') INTO tmp_result;

      VSQL := 'DELETE FROM ttv_processinstancenote WHERE processinstanceid IN (SELECT jp_id FROM tmppurgewo)';
      SELECT purgewoobject(VSQL,'delete ttv_processinstancenote') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished ttv_processinstancenote') INTO tmp_result;

      VSQL := 'UPDATE jbpm_token SET ProcessInstance_ = NULL ,subprocessinstance_=null WHERE id_ in (SELECT jt_id FROM tmppurgewo)';
      SELECT purgewoobject(VSQL,'UPDATE jbpm_token') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Updated jbpm_token') INTO tmp_result;

      vsql := 'DELETE FROM jbpm_processinstance WHERE id_ in (select jp_id from tmppurgewo)';
      SELECT purgewoobject(VSQL,'delete jbpm_processinstance') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished jbpm_processinstance') INTO tmp_result;

      VSQL := 'DELETE FROM jbpm_token WHERE id_ IN (SELECT jt_id FROM tmppurgewo)';
      SELECT purgewoobject(VSQL,'delete jbpm_token') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished jbpm_token') INTO tmp_result;

      vsql := 'update jbpm_Processinstance set superprocesstoken_=null where(select count(*) from tmppurgewo)>0 and superprocesstoken_ is not null
               and superprocesstoken_ in (select superprocesstoken_ from jbpm_processinstance where superprocesstoken_ is not null except select id_ from jbpm_token)';
      SELECT purgewoobject(VSQL,'update jbpm_processinstance') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Updated jbpm_processinstance') INTO tmp_result;

      SELECT insert_purge_log_msg ('delete_log','Finished Purge Process') INTO tmp_result;

      VSQL := 'INSERT INTO elastic_search_wopurge_ids  SELECT jp_id, now()::timestamp FROM tmppurgewo';
      SELECT purgewoobject(VSQL,'insert into elastic_search_wopurge_ids') INTO tmp_result;
      SELECT insert_purge_log_msg ('delete_log','Finished inserting into elastic_search_wopurge_ids') INTO tmp_result;
   END IF;
      SELECT insert_purge_log_msg ('delete_log','Script finished successfully') INTO tmp_result;
      return 0;
EXCEPTION
    WHEN OTHERS THEN
      select SUBSTR('Error in function_purge_cms_wos function : '||'-'||SQLERRM, 1, 500) into err_msg;
      SELECT insert_purge_log_msg('delete_log',err_msg) INTO tmp_result;
      return 1;
END;
$func_purge_cms_wos$ LANGUAGE plpgsql;

DO $$declare
   results smallint;
begin
   select purge_cms_wos() into results;
end$$;

