#!/bin/sh
######################################################################
# Name of the file : purge_elasticsearch_wos.sh                      #
######################################################################
# Description : Script to purge the CMS WOs from the Elastic search. #
#               This script deletes the Workorders that are          #
#               successfully deleted from database. If geo site      #
#               exists, it will delete from both sites.              #
#                                                                    #
# Created by  : Siva Soumya Mandadi                                  #
# Date        : 03/23/2015                                           #
#                                                                    #
# Modified by : Suresh Neravati on 03/07/2017 to work from app node  #
######################################################################

#Defined below are variables needed
DB_TYPE="edb"
DB_NAME="ttv"
ES_SERVER="es"
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
CURR_WO_ID=1
PGP="Wf\$1234"
WO_ID_PURGED=""
WO_ID_BATCH_LIMIT=100
LOG_DIR="/opt/db/scripts/cms"
LOG_FILE="purge_elasticsearch_wos.log"
HOST_NAME="dbserver"
GEO_CONF_DIR="/opt/tandbergtv"
GEO_CONF_FILE="geo.conf"
IS_GEO=no
CAN_RUN_USER="root"
DB_VER=${DB_VERSION:-10}
PSQLHOME="/usr/pgsql-${DB_VER}/bin"

# only ${CAN_RUN_USER} user can run this script.
if [ `whoami` !=  "${CAN_RUN_USER}" ]; then
  echo "************************************************************************************"
  echo "Only ${CAN_RUN_USER} user can run this script. Please log in as ${CAN_RUN_USER} user and try again...!"
  echo "************************************************************************************"
  exit 1
fi

DB_USER="wfs"
if [ "X${DB_TYPE}" = "Xazure" ]; then
     DB_USER="wfs@$AZURE_DB"
fi

if [[ -f ${GEO_CONF_DIR}/${GEO_CONF_FILE} ]]; then
  SEC_DOMAIN=$(grep -i SECONDARY_DOMAIN ${GEO_CONF_DIR}/${GEO_CONF_FILE}| cut -f2 -d"=" | sed 's/^ *//')
  if [[ "X${SEC_DOMAIN}" = "X" ]]; then
    echo -e "\nNo Secondary Domain\n"
  else
    IS_GEO=yes
  fi
fi
PORT=${DB_PORT:-5444}
export PGPASSWORD=${PGP}
TOTAL_COUNT=$(${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "select count(*) from elastic_search_wopurge_ids;")
if [[ "$TOTAL_COUNT" -eq "0" ]] ; then
  echo "**************************************************************"
  echo "No workorders to purge from Elasticsearch"
  echo "**************************************************************"
  exit 1
fi

# delete WO's in batches of 100
# only WO removes from table if successfully purge from primary and secondary if available
while [[ "$TOTAL_COUNT" -gt "0" ]] ; do
  WO_ID_PURGED=""
  esWOlist=$(${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "select distinct wopurge_id from wfs.elastic_search_wopurge_ids where wopurge_id>='$CURR_WO_ID' order by wopurge_id offset 0 limit $WO_ID_BATCH_LIMIT;")
  for woID in $esWOlist ; do
    success=""
    httpCode=$(curl -s -I -XDELETE "http://$ES_SERVER:9200/wfs/_doc/$woID" | grep '^HTTP/1' | awk '{print $2}')
    if [[ -z "$httpCode" ]] ; then
      echo "**************************************************************"
      echo " Connection failed to Elasticsearch Node: $ES_SERVER"
      echo "**************************************************************"
      exit 1
    elif [[ "$httpCode" -eq "200" ]] || [[ "$httpCode" -eq "404" ]] ; then
      if [[ "$IS_GEO" = "yes" ]] ; then
    	httpCode2=$(curl -s -I -XDELETE "http://$ES_SERVER.$SEC_DOMAIN:9200/wfs/_doc/$woID" | grep '^HTTP/1' | awk '{print $2}')
    	if [[ "$httpCode2" -eq "200" ]] || [[ "$httpCode2" -eq "404" ]] ; then
          success="purged"
        fi
      else
        success="purged"
      fi
    fi
    
    if [[ "$success" = "purged" ]] ; then
      WO_ID_PURGED=$woID","$WO_ID_PURGED
    else
      echo -e "$woID" >> $LOG_DIR/$LOG_FILE
    fi
    CURR_WO_ID=$woID
  done
  if [[ ! -z "$WO_ID_PURGED" ]] ; then
    WO_ID_PURGED=${WO_ID_PURGED%?}
    ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "delete from elastic_search_wopurge_ids where wopurge_id in ($WO_ID_PURGED);"
    echo "WO IDs:$WO_ID_PURGED purged from Elasticsearch"
  fi
  TOTAL_COUNT=$((TOTAL_COUNT - WO_ID_BATCH_LIMIT))
done
echo "******************************************************************"
echo "No more workorders to purge from Elasticsearch"
echo "End of the purge work order script"
echo "------------------------------------------------------------------"
exit 0


