/*

*/
\set VERBOSITY terse
PREPARE get_inst_schema AS SELECT :'inst_schema'::text;

CREATE OR REPLACE FUNCTION CREATEPOSTCMS (vschema varchar, comp_name varchar, db_version varchar) RETURNS integer AS $func_createpostcms$
DECLARE
    vsql                  varchar;
    wk_message            varchar:= '';
    tmp_result            smallint;
    errcnt                smallint;
    ischema               text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    -- Inserting into table 'SYSTEM_SETTINGS'
    vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values ('''||comp_name||''',''RELEASE'','''||db_version||''')';
    select CREATEOBJECT(vsql,'Unable to insert db version into SYSTEM_SETTINGS') INTO tmp_result;

    /*--------------------------------------------------------------------
                                CREATING TABLES
    --------------------------------------------------------------------*/
    --SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TEST','N') INTO tmp_result;
    --SELECT createseq(vschema,'TEST') INTO tmp_result;
    --SELECT createupdatetrg(vschema,'TEST') INTO tmp_result;

      -- Avinash added new table on 07/25/2014
      vsql := 'CREATE TABLE '||vschema||'.elastic_search_wopurge_ids(
      wopurge_id      numeric(10),
      wo_delete_date  date)';

      SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE '||vschema||'.elastic_search_wopurge_ids')  INTO tmp_result;

      vsql := 'create index idx_elastic_search_wopurge_ids on '||vschema||'.elastic_search_wopurge_ids (wopurge_id)';
      SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX idx_elastic_search_wopurge_ids')  INTO tmp_result;

      --Code from createPMM;
      vsql := 'INSERT INTO '||vschema||'.ttv_MONITOREDDRIVE (monitoreddriveid, name, description, path, internaldriveid, totalcapacity, warningthresholdpercent, errorthresholdpercent, currentbytesused, currentdrivestatusid,CreateDate, UpdateDate) VALUES (nextval('''||vschema||'.ttv_MONITOREDDRIVE_SEQ''), ''Content'', ''Drive for mapped and unmapped assets in PMM'', ''/content'', 1, 100000000000, 50, 75, 0, 0, now(), now())';
      SELECT CREATEOBJECT(vsql,'Unable to INSERT INTO '||vschema||'.ttv_MONITOREDDRIVE Drive for mapped and unmapped assets in PMM.') INTO tmp_result;

      --Code from createNEPTUNE
      vsql := 'ALTER TABLE '||vschema||'.CMS_ASSETLIST ADD CONSTRAINT FK_CONTENTCLASS_ASSETLIST_ID FOREIGN KEY (CONTENT_CLASS) REFERENCES '||vschema||'.PMM_CONTENT_CLASS(ID)';
      SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.CMS_ASSETLIST ADD CONSTRAINT FK_CONTENTCLASS_ASSETLIST_ID ') INTO tmp_result;
	  
      vsql := ' ALTER TABLE '||vschema||'.CMS_ASSETLIST_ASSET_MAP ADD CONSTRAINT FK_ASSETLIST_MAP_TITLE_ID FOREIGN KEY (TITLE_ID) REFERENCES '||vschema||'.PMM_TITLE (ID_)';
      SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.CMS_ASSETLIST_ASSET_MAP ADD CONSTRAINT FK_ASSETLIST_MAP_TITLE_ID') INTO tmp_result;

      --Code from createSITES
      VSQL := 'ALTER TABLE '||vschema||'.SITES_SITE ADD CONSTRAINT SITES_SITE_TTV_RESOURCE_FK1 FOREIGN KEY (ASSOCIATED_RESOURCE_ID) REFERENCES '||vschema||'.TTV_RESOURCE (RESOURCEID)';
      SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.SITES_SITE ADD CONSTRAINT SITES_SITE_TTV_RESOURCE_FK1') INTO tmp_result;

      vsql := 'ALTER TABLE '||vschema||'.sites_site_ruleset add constraint FK_siteRuleset_Ruleset foreign key (ruleSetId) references '||vschema||'.Tre_RuleSet';
      SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.sites_site_ruleset add constraint FK_siteRuleset_Ruleset') INTO tmp_result;
              
      --Code from createRules
      vsql := 'ALTER TABLE '||vschema||'.TRE_BULKEXECUTION_CONTENTPROC ADD CONSTRAINT FK_TRE_BULK_CONTENTPROC_TID FOREIGN KEY(TitleID) REFERENCES '||vschema||'.pmm_title(ID_)';
      SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.TRE_BULKEXECUTION_CONTENTPROC ADD CONSTRAINT FK_TRE_BULK_CONTENTPROC_TID') INTO tmp_result;

      vsql := 'ALTER TABLE '||vschema||'.TRE_BULKEXECUTION_GENERAL ADD CONSTRAINT FK_TRE_BULKEXECUTION_GEN_TID FOREIGN KEY(TITLEID) REFERENCES '||vschema||'.PMM_TITLE(ID_)';
      SELECT CREATEOBJECT(vsql,'Unable to TABLE '||vschema||'.TRE_BULKEXECUTION_GENERAL ADD CONSTRAINT FK_TRE_BULKEXECUTION_GEN_TID') INTO tmp_result;

      vsql := 'ALTER TABLE '||vschema||'.TRE_BULKEXECUTION_FAILEDTITLES ADD CONSTRAINT FK_TRE_BULKEXECUTION_FTS_TID FOREIGN KEY(TITLEID) REFERENCES '||vschema||'.PMM_TITLE(ID_)';
      SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.TRE_BULKEXECUTION_FAILEDTITLES ADD CONSTRAINT FK_TRE_BULKEXECUTION_FTS_TID') INTO tmp_result;

      -- Daniel Weiner Added a new table tre_ruleset_mso on 03-06-2013, below is the table foreign key constraint
      vsql := 'ALTER TABLE '||vschema||'.tre_ruleset_mso ADD CONSTRAINT fk_rulesetmso_mso FOREIGN KEY (msoid) REFERENCES '||vschema||'.sites_mso_mtm(mso_id)';
      SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.tre_ruleset_mso ADD CONSTRAINT fk_rulesetmso_mso') INTO tmp_result;


    execute 'select COUNT(*) from '||ischema||'.install_table where upper(install_message) like ''%ERROR%''' into errcnt;
    if errcnt = 0 then
       EXECUTE 'INSERT INTO '||ischema||'.install_table(install_message) values (''Installation of POSTCMS database for version '||db_version||' completed SUCCESSFULLY'')';
    end if;
    return 0;

EXCEPTION
    WHEN OTHERS THEN
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in createpostcms function : '')';
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
       return 1;
END;
$func_createpostcms$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION CONVERTPOSTCMS (vschema varchar, comp_name varchar, db_version varchar) RETURNS integer AS $func_convertpostcms$
DECLARE
    vsql       varchar;
    wk_message VARCHAR:= '';
    tmp_result smallint;
    wk_release varchar:='';    
    cms_comps  smallint;
    ischema    text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;

     /*--------------------------------------------------------------------------------------
                Start of Convert release 5.2.2(CMS 5.2) to 5.2.3(CMS 5.2) -- chg 4 
      --------------------------------------------------------------------------------------*/
    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release =  '5.2.2' THEN
        -- on 06/20/2016 Suresh dropped the deprecated tables. 
        vsql := 'DROP TABLE '||vschema||'.alert_actions_hist';
        SELECT CREATEOBJECT(vsql,'Unable to DROP TABLE '||vschema||'.alert_actions_hist','Y') into tmp_result;

        vsql := 'DROP TABLE '||vschema||'.alerts_hist';
        SELECT CREATEOBJECT(vsql,'Unable to DROP TABLE '||vschema||'.alerts_hist','Y') into tmp_result;

        vsql := 'DROP TABLE '||vschema||'.alert_actions';
        SELECT CREATEOBJECT(vsql,'Unable to DROP TABLE '||vschema||'.alert_actions','Y') into tmp_result;

        vsql := 'DROP TABLE '||vschema||'.alerts';
        SELECT CREATEOBJECT(vsql,'Unable to DROP TABLE '||vschema||'.alerts','Y') into tmp_result;

        vsql := 'DROP TABLE '||vschema||'.alert_names';
        SELECT CREATEOBJECT(vsql,'Unable to DROP TABLE '||vschema||'.alert_names','Y') into tmp_result;

        vsql := 'DROP TABLE '||vschema||'.system_release';
        SELECT CREATEOBJECT(vsql,'Unable to DROP TABLE '||vschema||'.system_release','Y') into tmp_result;

        select set_version(vschema, comp_name,'5.2.2','5.2.3') into tmp_result;
     END IF;

    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '5.2.3' THEN
        -- Changed the database scripts from EDB to Postgres
        select set_version(vschema, comp_name,'5.2.3','6.0.0') into tmp_result;
    END IF;

    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '6.0.0' THEN
        -- On 03/16/2018 changed the database scripts from EDB to Postgres10 in cms7.0
        select set_version(vschema, comp_name,'6.0.0',db_version) into tmp_result;
    END IF;

  EXECUTE 'INSERT INTO '||ischema||'.install_table (msgdate, install_message) values (now(),''Upgrading '||comp_name||' component to '||db_version||' completed SUCCESSFULLY'')';
  RETURN tmp_result;
EXCEPTION
    WHEN OTHERS THEN
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in convertrm function : '')';
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
      return 1;
END;
$func_convertpostcms$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION INSTALL_POSTCMS () RETURNS integer AS $func_installpostcms$
DECLARE
  comp_name    varchar := 'POSTCMS';
  vschema      varchar := 'wfs';
  func_results smallint;
  wk_release   varchar:='';    
  db_version   varchar := '7.0.0';
  wk_count     numeric;
  ischema      text;
BEGIN
  EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
  SELECT count(*) INTO wk_count FROM pg_constraint WHERE upper(conname) = 'FK_CONTENTCLASS_ASSETLIST_ID';
  IF wk_count < 1 THEN
    select CREATEPOSTCMS(vschema,comp_name,db_version) into func_results;
  ELSE
    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release < db_version  THEN
       select CONVERTPOSTCMS(vschema,comp_name,db_version) into func_results;
    ELSIF wk_release = db_version  THEN
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''There are no database changes in '||comp_name||' component to upgrade'')';
    END IF;
  END IF;
  return func_results;
END;
$func_installpostcms$ LANGUAGE plpgsql;

DO $$declare
   results    smallint;
begin
   select INSTALL_POSTCMS() into results;
end$$;