/*

*/
\set VERBOSITY terse
\set default_content `cat default_content_class.xml`
\set offer_content `cat offer_content_class.xml`

PREPARE get_dcc_value AS SELECT :'default_content'::text;
PREPARE get_occ_value AS SELECT :'offer_content'::text;

PREPARE get_inst_schema AS SELECT :'inst_schema'::text;

do $$declare
  vsql text;
  ischema    text;
BEGIN
  EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
  EXECUTE 'CREATE TABLE IF NOT EXISTS '||ischema||'.install_table (msgdate timestamp default now(), install_message varchar(4000))';
END$$;

create or replace function func_pad_zeros(vstr varchar, padzeros numeric default 2) returns varchar AS $func_pad_zeros$
DECLARE
  newstr varchar;
BEGIN
  select string_agg(val,'.') into newstr from (select lpad(regexp_split_to_table(replace(vstr,'.',','),','),2,'0'::text) as val) as a;
  return newstr;
END;
$func_pad_zeros$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION createobject(vsql text, errmsg varchar, mask varchar default 'N') RETURNS smallint AS $func_createobject$
DECLARE
  verrmsg   varchar:='';
BEGIN
  EXECUTE vsql;
  return 0;
EXCEPTION 
  WHEN others THEN 
    select substring(errmsg,1,200) into verrmsg;
    verrmsg := sqlstate||' - Error : "'||verrmsg ||'", '||sqlerrm||'-- '||vsql;
    if upper(mask) != 'Y' then
      raise notice 'Error: % ',verrmsg;
      raise exception 'Error: % ',verrmsg;
    end if;
    return 1;
END;
$func_createobject$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION createseq( vschema varchar, vtabname varchar, vseqstart integer default 1,  vcache integer default 1) RETURNS smallint AS $func_createseq$
DECLARE
  verrmsg    varchar:='';
  pkeycol    varchar:='';
  vsql       varchar;
BEGIN
  EXECUTE 'SELECT  kcu.column_name
             FROM  INFORMATION_SCHEMA.TABLES t
             LEFT JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc
                 ON tc.table_catalog = t.table_catalog
                 AND tc.table_schema = t.table_schema
                 AND tc.table_name = t.table_name
                 AND tc.constraint_type = ''PRIMARY KEY''
             LEFT JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu
                 ON kcu.table_catalog = tc.table_catalog
                 AND kcu.table_schema = tc.table_schema
                 AND kcu.table_name = tc.table_name
                 AND kcu.constraint_name = tc.constraint_name
            WHERE  t.table_schema = '''||vschema||'''
              AND  upper(t.table_name) = upper('''||vtabname||''')' INTO pkeycol;

  vsql := 'CREATE SEQUENCE '||substr(vtabname,1,26)||'_SEQ INCREMENT BY 1 START WITH '||vseqstart::text||' CACHE '||vcache::text;
  EXECUTE vsql;
  IF  pkeycol IS NOT NULL  OR pkeycol <> '' THEN
     EXECUTE 'ALTER TABLE '||vschema||'.'||vtabname||' ALTER COLUMN '||pkeycol||' set default nextval ('''||substr(vtabname,1,26)||'_SEQ'')';
  END IF;
  return 0;
EXCEPTION 
  WHEN others THEN 
    verrmsg := sqlstate||' - Error : Unable to create '||substr(vtabname,1,26)||'_SEQ ,'||sqlerrm;
    raise notice 'Error: %',verrmsg;
    raise exception 'Error: %',verrmsg;
    return 1;
END;
$func_createseq$ LANGUAGE plpgsql;

drop FUNCTION if exists createupdatetrg( varchar, varchar);

CREATE OR REPLACE FUNCTION createupdatetrg( vschema varchar, vtabname varchar, vmask varchar default 'N') RETURNS smallint AS $func_createupdatetrg$
DECLARE
    verrmsg varchar:='';
    vcount  smallint;
    vsql    varchar;
BEGIN
    EXECUTE 'SELECT count(*) FROM information_schema.columns WHERE table_schema = lower('''||vschema||''') AND upper(table_name) = upper('''||vtabname||''') AND upper(column_name) = ''UPDATEDATE''' INTO vcount;
    if ( vcount > 0 ) then
      vsql := 'CREATE OR REPLACE FUNCTION FUNC_'||substr(vtabname,1,26)||'UPD() RETURNS TRIGGER AS $$ BEGIN NEW.UPDATEDATE = now(); RETURN NEW; END; $$ language plpgsql';
      EXECUTE vsql;
      vsql := 'CREATE TRIGGER '||substr(vtabname,1,26)||'UPD BEFORE UPDATE ON '||vtabname||' FOR EACH ROW EXECUTE PROCEDURE  FUNC_'||substr(vtabname,1,26)||'UPD()';
      EXECUTE vsql;
   end if;
   return 0;
EXCEPTION 
   WHEN others THEN 
      verrmsg := sqlstate||' - Error : While creating trigger, '||sqlerrm;
      if upper(vmask) != 'Y' then
         raise notice 'Error: % ',verrmsg;
         raise exception 'Error: % ',verrmsg;
      end if;
      return 1;
  END;
$func_createupdatetrg$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION set_version( vschema varchar, comp_name varchar, from_version varchar, to_version varchar) RETURNS smallint AS $func_set_version$
DECLARE
   wk_message     varchar(500);
   verrmsg        varchar:='';
BEGIN
   if to_version < '5.2.3' then
      EXECUTE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value='''||to_version||''' WHERE setting_type = ''RELEASE''';
   else
      EXECUTE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value='''||to_version||''' WHERE setting_type = ''RELEASE'' and component_name = '''||comp_name||'''';
   end if;
   return 0;
EXCEPTION 
   WHEN others THEN 
      verrmsg := sqlstate||' - Error : While setting version from "'||from_version||'", '||sqlerrm;
      raise notice 'Error: % ',verrmsg;
      raise exception 'Error: % ',verrmsg;
      return 1;
END;
$func_set_version$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION drop_purge_table_cons() RETURNS void AS $func_drop_purge_table_constraints$
DECLARE
    vsql                  varchar;
    wk_message            varchar:= '';
    tmp_result            smallint;
    errcnt                smallint;
BEGIN
    vsql := 'DO $$
             DECLARE
                i record;
             BEGIN
                FOR i IN (SELECT ''ALTER TABLE ''||pg_get_userbyid(c.relowner)||''.''||c.relname||'' DROP CONSTRAINT ''||lower(replace(pc.conname,''"'','''')) AS CONST_STR
                            FROM pg_constraint pc, pg_class c, pg_constraint pc1
                           WHERE c.oid = pc.conrelid
                             AND pc.contype = ''f''
                             AND pc1.conrelid = pc.confrelid AND pc1.contype = ''p''
                             AND ( CASE WHEN pc.contype = ''f'' THEN pc1.conname ELSE NULL END) IN (
                                  SELECT pc.conname
                                    FROM pg_constraint pc, pg_class c
                                   WHERE c.oid = pc.conrelid
                                     AND pc.contype=''p''
                                     AND pg_get_userbyid(c.relowner)=''wfs'')
                             AND upper(c.relname) IN (''JBPM_COMMENT'',''JBPM_LOG'',''JBPM_VARIABLEINSTANCE'',''JBPM_TOKEN'',''JBPM_PROCESSINSTANCE'',
                        ''TTV_MONITOREDDRIVEHISTORY'',''ALERT_ACTIONS_HIST'',''ALERTS_HIST'',''TTV_MESSAGELOG'',
                        ''JBPM_TOKENVARIABLEMAP'',''JBPM_TASKINSTANCE'',''JBPM_MODULEINSTANCE'',''TTV_PROCESSINSTANCENOTE'',
                                                    ''CMS_ASSETLIST_ASSET_METADATA'',''CMS_ASSETLIST_ASSET_MAP'',''SITES_TRACKSITETITLE'',
                                                    ''SITES_DISTSITETITLE'',''PMM_PROPERTIES'',''PMM_PROGRESSITEM'',''PMM_TITLE_TITLELISTXREF'',
                                                    ''PMM_TITLEASSET_PROPERTY'',''PMM_TITLEASSETSTATUS'',''PMM_TITLE_PURGE_HISTORY'',''PMM_TITLE''))
                LOOP
                   EXECUTE i.const_str;
                END LOOP;
              END$$;';
    SELECT CREATEOBJECT(vsql,'Unable to drop constraints from purge related tables.','Y') INTO tmp_result;
EXCEPTION
   WHEN OTHERS THEN
      EXECUTE 'Insert into wfs.install_table(install_message) values (''Error in function purge_table_constraints function : '')';
      EXECUTE 'Insert into wfs.install_table(install_message) values (''   '||sqlerrm||''')';
END;
$func_drop_purge_table_constraints$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION get_version (vschema varchar, comp_name varchar) RETURNS varchar AS $func_get_version$
DECLARE
    cms_comps  integer;
    wk_release varchar:='';    
    ischema    text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    execute 'SELECT count(*) FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' into cms_comps;
    IF cms_comps = 1 THEN
       execute 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' into wk_release;
    ELSIF cms_comps > 1 THEN
       execute 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE'' and component_name = '''||comp_name||'''' into wk_release;
    END IF;
    RETURN wk_release;
EXCEPTION
    WHEN OTHERS THEN
        EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in func_get_version function : '')';
        EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
        RETURN wk_release;
END;
$func_get_version$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION CREATEPRECMS (vschema varchar, comp_name varchar, db_version varchar) RETURNS integer AS $func_createprecms$
DECLARE
    vsql                  varchar;
    wk_message            varchar:= '';
    tmp_result            smallint;
    errcnt                smallint;
    ischema    text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    /*--------------------------------------------------------------------
                                CREATING TABLES
    --------------------------------------------------------------------*/
    EXECUTE 'Drop table IF EXISTS '||ischema||'.install_table';
    EXECUTE 'CREATE TABLE IF NOT EXISTS '||ischema||'.install_table (msgdate timestamp default now(), install_message varchar(4000))';
    -- creating table SYSTEM_SETTINGS
    vsql :=  'CREATE TABLE '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME VARCHAR(50), SETTING_TYPE VARCHAR(25), SETTING_VALUE VARCHAR(1024), CREATEDATE TIMESTAMP(6) DEFAULT (CURRENT_TIMESTAMP) NOT NULL)';
    select CREATEOBJECT(vsql,'Unable to create table SYSTEM_SETTINGS') INTO tmp_result;
    vsql := 'CREATE OR REPLACE FUNCTION FUNC_SYSTEM_SETTINGSUPD() RETURNS TRIGGER AS $$ BEGIN NEW.CREATEDATE = now(); RETURN NEW; END; $$ language plpgsql';
    EXECUTE vsql;
    vsql := 'CREATE TRIGGER SYSTEM_SETTINGSUPD BEFORE UPDATE ON SYSTEM_SETTINGS FOR EACH ROW EXECUTE PROCEDURE  FUNC_SYSTEM_SETTINGSUPD()';
    EXECUTE vsql;

    -- Inserting into table 'SYSTEM_SETTINGS'
    vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values ('''||comp_name||''',''RELEASE'','''||db_version||''')';
    select CREATEOBJECT(vsql,'Unable to insert db version into SYSTEM_SETTINGS') INTO tmp_result;



    execute 'select COUNT(*) from '||ischema||'.install_table where upper(install_message) like ''%ERROR%''' into errcnt;
    if errcnt = 0 then
       EXECUTE 'INSERT INTO '||ischema||'.install_table(install_message) values (''Installation of PRECMS database for version '||db_version||' completed SUCCESSFULLY'')';
    end if;
    return 0;

EXCEPTION
    WHEN OTHERS THEN
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in createprecms function : '')';
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
       return 1;
END;
$func_createprecms$ LANGUAGE plpgsql;



CREATE OR REPLACE FUNCTION CONVERTPRECMS (vschema varchar, comp_name varchar, db_version varchar) RETURNS integer AS $func_convertprecms$
DECLARE
    vsql       varchar;
    wk_message VARCHAR:= '';
    tmp_result smallint;
    wk_release varchar:='';    
    cms_comps  smallint;
    comp_recs  numeric := 0;
    myvar      varchar(10):='';    
    dcc_value             text;
    occ_value             text;
    ischema    text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    raise notice '%', ischema;

    EXECUTE 'SELECT count(*) FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO comp_recs;

    IF comp_recs = 1 THEN
/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.22.0(CMS 2.5.000.25) to 3.3.0.0(CMS 3.0.000.xx) -- chg 1 
    ----------------------------------------------------------------------------------------------
*/
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;


        IF ((wk_release =  '3.2.22') or (wk_release =  '3.2.22.1'))  THEN 
         -- Anna changes on 06/07/2012 to create custom field group and field tables
          vsql := 'CREATE TABLE '||vschema||'.MDM_CUSTOM_FIELD_GROUP (
                         GROUP_ID     numeric NOT NULL,
                         NAME         varchar(255) ,
                         DISPLAY_NAME varchar(255) NOT NULL,
                         ASSET_PATH   varchar(255) NOT NULL,
                         CREATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                         UPDATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                         CONSTRAINT mdm_custom_field_group_pk PRIMARY KEY (GROUP_ID)
                         )';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.MDM_CUSTOM_FIELD_GROUP','Y') INTO tmp_result;
          SELECT createseq(vschema,'MDM_CUSTOM_FIELD_GROUP') INTO tmp_result;
          SELECT createupdatetrg(vschema,'MDM_CUSTOM_FIELD_GROUP') INTO tmp_result;

          vsql := 'CREATE TABLE '||vschema||'.MDM_CUSTOM_FIELD (
                         CUSTOM_FIELD_ID        numeric NOT NULL,
                         NAME                   varchar(255) NOT NULL,
                         DATA_TYPE              varchar(20),
                         DROP_DOWN              varchar(1),
                         JOB_PARAMETER          varchar(1),
                         JOB_SCHEDULE_PARAMETER varchar(1),
                         GROUP_ID               numeric NOT NULL,
                         DISPLAY_NAME           varchar(255) NOT NULL,
                         CREATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                         UPDATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                         CONSTRAINT mdm_custom_field_pk PRIMARY KEY (CUSTOM_FIELD_ID),
                         CONSTRAINT fk_mdm_custom_field_group_id FOREIGN KEY(GROUP_ID) 
                             REFERENCES '||vschema||'.MDM_CUSTOM_FIELD_GROUP(GROUP_ID)
                         )';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.MDM_CUSTOM_FIELD','Y') INTO tmp_result;
          SELECT createseq(vschema,'MDM_CUSTOM_FIELD') INTO tmp_result;
          SELECT createupdatetrg(vschema,'MDM_CUSTOM_FIELD') INTO tmp_result;

           select set_version(vschema, comp_name,'3.2.22','3.3.0') into tmp_result;
         END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release 3.3.0.0(CMS 3.0.000.xx) to 3.3.1.0(CMS 3.0.000.xx) -- chg 2 
    ---------------------------------------------------------------------------------------------- 
*/
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF wk_release =  '3.3.0'  THEN 
         -- Anna changes on 06/22/2012 to add column uuid in custom field group table
          vsql := 'ALTER TABLE '||vschema||'.MDM_CUSTOM_FIELD_GROUP ADD UUID varchar(255)';
          SELECT CREATEOBJECT(vsql,'Unable to ALTER table MDM_CUSTOM_FIELD_GROUP to ADD COLUMN UUID','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'3.3.0','3.3.1') into tmp_result;
        END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release 3.3.1.0(CMS 3.0.000.xx) to 3.3.2.0(CMS 3.0.000.xx) -- chg 3 
    ---------------------------------------------------------------------------------------------- 
*/
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF wk_release =  '3.3.1'  THEN 
          -- Steve added six Metadata Enhancement tables on 06/22/2012.
          vsql := 'CREATE TABLE '||vschema||'.ME_SUBS_PROFILE (	
                       ID          numeric, 
                       NAME        varchar(4000) NOT NULL, 
                       CONNECTION  varchar(4000) NOT NULL, 
                       PLUGIN_NAME varchar(4000) NOT NULL,
                       CREATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       CONSTRAINT  ME_PROFILE_PK PRIMARY KEY (ID),
                       CONSTRAINT  ME_PROFILE_UK1 UNIQUE (NAME))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_SUBS_PROFILE','Y') INTO tmp_result;
          SELECT createseq(vschema,'ME_SUBS_PROFILE',1000) INTO tmp_result;
          SELECT createupdatetrg(vschema,'ME_SUBS_PROFILE') INTO tmp_result;
          --CREATESEQ('ME_SUBS_PROFILE',1000); 
          
          vsql := 'CREATE TABLE '||vschema||'.ME_CACHE_RESULT (	
                       ID            numeric, 
                       TITLE_ID      numeric NOT NULL, 
                       PROFILE_ID    numeric NOT NULL, 
                       REQUEST_KEY   varchar(400) NOT NULL, 
                       RESULT_WEIGHT numeric DEFAULT 0, 
                       REMOTE_ID     varchar(1000) NOT NULL, 
                       NAME          varchar(4000) NOT NULL, 
                       YEAR          numeric NOT NULL, 
                       TYPE          varchar(4000) NOT NULL, 
                       THUMBNAIL     varchar(4000), 
                       ACTORS        varchar(4000), 
                       RANKING       numeric, 
                       ENHANCED_FIELDS text,
                       CREATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       CONSTRAINT ME_CACHE_RESULT_PK PRIMARY KEY (ID),
                       CONSTRAINT ME_CACHE_RESULT_UK1 UNIQUE (TITLE_ID, PROFILE_ID, REQUEST_KEY, REMOTE_ID),
                       CONSTRAINT ME_CACHE_RESULT_ME_PROFIL_FK1 FOREIGN KEY (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE (ID),
                       CONSTRAINT ME_CACHE_RESULT_PMM_TITLE_FK1 FOREIGN KEY (TITLE_ID) REFERENCES '||vschema||'.PMM_TITLE (ID_))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_CACHE_RESULT','Y') INTO tmp_result;
          SELECT createseq(vschema,'ME_CACHE_RESULT',1000) INTO tmp_result;
          SELECT createupdatetrg(vschema,'ME_CACHE_RESULT') INTO tmp_result;
          --CREATESEQ('ME_CACHE_RESULT',1000); 
          
          vsql := 'CREATE TABLE '||vschema||'.ME_FIELD_DEFINITION (	
                       ID         numeric, 
                       SOURCE     varchar(100)  NOT NULL, 
                       PATH       varchar(4000) NOT NULL, 
                       DATATYPE   varchar(100)  NOT NULL,
                       CREATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       CONSTRAINT ME_FIELD_DEFINITION_PK PRIMARY KEY (ID),
                       CONSTRAINT ME_FIELD_DEFINITION_UK1 UNIQUE (SOURCE, PATH))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_FIELD_DEFINITION','Y') INTO tmp_result;
          SELECT createseq(vschema,'ME_FIELD_DEFINITION',1000) INTO tmp_result;
          SELECT createupdatetrg(vschema,'ME_FIELD_DEFINITION') INTO tmp_result;
          --CREATESEQ('ME_FIELD_DEFINITION',1000); 
          
          vsql := 'CREATE TABLE '||vschema||'.ME_ENHANCED_FIELD (	
                       ID         numeric, 
                       PROFILE_ID numeric NOT NULL, 
                       FIELD_ID   numeric NOT NULL,
                       CREATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       CONSTRAINT ME_ENHANCED_FIELDS_PK PRIMARY KEY (ID),
                       CONSTRAINT ME_ENHANCED_FIELDS_UK1 UNIQUE (PROFILE_ID, FIELD_ID),
                       CONSTRAINT ME_ENHANCED_FIELDS_ME_FIE_FK1 FOREIGN KEY (FIELD_ID) REFERENCES '||vschema||'.ME_FIELD_DEFINITION (ID),
                       CONSTRAINT ME_ENHANCED_FIELDS_ME_PRO_FK1 FOREIGN KEY (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE (ID))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_ENHANCED_FIELD','Y') INTO tmp_result;
          SELECT createseq(vschema,'ME_ENHANCED_FIELD',1000) INTO tmp_result;
          SELECT createupdatetrg(vschema,'ME_ENHANCED_FIELD') INTO tmp_result;
          --CREATESEQ('ME_ENHANCED_FIELD',1000); 
          
          vsql := 'CREATE TABLE '||vschema||'.ME_IDENTIFIER_KEY (	
                       ID             numeric, 
                       PROFILE_ID     numeric NOT NULL, 
                       KEY_FIELD_ID   numeric NOT NULL, 
                       VALUE_FIELD_ID numeric NOT NULL,
                       CREATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       CONSTRAINT ME_IDENTIFIER_KEY_PK PRIMARY KEY (ID),
                       CONSTRAINT ME_IDENTIFIER_KEY_UK1 UNIQUE (PROFILE_ID, KEY_FIELD_ID, VALUE_FIELD_ID),
                       CONSTRAINT ME_IDENTIFIER_KEY_ME_FIEL_FK1 FOREIGN KEY (KEY_FIELD_ID) REFERENCES '||vschema||'.ME_FIELD_DEFINITION (ID),
                       CONSTRAINT ME_IDENTIFIER_KEY_ME_FIEL_FK2 FOREIGN KEY (VALUE_FIELD_ID) REFERENCES '||vschema||'.ME_FIELD_DEFINITION (ID),
                       constraint ME_IDENTIFIER_KEY_ME_PROF_FK1 foreign key (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE (ID))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_IDENTIFIER_KEY','Y') INTO tmp_result;
          SELECT createseq(vschema,'ME_IDENTIFIER_KEY',1000) INTO tmp_result;
          SELECT createupdatetrg(vschema,'ME_IDENTIFIER_KEY') INTO tmp_result;
          --CREATESEQ('ME_IDENTIFIER_KEY',1000); 
    
          vsql := 'CREATE TABLE '||vschema||'.ME_SUBS_PROFILE_PARAMETER (	
                       ID         numeric, 
                       PROFILE_ID numeric NOT NULL, 
                       NAME       varchar(4000) NOT NULL, 
                       VALUE      varchar(4000),
                       CREATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       CONSTRAINT ME_SUBS_PROFILE_PARAMETER_PK PRIMARY KEY (ID),
                       CONSTRAINT ME_SUBS_PROFILE_PARAMETER_UK1 UNIQUE (PROFILE_ID, NAME),
                       CONSTRAINT ME_SUBS_PROFILE_PARAMETER_FK1 FOREIGN KEY (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE(ID))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_SUBS_PROFILE_PARAMETER','Y') INTO tmp_result;
          SELECT createseq(vschema,'ME_SUBS_PROFILE_PARAMETER',1000) INTO tmp_result;
          SELECT createupdatetrg(vschema,'ME_SUBS_PROFILE_PARAMETER') INTO tmp_result;
          --CREATESEQ('ME_SUBS_PROFILE_PARAMETER',1000); 
           select set_version(vschema, comp_name,'3.3.1','3.3.2') into tmp_result;
        END IF;

/*  ----------------------------------------------------------------------------------------------
            Start of Convert release 3.3.2.0(CMS 3.0.000.xx) to 3.3.3.0(CMS 3.0.000.xx) -- chg 4 
    ---------------------------------------------------------------------------------------------- 
*/
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.2'  THEN 

          VSQL := 'ALTER TABLE '||VSCHEMA||'.SCH_PASTEXECUTION  ADD ORIG_EXECUTION_TIME TIMESTAMP, ADD FINISHED  numeric(1,0)';
          SELECT createobject(vsql,'Unable to ALTER TABLE '||vschema||'.SCH_PASTEXECUTION  ORIG_EXECUTION_TIME,FINISHED','Y') INTO tmp_result;         
          VSQL := 'CREATE TABLE '||VSCHEMA||'.SCH_PASTEXECUTIONDATA (
                      PASTEXEC_ID   numeric    NOT NULL,
                      NAME          varchar(255) NOT NULL,
                      VALUE         bytea,                    ----------BLOB
                      CONSTRAINT SCH_PASTEXEDATA_PK PRIMARY KEY (PASTEXEC_ID,NAME),
                      CONSTRAINT SCH_PASTEXEDATA_FK1 FOREIGN KEY (PASTEXEC_ID) REFERENCES '||vschema||'.SCH_PASTEXECUTION(ID))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.SCH_PASTEXECUTIONDATA','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'3.3.2','3.3.3') into tmp_result;
        END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release from 3.3.3.0(CMS 3.0.000.xx) to 3.3.4.0(CMS 3.0.000.xx) -- chg 5 (sprint-3) 
    ---------------------------------------------------------------------------------------------- 
*/
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.3'  THEN 

          VSQL := 'ALTER TABLE '||vschema||'.mdm_custom_field ADD multivalue VARCHAR(1)';
          SELECT createobject(vsql,'Unable to alter table '||vschema||'.mdm_custom_field to add multivalue columns.','Y') INTO tmp_result;
          VSQL := 'ALTER TABLE '||vschema||'.mdm_custom_field ADD field_type numeric(3) DEFAULT 1 NOT NULL';
          SELECT createobject(vsql,'Unable to alter table '||vschema||'.mdm_custom_field to add field_type columns.','Y') INTO tmp_result;
          VSQL := 'ALTER TABLE '||VSCHEMA||'.mdm_custom_field DROP COLUMN drop_down';
          SELECT createobject(vsql,'Unable to alter table '||VSCHEMA||'.mdm_custom_field  drop column DROP_DOWN','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'3.3.3','3.3.4') into tmp_result;
        END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release from 3.3.4.0(CMS 3.0.000.xx) to 3.3.5.0(CMS 3.0.000.xx) -- chg 6  
    ---------------------------------------------------------------------------------------------- 
*/
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.4'  THEN 
          --CreateMetaEnhancement();        -- this line has tobe removed, since procedure name changed to createme.
          -- comeback here
          --SELECT createme(vschema, 'METADATA_ENHANCEMENT','6.0.0') into tmp_result;
           select set_version(vschema, comp_name,'3.3.4','3.3.5') into tmp_result;
        END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release from 3.3.5.0(CMS 3.0.000.xx) to 3.3.6.0(CMS 3.0.000.xx) -- chg 7  
    ---------------------------------------------------------------------------------------------- 
*/
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.5'  THEN 
          VSQL := 'ALTER TABLE '||VSCHEMA||'.ME_FIELD_DEFINITION DROP CONSTRAINT ME_FIELD_DEFINITION_UK1';
          SELECT createobject(vsql,'Unable to alter table '||VSCHEMA||'.ME_FIELD_DEFINITION DROP CONSTRAINT ME_FIELD_DEFINITION_UK1','Y') INTO tmp_result;      

          VSQL := 'ALTER TABLE '||VSCHEMA||'.sch_ruleparameter ALTER COLUMN value TYPE varchar(1000)';
          SELECT createobject(vsql,'Unable to alter table '||VSCHEMA||'.sch_ruleparameter ALTER COLUMN value TYPE varchar(1000)','Y') INTO tmp_result;           select set_version(vschema, comp_name,'3.3.5','3.3.6') into tmp_result;
        END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release from 3.3.6.0(CMS 3.0.000.xx) to 3.3.7.0(CMS 3.0.000.xx) -- chg 8  
    ---------------------------------------------------------------------------------------------- 
*/
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.6'  THEN 
          VSQL := 'alter table '||VSCHEMA||'.ME_IDENTIFIER_CRITERIA drop constraint ME_IDENTIFIER_CRITERIA_UK1';
          SELECT createobject(vsql,'Unable to alter table '||VSCHEMA||'.ME_IDENTIFIER_CRITERIA drop constraint ME_IDENTIFIER_CRITERIA_UK1','Y') INTO tmp_result;      

          VSQL := 'alter table '||VSCHEMA||'.ME_IDENTIFIER_CRITERIA add constraint ME_IDENTIFIER_CRITERIA_UK1 UNIQUE (PROFILE_ID, KEY_FIELD_ID)';
          SELECT createobject(vsql,'Unable to alter table '||VSCHEMA||'.ME_IDENTIFIER_CRITERIA add constraint ME_IDENTIFIER_CRITERIA_UK1 UNIQUE (PROFILE_ID, KEY_FIELD_ID))','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'3.3.6','3.3.7') into tmp_result;
        END IF;
/*---- Start of Convert release from 3.3.7.0(CMS 3.0.000.xx) to 3.3.8.0(CMS 3.0.000.xx) -- chg 9 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;

        IF WK_RELEASE =  '3.3.7'  THEN 
          VSQL := 'alter table '||VSCHEMA||'.ME_CACHE_RESULT ALTER COLUMN REMOTE_ID DROP NOT NULL, ALTER COLUMN YEAR  DROP NOT NULL';
          SELECT createobject(vsql,'Unable to alter table '||VSCHEMA||'.ME_CACHE_RESULT ALTER COLUMN REMOTE_ID DROP NOT NULL, ALTER COLUMN YEAR  DROP NOT NULL','Y') INTO tmp_result;       
           select set_version(vschema, comp_name,'3.3.7','3.3.8') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.3.8.0(CMS 3.0.000.xx) to 3.3.9.0(CMS 3.0.000.xx) -- chg 10 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;

        IF WK_RELEASE =  '3.3.8'  THEN 
          VSQL := 'update '||VSCHEMA||'.sch_pastexecution set orig_execution_time = execution_time, finished = 1';
          SELECT createobject(vsql,'Unable to update '||VSCHEMA||'.sch_pastexecution set orig_execution_time and finished columns.','Y') INTO tmp_result;

          vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION (
                       CORRELATIONID      varchar(128),
                       WORKFLOWREFERNCEID varchar(256),
                       FINISHED           numeric(1,0) DEFAULT(0),
                       CREATEDATE         TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       UPDATEDATE         TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                       CONSTRAINT TRE_BULKEXEC_CORRELATIONID_PK PRIMARY KEY (CORRELATIONID))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TRE_BULKEXECUTION','Y') INTO tmp_result;
          SELECT createupdatetrg(vschema,'TRE_BULKEXECUTION') INTO tmp_result;

          vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION_CONTENTPROC (
                    CORRELATIONID varchar(128),
                    TITLEID       numeric,
                    ruleSetId     numeric(10),
                    CREATEDATE    TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    UPDATEDATE    TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    CONSTRAINT TRE_BULK_CONTENTPROC_CORRID_PK PRIMARY KEY(correlationId, titleId, ruleSetId),
                    CONSTRAINT FK_TRE_BULK_CONTENTPROC_CORRID FOREIGN KEY(correlationId) REFERENCES '||vschema||'.TRE_BULKEXECUTION(correlationId),
                    CONSTRAINT FK_TRE_BULK_CONTENTPROC_TID FOREIGN KEY(TitleID) REFERENCES '||vschema||'.pmm_title(ID_),
                    CONSTRAINT FK_TRE_BULK_CONTENTPROC_RSETID FOREIGN KEY(ruleSetId) REFERENCES '||vschema||'.Tre_RuleSet(ruleSetId))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TRE_BULKEXECUTION_CONTENTPROC','Y') INTO tmp_result;
          SELECT createupdatetrg(vschema,'TRE_BULKEXECUTION_CONTENTPROC') INTO tmp_result;

          vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION_GENERAL (
                    CORRELATIONID varchar(128),
                    TITLEID       numeric,
                    CREATEDATE    TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    UPDATEDATE    TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    CONSTRAINT TRE_BULK_GENERL_CORRID_PK PRIMARY KEY(correlationId, titleId),
                    CONSTRAINT FK_TRE_BULKEXECUTION_GEN_CORRID FOREIGN KEY(correlationId) REFERENCES '||vschema||'.TRE_BULKEXECUTION(correlationId),
                    CONSTRAINT FK_TRE_BULKEXECUTION_GEN_TID FOREIGN KEY(TITLEID) REFERENCES '||vschema||'.PMM_TITLE(ID_))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TRE_BULKEXECUTION_GENERAL','Y') INTO tmp_result;
          SELECT createupdatetrg(vschema,'TRE_BULKEXECUTION_GENERAL') INTO tmp_result;

          vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION_FAILEDTITLES (
                    CORRELATIONID varchar(128),
                    TITLEID       numeric,
                    CREATEDATE    TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    UPDATEDATE    TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    CONSTRAINT TRE_BULK_FAILTITLES_CORRID_PK PRIMARY KEY(correlationId, titleId),
                    CONSTRAINT FK_TRE_BULKEXECUTION_FTS_CORRID FOREIGN KEY(correlationId) REFERENCES '||vschema||'.TRE_BULKEXECUTION(correlationId),
                    CONSTRAINT FK_TRE_BULKEXECUTION_FTS_TID FOREIGN KEY(TITLEID) REFERENCES '||vschema||'.PMM_TITLE(ID_))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TRE_BULKEXECUTION_FAILEDTITLES','Y') INTO tmp_result;
          SELECT createupdatetrg(vschema,'TRE_BULKEXECUTION_FAILEDTITLES') INTO tmp_result;

           select set_version(vschema, comp_name,'3.3.8','3.3.9') into tmp_result;
        END IF;


/*---- Start of Convert release from 3.3.9.0(CMS 3.0.000.xx) to 3.3.10.0(CMS 3.0.000.xx) -- chg 10 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.9'  THEN 
          VSQL := 'DROP TRIGGER IF EXISTS TRE_BULKEXECUTIONTRG ON '||vschema||'.TRE_BULKEXECUTION';
          SELECT createobject(vsql,'Unable to DROP TRIGGER TRE_BULKEXECUTIONTRG.','Y') INTO tmp_result;       
          VSQL := 'DROP SEQUENCE '||vschema||'.TRE_BULKEXECUTION_SEQ';
          SELECT createobject(vsql,'Unable to DROP SEQUENCE '||vschema||'.TRE_BULKEXECUTION_SEQ.','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'3.3.9','3.3.10') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.3.10.0(CMS 3.0.000.xx) to 3.3.11.0(CMS 3.0.000.xx) -- chg 11 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.10'  THEN 
          -- Vishal request on 08/24/2012.
          vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Merge Failure Pattern'',''.*Merge failed for.*'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y') INTO tmp_result;

          vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Translation Error Pattern'',''.*Failure to translate EPG error for.*'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y') INTO tmp_result;

          vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Validation Rule Abort Pattern'',''.*Validation rule caused abort for.*'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y') INTO tmp_result;

          vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Validation Rule Failed Pattern'',''.*Validation rule failed for.*'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y') INTO tmp_result;

          vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Publish Failure Pattern'',''.*Failure to publish EPG data for.*'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y') INTO tmp_result;

          vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
          values (''EPGManager Publish Failure'',''EPGManager Publish Failure Pattern'',1,60,1,60,''LOG'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y') INTO tmp_result;

          vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
          values (''EPGManager Merge Failure Alert'',''EPGManager Merge Failure Pattern'',1,60,1,60,''LOG'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y') INTO tmp_result;

          vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE)
          values (''EPGManager Translation Alert'',''EPGManager Translation Error Pattern'',1,60,1,60,''LOG'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y') INTO tmp_result;

          vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
          values (''EPGManager Validation Rule Alert'',''EPGManager Validation Rule Failed Pattern'',1,60,1,60,''LOG'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y') INTO tmp_result;

          vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE)
          values (''EPGManager Validation Rule Abort'',''EPGManager Validation Rule Abort Pattern'',1,60,1,60,''LOG'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y') INTO tmp_result;

          vsql := 'INSERT INTO '||vschema||'.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL) VALUES(''Login Failed'', 1, ''4'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y') INTO tmp_result;    
    
          vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Merge Failure Alert'',1,''19'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y') INTO tmp_result;    

          vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Publish Failure'',1,''20'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y') INTO tmp_result;    

          vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Translation Alert'',1,''16'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y') INTO tmp_result;    

          vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Validation Rule Alert'',1,''18'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y') INTO tmp_result;    

          vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Validation Rule Abort'',1,''17'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y') INTO tmp_result;

          -- Suneeta Puranik request on 08/28/2012
          vsql := 'CREATE INDEX sites_mso_override_xpath_idx ON '||vschema||'.sites_mso_override(field_xpath)';
          SELECT CREATEOBJECT(vsql,'Unable to create index sites_mso_override_xpath_idx','Y') INTO tmp_result; 

          vsql := 'CREATE INDEX sites_mso_override_mso_idx ON '||vschema||'.sites_mso_override(mso_id)';
          SELECT CREATEOBJECT(vsql,'Unable to create index sites_mso_override_mso_idx','Y') INTO tmp_result;

          vsql := 'CREATE INDEX sites_mso_site_idx ON '||vschema||'.sites_mso(site_id)';
          SELECT CREATEOBJECT(vsql,'Unable to create index sites_mso_site_idx','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'3.3.10','3.3.11') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.3.11.0(CMS 3.0.000.xx) to 3.3.12.0(CMS 3.0.000.xx) -- chg 12 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.11'  THEN 
      -- Suneeta Puranik request on 08/29/2012
          vsql := 'CREATE INDEX sch_ruleparameter_value_idx ON '||vschema||'.sch_ruleparameter(value)';
          SELECT CREATEOBJECT(vsql,'Unable to create index sch_ruleparameter_value_idx','Y') INTO tmp_result; 

          vsql := 'CREATE INDEX sch_wojob_job_idx ON '||vschema||'.sch_wojob(jobid)';
          SELECT CREATEOBJECT(vsql,'Unable to create index sch_wojob_job_idx','Y') INTO tmp_result;

          vsql := 'ALTER TABLE '||vschema||'.sch_job ALTER COLUMN name TYPE varchar(300)';
          SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.sch_job ALTER COLUMN name TYPE varchar.','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'3.3.11','3.3.12') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.3.12.0(CMS 3.0.000.xx) to 3.3.13.0(CMS 3.0.000.xx) -- chg 13 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.12'  THEN 
          vsql := 'ALTER TABLE '||vschema||'.ME_IDENTIFIER_CRITERIA ADD ASSET_TYPE varchar(255)';
          SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.ME_IDENTIFIER_CRITERIA ADD ASSET_TYPE varchar(255)','Y') INTO tmp_result; 
           select set_version(vschema, comp_name,'3.3.12','3.3.13') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.3.13.0(CMS 3.0.000.xx) to 3.3.14.0(CMS 3.0.000.xx) -- chg 14 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.13'  THEN 
          vsql := 'GRANT create view,SELECT ANY DICTIONARY TO WFS';
          --SELECT CREATEOBJECT(vsql,'Unable to GRANT SELECT ANY DICTIONARY TO WFS') INTO tmp_result; 
           select set_version(vschema, comp_name,'3.3.13','3.3.14') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.3.14.0(CMS 3.0.000.xx) to 3.3.15.0(CMS 3.0.000.xx) -- chg 15 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.14'  THEN 
          vsql := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ((select id from '||vschema||'.CMS_LOOKUP_KEY where name=''ORIGINAL''),''AUDIO'')';
          SELECT CREATEOBJECT(vsql,'Unable to Insert Asset Type AUDIO into CMS_LOOKUP_KEY_ASSET_TYPE','Y') INTO tmp_result; 
           select set_version(vschema, comp_name,'3.3.14','3.3.15') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.3.15.0(CMS 3.0.000.xx) to 3.3.16.0(CMS 3.0.000.xx) -- chg 16 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.15'  THEN 
          vsql := 'ALTER TABLE '||vschema||'.pmm_properties ALTER COLUMN name TYPE varchar(4000)';
          SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.pmm_properties ALTER COLUMN name TYPE varchar(4000)','Y') INTO tmp_result; 
           select set_version(vschema, comp_name,'3.3.15','3.3.16') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.3.16.0(CMS 3.0.000.xx) to 3.3.17.0(CMS 3.0.000.xx) -- chg 17 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.16'  THEN 
          vsql := 'create index idx_jbpmaction_event on '||vschema||'.jbpm_action (event_)';
          SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpmaction_event on '||vschema||'.jbpm_action (event_)','Y') INTO tmp_result; 
          vsql := 'create index idx_jbpmaction_exceptionhndlr on '||vschema||'.jbpm_action (exceptionhandler_)';
          SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpmaction_exceptionhndlr on '||vschema||'.jbpm_action (exceptionhandler_)','Y') INTO tmp_result;
          vsql := 'create index idx_jbpm_transition_from on '||vschema||'.jbpm_transition (from_)';
          SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpm_transition_from on '||vschema||'.jbpm_transition (from_)','Y') INTO tmp_result;
          vsql := 'create index idx_jbpm_transition_to on '||vschema||'.jbpm_transition (to_)';
          SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpm_transition_to on '||vschema||'.jbpm_transition (to_)','Y') INTO tmp_result;
          vsql := 'create index idx_jbpm_event_task_node on '||vschema||'.jbpm_event (task_,node_)';
          SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpm_event_task_node on '||vschema||'.jbpm_event (task_,node_)','Y') INTO tmp_result;

          vsql := 'create index idx_tre_action_ruleid on '||vschema||'.tre_action (ruleid)';
          SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_action_ruleid on '||vschema||'.tre_action (ruleid)','Y') INTO tmp_result; 
          vsql := 'create index idx_tre_actionparmval_actionid on '||vschema||'.tre_actionparametervalue(actionid)';
          SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_actionparmval_actionid on '||vschema||'.tre_actionparametervalue(actionid)','Y') INTO tmp_result;
          vsql := 'create index idx_tre_expnode_parentid on '||vschema||'.tre_expnode(parentid)';
          SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_expnode_parentid on '||vschema||'.tre_expnode(parentid)','Y') INTO tmp_result;
          vsql := 'create index idx_tre_rule_rulesetid on '||vschema||'.tre_rule(rulesetid)';
          SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_rule_rulesetid on '||vschema||'.tre_rule(rulesetid)','Y') INTO tmp_result;

          vsql := 'alter table '||vschema||'.cms_assetlist add constraint unq_cms_assetlist_name UNIQUE (name)';
          SELECT CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.cms_assetlist add constraint unq_cms_assetlist_name UNIQUE (name)','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'3.3.16','3.3.17') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.3.17.0(CMS 3.0.000.xx) to 3.3.18.0(CMS 3.0.000.xx) -- chg 18 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.17'  THEN 
          vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) VALUES (''Business Continuance status change pattern'',''.*Business continuance stat change.*'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.alert_names record forBusiness Continuance status change pattern','Y') INTO tmp_result;

          vsql := 'INSERT INTO '||vschema||'.ALERTS (IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE) '||
                  ' VALUES (''Business Continuance status'',''Business Continuance status change pattern'',1,3600,1,3600,''LOG'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.ALERTS record for Business Continuance status change pattern','Y') INTO tmp_result;

          vsql := 'INSERT INTO '||vschema||'.ALERT_ACTIONS(IDENTIFIER,ACTION_TYPE, DETAIL) VALUES (''Business Continuance status'',1,21)';
          SELECT CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.ALERT_ACTIONS record for Business Continuance status change pattern','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'3.3.17','3.3.18') into tmp_result;
        END IF;  

/*---- Start of Convert release from 3.3.18.0(CMS 3.0.000.xx) to 3.3.19.0(CMS 3.0.000.xx) -- chg 19 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.18'  THEN 
          VSQL := 'alter table '||VSCHEMA||'.SITES_MSO_OVERRIDE_HISTORY drop constraint FK_SITES_MOH_MSO_ID';
          SELECT CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.SITES_MSO_OVERRIDE_HISTORY to drop constraint FK_SITES_MOH_MSO_ID','Y') INTO tmp_result;
          
          -- Sanjay request on 11/06/2012          
          vsql := 'alter table '||vschema||'.SITES_MSO_OVERRIDE_HISTORY add mso_name varchar(1000)';
          SELECT CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.SITES_MSO_OVERRIDE_HISTORY add mso_name','Y') INTO tmp_result;

          vsql := 'CREATE INDEX sites_mso_or_hist_msoid_idx ON '||vschema||'.SITES_MSO_OVERRIDE_HISTORY(MSO_ID)';
          SELECT CREATEOBJECT(vsql,'Unable to create index sites_mso_or_hist_msoid_idx','Y') INTO tmp_result; 
    
          VSQL := 'CREATE INDEX sites_mso_or_hist_tleid_idx ON '||VSCHEMA||'.SITES_MSO_OVERRIDE_HISTORY(SITE_TITLE_ID)';
          SELECT CREATEOBJECT(vsql,'Unable to create index sites_mso_or_hist_tleid_idx','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'3.3.18','3.3.19') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.3.19.0(CMS 3.0.000.xx) to 3.3.20.0(CMS 3.0.000.xx) -- chg 20 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.19'  THEN 
          VSQL := 'update '||VSCHEMA||'.ALERT_NAMES set pattern=''.*Business continuance status change.*'' where alert_name=''Business Continuance status change pattern''';
          SELECT CREATEOBJECT(vsql,'Unable to update '||VSCHEMA||'.ALERT_NAMES set pattern=''.*Business continuance status change.*''','Y') INTO tmp_result;

          vsql := 'CREATE INDEX idx_jbpm_vinstance_strval on  '||vschema||'.JBPM_VARIABLEINSTANCE(STRINGVALUE_)';
          SELECT CREATEOBJECT(vsql,'Unable to create index idx_jbpm_vinstance_strval','Y') INTO tmp_result; 

          vsql := 'CREATE INDEX idx_jbpm_vinstance_longval ON '||vschema||'.JBPM_VARIABLEINSTANCE(LONGVALUE_)';
          SELECT CREATEOBJECT(vsql,'Unable to create index idx_jbpm_vinstance_longval','Y') INTO tmp_result; 

           select set_version(vschema, comp_name,'3.3.19','3.3.20') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.3.20.0(CMS 3.0.000.xx) to 3.4.1 (CMS 3.1.000.xx) -- chg 1 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.3.20'  THEN 
          -- Francisco changes on 02/07/2013.
          vsql := 'CREATE TABLE '||vschema||'.CMS_SETTING_GROUP (
                    SETTINGGROUPID numeric(20),
                    GROUP_PATH     varchar(255) NOT NULL,
                    PARENT_PATH    varchar(255),
                    CREATEDATE	   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    UPDATEDATE	   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    CONSTRAINT PK_CMS_SETTING_GROUP_SGID PRIMARY KEY (SETTINGGROUPID))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.CMS_SETTING_GROUP','Y') INTO tmp_result;
          SELECT createseq(vschema,'CMS_SETTING_GROUP') INTO tmp_result;
          SELECT createupdatetrg(vschema,'CMS_SETTING_GROUP') INTO tmp_result;

          VSQL := 'CREATE UNIQUE INDEX IDX_CMS_SETTING_GROUP_GRPPATH ON '||vschema||'.CMS_SETTING_GROUP(GROUP_PATH)';
          SELECT CREATEOBJECT(VSQL,'Unable to CREATE UNIQUE INDEX '||vschema||'.IDX_CMS_SETTING_GROUP_GRPPATH','Y') INTO tmp_result;

          vsql := 'CREATE TABLE '||vschema||'.CMS_SETTING (
                    SETTINGID            numeric(20),
                    SETTING_NAME         varchar(255) NOT NULL,
                    SETTING_VALUE        text,
                    CMS_SETTING_GROUP_ID numeric(20) NOT NULL,
                    CREATEDATE	         TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    UPDATEDATE	         TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    CONSTRAINT CMS_SETTING_SETTINGID_PK PRIMARY KEY (SETTINGID),
                    CONSTRAINT CMS_SETTING_SETTINGGROUPID_FK  FOREIGN KEY (CMS_SETTING_GROUP_ID) REFERENCES '||vschema||'.CMS_SETTING_GROUP(SETTINGGROUPID))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.CMS_SETTING','Y') INTO tmp_result;
          SELECT createseq(vschema,'CMS_SETTING') INTO tmp_result;
          SELECT createupdatetrg(vschema,'CMS_SETTING') INTO tmp_result;

          VSQL := 'CREATE UNIQUE INDEX IDX_CMS_SETTING_SNAME_GRPID ON '||vschema||'.CMS_SETTING(SETTING_NAME, CMS_SETTING_GROUP_ID)';
          SELECT CREATEOBJECT(VSQL,'Unable to CREATE UNIQUE INDEX '||vschema||'.IDX_CMS_SETTING_SNAME_GRPID','Y') INTO tmp_result;

          --  Cherise Ho changes on 02/25/2013.
          vsql := 'CREATE TABLE '||vschema||'.CMS_COMPONENT (
                    COMPONENTID numeric(20),
                    NAME        varchar(100) NOT NULL,
                    BASEURL     varchar(200) NOT NULL,
                    STATUSID    numeric,
                    CREATEDATE	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    UPDATEDATE	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    CONSTRAINT CMS_COMPONENT_PK PRIMARY KEY (COMPONENTID),
                    CONSTRAINT CMS_COMPONENT_UKNAME UNIQUE (NAME))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.CMS_COMPONENT','Y') INTO tmp_result;
          SELECT createseq(vschema,'CMS_COMPONENT') INTO tmp_result;
          SELECT createupdatetrg(vschema,'CMS_COMPONENT') INTO tmp_result;

          VSQL := 'ALTER TABLE '||vschema||'.CMS_MODULE ADD COMPONENTID numeric(20)';
          SELECT CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||vschema||'.CMS_MODULE TO ADD COLUMN COMPONENTID','Y') INTO tmp_result;

          VSQL := 'CREATE INDEX IDX_CMS_COMPONENT_COMPID ON WFS.CMS_MODULE (COMPONENTID)';
          SELECT CREATEOBJECT(VSQL,'Unable to CREATE INDEX '||vschema||'.IDX_CMS_COMPONENT_COMPID','Y') INTO tmp_result;

          VSQL := 'ALTER TABLE '||vschema||'.CMS_MODULE ADD CONSTRAINT CMS_MODULE_UQ_NAME UNIQUE (MODULENAME, COMPONENTID), 
                         ADD CONSTRAINT CMS_MODULE_UQ_DISPLAYNAME UNIQUE (DISPLAYNAME, COMPONENTID),
                         ADD CONSTRAINT CMS_MODULE_COMPONENT_FK FOREIGN KEY (COMPONENTID) REFERENCES '||vschema||'.CMS_COMPONENT (COMPONENTID)';
          SELECT CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||vschema||'.CMS_MODULE ADD THREE CONSTRAINTS.','Y') INTO tmp_result;

          vsql := 'CREATE TABLE '||vschema||'.CMS_PORTAL_USER_PREFERENCES (
                    ID           numeric(20),
                    USERNAME     varchar(100) NOT NULL,
                    COMPONENT    varchar(100) NOT NULL,
                    KEY          varchar(500) NOT NULL,
                    COLUMN_INDEX numeric(20),
                    ROW_INDEX    numeric(20),
                    WIDTH        numeric(20,4),
                    HEIGHT       numeric(20,4),
                    CREATEDATE	 TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    UPDATEDATE	 TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    CONSTRAINT PK_CMS_PORTAL_PREFERENCES PRIMARY KEY (ID),
                    CONSTRAINT UQ_CMS_PORTAL_PREF UNIQUE (USERNAME, COMPONENT, KEY))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.CMS_PORTAL_USER_PREFERENCES','Y') INTO tmp_result;
          SELECT createseq(vschema,'CMS_PORTAL_USER_PREFERENCES') INTO tmp_result;
          SELECT createupdatetrg(vschema,'CMS_PORTAL_USER_PREFERENCES') INTO tmp_result;
          -- comeback here 
          vsql := 'DO $$
                   DECLARE
                      x numeric;
                    BEGIN
                      SELECT COUNT(*) INTO x FROM WFS.CMS_PORTAL_USER_PREFERENCES;
                      IF x = 0 THEN
                        /* default column settings */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT nextval('''||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ''), innerusertable.USERNAME, ''__column__0'', ''__column__0'', 0, -1, 0.5, -1
                          FROM (SELECT DISTINCT USERNAME FROM '||vschema||'.CMS_USER_PREFERENCES WHERE TYPE LIKE ''portlet.order'') innerusertable;
                        
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT nextval('''||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ''), innerusertable.USERNAME, ''__column__1'', ''__column__1'', 1, -1, 0.5, -1
                          FROM (SELECT DISTINCT USERNAME FROM '||vschema||'.CMS_USER_PREFERENCES WHERE TYPE LIKE ''portlet.order'') innerusertable;
                        
                        /* Content Portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT nextval('''||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ''), USERNAME, ''Content'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                            FROM '||vschema||'.CMS_USER_PREFERENCES
                           WHERE TYPE LIKE ''portlet.order''
                             AND KEY in (''ACTIVITY'', ''LAST_MODIFIED'');
                        
                        /* Content Trafficking Portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT nextval('''||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ''), USERNAME, ''Content Trafficking'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                          FROM '||vschema||'.CMS_USER_PREFERENCES
                          WHERE TYPE LIKE ''portlet.order''
                            AND KEY in (''ALERT_LIST'');
                        
                        /* Workflow portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT nextval('''||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ''), USERNAME, ''Workflow'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                          FROM '||vschema||'.CMS_USER_PREFERENCES
                          WHERE TYPE LIKE ''portlet.order''
                            and KEY in (''ACTIVE_RESOURCES'', ''RESOURCE_LIST'', ''RESOURCE_GROUP_QUEUE_LIST'', ''USER_TASK_LIST'', ''WFS.QueuedUserTasksPortlet'', ''WO_STATUS'');
                        
                        /* External Tools portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT nextval('''||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ''), USERNAME, ''External Tools'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                          FROM '||vschema||'.CMS_USER_PREFERENCES
                          WHERE TYPE LIKE ''portlet.order''
                            and KEY in (''CLICK_THROUGH'');
                        
                        /* Sites portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT nextval('''||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ''), USERNAME, ''Sites'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                          FROM '||vschema||'.CMS_USER_PREFERENCES
                          WHERE TYPE LIKE ''portlet.order''
                            and KEY in (''DISTRIBUTION'');
                        
                        /* Scheduler portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT nextval('''||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ''), USERNAME, ''Scheduler'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                          FROM '||vschema||'.CMS_USER_PREFERENCES
                          WHERE TYPE LIKE ''portlet.order''
                            and KEY in (''UPCOMINGJOBS'');
                      END IF;
                    END$$;';
          -- comeback here and uncomment the below line. 
          SELECT CREATEOBJECT(vsql,'Unable to INSERT '||vschema||'.CMS_USER_PREFERENCES data INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES','Y') INTO tmp_result; 

           select set_version(vschema, comp_name,'3.3.20','3.4.1') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.4.1(CMS 3.0.000.xx) to 3.4.2 (CMS 3.1.000.xx) -- chg 2 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.1'  THEN 
          vsql := 'ALTER TABLE '||vschema||'.CMS_PORTAL_USER_PREFERENCES ALTER COLUMN WIDTH TYPE numeric(24,4),
                        ALTER COLUMN HEIGHT TYPE numeric(24,4)';
          SELECT CREATEOBJECT(VSQL,'Unable to ALTER table '||vschema||'.CMS_PORTAL_USER_PREFERENCES.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'3.4.1','3.4.2') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.4.2(CMS 3.0.000.xx) to 3.4.3 (CMS 3.1.000.xx) -- chg 3 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.2'  THEN 
          -- Anna Simonenko changes on 03/04/2013.
          vsql := 'CREATE TABLE '||vschema||'.SITES_MSO_MTM (
                    MSO_ID          numeric,
                    MSO_NAME        varchar(255) NOT NULL,
                    MSO_DESCRIPTION varchar(255),
                    CREATEDATE	    TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    UPDATEDATE	    TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    CONSTRAINT PK_SITES_MSO_MTM_ID PRIMARY KEY (MSO_ID))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.SITES_MSO_MTM','Y') INTO tmp_result;
          SELECT createseq(vschema,'SITES_MSO_MTM') INTO tmp_result;
          SELECT createupdatetrg(vschema,'SITES_MSO_MTM') INTO tmp_result;

          vsql := 'CREATE TABLE '||vschema||'.SITES_MSO_SITE (
                    MSO_ID       numeric NOT NULL,
                    SITE_ID      numeric NOT NULL,
                    CREATEDATE	 TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    UPDATEDATE	 TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    CONSTRAINT PK_SITES_MSO_SITE_MSO_SITE PRIMARY KEY (MSO_ID, SITE_ID),
                    CONSTRAINT FK_SITES_MSO_SITE_MSO_ID FOREIGN KEY (MSO_ID) REFERENCES '||vschema||'.SITES_MSO_MTM (MSO_ID),
                    CONSTRAINT FK_SITES_MSO_SITE_SITE_ID FOREIGN KEY (SITE_ID) REFERENCES '||vschema||'.SITES_SITE (ID_))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.SITES_MSO_SITE','Y') INTO tmp_result;
          SELECT createupdatetrg(vschema,'SITES_MSO_SITE') INTO tmp_result;

           select set_version(vschema, comp_name,'3.4.2','3.4.3') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.4.3(CMS 3.0.000.xx) to 3.4.4 (CMS 3.1.000.xx) -- chg 4 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.3'  THEN       
          -- Daniel Weiner Added a new table tre_ruleset_mso on 03-06-2013
          vsql := 'CREATE TABLE '||vschema||'.TRE_RULESET_MSO (
                    rulesetid     numeric,
                    msoid         numeric,
                    createdate    TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    updatedate    TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                    CONSTRAINT pk_tre_ruleset_mso_rs_msoid primary key(rulesetid, msoid),
                    CONSTRAINT fk_rulesetmso_ruleset FOREIGN KEY (rulesetid) REFERENCES '||vschema||'.tre_ruleset(rulesetid),  
                    CONSTRAINT fk_rulesetmso_mso FOREIGN KEY (msoid) REFERENCES '||vschema||'.sites_mso_mtm(mso_id))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TRE_RULESET_MSO','Y') INTO tmp_result;
          SELECT createupdatetrg(vschema,'TRE_RULESET_MSO') INTO tmp_result;

          vsql := 'ALTER TABLE '||vschema||'.tre_ruleset ADD class_id varchar(10) DEFAULT ''RS'' NOT NULL';
          SELECT CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.tre_ruleset to add column class_id.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'3.4.3','3.4.4') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.4.4(CMS 3.0.000.xx) to 3.4.5 (CMS 3.1.000.xx) -- chg 5 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.4'  THEN       
          -- Daniel added a new record for MSO Override in tre_package table on 03/08/2013.
          vsql := 'insert into '||vschema||'.Tre_PACKAGE(PACKAGEID, N_VERSION,NAME) values(7,1,''MSOOVERRIDE'')';
          SELECT createobject(vsql,'Unable to insert into Tre_PACKAGE','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'3.4.4','3.4.5') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.4.5(CMS 3.0.000.xx) to 3.4.6 (CMS 3.1.000.xx) -- chg 6 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.5'  THEN 
          -- Daniel Weiner removed not null constraint from two columns of sites_mso_override_history table.
          vsql := 'ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY ALTER COLUMN search_value DROP NOT NULL,ALTER COLUMN replacement_value DROP NOT NULL';
          SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY ALTER COLUMNS search_value and replacement_value to NULL','Y') INTO tmp_result; 

           select set_version(vschema, comp_name,'3.4.5','3.4.6') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.4.6(CMS 3.0.000.xx) to 3.4.7 (CMS 3.1.000.xx) -- chg 7 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.6'  THEN 
          -- Anna Simonenko added new column ASSOCIATED_GROUP_NAME in sites_site table on 04/16/2013.
          vsql := 'ALTER TABLE '||vschema||'.sites_site ADD ASSOCIATED_GROUP_NAME varchar(255)';
          SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.sites_site add column ASSOCIATED_GROUP_NAME.','Y') INTO tmp_result; 

          vsql := 'delete from '||vschema||'.ALERT_ACTIONS where IDENTIFIER=''Duplicate Parameters''';
          SELECT CREATEOBJECT(vsql,'Unable to delete record from '||vschema||'.ALERT_ACTIONS where IDENTIFIER=''Duplicate Parameters''','Y') INTO tmp_result; 

          vsql := 'delete from '||vschema||'.ALERTS where IDENTIFIER=''Duplicate Parameters''';
          SELECT CREATEOBJECT(vsql,'Unable to delete record from '||vschema||'.ALERTS where IDENTIFIER=''Duplicate Parameters''','Y') INTO tmp_result; 

          vsql := 'delete from '||vschema||'.ALERT_NAMES where ALERT_NAME=''Duplicate Parameters For Workorder Pattern''';
          SELECT CREATEOBJECT(vsql,'Unable to delete record from '||vschema||'.ALERT_NAMES where ALERT_NAME=''Duplicate Parameters For Workorder Pattern''','Y') INTO tmp_result; 

           select set_version(vschema, comp_name,'3.4.6','3.4.7') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.4.7(CMS 3.0.000.xx) to 3.4.8 (CMS 3.1.000.xx) -- chg 8 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.7'  THEN 
          null;
           select set_version(vschema, comp_name,'3.4.7','3.4.8') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.4.8(CMS 3.0.000.xx) to 3.4.9 (CMS 3.1.000.xx) -- chg 9 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.8'  THEN 
          --- Daniel added new column ACTION_NAME in sites_mso_override_history on 04/18/2013.
          vsql :='ALTER TABLE '||vschema||'.sites_mso_override_history ADD ACTION_NAME varchar(255)';
          SELECT CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||vschema||'.sites_mso_override_history ADD column ACTION_NAME.','Y') INTO tmp_result;

          vsql :=  'UPDATE '||vschema||'.sites_mso_override_history SET action_name = ''overrideLegacy''';
          SELECT CREATEOBJECT(vsql,'Unable to UPDATE action_name column in '||vschema||'.sites_mso_override_history.','Y') INTO tmp_result;

          --- Suresh Neravati added a new column in system_settings table.
          vsql :='ALTER TABLE '||vschema||'.system_settings ADD CREATEDATE TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL';
          SELECT CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||vschema||'.system_settings add column CREATEDATE.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'3.4.8','3.4.9') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.4.9(CMS 3.0.000.213) to 3.4.10 (CMS 3.1.000.xx) -- chg 10 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.9'  THEN 
          -- Suresh Neravati added a trigger system_settingsupd on 05/14/2013. 
          -- comeback here to change the trigger to postgres format
          --vsql :=  'CREATE OR REPLACE TRIGGER system_settingsupd before update ON '||VSCHEMA||'.system_settings FOR EACH ROW BEGIN  SELECT current_timestamp INTO :new.createdate FROM dual; END;';
          vsql := 'CREATE OR REPLACE FUNCTION '||VSCHEMA||'.func_system_settingsupd() RETURNS TRIGGER AS $$ BEGIN  SELECT current_timestamp INTO :new.createdate FROM dual; END; $$ language plpgsql';
          SELECT CREATEOBJECT(vsql,'Unable to create trigger function '||VSCHEMA||'.func_system_settingsupd','Y') INTO tmp_result;

          vsql := 'CREATE OR REPLACE TRIGGER system_settingsupd before update ON '||VSCHEMA||'.system_settings FOR EACH ROW EXECUTE PROCEDURE '||VSCHEMA||'.func_system_settingsupd()';
          SELECT CREATEOBJECT(vsql,'Unable to create trigger '||VSCHEMA||'.system_settingsupd','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'3.4.9','3.4.10') into tmp_result;
        END IF;



/*---- Start of Convert release from 3.4.10(CMS 3.0.000.213) to 3.4.11 (CMS 3.1.000.xx) -- chg 11 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.10'  THEN 
          -- Suresh Neravati added the index me_cache_result_request_idx on 05/16/2013.
          vsql := 'CREATE INDEX ME_CACHE_RESULT_REQUEST_IDX ON '||vschema||'.ME_CACHE_RESULT( REQUEST_ID)';
          SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX '||vschema||'.ME_CACHE_RESULT_REQUEST_IDX','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'3.4.10','3.4.11') into tmp_result;
        END IF;

/*---- Start of Convert release from 3.4.11(CMS 3.0.000.213) to 3.4.12 (CMS 3.1.000.xx) -- chg 12 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.11'  THEN 
          vsql := 'ALTER TABLE '||vschema||'.CMS_ROLE ADD HIDDEN varchar(1) DEFAULT 0 NOT NULL check (HIDDEN in (''0'',''1''))';
          SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.CMS_ROLE ADD HIDDEN column','Y') INTO tmp_result;
          
          vsql := 'INSERT INTO '||vschema||'.CMS_ROLE(ROLE_NAME, DESCRIPTION, HIDDEN) VALUES(''_services_'', ''services role - system use only'', ''1'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE','Y') INTO tmp_result;

          vsql := 'ALTER TABLE '||vschema||'.CMS_USER ADD HIDDEN varchar(1) DEFAULT 0 NOT NULL check (HIDDEN in (''0'',''1''))';
          SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.CMS_USER ADD HIDDEN column','Y') INTO tmp_result;      

          vsql := 'INSERT INTO '||vschema||'.CMS_USER(USERNAME, PASSWORD, ACTIVE, FIRSTNAME, LASTNAME, EMAIL, HIDDEN) VALUES
                   (''services'', ''8744d9c7ddf4a59d758114146ea754b670ce89ee'', ''1'', ''services2'',''services'', ''test@test.com'', ''1'')';
          SELECT CREATEOBJECT(vsql,'Unable to insert CMS_USER services','Y') INTO tmp_result;
          
          vsql := 'INSERT INTO '||vschema||'.CMS_USERROLES (USERID, ROLEID) SELECT u.USERID, r.ROLEID FROM '||vschema||'.CMS_USER u CROSS JOIN '||vschema||'.CMS_ROLE r WHERE u.USERNAME = ''services'' and r.ROLE_NAME = ''_services_''';
          SELECT CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.CMS_USERROLES for the ROLE Services','Y') INTO tmp_result; 
          
          vsql := 'DO $$
                   DECLARE 
                     settingsModuleId numeric;
                   BEGIN
                     BEGIN
                       SELECT MODULEID INTO settingsModuleId FROM '||vschema||'.CMS_MODULE WHERE MODULENAME = ''SettingsManagement'';
                       EXCEPTION
                         WHEN NO_DATA_FOUND THEN settingsModuleId := NULL;
                     END;
                     IF settingsModuleId IS NULL THEN
                       INSERT INTO '||vschema||'.CMS_MODULE(MODULEID, MODULENAME, DISPLAYNAME) VALUES (nextval('''||vschema||'.CMS_MODULE_SEQ''),''SettingsManagement'', ''Settings Management'');
                       INSERT INTO '||vschema||'.CMS_PERMISSION(PERMISSIONNAME, DISPLAYNAME, MODULEID, ORDERnumeric) values (''View'', ''View'', currval('''||vschema||'.CMS_MODULE_SEQ''), 0 );
                       INSERT INTO '||vschema||'.CMS_PERMISSION(PERMISSIONNAME, DISPLAYNAME, MODULEID, ORDERnumeric) values (''Modify'', ''Modify'', currval('''||vschema||'.CMS_MODULE_SEQ''), 1);
                     END IF;
                     SELECT MODULEID INTO settingsModuleId FROM '||vschema||'.CMS_MODULE WHERE MODULENAME = ''SettingsManagement'';
                     INSERT INTO '||vschema||'.CMS_ROLEPERMISSIONS(ROLEID, PERMISSIONID) (SELECT r.ROLEID, p.PERMISSIONID from '||vschema||'.CMS_ROLE r CROSS JOIN '||vschema||'.CMS_PERMISSION p 
                      WHERE r.ROLE_NAME = ''_services_'' and p.MODULEID = settingsModuleId);
                   END $$;';
          -- comeback here to change the code to postgres format
          SELECT CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.CMS_MODULE, '||vschema||'.CMS_PERMISSION and '||vschema||'.CMS_ROLEPERMISSIONS','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'3.4.11','3.4.12') into tmp_result;
        END IF;

	/*---- Start of Convert release from 3.4.12 (CMS 3.1) to 3.4.13 (CMS 3.1.010)  --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.12'  THEN 

           vsql := 'DO $$declare
                       vmdm_sites_count numeric(15):=0;
                       sitetbl_exists numeric(5)=0;
                    begin
                       select count(*) into sitetbl_exists from all_all_tables where table_name=''MDM_METADATA_SITE'';
                       if (sitetbl_exists = 0) then
                          create table '||vschema||'.mdm_metadata_site as 
                          select sys_nc_rowinfo$ 
                             from wfs.mdm_metadata 
                           where CAST ((xpath (''/ECMFSpec/@documentId''::text, sys_nc_rowinfo$)::text[])[1]::text as numeric) 
                                   in (select mdmdocid from wfs.pmm_title where originaltitle_id is not null);

                          select count(*) into vmdm_sites_count from wfs.mdm_metadata_site;
                          if (vmdm_sites_count>0) then
                              delete from '||vschema||'.mdm_metadata 
                               where CAST ((xpath (''/ECMFSpec/@documentId''::text, sys_nc_rowinfo$)::text[])[1]::text as numeric) 
                                         in (select mdmdocid from wfs.pmm_title where originaltitle_id is not null);
                          end if;
                        end if;
                    end $$;';
          -- comeback here to change the code to postgres format
          -- SELECT CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.mdm_metadata_site and delete sites data from '||vschema||'.mdm_metadata.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'3.4.12','3.4.13') into tmp_result;
         END IF;

	/*---- Start of Convert release from 3.4.13 to 4.0.0 (CMS 4.0.0)  --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '3.4.13'  THEN 

           vsql := 'CREATE TABLE '||vschema||'.MDM_ELASTIC_SEARCH_FAILED_TITLES (
                           title_id   numeric     NOT NULL,
                           CREATEDATE TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                           UPDATEDATE TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                           CONSTRAINT pk_elsearch_failed_title_id PRIMARY KEY(title_id))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.MDM_ELASTIC_SEARCH_FAILED_TITLES','Y') INTO tmp_result;


           vsql := 'ALTER TABLE '||vschema||'.mdm_metadata RENAME COLUMN sys_nc_rowinfo$ TO document';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'wfs.mdm_metadata RENAME COLUMN sys_nc_rowinfo$','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||vschema||'.mdm_metadata 
                             ADD COLUMN document_id numeric(19),
                             ADD CONSTRAINT idx_mdm_metadata_uk UNIQUE (document_id)';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.mdm_metadata ADD columns document_id','Y') INTO tmp_result;

           vsql := 'UPDATE '||vschema||'.mdm_metadata SET document_id = CAST((xpath (''/ECMFSpec/@documentId''::text, document)::text[])[1]::text as numeric)'; 
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE TABLE '||vschema||'.mdm_metadata for columns document_id and latest_revision','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||vschema||'.mdm_metadata ALTER COLUMN document_id SET NOT NULL';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.mdm_metadata ALTER COLUMN document_id SET NOT NULL','Y') INTO tmp_result;


           vsql := 'ALTER TABLE '||vschema||'.mdm_metadata_site RENAME COLUMN sys_nc_rowinfo$ TO document';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.mdm_metadata_site RENAME COLUMN sys_nc_rowinfo$','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||vschema||'.mdm_metadata_site 
                             ADD COLUMN document_id numeric(19),
                             ADD CONSTRAINT idx_mdm_metadata_site_uk UNIQUE (document_id)';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.mdm_metadata_site ADD columns document_id','Y') INTO tmp_result;

           vsql := 'UPDATE '||vschema||'.mdm_metadata_site SET document_id = CAST((xpath (''/ECMFSpec/@documentId''::text, document)::text[])[1]::text as numeric)'; 
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE TABLE '||vschema||'.mdm_metadata_site for columns document_id','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||vschema||'.mdm_metadata_site ALTER COLUMN document_id SET NOT NULL';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.mdm_metadata_site ALTER COLUMN document_id SET NOT NULL','Y') INTO tmp_result;


           vsql := 'ALTER TABLE '||vschema||'.mdm_metadata_revision RENAME COLUMN sys_nc_rowinfo$ TO document';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.mdm_metadata_revision RENAME COLUMN sys_nc_rowinfo$','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||vschema||'.mdm_metadata_revision 
                             ADD COLUMN document_id numeric(19),
                             ADD COLUMN revision numeric(19)';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.mdm_metadata_revision ADD columns document_id and revision','Y') INTO tmp_result;

           vsql := 'UPDATE '||vschema||'.mdm_metadata_revision SET document_id = CAST((xpath (''/ECMFSpec/@documentId''::text, document)::text[])[1]::text as numeric),
                                               revision = CAST((xpath (''/ECMFSpec/@revision''::text, document)::text[])[1]::text as numeric)'; 
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE TABLE '||vschema||'.mdm_metadata_revision for columns document_id and revision','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||vschema||'.mdm_metadata_revision ALTER COLUMN document_id SET NOT NULL';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.mdm_metadata_revision ALTER COLUMN document_id SET NOT NULL','Y') INTO tmp_result;


           vsql := 'alter table '||vschema||'.qrtz_job_details
                        ALTER COLUMN IS_DURABLE DROP DEFAULT, ALTER COLUMN IS_DURABLE TYPE BOOLEAN USING (IS_DURABLE <> 0),
                        ALTER COLUMN IS_VOLATILE DROP DEFAULT, ALTER COLUMN IS_VOLATILE TYPE BOOLEAN USING (IS_VOLATILE <> 0),
                        ALTER COLUMN IS_STATEFUL DROP DEFAULT, ALTER COLUMN IS_STATEFUL TYPE BOOLEAN USING (IS_STATEFUL <> 0),
                        ALTER COLUMN REQUESTS_RECOVERY DROP DEFAULT, ALTER COLUMN REQUESTS_RECOVERY TYPE BOOLEAN USING (REQUESTS_RECOVERY <> 0)';
           SELECT CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.qrtz_job_details columns from numeric to boolean datatype.','Y') INTO tmp_result;

           vsql := 'alter table '||vschema||'.qrtz_triggers ALTER COLUMN IS_VOLATILE DROP DEFAULT, ALTER COLUMN IS_VOLATILE TYPE BOOLEAN USING (IS_VOLATILE <> 0)';
           SELECT CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.qrtz_triggers column from numeric to boolean datatype.','Y') INTO tmp_result;

           vsql := 'alter table '||vschema||'.qrtz_fired_triggers
                        ALTER COLUMN IS_VOLATILE DROP DEFAULT, ALTER COLUMN IS_VOLATILE TYPE BOOLEAN USING (IS_VOLATILE <> 0),
                        ALTER COLUMN IS_STATEFUL DROP DEFAULT, ALTER COLUMN IS_STATEFUL TYPE BOOLEAN USING (IS_STATEFUL <> 0),
                        ALTER COLUMN REQUESTS_RECOVERY DROP DEFAULT, ALTER COLUMN REQUESTS_RECOVERY TYPE BOOLEAN USING (REQUESTS_RECOVERY <> 0)';
           SELECT CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.qrtz_fired_triggers columns from numeric to boolean datatype.','Y') INTO tmp_result;

           vsql := 'CREATE OR REPLACE FUNCTION '||vschema||'.FUNC_PMM_TITLE_PURGE_INSERT_UPD() RETURNS TRIGGER AS $$
                    BEGIN'|| 
                      ' IF (INSERTING AND NOT (:NEW.RETIREMENT_DATE IS NULL) ) OR (UPDATING AND (NVL(:NEW.RETIREMENT_DATE,(current_timestamp-10000)) <> NVL(:OLD.RETIREMENT_DATE,(current_timestamp-10000))'||
                         '  AND :OLD.ORIGINALTITLE_ID IS NULL)) THEN'|| 
                               ' INSERT INTO '||vschema||'.PMM_TITLE_PURGE_HISTORY (TITLE_ID, PROVIDER_ID, '|| 
                                      ' PROVIDER_NAME, TITLE_RETIREMENT_DATE, TITLE_BRIEF, '|| 
                                      ' PACKAGE_ASSET_ID, ASSET_NAME,LICENSE_START,LICENSE_END)'|| 
                                ' SELECT :NEW.ID_, p.PROVIDERID,  p.NAME, :NEW.RETIREMENT_DATE, '||
                                   ' CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/DisplayTitle/Value/text()'', vmf.document)::text[])[1]::text as VARCHAR) AS title_brief,'||
                                   ' CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'', vmf.document)::text[])[1]::text as VARCHAR) as package_assetid,'||
                                   ' CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'',vmf.document)::text[])[1]::text as VARCHAR) AS asset_name,'||
                                   ' CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'',vmf.document)::text[])[1] as timestamp) as licensing_startdt,'||
                                   ' CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'',vmf.document)::text[])[1] as timestamp) AS licensing_enddt '||
                                '   FROM '||vschema||'.mdm_metadata  vmf, '||vschema||'.pmm_partner p '||
                                '  WHERE vmf.document_id = :NEW.MDMDOCID  '||
                                '    AND (p.id_ = :NEW.PARTNER_ID); '|| 
                      ' END IF;'|| 
                    ' END; $$';
           SELECT CREATEOBJECT(vsql,'Unable to create trigger function FUNC_PMM_TITLE_PURGE_INSERT_UPD','Y') INTO tmp_result;
           -- comeback here to change the code to postgres format, check if it is required or not also
           vsql := 'CREATE OR REPLACE TRIGGER PMM_TITLE_PURGE_INSERTTRG AFTER UPDATE OR INSERT ON '||vschema||'.PMM_TITLE FOR EACH ROW EXECUTE PROCEDURE '||vschema||'.FUNC_PMM_TITLE_PURGE_INSERT_UPD()'; 
           SELECT CREATEOBJECT(vsql,'Unable to create trigger PMM_TITLE_PURGE_INSERTTRG','Y') INTO tmp_result;

  -- Creating View VDW_NODE
           vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_NODE ( NODEID, NODECLASS, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKID, TASKNAME, ISSTARTNODE, RESOURCEGROUPID, RESOURCEGROUPNAME, RESOURCETYPEID, RESOURCETYPENAME, TASKCONTROLLERID, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  n.ID_ NodeId,
                                  CASE when n.CLASS_= ''D'' then ''DECISION''
                                       when n.CLASS_= ''E'' then ''END''
                                       when n.CLASS_= ''R'' then ''START''
                                       when n.CLASS_= ''Y'' then ''MANUAL''
                                       when n.CLASS_= ''Z'' then ''AUTOMATED''
                                       else ''UNKNOWN''
                                       end as  NodeClass,
                                  n.NAME_ NodeName,
                                  n.PROCESSDEFINITION_ ProcessDefinitionId,
                                  d.NAME_ ProcessDefinitionName,
                                  n.NODECOLLECTIONINDEX_ NodeIndex,
                                  t.ID_ TaskId,
                                  t.NAME_ TaskName,
                                  case when COALESCE(d.STARTSTATE_, -1)=-1 then 0
                                       else 1 end as IsStartNode,
                                  n.ResourceGroupId,
                                  COALESCE (g.Name, ''[N/A]'') ResourceGroupName,
                                  g.ResourceTypeId,
                                  COALESCE (ty.Name, ''[N/A]'') ResourceTypeName,
                                  TASKCONTROLLER_ TaskControllerId,
                                  d.ProcessDefinitionTypeId,
                                  dt.Name ProcessDefinitionTypeName,
                                  n.CreateDate,
                                  n.UpdateDate
                          FROM    '||vschema||'.JBPM_NODE n
                          JOIN    '||vschema||'.JBPM_PROCESSDEFINITION d
                          ON (    d.ID_ = n.PROCESSDEFINITION_)
                          JOIN    '||vschema||'.TTV_ProcessDefinitionType dt
                          ON (    dt.ProcessDefinitionTypeId = d.ProcessDefinitionTypeId)
                          LEFT JOIN '||vschema||'.TTV_ResourceGroup g
                          ON (    g.ResourceGroupId = n.ResourceGroupId)
                          LEFT JOIN '||vschema||'.TTV_ResourceType ty
                          ON (    ty.ResourceTypeId = g.ResourceTypeId)
                          LEFT JOIN '||vschema||'.JBPM_TASK t
                          ON (    t.TASKNODE_ = n.ID_
                          OR              t.STARTSTATE_ = n.ID_)';
           SELECT CREATEOBJECT(vsql,'Unable to create view VDW_NODE','Y') INTO tmp_result;
 
      -- Creating View VDW_PROCESSINSTANCE
           vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_PROCESSINSTANCE ( PROCESSINSTANCEID, LOCALSTARTDATE, LOCALENDDATE, ISSUSPENDED, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, ADMINSTATUSID, ADMINSTATUS, OPERSTATUSID, OPERSTATUS, PRIORITYID, PRIORITY, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  I.ID_ PROCESSINSTANCEID,
                                  START_ LOCALSTARTDATE,
                                  END_ LOCALENDDATE,
                                  ISSUSPENDED_ ISSUSPENDED,
                                  PROCESSDEFINITION_ PROCESSDEFINITIONID,
                                  NAME_ PROCESSDEFINITIONNAME,
                                  ADMINISTRATIVEPROCESSSTATUSID ADMINSTATUSID,
                                  ADS.NAME ADMINSTATUS,
                                  OPERATIONALPROCESSSTATUSID OPERSTATUSID,
                                  OPS.NAME OPERSTATUS,
                                  I.PROCESSPRIORITYID PRIORITYID,
                                  COALESCE(P.NAME, ''[N/A]'') PRIORITY,
                                  d.ProcessDefinitionTypeId,
                                  dt.Name ProcessDefinitionTypeName,
                                  I.CREATEDATE,
                                  I.UPDATEDATE
                          FROM    '||vschema||'.JBPM_PROCESSINSTANCE I
                          JOIN    '||vschema||'.JBPM_PROCESSDEFINITION D
                          ON (    D.ID_ = PROCESSDEFINITION_)
                          JOIN    '||vschema||'.TTV_ProcessDefinitionType dt
                          ON (    dt.ProcessDefinitionTypeId = d.ProcessDefinitionTypeId)
                          LEFT JOIN '||vschema||'.TTV_PROCESSPRIORITY P
                          ON (    P.PROCESSPRIORITYID = I.PROCESSPRIORITYID)
                          JOIN    '||vschema||'.TTV_PROCESSSTATUS ADS
                          ON (    ADS.PROCESSSTATUSID = ADMINISTRATIVEPROCESSSTATUSID)
                          JOIN    '||vschema||'.TTV_PROCESSSTATUS OPS
                          ON (    OPS.PROCESSSTATUSID = OPERATIONALPROCESSSTATUSID)';
          SELECT CREATEOBJECT(vsql,'Unable to create view VDW_PROCESSINSTANCE','Y') INTO tmp_result;
 
      -- Creating View VDW_LOG
           vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_LOG
                          AS 
                  SELECT	l.ID_ LogId,
                          l.CLASS_ LogClass,
                          case when l.CLASS_=''N'' then ''NODE''
                               when l.CLASS_=''7'' then ''MESSAGE''
                               when l.CLASS_=''8'' then ''USAGE''
                               when l.CLASS_=''9'' then ''QUEUE''	
                               else ''UNKNOWN'' 
                               end as LogClassName,
                          l.DATE_ LocalDate,
                          n.ProcessDefinitionId,
                          n.ProcessDefinitionName,
                          p.ProcessInstanceId,
                          p.ProcessDefinitionTypeId,
                          l.NODE_ NodeId,
                          n.NodeClass,
                          n.NodeName,
                          n.NodeIndex,
                          n.IsStartNode,
                          l.ENTER_ LocalEnterDate,
                          l.LEAVE_ LocalLeaveDate,
                          l.DURATION_ Duration,
                          l.ResourceGroupId,
                          COALESCE(g.Name, ''[N/A]'') ResourceGroupName,
                          g.ResourceTypeId,
                          COALESCE(ty.Name, ''[N/A]'') ResourceTypeName,
                          l.ResourceId,
                          COALESCE (r.Name, ''[N/A]'') ResourceName,
                          AdministrativeStatusId	AdminStatusId,
                          ads.Name AdminStatus,
                          OperationalStatusId	OperStatusId,
                          ops.Name OperStatus,
                          INDEX_,
                          l.TOKEN_ TokenId,
                          l.CreateDate,
                          l.UpdateDate
                    FROM	'||vschema||'.JBPM_LOG l
                          JOIN	'||vschema||'.vDW_NODE n
                          ON (	n.NodeId = l.NODE_)
                          JOIN	'||vschema||'.JBPM_TOKEN t
                          ON (	t.ID_ = l.TOKEN_)
                          JOIN	'||vschema||'.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = t.PROCESSINSTANCE_)
                          LEFT JOIN '||vschema||'.TTV_ResourceGroup g
                          ON (	g.ResourceGroupId = l.ResourceGroupId)
                          LEFT JOIN '||vschema||'.TTV_ResourceType ty
                          ON (	ty.ResourceTypeId = g.ResourceTypeId)
                          LEFT JOIN '||vschema||'.TTV_Resource r
                          ON (	r.ResourceId = l.ResourceId)
                          LEFT JOIN '||vschema||'.TTV_ProcessStatus ads
                          ON (	ads.ProcessStatusId = l.AdministrativeStatusId)
                          LEFT JOIN '||vschema||'.TTV_ProcessStatus ops
                          ON (	ops.ProcessStatusId = l.OperationalStatusId)';
          SELECT CREATEOBJECT(vsql,'Unable to create view VDW_LOG','Y') INTO tmp_result;
 
      -- Creating View VDW_TASKINSTANCE
  
           vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_TASKINSTANCE ( TASKINSTANCEID, TASKINSTANCENAME, LOCALCREATEDATE, LOCALENDDATE, ISCANCELLED, ISSUSPENDED, ISOPEN, TASKID, NODEID, NODECLASS, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKNAME, ISSTARTNODE, TASKCONTROLLERID, TOKENID, PROCESSINSTANCEID, CURRENTADMINSTATUSID, CURRENTADMINSTATUS, CURRENTOPERSTATUSID, CURRENTOPERSTATUS, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	i.ID_ TaskInstanceId,
                                  i.NAME_ TaskInstanceName,
                                  i.CREATE_ LocalCreateDate,
                                  i.END_ LocalEndDate,
                                  i.ISCANCELLED_ IsCancelled,
                                  i.ISSUSPENDED_ IsSuspended,
                                  i.ISOPEN_ IsOpen,
                                  i.TASK_ TaskId,
                                  n.NodeId,
                                  n.NodeClass,
                                  n.NodeName,
                                  n.ProcessDefinitionId,
                                  n.ProcessDefinitionName,
                                  n.NodeIndex,
                                  n.TaskName,
                                  n.IsStartNode,
                                  n.TaskControllerId,
                                  i.TOKEN_ TokenId,
                                  p.ProcessInstanceId,
                                  p.AdminStatusId CurrentAdminStatusId,
                                  p.AdminStatus CurrentAdminStatus,
                                  p.OperStatusId CurrentOperStatusId,
                                  p.OperStatus CurrentOperStatus,
                                  n.ProcessDefinitionTypeId,
                                  n.ProcessDefinitionTypeName,
                                  i.CREATEDATE,
                                  i.UPDATEDATE
                          FROM	'||vschema||'.JBPM_TASKINSTANCE i
                          JOIN	'||vschema||'.vDW_NODE n
                          ON (	n.TaskId = i.TASK_)
                          JOIN	'||vschema||'.JBPM_TOKEN t
                          ON (	t.ID_ = i.TOKEN_)
                          JOIN	'||vschema||'.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = t.PROCESSINSTANCE_)';
          SELECT CREATEOBJECT(vsql,'Unable to create view VDW_TASKINSTANCE','Y') INTO tmp_result;

          -- Creating View VDW_VARIABLEACCESS
           vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_VARIABLEACCESS ( VARIABLEACCESSID, VARIABLENAME, ACCESSTYPE, MAPPEDNAME, TASKCONTROLLERID, VARIABLEINDEX, DATATYPEID, DATATYPENAME, NODEID, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKNAME, ISSTARTNODE, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	v.ID_ VariableAccessId,
                                  v.VARIABLENAME_ VariableName,
                                  v.ACCESS_ AccessType,
                                  v.MAPPEDNAME_ MappedName,
                                  v.TASKCONTROLLER_ TaskControllerId,
                                  v.Index_ VariableIndex,
                                  v.DataTypeId,
                                  t.DataTypeName,
                                  n.NodeId,
                                  n.NodeName,
                                  n.ProcessDefinitionId,
                                  n.ProcessDefinitionName,
                                  n.NodeIndex,
                                  n.TaskName,
                                  n.IsStartNode,
                                  n.ProcessDefinitionTypeId,
                                  n.ProcessDefinitionTypeName,
                                  v.CreateDate,
                                  v.UpdateDate
                          FROM	'||vschema||'.JBPM_VARIABLEACCESS v
                          JOIN	'||vschema||'.TTV_DATATYPE t
                          ON (	t.DataTypeId = v.DataTypeId)
                          JOIN	'||vschema||'.vDW_Node n
                          ON (	n.TaskControllerId = v.TASKCONTROLLER_)';
          SELECT CREATEOBJECT(vsql,'Unable to create view VDW_VARIABLEACCESS','Y') INTO tmp_result;

          -- Creating View VDW_VARIABLEINSTANCE
           vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_VARIABLEINSTANCE ( VARIABLEINSTANCEID, CLASSCODE, CLASSNAME, VARIABLEINSTANCENAME, TOKENID, ISGLOBALVARIABLE, PROCESSINSTANCEID, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NUMERICVALUE, STRINGVALUE, LONGVALUE_, STRINGVALUE_, DOUBLEVALUE_, TOKENVARIABLEMAP_, TASKINSTANCEID, TASKINSTANCENAME, TASKID, NODEID, NODECLASS, NODENAME, NODEINDEX, TASKNAME, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  i.ID_    VariableInstanceId,
                                  i.CLASS_ ClassCode,
                                  case when i.CLASS_=''N'' then ''NULL''
                                       when i.CLASS_=''S'' then ''STRING''
                                       when i.CLASS_=''L'' then ''LONG''
                                       else ''[UNKNOWN]'' end as ClassName,
                                  i.NAME_ VariableInstanceName,
                                  i.TOKEN_ TokenId,
                                  case when COALESCE(i.TOKENVARIABLEMAP_, -1)=-1 then 0
                                       else 1 end as IsGlobalVariable,
                                  i.PROCESSINSTANCE_ ProcessInstanceId,
                                  p.ProcessDefinitionId,
                                  p.ProcessDefinitionName,
                                  case when i.CLASS_=''L'' then 
                                      COALESCE(i.LONGVALUE_,TO_number(i.DOUBLEVALUE_::text,''9999999999999999D999999''::text))
                                  else 
                                      NULL 
                                  end as NumericValue,
                                  case when i.CLASS_=''L'' then NULL
                                  else i.STRINGVALUE_ end as StringValue,
                                  i.LONGVALUE_,
                                  i.STRINGVALUE_,
                                  i.DOUBLEVALUE_,
                                  i.TOKENVARIABLEMAP_,
                                  i.TASKINSTANCE_ TaskInstanceId,
                                  t.TaskInstanceName,
                                  t.TaskId,
                                  t.NodeId,
                                  t.NodeClass,
                                  t.NodeName,
                                  t.NodeIndex,
                                  t.TaskName,
                                  p.ProcessDefinitionTypeId,
                                  p.ProcessDefinitionTypeName,
                                  i.CREATEDATE,
                                  i.UPDATEDATE
                          FROM	'||vschema||'.JBPM_VARIABLEINSTANCE i
                          JOIN	'||vschema||'.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = i.PROCESSINSTANCE_)
                          LEFT JOIN '||vschema||'.vDW_TaskInstance t
                          ON (	t.TaskInstanceId = i.TASKINSTANCE_)';
           SELECT CREATEOBJECT(vsql,'Unable to create view VDW_VARIABLEINSTANCE','Y') INTO tmp_result;

           -- comeback here
           --CreateQueryViews();

           VSQL := 'CREATE VIEW '||vschema||'.VDW_MDM_Metadata_Fields AS '|| 
                    ' SELECT  CAST ((xpath (''/ECMFSpec/@documentId''::text, document)::text[])[1]::text as numeric) AS document_id,'||
                            ' CAST ((xpath (''/ECMFSpec/Package/Fields/AssetName/text()''::text, document)::text[])[1]::text as VARCHAR) AS asset_name,'||
                            ' CAST ((xpath (''/ECMFSpec/Package/Fields/Identifier/Id/text()''::text, document)::text[])[1]::text as VARCHAR) AS package_assetid,'||
                            ' CAST ((xpath (''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()''::text, document)::text[])[1]::text as TIMESTAMP) AS licensing_startdt,'||
                            ' CAST ((xpath (''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()''::text, document)::text[])[1]::text as TIMESTAMP) AS licensing_enddt,'||
                            ' CAST ((xpath (''/ECMFSpec/Package/Title/Fields/Title/DisplayTitle/Value/text()''::text, document)::text[])[1]::text as VARCHAR) AS title_brief '||
                    ' FROM '||VSCHEMA||'.mdm_metadata mdm';
           SELECT CREATEOBJECT(VSQL,'Unable to create view '||vschema||'.VDW_MDM_Metadata_Fields','Y') INTO tmp_result;

           vsql := 'CREATE OR REPLACE VIEW '||vschema||'.VW_CAT_CATEGORY_PATHS AS
                         WITH RECURSIVE path_graph AS
                         (SELECT c, 1 AS level, ARRAY[name::text] AS pathArray 
                            FROM '||vschema||'.CAT_CATEGORY c
                           WHERE id > 0  AND c.parent_category_id = 0 
                         UNION ALL
                          SELECT ci, path_graph.level + 1 AS level, pathArray || name::text 
                            FROM path_graph
                            JOIN '||vschema||'.CAT_CATEGORY ci ON ci.parent_category_id = (path_graph.c).id ) 
                         SELECT      (path_graph.c).name,
                                     (path_graph.c).id,
                                     (path_graph.c).parent_category_id,
                                      array_to_string(pathArray,''/'') AS path,
                                     (path_graph.c).createdate,
                                     (path_graph.c).associated_category_package
                         FROM path_graph';
           -- comeback here to change the code to postgres format
           SELECT CREATEOBJECT(VSQL,'Unable to create view VW_CAT_CATEGORY_PATHS.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'3.4.13','4.0.0') into tmp_result;
         END IF;

        /*---- Start of Convert release from 4.0.0 (CMS 4.0.0) to 4.0.1 (CMS 4.0.0) change 1--- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.0'  THEN 

           vsql := 'ALTER SEQUENCE '||vschema||'.jbpm_processinstance_seq CACHE 1';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER SEQUENCE '||vschema||'.jbpm_processinstance_seq CACHE 1','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.0','4.0.1') into tmp_result;
         END IF;

        /*---- Start of Convert release from 4.0.1(CMS 4.0.0) to 4.0.2 (CMS 4.0.0) change 2 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.1'  THEN 
           vsql := 'DROP TABLE '||vschema||'.MDM_FIELDREVISION';
           SELECT CREATEOBJECT(vsql,'Unable to DROP TABLE '||vschema||'.MDM_FIELDREVISION','Y') INTO tmp_result;

           vsql := 'DROP TABLE '||vschema||'.MDM_FIELD';
           SELECT CREATEOBJECT(vsql,'Unable to DROP TABLE '||vschema||'.MDM_FIELD','Y') INTO tmp_result;

           vsql := 'DROP TABLE '||vschema||'.MDM_RELATION';
           SELECT CREATEOBJECT(vsql,'Unable to DROP TABLE '||vschema||'.MDM_RELATION','Y') INTO tmp_result;

           vsql := 'DROP TABLE '||vschema||'.MDM_ASSET';
           SELECT CREATEOBJECT(vsql,'Unable to DROP TABLE '||vschema||'.MDM_ASSET','Y') INTO tmp_result;

           vsql := 'DROP SEQUENCE '||vschema||'.MDM_FIELDREVISION_SEQ';
           SELECT CREATEOBJECT(vsql,'Unable to DROP SEQUENCE '||vschema||'.MDM_FIELDREVISION_SEQ','Y') INTO tmp_result;

           vsql := 'DROP SEQUENCE '||vschema||'.MDM_FIELD_SEQ';
           SELECT CREATEOBJECT(vsql,'Unable to DROP SEQUENCE '||vschema||'.MDM_FIELD_SEQ','Y') INTO tmp_result;

           vsql := 'DROP SEQUENCE '||vschema||'.MDM_RELATION_SEQ';
           SELECT CREATEOBJECT(vsql,'Unable to DROP SEQUENCE '||vschema||'.MDM_RELATION_SEQ','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.1','4.0.2') into tmp_result;
         END IF;

        /*---- Start of Convert release from 4.0.2(CMS 4.0.0) to 4.0.3 (CMS 4.0.0) change 3 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.2'  THEN 
           vsql := 'do $$declare
                       seqnum numeric(10);
                       maxnum numeric(10);
                    begin
                       select nextval('''||vschema||'.mdm_asset_seq'') into seqnum from dual;
                    exception
                      when others then
                         select nvl(max(mdmdocid),0) into maxnum from wfs.pmm_title;
                         maxnum:=maxnum+200;  
                         execute ''CREATE SEQUENCE wfs.mdm_ASSET_SEQ INCREMENT BY 1 START WITH ''||maxnum||'' NO MAXVALUE'';
                    end$$;';
           -- comeback here to change the code to postgres format
           SELECT CREATEOBJECT(vsql,'Unable to create SEQUENCE mdm_ASSET_SEQ','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.2','4.0.3') into tmp_result;
         END IF;

        /*---- Start of Convert release from 4.0.3(CMS 4.0.0) to 4.0.4 (CMS 4.0.0) change 4 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.3'  THEN 

           vsql := 'CREATE TABLE '||vschema||'.mdm_asset_identifier  (
             asset_id     numeric(19) NOT NULL,
             document_id  numeric(19) NOT NULL,
             keys         json,
             CREATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
             UPDATEDATE   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
             CONSTRAINT mdm_asset_identifier_pk PRIMARY KEY (asset_id))';

          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.MDM_ASSET_IDENTIFIER','Y') INTO tmp_result;
          SELECT createseq(vschema,'MDM_ASSET_IDENTIFIER') INTO tmp_result;
          SELECT createupdatetrg(vschema,'MDM_ASSET_IDENTIFIER') INTO tmp_result;

           vsql := 'CREATE INDEX mdm_assetidf_documentid_idx ON '||vschema||'.mdm_asset_identifier (document_id)';
           SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX mdm_assetidf_documentid_idx','Y') INTO tmp_result;

           vsql := 'CREATE INDEX mdm_assetidf_provider_idx ON '||vschema||'.mdm_asset_identifier ((keys->''Fields''->''ProviderInfo''->''Identifier''->>''Id''))';
           SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX mdm_assetidf_provider_idx ','Y') INTO tmp_result;

           vsql := 'CREATE INDEX mdm_assetidf_identifier_id_idx ON '||vschema||'.mdm_asset_identifier ((keys->''Fields''->''Identifier''->>''Id''))';
           SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX mdm_assetidf_identifier_id_idx','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.3','4.0.4') into tmp_result;
         END IF;


        /*---- Start of Convert release from 4.0.4(CMS 4.0.0) to 4.0.5 (CMS 4.0.0) change 5 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.4'  THEN 

           vsql := 'ALTER TABLE '||vschema||'.PMM_TITLE ADD DISTRIBUTION_STATUS varchar(20)';
           SELECT CREATEOBJECT(vsql,'Unable to alter table PMM_Title to add column distribution_status.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.4','4.0.5') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.5(CMS 4.0.0) to 4.0.6 (CMS 4.0.0) change 6 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.5'  THEN 

           --vsql := 'UPDATE '||vschema||'.PMM_TITLE SET DISTRIBUTION_STATUS=''NONE''';
           --SELECT CREATEOBJECT(vsql,'Unable to update table PMM_Title column distribution_status all rows.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.5','4.0.6') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.6(CMS 4.0.0) to 4.0.7 (CMS 4.0.0) change 7 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.6'  THEN 

           vsql := 'ALTER TABLE '||vschema||'.PMM_TITLE ADD PROCESSING_STATUS varchar(20)';
           SELECT CREATEOBJECT(vsql,'Unable to alter table PMM_Title to add column processing_status.','Y') INTO tmp_result;

           vsql := 'UPDATE '||vschema||'.PMM_TITLE SET PROCESSING_STATUS = ''NONE'', DISTRIBUTION_STATUS=''NONE''';
           SELECT CREATEOBJECT(vsql,'Unable to update table PMM_Title columns processing_status and distribution_status all rows.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.6','4.0.7') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.7 (CMS 4.0.0) to 4.0.8 (CMS 4.0.0) change 8 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.7'  THEN 

           vsql := 'CREATE INDEX mdm_externalseriesid_id_idx ON '||vschema||'.mdm_asset_identifier ((keys->''Fields''->''ExternalSeriesID''->>''Id''))';
           SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX mdm_externalseriesid_id_idx ON '||vschema||'.mdm_asset_identifier.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.7','4.0.8') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.8 (CMS 4.0.0) to 4.0.9 (CMS 4.0.0) change 9 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.8'  THEN 

           vsql := 'ALTER TABLE '||vschema||'.mdm_elastic_search_failed_titles ADD COLUMN title_type numeric(10)';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE mdm_elastic_search_failed_titles ADD COLUMN title_type.','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||vschema||'.pmm_partner ADD COLUMN istenant numeric(1)';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE pmm_partner ADD COLUMN istenant.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.8','4.0.9') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.9 (CMS 4.0.0) to 4.0.10 (CMS 4.0.0) change 10 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.9'  THEN 

           -- Brian Maso request on 06/30/2014
           vsql := 'create index idx_sites_distsitetitle_titleid on '||vschema||'.sites_distsitetitle(titleid)';
           SELECT CREATEOBJECT(vsql,'Unable to create index idx_sites_distsitetitle_titleid on '||vschema||'.sites_distsitetitle','Y') INTO tmp_result; 

           vsql := 'create index idx_sites_tracksitetitle_titleid on '||vschema||'.sites_tracksitetitle(titleid)';
           SELECT CREATEOBJECT(vsql,'Unable to create index idx_sites_tracksitetitle_titleid on '||vschema||'.sites_tracksitetitle','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.9','4.0.10') into tmp_result;
        END IF;


        /*---- Start of Convert release from 4.0.10 (CMS 4.0.0) to 4.0.11 (CMS 4.0.0) change 11 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.10'  THEN 

           -- BakNg request on 07/02/2014
           vsql := 'ALTER TABLE '||vschema||'.sites_distsitetitle ADD COLUMN status_detail numeric(1) default 0';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.sites_distsitetitle ADD COLUMN status_detail','Y') INTO tmp_result; 

           vsql := 'UPDATE '||vschema||'.pmm_partner SET istenant=1 WHERE partnertype=0';
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE wfs.pmm_partner SET istenant=1','Y') INTO tmp_result;

           vsql := 'UPDATE '||vschema||'.pmm_partner SET istenant=0 WHERE partnertype<>0';
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE wfs.pmm_partner SET istenant=0','Y') INTO tmp_result;

           vsql := 'UPDATE '||vschema||'.mdm_elastic_search_failed_titles SET title_type=0 WHERE title_type IS NULL';
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE '||vschema||'.mdm_elastic_search_failed_titles SET title_type=0','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||vschema||'.mdm_elastic_search_failed_titles ALTER COLUMN title_type SET DEFAULT 0, ALTER COLUMN title_type SET NOT NULL';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.mdm_elastic_search_failed_titles ALTER COLUMN title_type SET DEFAULT to ZERO and NOT NULL','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.10','4.0.11') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.11 (CMS 4.0.0) to 4.0.12 (CMS 4.0.0) change 12 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.11'  THEN 

           -- Pallav Rustogi request on 07/11/2014
           vsql := 'CREATE TABLE '||vschema||'.CMS_LICENSE_AUDIT (
                           id_         numeric(19),
                           type        varchar(32),
                           usage       varchar(100),
                           CREATEDATE  TIMESTAMP(6) NOT NULL,
                           UPDATEDATE  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                           CONSTRAINT PK_cms_license_audit_id PRIMARY KEY (ID_))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.CMS_LICENSE_AUDIT','Y') INTO tmp_result;
          SELECT createseq(vschema,'CMS_LICENSE_AUDIT') INTO tmp_result;
          SELECT createupdatetrg(vschema,'CMS_LICENSE_AUDIT') INTO tmp_result;

           vsql := 'CREATE TABLE '||vschema||'.CMS_AUDIT_TRAIL (
                           id_    numeric(19),
                           type  varchar(32),
                           hash  varchar(100),
                           CONSTRAINT PK_cms_audit_trail_id PRIMARY KEY (ID_))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.CMS_AUDIT_TRAIL','Y') INTO tmp_result;
          SELECT createseq(vschema,'CMS_AUDIT_TRAIL') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.11','4.0.12') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.12 (CMS 4.0.0) to 4.0.13 (CMS 4.0.0) change 13 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.12'  THEN 

           -- Bak Ng added new table on 07/21/2014
           vsql := 'CREATE TABLE '||vschema||'.SITES_DISTRIBUTION_HISTORY (
                           id_     numeric(10),
                           titleid numeric(10),
                           createdate timestamp(6) DEFAULT (current_timestamp) NOT NULL,
                           constraint pk_sites_distribution_history_id PRIMARY KEY (id_))';

          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.SITES_DISTRIBUTION_HISTORY','Y') INTO tmp_result;
          SELECT createseq(vschema,'SITES_DISTRIBUTION_HISTORY') INTO tmp_result;

           vsql := 'CREATE INDEX sites_distribution_history_createdate_idx ON '||vschema||'.sites_distribution_history(createdate)';
           SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX sites_distribution_history_createdate_idx','Y') INTO tmp_result;

           vsql := 'CREATE OR REPLACE FUNCTION func_add_dist_hist_ins_upd() RETURNS TRIGGER AS $$ 					  
                    BEGIN
                       INSERT INTO wfs.sites_distribution_history(titleid) VALUES(NEW.titleid);
                    END; $$  language plpgsql';
           SELECT CREATEOBJECT(vsql,'Unable to CREATE TRIGGER FUNCTION func_add_dist_hist_ins_upd.','Y') INTO tmp_result;

           vsql := 'CREATE TRIGGER add_dist_hist_trigger
                      AFTER INSERT OR UPDATE
                      ON '||vschema||'.sites_distsitetitle
                      FOR EACH ROW
                      WHEN (NEW.status=3)
                      EXECUTE PROCEDURE func_add_dist_hist_ins_upd()';
           -- comeback here to change the code to postgres format
           SELECT CREATEOBJECT(vsql,'Unable to CREATE TRIGGER add_dist_hist_trigger','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.12','4.0.13') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.13 (CMS 4.0.0) to 4.0.14 (CMS 4.0.0) change 14 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.13'  THEN 

           -- Avinash added new table on 07/25/2014
           vsql := 'CREATE TABLE '||vschema||'.elastic_search_wopurge_ids(
                      wopurge_id      numeric(10),
                      wo_delete_date  date)';

           SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE '||vschema||'.elastic_search_wopurge_ids','Y') INTO tmp_result;

           vsql := 'create index idx_elastic_search_wopurge_ids on '||vschema||'.elastic_search_wopurge_ids (wopurge_id)';
           SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX idx_elastic_search_wopurge_ids','Y') INTO tmp_result;

           -- comeback here to change to postgres format....
           --SELECT CREATEOBJECT(vsql,'Unable to drop constraints from purge related tables.','Y') INTO tmp_result;
           execute 'select drop_purge_table_cons();';
           select set_version(vschema, comp_name,'4.0.13','4.0.14') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.14 (CMS 4.0.0) to 4.0.15 (CMS 4.0.0) change 15 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.14'  THEN 

           vsql := 'CREATE INDEX idx_jbpm_token_pi ON '||vschema||'.jbpm_token (processinstance_)';
           SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX idx_jbpm_token_pi ON '||vschema||'.jbpm_token','Y') INTO tmp_result;

           vsql := 'CREATE INDEX idx_mdm_asset_identifier_docid ON '||vschema||'.mdm_asset_identifier (document_id)';
           SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX idx_mdm_asset_identifier_docid ON '||vschema||'.mdm_asset_identifier','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.14','4.0.15') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.15 (CMS 4.0.0) to 4.0.16 (CMS 4.0.0) change 16 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.15'  THEN 

           vsql :=  'CREATE INDEX idx_jbpm_log_node ON '||vschema||'.jbpm_log(node_)';
           SELECT CREATEOBJECT(VSQL,'Unable to create index idx_jbpm_log_node on JBPM_LOG table','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.15','4.0.16') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.16 (CMS 4.0.0) to 4.0.17 (CMS 4.0.0) change 17 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.16'  THEN 

           -- BakNg added records into custom field and group on 08-15-2014.
           vsql := 'INSERT INTO '||vschema||'.mdm_custom_field_group (name, display_name,asset_path,uuid)
                    SELECT ''Portal'',''Portal'',''PACKAGE'',''1'' WHERE NOT EXISTS (SELECT 1 FROM '||vschema||'.mdm_custom_field_group WHERE display_name = ''Portal'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT Portal record INTO '||vschema||'.mdm_custom_field_group table.','Y') INTO tmp_result;
      
           vsql := 'INSERT INTO '||vschema||'.mdm_custom_field (name,data_type,job_parameter,job_schedule_parameter,display_name, multivalue, field_type, group_id)
                    SELECT ''priority'',''Boolean'',''N'',''N'',''Priority'',''N'',2,cfg.group_id FROM '||vschema||'.mdm_custom_field_group cfg 
                     WHERE display_name=''Portal'' AND asset_path=''PACKAGE'' AND NOT EXISTS (SELECT 1 FROM '||vschema||'.mdm_custom_field WHERE name = ''priority'' AND group_id=cfg.group_id)';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT portal record into '||vschema||'.mdm_custom_field table.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.16','4.0.17') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.17 (CMS 4.0.0) to 4.0.18 (CMS 4.0.0) change 18 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.17'  THEN 

           -- On 08-22-2014 Suresh Neravati added Distribution site and Partner association.
           vsql := 'DO $$
                    DECLARE
                       s RECORD;
                    BEGIN
                       FOR s IN (SELECT ''SITE_''||s.id_ sites_siteid FROM '||vschema||'.sites_site s WHERE s.type=2 AND ''SITE_''||s.id_ not IN (SELECT name FROM '||vschema||'.pmm_partner))
                       LOOP
                          INSERT INTO '||vschema||'.pmm_context (id_, containertypeid) VALUES (nextval('''||vschema||'.pmm_context_seq''),1); 
                          INSERT INTO '||vschema||'.pmm_partner (id_, name, partnertype, contextid, isactive, istenant) 
                              VALUES (nextval('''||vschema||'.pmm_partner_seq''), s.sites_siteid, 1,'||vschema||'.pmm_context_seq.currval,1,0);
                          INSERT INTO '||vschema||'.pmm_contact (partnerid) values (currval('''||vschema||'.pmm_partner_seq'');
                       END LOOP;
                    END$$;';
           -- comeback here to change this to postgres format
           SELECT CREATEOBJECT(vsql,'Unable to add Distribution site and Partner association.','Y') INTO tmp_result;
      
           select set_version(vschema, comp_name,'4.0.17','4.0.18') into tmp_result;
        END IF;


        /*---- Start of Convert release from 4.0.18 (CMS 4.0.0) to 4.0.19 (CMS 4.0.0) change 19 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.18'  THEN 

           vsql :=  'DROP INDEX '||vschema||'.IDX_JBPM_VARIABLEINSTANCE_01';
           SELECT CREATEOBJECT(vsql,'Unable to drop index IDX_JBPM_VARIABLEINSTANCE_01','Y') INTO tmp_result;

           vsql :=  'DROP INDEX '||vschema||'.IDX_JBPM_VARIABLEINSTANCE_03';
           SELECT CREATEOBJECT(vsql,'Unable to drop index IDX_JBPM_VARIABLEINSTANCE_03','Y') INTO tmp_result;

           vsql :=  'DROP INDEX '||vschema||'.IDX_JBPM_VINSTANCE_STRVAL';
           SELECT CREATEOBJECT(vsql,'Unable to drop index IDX_JBPM_VINSTANCE_STRVAL','Y') INTO tmp_result;

           -- On 09-18-2014 Suresh Neravati added new index IDX_JBPM_VARIABLEINSTANCE_WOID on JBPM_VARIABLEINSTANCE table.
           vsql :=  'CREATE INDEX IDX_JBPM_VARIABLEINSTANCE_WOID ON '||vschema||'.JBPM_VARIABLEINSTANCE (PROCESSINSTANCE_)';
           SELECT CREATEOBJECT(vsql,'Unable to index IDX_JBPM_VARIABLEINSTANCE_WOID on JBPM_VARIABLEINSTANCE','Y') INTO tmp_result;

           vsql :=  'alter table '||vschema||'.jbpm_variableinstance set (autovacuum_vacuum_scale_factor = 0.01, autovacuum_analyze_scale_factor = 0.005, fillfactor = 70)';
           -- comeback here to verify this works in postgresql
           SELECT CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.jbpm_variableinstance set autovacuum_vacuum_scale_factor, autovacuum_analyze_scale_factor, fillfactor','Y') INTO tmp_result;
      
           select set_version(vschema, comp_name,'4.0.18','4.0.19') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.19 (CMS 4.0.0) to 4.0.20 (CMS 4.0.0) change 20 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.19'  THEN 

           -- On 09-24-2014 Suresh Neravati added two new indexes on JBPM_VARIABLEINSTANCE table and brought back the longval index.
           vsql :=  'CREATE INDEX IDX_JBPM_VINSTANCE_DBLVAL ON '||vschema||'.JBPM_VARIABLEINSTANCE (DOUBLEVALUE_)';
           SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_VINSTANCE_DBLVAL ON WFS.JBPM_VARIABLEINSTANCE','Y') INTO tmp_result;

           vsql :=  'CREATE INDEX IDX_JBPM_VINSTANCE_NAME ON '||vschema||'.JBPM_VARIABLEINSTANCE(NAME_)';
           SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_VINSTANCE_NAME ON WFS.JBPM_VARIABLEINSTANCE','Y') INTO tmp_result;

           vsql :=  'CREATE INDEX idx_jbpm_vinstance_longval ON '||vschema||'.JBPM_VARIABLEINSTANCE(LONGVALUE_)';
           SELECT CREATEOBJECT(vsql,'Unable to create index idx_jbpm_vinstance_longval ON WFS.JBPM_VARIABLEINSTANCE','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.19','4.0.20') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.20 (CMS 4.0.0) to 4.0.21 (CMS 4.0.0) change 21 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.0.20'  THEN 

           -- On 10-22-2014 Suresh Neravati added new index on mdm_metadata_revision and pmm_title_resource tables for performance.
           vsql := 'create index idx_mdm_metadata_rev_doc_revs on '||vschema||'.mdm_metadata_revision (document_id,revision)';
           SELECT CREATEOBJECT(vsql,'Unable to create index idx_mdm_metadata_rev_doc_revs on '||vschema||'.mdm_metadata_revision','Y') INTO tmp_result;

           vsql := 'create index idx_pmm_title_resource_titleid on '||vschema||'.pmm_title_resource (titleid)';
           SELECT CREATEOBJECT(vsql,'Unable to create index idx_pmm_title_resource_titleid on '||vschema||'.pmm_title_resource','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.0.20','4.0.21') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.0.21 (CMS 4.0.0) to 4.1.1 (CMS 4.1.0) change 1 ---*/
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF (( WK_RELEASE = '4.0.21' ) or ( WK_RELEASE = '4.0.23' )) THEN
           -- On 11-21-2014 Eugene and Bryan added new index on sites_distsitetitle table for performance.
           vsql := 'create index idx_sites_distsitetitle_siteid  ON '||vschema||'.sites_distsitetitle (siteid)';
           SELECT CREATEOBJECT(vsql,'Unable to create index idx_sites_distsitetitle_siteid  ON '||vschema||'.sites_distsitetitle','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'4.0.21','4.1.1') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.1.1 (CMS 4.1.0) to 4.1.2 (CMS 4.1.0) change 2 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.1.1'  THEN
 
           -- On 11-27-2014 Kriss Lu from CGC team added a new column affiliation_code on pmm_partner table.
            vsql := 'ALTER TABLE '||vschema||'.pmm_partner ADD COLUMN affiliation_code varchar(20)';
            SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE pmm_partner ADD COLUMN affiliation_code.','Y') INTO tmp_result;
     
            -- update affiliation code to a five characters code from the id_ column if it is null, with leading 0 padding.      
            vsql := 'update '||vschema||'.pmm_partner set affiliation_code=to_char(id_, ''FM00000'') where affiliation_code is null';
            SELECT CREATEOBJECT(vsql,'Unable to update affiliation_code of TABLE pmm_partner.','Y') INTO tmp_result;

            vsql := 'alter table '||vschema||'.pmm_partner alter affiliation_code set not null';
            SELECT CREATEOBJECT(vsql,'Unable to update affiliation_code of TABLE pmm_partner to not null.','Y') INTO tmp_result;
     
           select set_version(vschema, comp_name,'4.1.1','4.1.2') into tmp_result;
        END IF;
        
        /*---- Start of Convert release from 4.1.2 (CMS 4.1.0) to 4.1.3 (CMS 4.1.0) change 3 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.1.2'  THEN
            vsql := 'alter table '||vschema||'.pmm_partner alter affiliation_code drop not null';
            SELECT CREATEOBJECT(vsql,'Unable to drop not_null constraints on affiliation_code in pmm_partner.','Y') INTO tmp_result;
     
           select set_version(vschema, comp_name,'4.1.2','4.1.3') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.1.3 (CMS 4.1.0) to 4.1.4 (CMS 4.1.0) change 4 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.1.3'  THEN
            -- Bak Ng added new index on affiliation_code column on 02-02-2015.
            vsql := 'CREATE INDEX affiliation_code_idx ON '||VSCHEMA||'.pmm_partner (affiliation_code)';
            SELECT CREATEOBJECT(vsql,'Unable to create index affiliation_code_idx.','Y') INTO tmp_result;

            -- Pallav Rustogi added new column inherited on pmm_partner_users table on 02-04-2015.
            vsql := 'ALTER TABLE '||vschema||'.PMM_PARTNER_USERS ADD COLUMN INHERITED BOOLEAN DEFAULT FALSE NOT NULL';
            SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.PMM_PARTNER_USERS ADD COLUMN INHERITED.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.1.3','4.1.4') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.1.4 (CMS 4.1.0) to 4.1.5 (CMS 4.1.0) change 5 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.1.4'  THEN
            -- Pallav Rustogi modified the column affiliation_code to 4000 characters on 03-18-2015.
            vsql := 'alter table '||vschema||'.pmm_partner alter column affiliation_code type varchar(4000)';
            SELECT CREATEOBJECT(vsql,'Unable to alter table pmm_partner alter column affiliation_code type varchar(4000)','Y') INTO tmp_result;

            -- James added three new columns to table tre_ruleset on 03/20/2015.
            vsql := 'ALTER TABLE '||vschema||'.tre_ruleset ADD COLUMN batches numeric(19) default 0, ADD COLUMN job_limit numeric(19) default 0, ADD COLUMN current_batch numeric(19) default 0';
            SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.tre_ruleset add columns batches and job_limit','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.1.4','4.1.5') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.1.5 (CMS 4.1.0) to 4.1.6 (CMS 4.1.0) change 6 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.1.5'  THEN
            -- Suresh Neravati added five new indexes on 04/19/2015 for fixing full table scan.

            vsql := 'create index idx_mdm_metadata_rev_doc on '||vschema||'.mdm_metadata_revision (document_id)';
            SELECT CREATEOBJECT(vsql,'Unable to create index idx_mdm_metadata_rev_doc on '||vschema||'.mdm_metadata_revision','Y') INTO tmp_result;

            vsql := 'create index idx_pmm_title_purge_hist_titleid on '||vschema||'.pmm_title_purge_history (title_id)';
            SELECT CREATEOBJECT(vsql,'Unable to create index idx_pmm_title_purge_hist_titleid on '||vschema||'.pmm_title_purge_history','Y') INTO tmp_result;

            vsql := 'create index idx_sites_dist_hist_titleid on '||vschema||'.sites_distribution_history (titleid)';
            SELECT CREATEOBJECT(vsql,'Unable to create index idx_sites_dist_hist_titleid on '||vschema||'.sites_distribution_history','Y') INTO tmp_result;

            vsql := 'create index idx_pmm_properties_title_id on '||vschema||'.pmm_properties (titleid)';
            SELECT CREATEOBJECT(vsql,'Unable to create index idx_pmm_properties_title_id on '||vschema||'.pmm_properties','Y') INTO tmp_result;

            vsql := 'create index idx_jbpm_variableaccess_taskc on '||vschema||'.jbpm_variableaccess(taskcontroller_)';
            SELECT CREATEOBJECT(vsql,'Unable to create index idx_jbpm_variableaccess_taskc on '||vschema||'.jbpm_variableaccess','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.1.5','4.1.6') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.1.6 (CMS 4.1.0) to 4.1.7 (CMS 4.1.0) change 7 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.1.6'  THEN

            -- Suresh Neravati 
           vsql := 'CREATE OR REPLACE VIEW '||vschema||'.VW_CAT_CATEGORY_PATHS AS
                         WITH RECURSIVE path_graph AS
                         (SELECT c, 1 AS level, ARRAY[name::text] AS pathArray 
                            FROM '||vschema||'.CAT_CATEGORY c
                           WHERE id > 0  AND c.parent_category_id = 0 
                         UNION ALL
                          SELECT ci, path_graph.level + 1 AS level, pathArray || name::text 
                            FROM path_graph
                            JOIN '||vschema||'.CAT_CATEGORY ci ON ci.parent_category_id = (path_graph.c).id ) 
                         SELECT      (path_graph.c).name,
                                     (path_graph.c).id,
                                     (path_graph.c).parent_category_id,
                                      array_to_string(pathArray,''/'') AS path,
                                     (path_graph.c).createdate,
                                     (path_graph.c).associated_category_package
                         FROM path_graph';
           --comeback here to change this to postgres format
           SELECT CREATEOBJECT(VSQL,'Unable to create view VW_CAT_CATEGORY_PATHS.','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'4.1.6','4.1.7') into tmp_result;
        END IF;

        /*---- Start of Convert release from 4.1.7 (CMS 4.1.0) to 4.1.8 (CMS 4.1.0) change 8 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '4.1.7'  THEN

           -- Anna Simonenko added two new indexes on tre tables on 05/06/2015.
           vsql := 'create index idx_tre_actionparmval_value on '||vschema||'.tre_actionparametervalue(value)';
           SELECT CREATEOBJECT(vsql,'Unable to create index idx_tre_actionparmval_value on '||vschema||'.tre_actionparametervalue(value)','Y') INTO tmp_result;

           vsql := 'create index idx_tre_predicate_fldlr on '||vschema||'.tre_predicate (fieldleft, fieldright)';
           SELECT CREATEOBJECT(vsql,'Unable to create idx_tre_predicate_fldlr on '||vschema||'.tre_predicate (fieldleft, fieldright)','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.1.7','4.1.8') into tmp_result;
        END IF;


        /*---- Start of Convert release from 4.1.8 (CMS 4.1.0) or 4.1.10 (CMS 4.1.1) to 5.0.0 (CMS 5.0) change 1 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF (( WK_RELEASE = '4.1.8' ) or ( WK_RELEASE = '4.1.10' )) THEN

           -- Anna Simonenko added a new content class type Offer on 06/19/2015.

           vsql := 'INSERT INTO '||VSCHEMA||'.pmm_content_class_type (content_class_type_id, name) VALUES (''3'', ''Offer'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT Offer Content Class INTO '||VSCHEMA||'.pmm_content_class_type','Y') INTO tmp_result;

           EXECUTE 'EXECUTE get_occ_value' INTO occ_value;
           vsql := 'INSERT INTO '||vschema||'.pmm_content_class (id, name, description, is_default, data, content_class_type_id) 
                    VALUES (nextval('''||vschema||'.PMM_CONTENT_CLASS_SEQ''), ''Offer'', ''Offer content class'', 0,'''||occ_value||''',3 )';
           -- comeback here to change this to postgres format.
           SELECT CREATEOBJECT(vsql,'Unable to INSERT Offer Content Class INTO '||VSCHEMA||'.pmm_content_class','Y') INTO tmp_result;

           -- creating the records in the CONTENT_CLASS_PARTNER TABLE for partner type 0 and 2 for offer content class.
           vsql := 'INSERT INTO '||vschema||'.pmm_content_class_partner (content_class_id, partner_id) SELECT cc.id, p.id_ FROM '||vschema||'.pmm_partner p, '||vschema||'.pmm_content_class cc '||
                   ' WHERE p.partnertype in (0,2) AND cc.content_class_type_id=3';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT Offer Content Class records INTO '||vschema||'.pmm_content_class_partner','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'4.1.8','5.0.0') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.0 (CMS 5.0) to 5.0.1 (CMS 5.0) change 2 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.0'  THEN

           -- Piyush Saini added a new column in cms_component table on 06/22/2015.
           
           vsql := 'ALTER TABLE '||vschema||'.CMS_COMPONENT ADD COLUMN LAST_SUCCESSFUL_SYNCH TIMESTAMP(6) without time zone';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.CMS_COMPONENT to add COLUMN LAST_SUCCESSFUL_SYNCH.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.0','5.0.1') into tmp_result;
        END IF;


        /*---- Start of Convert release from 5.0.1 (CMS 5.0) to 5.0.2 (CMS 5.0) change 3 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.1'  THEN

           -- Edwin Nguyen modified the Offer content class on 06/30/2015.           
           vsql := 'update '||vschema||'.pmm_content_class set data=convert_from(pg_read_binary_file(''offer_content_class.xml''),''UTF8'') where name=''Offer''';
           --SELECT CREATEOBJECT(vsql,'Unable to update '||vschema||'.pmm_content_class to set new offer_content_class.xml','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.1','5.0.2') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.2 (CMS 5.0) to 5.0.3 (CMS 5.0) change 4 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.2'  THEN

           -- Drew Darrough modified the pmm_partner table 08/11/2015.           
           vsql := 'ALTER TABLE '||vschema||'.pmm_partner ADD COLUMN isemailnotify BOOLEAN DEFAULT FALSE NOT NULL ';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE pmm_partner ADD COLUMN isemailnotify.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.2','5.0.3') into tmp_result;
        END IF;


        /*---- Start of Convert release from 5.0.3 (CMS 5.0) to 5.0.4 (CMS 5.0) change 5 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.3'  THEN

           -- Drew Darrough modified the pmm_partner table 08/11/2015.           
           vsql := 'ALTER TABLE '||vschema||'.pmm_partner ALTER COLUMN isemailnotify DROP DEFAULT, ALTER COLUMN isemailnotify TYPE NUMERIC(1,0) 
                    USING CASE WHEN isemailnotify THEN 1 ELSE 0 END, ALTER COLUMN isemailnotify SET default 0';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE pmm_partner ALTER COLUMN isemailnotify.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.3','5.0.4') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.4 (CMS 5.0) to 5.0.5 (CMS 5.0) change 6 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.4'  THEN

           -- Haitham added a new table sites_distribution_option on 08/28/2015.
           vsql := 'CREATE TABLE '||vschema||'.sites_dependencies (
                    id         numeric(1),
                    sitesgraph json,
                    version    numeric(14) NOT NULL DEFAULT 0,
                    CONSTRAINT PK_SITES_DEPENDENCIES_ID PRIMARY KEY (ID))';
          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.sites_dependencies','Y') INTO tmp_result;

           vsql := 'CREATE UNIQUE INDEX idx_sites_dependencies_sgraph ON '||vschema||'.sites_dependencies ((sitesgraph ->> ''id''::text))';
           --SELECT CREATEOBJECT(VSQL,'Unable to create UNIQUE INDEX idx_sites_dependencies_sgraph','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.sites_dependencies VALUES (1,''[]'',0)';
           SELECT CREATEOBJECT(VSQL,'Unable to INSERT INTO '||vschema||'.sites_dependencies','Y') INTO tmp_result;

           -- Edwin Nguyen added two insert statements into sites_distribution_option table on 08/28/2015.
           vsql := 'INSERT INTO '||vschema||'.SITES_DISTRIBUTION_OPTION (ID_, NAME) VALUES (3, ''DEPENDSON'')';
           SELECT CREATEOBJECT(vsql,'Unable to insert SITES_DISTRIBUTION_OPTION','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.SITES_DISTRIBUTION_OPTION (ID_, NAME) VALUES (4, ''WAITING_FOR_DEPENDENCY'')';
           SELECT CREATEOBJECT(vsql,'Unable to insert SITES_DISTRIBUTION_OPTION','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.4','5.0.5') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.5 (CMS 5.0) to 5.0.6 (CMS 5.0) change 7 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.5'  THEN

           -- Suresh Neravati corrected the insert statement to sites_distribution_status table on 09/01/2015.
           vsql := 'DELETE FROM '||vschema||'.SITES_DISTRIBUTION_OPTION WHERE NAME = ''WAITING_FOR_DEPENDENCY'' AND ID_ = 4';
           SELECT CREATEOBJECT(vsql,'Unable to DELETE FROM SITES_DISTRIBUTION_OPTION','Y') INTO tmp_result;

           -- Edwin Nguyen added two insert statements into sites_distribution_status table on 08/28/2015.
           vsql := 'INSERT INTO '||vschema||'.SITES_DISTRIBUTION_STATUS (ID_, NAME) VALUES (5, ''WAITING_FOR_DEPENDENCY'')';
           SELECT CREATEOBJECT(vsql,'Unable to insert  SITES_DISTRIBUTION_STATUS','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.5','5.0.6') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.6 (CMS 5.0) to 5.0.7 (CMS 5.0) change 8 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.6'  THEN

           -- Suresh Neravati dropped index wfs.idx_sites_dependencies_sgraph as per Kinjal on 09/11/2015.
           vsql := 'DROP INDEX '||vschema||'.idx_sites_dependencies_sgraph';
           SELECT CREATEOBJECT(vsql,'Unable to Drop index idx_sites_dependencies_sgraph','Y') INTO tmp_result;

           -- Haitham Khedre requested to add new column isemailnotify to table tre_ruleset on 09/11/2015.
           vsql := 'ALTER TABLE '||vschema||'.tre_ruleset ADD COLUMN isemailnotify numeric(1) not null default 0';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.tre_ruleset TO ADD COLUMN isemailnotify','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.6','5.0.7') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.7 (CMS 5.0) to 5.0.8 (CMS 5.0) change 9 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.7'  THEN

           -- Haitham modified the Offer content class on 09/30/2015.           
           EXECUTE 'EXECUTE get_occ_value' INTO occ_value;
           vsql := 'update '||vschema||'.pmm_content_class set data='''||occ_value||''' where name=''Offer''';
           SELECT CREATEOBJECT(vsql,'Unable to update '||vschema||'.pmm_content_class to set new offer_content_class.xml','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.7','5.0.8') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.8 (CMS 5.0) to 5.0.9 (CMS 5.0) change 10 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.8'  THEN

           -- Haitham used text formatted Offer content class on 10/07/2015 to fix the issue I-04323.           
           EXECUTE 'EXECUTE get_occ_value' INTO occ_value;
           vsql := 'update '||vschema||'.pmm_content_class set data='''||occ_value||''' where name=''Offer''';
           SELECT CREATEOBJECT(vsql,'Unable to update '||vschema||'.pmm_content_class to set new offer_content_class.xml','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.8','5.0.9') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.9 (CMS 5.0) to 5.0.10 (CMS 5.0) change 11 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.9'  THEN

           -- Brandon Cox request on 10/13/2015 to add lookup key value as TTV.COM for self partner TTV - Issue I-04369.
           vsql := 'update '||vschema||'.pmm_partner set lookupkey=providerid where COALESCE(lookupkey,'''')='''' AND partnertype in (select id_ from '||vschema||'.pmm_partnertype where name in 

(''SELF'',''SOURCE''))';
           SELECT CREATEOBJECT(vsql,'Unable to update '||vschema||'.pmm_partner table to set lookupkey as TTV.COM for SELF partner','Y') INTO tmp_result;

           -- Della Liao from CGC team request on 10/26/2015 to remove epgmanager module from cms_module table.

           vsql := 'delete from '||vschema||'.cms_rolepermissions where permissionid in (select permissionid from '||vschema||'.cms_permission where moduleid in (select moduleid from '||vschema||'.cms_module 

where modulename=''EPGManager'' and componentId is null))';
           SELECT CREATEOBJECT(vsql,'Unable to delete from '||vschema||'.cms_rolepermissions where modulename is EPGManager and componentId is null','Y') INTO tmp_result;

           vsql := 'delete from '||vschema||'.cms_permission where moduleid in (select moduleid from '||vschema||'.cms_module where modulename=''EPGManager'' and componentId is null)';
           SELECT CREATEOBJECT(vsql,'Unable to delete from '||vschema||'.cms_permission where modulename is EPGManager and componentId is null','Y') INTO tmp_result;

           vsql := 'delete from '||vschema||'.cms_module where modulename=''EPGManager'' and componentId is null';
           SELECT CREATEOBJECT(vsql,'Unable to delete from '||vschema||'.cms_module where modulename is EPGManager and componentId is null','Y') INTO tmp_result;

           -- AndrewRyan-Waldo request on 10/28/2015 to adding Workflow remote component entry to Database.
           vsql := 'insert into '||vschema||'.cms_component (name, baseurl, statusid, last_successful_synch) values (''workflow'', ''https://app:7443'', 4, current_timestamp)';
           SELECT CREATEOBJECT(vsql,'Unable to insert workflow into '||vschema||'.cms_component table','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.9','5.0.10') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.10 (CMS 5.0) to 5.0.11 (CMS 5.0) change 12 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.10'  THEN

           -- Della Liao request on 11/19/2015 to adding epg remote component entry to Database.
           vsql := 'insert into '||vschema||'.cms_component (name, baseurl, statusid, last_successful_synch) values (''epg'', ''https://app:8443/epg/services/components'', 4, current_timestamp)';
           SELECT CREATEOBJECT(vsql,'Unable to insert epg into '||vschema||'.cms_component table','Y') INTO tmp_result;

           -- Samuel request to add Offer management in workflow resource systemids in cms_settings table on 11/19/2015.
           vsql := 'update '||vschema||'.cms_setting set setting_value=setting_value||'',OM'' where setting_name=''com.tandbergtv.workflow.resource.systemids'' and setting_value not like ''%OM%''';
           SELECT CREATEOBJECT(vsql,'Unable to to add Offer management in workflow resource systemids in cms_settings table','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.10','5.0.11') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.11 (CMS 5.0) to 5.0.12 (CMS 5.0) change 13 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.11'  THEN

           -- Haitham request to update the Offer content class to add includeInBatch attribute for some of the tags on 12/01/2015.           
           EXECUTE 'EXECUTE get_occ_value' INTO occ_value;
           vsql := 'update '||vschema||'.pmm_content_class set data='''||occ_value||''' where name=''Offer''';
           SELECT CREATEOBJECT(vsql,'Unable to update '||vschema||'.pmm_content_class to set new offer_content_class.xml','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.11','5.0.12') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.12 (CMS 5.0) to 5.0.13 (CMS 5.0) change 14 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.12'  THEN

           -- Avinash Kharul request on 12/10/2015 to update setting value to 127.0.0.1 for RCS records in cms_setting table.
           vsql := 'update '||vschema||'.cms_setting set setting_value = ''127.0.0.1'' where setting_name in (''RcsSystem.ConnectionPool.serverName'', ''RecReqQueueSystem.ConnectionPool.serverName'', 
                    ''dbserver'', ''EPG_FTP_HOST'')';
           SELECT CREATEOBJECT(vsql,'Unable to update '||vschema||'.cms_setting set setting_value to 127.0.0.1 on RCS records','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.12','5.0.13') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.13 (CMS 5.0) to 5.0.14 (CMS 5.0) change 15 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.13'  THEN

           -- Vitaliy filed Bug B-2135 on 12/11/2015 for portal user_activity table data Logged In and Logged Out.
           vsql := 'update portal.user_activity set action = ''Logged On'' , brief_details = ''Logged On'' where action = ''Logged In''';
           SELECT CREATEOBJECT(vsql,'Unable to update portal.user_activity to set action and brief_dettails columns to Logged On','Y') INTO tmp_result;

           vsql := 'update portal.user_activity set action = ''Logged Off'' , brief_details = ''Logged Off'' where action = ''Logged Out''';
           SELECT CREATEOBJECT(vsql,'Unable to update portal.user_activity to set action and brief_dettails columns to Logged Off','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.13','5.0.14') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.14 (CMS 5.0) to 5.0.15 (CMS 5.0) change 16 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.14'  THEN

           --Evan Huang request on 12/30/2015 to Update the workflow modules cms_module.componentid with new workflow cms_component.componentid in the upgrade.
           vsql := 'update '||vschema||'.cms_module set componentid = (select componentid from '||vschema||'.cms_component where name = ''workflow'') where modulename in 
                           (''Plugins'', ''ResourceManagement'', ''Home'', ''WorkOrderManagement'', ''Monitoring'',''UserTasks'')';
           SELECT CREATEOBJECT(vsql,'Unable to update '||vschema||'.cms_module componentid for workflow modules','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.14','5.0.15') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.15 (CMS 5.0) to 5.0.16 (CMS 5.0) change 17 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.15'  THEN

           -- Haitham request to update the Offer and Default content classes to add custom field enable tags on 01/15/2016.           
           EXECUTE 'EXECUTE get_occ_value' INTO occ_value;
           vsql := 'update '||vschema||'.pmm_content_class set data='''||occ_value||''' where name=''Offer''';
           SELECT CREATEOBJECT(vsql,'Unable to update '||vschema||'.pmm_content_class to set new offer_content_class.xml','Y') INTO tmp_result;

           EXECUTE 'EXECUTE get_dcc_value' INTO dcc_value;
           vsql := 'update '||vschema||'.pmm_content_class set data='''||dcc_value||''' where name=''Default''';
           SELECT CREATEOBJECT(vsql,'Unable to update '||vschema||'.pmm_content_class to set new default_content_class.xml','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.15','5.0.16') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.16 (CMS 5.0) to 5.0.17 (CMS 5.0) change 18 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.0.16'  THEN

           -- Haitham revised request to update the Default content classes to add custom field enable tags on 02/03/2016.           
           vsql := 'update '||vschema||'.pmm_content_class set data = XMLPARSE(DOCUMENT replace(text(data),''<asset batchMax="1" batchMin="1" max="1" min="1" path="PACKAGE">'',
       ''<asset batchMax="1" batchMin="1" max="1" min="1" path="PACKAGE">
       <field fieldType="DROP_DOWN" isAttribute="true" path="/Fields/CustomFields/CustomField[@name=priority]/@value">
         <value>false</value>
         <options>
           <option>
             <value>false</value>
             <displayName>N</displayName>
           </option>
           <option>
             <value>true</value>
             <displayName>Y</displayName>
           </option>
         </options>
       </field>
       <field path="/Fields/CustomFields/CustomField[@name=priority]"/>
       <field fieldType="TEXT_BOX" path="/Fields/CustomFields;1"/>
       <field path="/Fields/CustomFields"/>'')) where name=''Default''';
           -- No need of this change, since we are updating the whole default content class xml in the above update.
           --SELECT CREATEOBJECT(vsql,'Unable to update '||vschema||'.pmm_content_class custom field changes.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.16','5.0.17') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.0.17 (CMS 5.0) to 5.1.0 (CMS 5.1) change 1 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF (( WK_RELEASE = '5.0.17' ) or ( WK_RELEASE = '5.0.18' )) THEN

           -- On 02/15/2016, Edwin Nguyen added two new columns action_on_failure and retry_attempts to sites_site table
           vsql := 'ALTER TABLE '||vschema||'.SITES_SITE ADD ACTION_ON_FAILURE varchar(255), ADD RETRY_ATTEMPTS numeric(3)';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.SITES_SITE ADD ACTION_ON_FAILURE and RETRY_ATTEMPTS columns','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.0.17','5.1.0') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.1.0 (CMS 5.1) to 5.1.1 (CMS 5.1) change 2 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.1.0'  THEN

           -- On 02/24/2016, Edwin Nguyen added a new column retry_wait_time to sites_site table
           vsql := 'ALTER TABLE '||vschema||'.SITES_SITE ADD RETRY_WAIT_TIME numeric(3)';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.SITES_SITE ADD RETRY_WAIT_TIME column','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.1.0','5.1.1') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.1.1 (CMS 5.1) to 5.1.2 (CMS 5.1) change 3 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.1.1'  THEN

           -- On 03/03/2016, Seungchan Lee added a new column isallocatable to ttv_resourcegroup table and set default value to 1.
           vsql := 'ALTER TABLE '||vschema||'.ttv_resourcegroup ADD COLUMN isallocatable numeric(1)';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.ttv_resourcegroup to add column isallocatable.','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||vschema||'.ttv_resourcegroup ALTER COLUMN isallocatable SET DEFAULT 1';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.ttv_resourcegroup ALTER COLUMN isallocatable SET DEFAULT 1.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.1.1','5.1.2') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.1.2 (CMS 5.1) to 5.1.3 (CMS 5.1) change 4 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.1.2'  THEN

           --On 03/03/2016, Sahil Verma updated the ttv_resourcegroup.isallocatable column with one for already existing records.
           vsql := 'UPDATE '||vschema||'.ttv_resourcegroup set isallocatable = 1';
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE '||vschema||'.ttv_resourcegroup to set isallocatable value to 1.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.1.2','5.1.3') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.1.3 (CMS 5.1) to 5.1.4 (CMS 5.1) change 5 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.1.3'  THEN

           -- Samuel request to add FMS resource type in the workflow resource systemids in cms_settings table on 03/29/2016.
           vsql := 'update '||vschema||'.cms_setting set setting_value=setting_value||'',07'' where setting_name=''com.tandbergtv.workflow.resource.systemids'' and setting_value not like ''%07%''';
           SELECT CREATEOBJECT(vsql,'Unable to to add FMS resource type in the workflow resource systemids in cms_settings table','Y') INTO tmp_result;

           -- Haitham added two new cis notification tables on 03/29/2016.
           vsql := 'CREATE TABLE '||vschema||'.SITES_CIS_NOTIFICATION_TYPE (
                    ID   numeric(19),
                    NAME varchar(255) NOT NULL,
                    CONSTRAINT pk_sites_cis_notif_type_id PRIMARY KEY (id),
                    CONSTRAINT sites_cis_notif_type_name_unq UNIQUE (name))';

          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.SITES_CIS_NOTIFICATION_TYPE','Y') INTO tmp_result;

           vsql := 'CREATE TABLE '||vschema||'.SITES_CIS_NOTIFICATION (
                    ID               numeric(19),
                    SITEID           numeric(19),
                    MESSAGEID        varchar(255) NOT NULL,
                    IDENTITY         varchar(36) NOT NULL,
                    NOTIFICATIONTYPE numeric(19),
                    CALLOUTURL       text,
                    QUERY            text,
                    createdate TIMESTAMP(6) DEFAULT current_timestamp not null,
                    updatedate TIMESTAMP(6) DEFAULT current_timestamp not null,
                    CONSTRAINT pk_sites_cis_notifi_id PRIMARY KEY (id),
                    CONSTRAINT sites_cis_notif_imsgid_unq UNIQUE (identity, messageid),
                    CONSTRAINT fk_sites_cis_notif_site_id FOREIGN KEY (siteid) REFERENCES '||vschema||'.sites_site (id_),
                    CONSTRAINT fk_sites_cis_notif_type FOREIGN KEY (notificationtype) REFERENCES '||vschema||'.sites_cis_notification_type (id))';

          select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.SITES_CIS_NOTIFICATION','Y') INTO tmp_result;
          SELECT createseq(vschema,'SITES_CIS_NOTIFICATION') INTO tmp_result;
          SELECT createupdatetrg(vschema,'SITES_CIS_NOTIFICATION') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.sites_cis_notification_type (id, name) VALUES (0, ''CIS_NOTIFICATION'')';
           SELECT CREATEOBJECT(vsql,'Unable to insert into table sites_cis_notification_type','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.sites_cis_notification_type (id, name) VALUES (1, ''CIS_DEREGISTRATION_NOTIFICATION'')';
           SELECT CREATEOBJECT(vsql,'Unable to insert into table sites_cis_notification_type','Y') INTO tmp_result;

           vsql := 'CREATE UNIQUE INDEX idx_sites_cis_notif_imsg_unq ON '||vschema||'.sites_cis_notification (identity, messageid)';
           SELECT CREATEOBJECT(vsql,'Unable to create unique index idx_sites_cis_notif_imsg_unq.','Y') INTO tmp_result; 

           vsql := 'CREATE INDEX idx_sites_cis_notif_site_id ON '||vschema||'.sites_cis_notification (siteid)';
           SELECT CREATEOBJECT(vsql,'Unable to create index idx_sites_cis_notif_site_id.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.1.3','5.1.4') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.1.4 (CMS 5.1) to 5.1.5 (CMS 5.1) change 6 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.1.4'  THEN

           -- Priyanka Padlia request to update priorities on workflow tables on 04/25/2016. Since there is a change in priority, we fixed this on 04/26/2016 code.
           NULL;
           select set_version(vschema, comp_name,'5.1.4','5.1.5') into tmp_result;
        END IF;


        /*---- Start of Convert release from 5.1.5 (CMS 5.1) to 5.1.6 (CMS 5.1) change 7 ---*/ 
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.1.5'  THEN

           EXECUTE 'SELECT count(*) FROM '||vschema||'.ttv_processpriority WHERE name in (''P20'',''P19'',''P18'',''P17'',''P16'',''P15'',''P14'',''P13'',''P12'',''P11'',''P10'',''P9'',''P8'',''P7'',''P6'',''P5'',''P4'',''P3'',''P2'',''P1'')' INTO myvar;
           IF myvar = '0' THEN

      -- Priyanka Padlia request to update priorities on workflow tables P20 as LOWEST and P1 as HIGHEST on 04/26/2016. Also decided not to create constraint JBPM_PINSTANCE#TTV_PPRIORITY on WorkOrder tab 
           vsql := 'UPDATE '||vschema||'.tre_actionparametervalue ta SET ta.value = CASE value WHEN ''LOWEST'' THEN ''P20'' WHEN ''LOW'' THEN ''P15'' WHEN ''NORMAL'' THEN ''P10'' WHEN ''HIGH'' THEN ''P5'' WHEN ''HIGHEST'' THEN ''P1'' ELSE ta.value END WHERE name=''priority''';
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE '||vschema||'.tre_actionparametervalue SET value.','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||vschema||'.JBPM_PROCESSINSTANCE Drop CONSTRAINT JBPM_PINSTANCE#TTV_PPRIORITY';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.JBPM_PROCESSINSTANCE Drop CONSTRAINT JBPM_PINSTANCE#TTV_PPRIORITY.','Y') INTO tmp_result;

           vsql := 'delete from '||vschema||'.ttv_processpriority';
           SELECT CREATEOBJECT(vsql,'Unable to delete from '||vschema||'.ttv_processpriority.','Y') INTO tmp_result;

           vsql := 'ALTER SEQUENCE '||vschema||'.TTV_PROCESSPRIORITY_SEQ minvalue 0';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER SEQUENCE '||vschema||'.TTV_PROCESSPRIORITY_SEQ minvalue 0.','Y') INTO tmp_result;

           vsql := 'ALTER SEQUENCE '||vschema||'.TTV_PROCESSPRIORITY_SEQ RESTART WITH 0';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER SEQUENCE '||vschema||'.TTV_PROCESSPRIORITY_SEQ RESTART WITH 0.','Y') INTO tmp_result;

           vsql := 'insert into '||vschema||'.ttv_processpriority (name) values (''P20''), (''P19''), (''P18''), (''P17''), (''P16''), (''P15''), (''P14''), (''P13''), (''P12''), (''P11''), (''P10''),(''P9''), (''P8''), (''P7''), (''P6''), (''P5''), (''P4''), (''P3''), (''P2''), (''P1'')';
           SELECT CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.ttv_processpriority (name) values P20 to P1.','Y') INTO tmp_result;

           vsql := 'UPDATE '||vschema||'.jbpm_processinstance SET processpriorityid = CASE processpriorityid WHEN 1 THEN 5 WHEN 2 THEN 10 WHEN 3 THEN 15 WHEN 4 THEN 19 ELSE processpriorityid END WHERE operationalprocessstatusid NOT IN (5,6)';
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE '||vschema||'.jbpm_processinstance SET processpriorityid.','Y') INTO tmp_result;

           vsql := 'UPDATE '||vschema||'.sch_wojob SET priority = CASE priority WHEN ''LOWEST'' THEN ''P20'' WHEN ''LOW'' THEN ''P15'' WHEN ''NORMAL'' THEN ''P10'' WHEN ''HIGH'' THEN ''P5'' WHEN ''HIGHEST'' THEN ''P1'' ELSE priority END';
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE '||vschema||'.sch_wojob SET priority.','Y') INTO tmp_result;

           END IF;

           select set_version(vschema, comp_name,'5.1.5','5.1.6') into tmp_result;
        END IF;

        /*---- Start of Convert release from 5.1.6 (CMS 5.1) to 5.1.7 (CMS 5.1) change 8 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.1.6'  THEN

           -- To fix the defect D-06095, on 05/17/2016 Edwin requested to change the istenant to 1 for self partner as part of upgrade.
           vsql := 'UPDATE '||vschema||'.pmm_partner SET istenant=1 WHERE partnertype=0';
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE wfs.pmm_partner SET istenant=1','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.1.6','5.1.7') into tmp_result;

        END IF;
        /*---- Start of Convert release from 5.1.7 (CMS 5.1) to 5.2.0 (CMS 5.2) change 1 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.1.7'  THEN

           -- On 05/23/2016 Usha Anand Talambeti added a new column issuccessnotify on pmm_partner table.
           vsql := 'ALTER TABLE '||vschema||'.pmm_partner ADD COLUMN issuccessnotify numeric (1,0) DEFAULT 0 NOT NULL';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.pmm_partner ADD COLUMN issuccessnotify numeric (1,0) DEFAULT 0 NOT NULL','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.1.7','5.2.0') into tmp_result;

        END IF;

        /*---- Start of Convert release from 5.2.0 (CMS 5.2) to 5.2.1 (CMS 5.2) change 2 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.2.0'  THEN

           -- On 05/27/2016 Edwin added a new row into sch_ruletype table.
           vsql := 'INSERT INTO '||vschema||'.sch_ruletype(id,type) VALUES (4, ''EVERY_N_HOURMINS'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT INTO '||vschema||'.sch_ruletype row for EVERY_N_HOURMINS.','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.2.0','5.2.1') into tmp_result;

        END IF;

        /*---- Start of Convert release from 5.2.1 (CMS 5.2) to 5.2.2 (CMS 5.2) change 3 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.2.1'  THEN

           -- On 06/15/2016 Usha Anand Talambeti added a new column DISTRIBUTION_DATE on pmm_title table.
           vsql := 'ALTER TABLE '||vschema||'.PMM_TITLE ADD COLUMN DISTRIBUTION_DATE TIMESTAMP(6)';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.PMM_TITLE ADD COLUMN DISTRIBUTION_DATE','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.2.1','5.2.2') into tmp_result;

        END IF;

        /*---- Start of Convert release from 5.2.2 (CMS 5.2) to 5.2.3 (CMS 5.2) change 4 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
        IF WK_RELEASE =  '5.2.2'  THEN

           -- On 06/14/2016 Suresh added a new column in system_setting for cms component.
           vsql := 'ALTER TABLE '||vschema||'.SYSTEM_SETTINGS ADD COLUMN COMPONENT_NAME varchar(50)';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.SYSTEM_SETTINGS ADD COLUMN COMPONENT_NAME','Y') INTO tmp_result;

           vsql := 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET COMPONENT_NAME = ''PRECMS'' WHERE SETTING_TYPE = ''RELEASE''';
           SELECT CREATEOBJECT(vsql,'Unable to UPDATE '||vschema||'.SYSTEM_SETTINGS SET COMPONENT_NAME = ''PRECMS''','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values (''WORKFLOW'',''RELEASE'',''5.2.2'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT new record for WORKFLOW INTO '||vschema||'.SYSTEM_SETTINGS','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values (''CONTENT_MANAGEMENT'',''RELEASE'',''5.2.2'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT new record for CONTENT_MANAGEMENT INTO '||vschema||'.SYSTEM_SETTINGS','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values (''NEPTUNE'',''RELEASE'',''5.2.2'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT new record for NEPTUNE INTO '||vschema||'.SYSTEM_SETTINGS','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values (''CATEGORY_MANAGEMENT'',''RELEASE'',''5.2.2'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT new record for CATEGORY_MANAGEMENT INTO '||vschema||'.SYSTEM_SETTINGS','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values (''METADATA_ENHANCEMENT'',''RELEASE'',''5.2.2'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT new record for METADATA_ENHANCEMENT INTO '||vschema||'.SYSTEM_SETTINGS','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values (''RULES'',''RELEASE'',''5.2.2'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT new record for RULES INTO '||vschema||'.SYSTEM_SETTINGS','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values (''JOB_SCHEDULER'',''RELEASE'',''5.2.2'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT new record for JOB_SCHEDULER INTO '||vschema||'.SYSTEM_SETTINGS','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values (''QUERYVIEWS'',''RELEASE'',''5.2.2'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT new record for QUERYVIEWS INTO '||vschema||'.SYSTEM_SETTINGS','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values (''POSTCMS'',''RELEASE'',''5.2.2'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT new record for POSTCMS INTO '||vschema||'.SYSTEM_SETTINGS','Y') INTO tmp_result;

           -- on 08/19/2016 Suresh added index on system_settings table.
           vsql := 'CREATE UNIQUE INDEX idx_system_settings_compname ON '||vschema||'.system_settings (component_name)';
           SELECT CREATEOBJECT(vsql,'Unable to CREATE UNIQUE INDEX idx_system_settings_compname.','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||ischema||'.install_table ALTER COLUMN msgdate TYPE timestamp(6) without time zone';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||ischema||'.install_table ALERT COLUMN msgdate TYPE timestamp','Y') INTO tmp_result;

           vsql := 'ALTER TABLE '||ischema||'.install_table ALTER COLUMN msgdate SET default current_timestamp';
           SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||ischema||'.install_table ALTER COLUMN msgdate SET default current_timestamp','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.2.2','5.2.3') into tmp_result;

        END IF;
    END IF;

        /*---- Start of Convert release from 5.2.3 (CMS 5.2) to 5.2.4 (CMS 5.2) change 5 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
       IF wk_release =  '5.2.3' THEN
           -- on 08/19/2016 Suresh added index on system_settings table.
           vsql := 'CREATE UNIQUE INDEX idx_system_settings_compname ON '||vschema||'.system_settings (component_name)';
           --SELECT CREATEOBJECT(vsql,'Unable to CREATE UNIQUE INDEX idx_system_settings_compname.','Y') INTO tmp_result;

           vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values (''QUERYVIEWS'',''RELEASE'',''5.2.2'')';
           SELECT CREATEOBJECT(vsql,'Unable to INSERT new record for QUERYVIEWS INTO '||vschema||'.SYSTEM_SETTINGS','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'5.2.3','5.2.4') into tmp_result;
       END IF;

        /*---- Start of Convert release from 5.2.4 (CMS 5.2) to 6.0.0 (CMS 6.0) change 1 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
       IF wk_release = '5.2.4' THEN	
           -- Changed the database scripts from EDB to Postgres
           select set_version(vschema, comp_name,'5.2.4','6.0.0') into tmp_result;
       END IF;
        
       /*---- Start of Convert release from 6.0.0 (CMS 6.0) to 6.0.1 (CMS 6.0) change 2 --- */
       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
       IF wk_release = '6.0.0' THEN	
           execute 'select drop_purge_table_cons();';

           vsql := 'alter user wfsdw nosuperuser';
           SELECT CREATEOBJECT(vsql,'Unable to alter user wfsdw nosuperuser','Y') INTO tmp_result;

           vsql := 'alter user epgmanager nosuperuser';
           SELECT CREATEOBJECT(vsql,'Unable to alter user epgmanager nosuperuser','Y') INTO tmp_result;

           vsql := 'alter user wfs nosuperuser';
           SELECT CREATEOBJECT(vsql,'Unable to alter user wfs nosuperuser','Y') INTO tmp_result;

           vsql := 'grant all on '||ischema||'.install_table to wfsdw';
           SELECT CREATEOBJECT(vsql,'Unable to ','Y') INTO tmp_result;

           select set_version(vschema, comp_name,'6.0.0','6.0.1') into tmp_result;
       END IF;

       EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
       IF (wk_release IN ('6.0.1','7.0.0')) THEN
           -- On 03/16/2018 changed the script to use PostgreSQL 10 and changed version to cms 7.0.0
           -- On 05/22/2018 Bo remove ContractManager module from cms UI.
           vsql := 'delete from '||vschema||'.cms_rolepermissions where permissionid in ('||
                          'select permissionid from '||vschema||'.cms_permission where moduleid in ('||
                                 'select moduleid from '||vschema||'.cms_module where modulename=''ContractManager''))';
           SELECT CREATEOBJECT(vsql,'Unable to delete from '||vschema||'.cms_rolepermissions where modulename is ContractManager','Y') INTO tmp_result;
           vsql := 'delete from '||vschema||'.cms_permission where moduleid in (select moduleid from '||vschema||'.cms_module where modulename=''ContractManager'')';
           SELECT CREATEOBJECT(vsql,'Unable to delete from '||vschema||'.cms_permission where modulename is ContractManager','Y') INTO tmp_result;
           vsql := 'delete from '||vschema||'.cms_module where modulename=''ContractManager''';
           SELECT CREATEOBJECT(vsql,'Unable to delete from '||vschema||'.cms_module where modulename is ContractManager','Y') INTO tmp_result;
           select set_version(vschema, comp_name,'7.0.0',db_version) into tmp_result;
       END IF;
	   
	   EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
	   IF (wk_release IN ('7.0.1','7.0.0')) THEN
	       -- Bo request on 5/5/2019 to add VF to setting value for 'com.tandbergtv.workflow.resource.systemids' in cms_setting table.
           vsql := 'update '||vschema||'.cms_setting set setting_value = setting_value || '',VF'' where setting_value not like ''%VF%'' and  setting_name = ''com.tandbergtv.workflow.resource.systemids''';   
           SELECT CREATEOBJECT(vsql,'Unable to update '||vschema||'.cms_setting set setting_value to add VF','Y') INTO tmp_result;
		   select set_version(vschema, comp_name,'7.0.1',db_version) into tmp_result;
	   END IF;


    EXECUTE 'INSERT INTO '||ischema||'.install_table (msgdate, install_message) values (now(),''Upgrading '||comp_name||' changes to '||db_version||' completed SUCCESSFULLY'')';
    RETURN tmp_result;
EXCEPTION
    WHEN OTHERS THEN
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in convertrm function : '')';
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
      return 1;
END;
$func_convertprecms$ LANGUAGE plpgsql;



CREATE OR REPLACE FUNCTION INSTALL_PRECMS () RETURNS integer AS $func_installprecms$
DECLARE
    comp_name    varchar := 'PRECMS';
    tbl_count    smallint;
    vschema      varchar := 'wfs';
    func_results smallint;
    wk_release   varchar:='';    
    db_version   varchar := '7.2.0';
    ischema    text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    select count(*) into tbl_count from pg_tables where schemaname = vschema and tablename not in ('install_table');
    IF tbl_count = 0 THEN
      select CREATEPRECMS(vschema,comp_name,db_version) into func_results;
    ELSE
      EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
      IF wk_release < db_version  THEN
         select CONVERTPRECMS(vschema,comp_name,db_version) into func_results;
      ELSIF wk_release = db_version  THEN
        EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''There are no database changes in '||comp_name||' component to upgrade'')';
      END IF;
    END IF;
    return func_results;
END;
$func_installprecms$ LANGUAGE plpgsql;

DO $$declare
   results    smallint;
begin
   select INSTALL_PRECMS() into results;
end$$;