/*
-- commented START WITH query views
-- changed to_char to ::text
-- NUMBER to NUMERIC
-- rownum commented the query
-- to_char(longvalue_) changed to to_char(longvalue_,'99999999999999999999')
-- to_char(bytevalue_) changed to to_char(longvalue_,'99999999999999999999')
-- Views commented and reasons
--   vdw_missingcontent             -- subquery in FROM must have an alias
--   vdw_sitetitle_metadata         -- rownum
--   vdw_title_master_child         -- hierarchical
--   vdw_title_metadata             -- rownum
--   vdw_wo_master_child            -- hierarchical
--   vw_rep_templates_used_by_title -- hierarchical
--   vw_rep_titles_prossby_template -- oracle/edb extract function.
*/
\set VERBOSITY terse
PREPARE get_inst_schema AS SELECT :'inst_schema'::text;

CREATE OR REPLACE FUNCTION CREATEQUERIES (vschema varchar, vname varchar) RETURNS varchar  AS $func_createqueries$
DECLARE
    vsql                            varchar;
    wk_message                      varchar:= '';
    tmp_result                      smallint;
    errcnt                          smallint;
    ischema                         text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    --select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TEST','N') INTO tmp_result;
    --SELECT createseq(vschema,'TEST') INTO tmp_result;
    --SELECT createupdatetrg(vschema,'TEST') INTO tmp_result;
    case vname
         when 'vsql_vdw_wo_master_child' then
            vsql:= 'CREATE OR REPLACE VIEW '||vschema||'.VDW_WO_MASTER_CHILD AS
                    SELECT * FROM
                    (SELECT level                         as wo_tree_level, 
                         JP.ID_                        AS workorder_id,
                         jp.PROCESSDEFINITION_         AS Template_id,
                         jd.name_                      as Template_name, 
                         jp.PROCESSPRIORITYID          AS process_priority_id,
                         pp.name                       AS process_priority,
                         jp.START_                     AS wo_start_time,
                         jp.END_                       AS wo_end_time,
                         jp.createdate                 AS wo_create_date,
                         jp.updatedate                 AS wo_update_date,       
                         JT.ID_                        AS token_id,
                         jp.SUPERPROCESSTOKEN_         AS super_process_token,
                         jp.ROOTTOKEN_                 AS root_token,
                         jt.parent_                    as token_parent_id,
                         jt.OPERATIONALSTATUS          AS process_status_id,
                         case when ps.name=''STOPPED'' then ''COMPLETED'' else ps.name end AS process_status       
                    FROM '||vschema||'.JBPM_TOKEN JT 
                    join '||vschema||'.JBPM_PROCESSINSTANCE JP on (JT.PROCESSINSTANCE_ = JP.ID_ )
                    left outer join '||vschema||'.TTV_PROCESSPRIORITY pp on (jp.PROCESSPRIORITYID=pp.PROCESSPRIORITYID)
                    join '||vschema||'.TTV_PROCESSSTATUS ps on (jt.OPERATIONALSTATUS= ps.PROCESSSTATUSID)
                    left outer join '||vschema||'.JBPM_processdefinition jd on (jp.PROCESSDEFINITION_ = jd.id_)
                    where jp.isactive =1
                    START WITH JP.SUPERPROCESSTOKEN_ IS NULL AND jt.parent_ is null 
                    CONNECT BY  JP.SUPERPROCESSTOKEN_= PRIOR JT.ID_
                    order siblings by jp.id_, jp.start_)  
                    UNION
                    SELECT * FROM
                    (SELECT level                         as wo_tree_level, 
                         JP.ID_                        AS workorder_id,
                         jp.PROCESSDEFINITION_         AS Template_id,
                         jd.name_                      as Template_name, 
                         jp.PROCESSPRIORITYID          AS process_priority_id,
                         pp.name                       AS process_priority,
                         jp.START_                     AS wo_start_time,
                         jp.END_                       AS wo_end_time,
                         jp.createdate                 AS wo_create_date,
                         jp.updatedate                 AS wo_update_date,       
                         JT.ID_                        AS token_id,
                         jp.SUPERPROCESSTOKEN_         AS super_process_token,
                         jp.ROOTTOKEN_                 AS root_token,
                         jt.parent_                    as token_parent_id,
                         jt.OPERATIONALSTATUS          AS process_status_id,
                         case when ps.name=''STOPPED'' then ''COMPLETED'' else ps.name end AS process_status       
                    FROM '||vschema||'.JBPM_TOKEN JT 
                    join '||vschema||'.JBPM_PROCESSINSTANCE JP on (JT.PROCESSINSTANCE_ = JP.ID_ )
                    left outer join '||vschema||'.TTV_PROCESSPRIORITY pp on (jp.PROCESSPRIORITYID=pp.PROCESSPRIORITYID)
                    join '||vschema||'.TTV_PROCESSSTATUS ps on (jt.OPERATIONALSTATUS= ps.PROCESSSTATUSID)
                    left outer join '||vschema||'.JBPM_processdefinition jd on (jp.PROCESSDEFINITION_ = jd.id_)
                    where jp.isactive =1
                    START WITH JP.SUPERPROCESSTOKEN_ IS NULL AND jt.parent_ is null 
                    CONNECT BY  jt.parent_ = prior jt.id_
                    order siblings by jp.id_, jp.start_)';

         when 'vsql_vdw_wo_node_log' then
            vsql:= 'CREATE OR REPLACE VIEW '||vschema||'.VDW_WO_NODE_LOG AS
                    SELECT JP.ID_         as workorder_id,
                           JT.ID_         as token_id ,
                           jd.name_       as template_name, 
                           jl.node_       as node_id,
                           jn.name_       as node_name, 
                           jl.enter_      as node_enter_time, 
                           jl.leave_      as node_leave_time, 
                           jl.index_      as log_index
                      FROM '||vschema||'.JBPM_TOKEN JT, 
                           '||vschema||'.JBPM_PROCESSINSTANCE JP, 
                           '||vschema||'.jbpm_processdefinition jd, 
                           '||vschema||'.jbpm_log jl, 
                           '||vschema||'.jbpm_node jn
                     WHERE JT.PROCESSINSTANCE_ = JP.ID_ 
                       and JL.token_ = jt.ID_
                       and jl.node_ = jn.id_ 
                       and jl.class_ = ''N''  
                       and jp.processdefinition_ = jd.id_
                     order by jp.id_,jl.enter_';      

         when 'vsql_vdw_wo_vi' then
            vsql:= 'CREATE OR REPLACE VIEW '||vschema||'.VDW_WO_VARIABLEINSTANCE AS
                    SELECT JP.ID_   as workorder_id,
                           JT.ID_   as token_id ,
                           vi.NAME_ as variable_name,
                           case when vi.STRINGVALUE_ is not null then vi.STRINGVALUE_ 
                                when vi.LONGVALUE_ is not null then to_char(vi.LONGVALUE_,''999999999999999999'')
                                when vi.DOUBLEVALUE_ is not null then to_char(vi.DOUBLEVALUE_,''9999999999999999D999999'')
                                when vi.DATEVALUE_ is not null then to_char(vi.DATEVALUE_,''YYYY-MM-DD HH24:MI:SS.FF'')
                                when vi.BYTEARRAYVALUE_ is not null then to_char(vi.BYTEARRAYVALUE_,''9999999999999999'')
                                else null end as variable_value               
                      FROM  '||vschema||'.JBPM_TOKEN JT, '||vschema||'.JBPM_PROCESSINSTANCE JP, '||vschema||'.jbpm_variableinstance vi
                            WHERE JT.PROCESSINSTANCE_ = JP.ID_ 
                             and vi.processinstance_ = jp.id_'; 

         when 'vsql_vdw_title_wo_details' then
            vsql:= 'CREATE OR REPLACE VIEW '||vschema||'.VDW_TITLE_WO_DETAILS AS
                  SELECT  t.id_                 as title_id,
                          mdm.document_id       as document_id ,
                          CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id/text()'',mdm.document)::text[])[1]::text as VARCHAR) as provider_id,                          
                          CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Name/text()'',mdm.document)::text[])[1]::text as VARCHAR) as provider_name,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value/text()'', mdm.document)::text[])[1]::text as VARCHAR) as title_brief,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'',mdm.document)::text[])[1] as timestamp) as license_start_date,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'',mdm.document)::text[])[1] as timestamp) as license_end_date,
                          CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'',mdm.document)::text[])[1]::text as VARCHAR) as package_asset_id,                          
                          CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'',mdm.document)::text[])[1]::text as VARCHAR) as asset_name,                          
                          jp.id_                as workorder_id,
                          jp.start_             as workorder_start_time,
                          jp.end_               as workorder_end_time,
                          jp.operationalprocessstatusid as workorder_status_id,
                          ps.name                       as workorder_status
                    FROM '||vschema||'.MDM_METADATA mdm 
                    join '||vschema||'.pmm_title t on ( t.mdmdocid= mdm.document_id ) 
                    join '||vschema||'.PMM_TITLESTATUS ts on (t.titlestatusid = ts.id_)
                    join '||vschema||'.jbpm_variableinstance vi on (t.id_::text = vi.stringvalue_ )
                    join '||vschema||'.jbpm_processinstance jp  on (vi.name_=''titleId'' and vi.processinstance_ = jp.id_)
                    join '||vschema||'.ttv_processstatus ps on (jp.operationalprocessstatusid=ps.processstatusid)';

         when 'vsql_vdw_sitetitle_wo_details' then
            vsql:= 'CREATE OR REPLACE VIEW '||vschema||'.VDW_SITETITLE_WO_DETAILS AS
                  SELECT  
                          t.id_                 as title_id,
                          mdm.document_id       as document_id ,
                          CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id/text()'',mdm.document)::text[])[1]::text as VARCHAR) as provider_id,                          
                          CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Name/text()'',mdm.document)::text[])[1]::text as VARCHAR) as provider_name,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value/text()'', mdm.document)::text[])[1]::text as VARCHAR) as title_brief,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'',mdm.document)::text[])[1] as timestamp) as license_start_date,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'',mdm.document)::text[])[1] as timestamp) as license_end_date,
                          CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'',mdm.document)::text[])[1]::text as VARCHAR) as package_asset_id,                          
                          CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'',mdm.document)::text[])[1]::text as VARCHAR) as asset_name,
                          jp.id_                as workorder_id,
                          jp.start_             as workorder_start_time,
                          jp.end_               as workorder_end_time,
                          jp.operationalprocessstatusid as workorder_status_id,
                          ps.name                       as workorder_status
                    FROM  '||vschema||'.MDM_METADATA_SITE mdm 
                    join '||vschema||'.pmm_title t on ( t.mdmdocid= mdm.document_id ) 
                    join '||vschema||'.PMM_TITLESTATUS ts on (t.titlestatusid = ts.id_)
                    join '||vschema||'.jbpm_variableinstance vi on (t.id_::text = vi.stringvalue_ )
                    join '||vschema||'.jbpm_processinstance jp  on (vi.name_=''titleId'' and vi.processinstance_ = jp.id_)
                    join '||vschema||'.ttv_processstatus ps on (jp.operationalprocessstatusid=ps.processstatusid)';

         when 'vsql_vdw_title_wo_node_log_det' then
            vsql:= 'CREATE OR REPLACE VIEW '||vschema||'.VDW_TITLE_WO_NODE_LOG_DETAILS AS
                  SELECT  t.id_                 as title_id,
                          mdm.document_id       as document_id ,
                          CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id/text()'',mdm.document)::text[])[1]::text as VARCHAR) as provider_id,                          
                          CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Name/text()'',mdm.document)::text[])[1]::text as VARCHAR) as provider_name,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value/text()'', mdm.document)::text[])[1]::text as VARCHAR) as title_brief,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'',mdm.document)::text[])[1] as timestamp) as license_start_date,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'',mdm.document)::text[])[1] as timestamp) as license_end_date,
                          CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'',mdm.document)::text[])[1]::text as VARCHAR) as package_asset_id,                          
                          CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'',mdm.document)::text[])[1]::text as VARCHAR) as asset_name,                          
                          jp.id_                as workorder_id,
                          JN.NAME_              as NODE_NAME,
                          JL.ENTER_             as NODE_ENTER_TIME, 
                          jl.leave_             as node_leave_time,
                          jl.duration_          as node_completion_time_seconds
                    FROM '||vschema||'.MDM_METADATA mdm 
                    join '||vschema||'.pmm_title t on (t.mdmdocid= mdm.document_id) 
                    join '||vschema||'.PMM_TITLESTATUS ts on (t.titlestatusid = ts.id_)
                    join '||vschema||'.jbpm_variableinstance vi on (t.id_::text = vi.stringvalue_ and vi.name_=''titleId'')
                    join '||vschema||'.jbpm_processinstance jp  on (vi.processinstance_ = jp.id_)
                    join '||vschema||'.jbpm_processdefinition jd on (jp.processdefinition_ = jd.id_)
                    join '||vschema||'.jbpm_token jt on (jt.processinstance_ = jp.id_ )
                    join '||vschema||'.jbpm_log jl  on (JL.token_ = jt.ID_)
                    join '||vschema||'.JBPM_NODE JN on (JL.NODE_ = JN.ID_ and JL.CLASS_ = ''N'')';

         when 'vsql_vdw_stitl_wo_node_log_det' then
            vsql:= 'CREATE OR REPLACE VIEW '||vschema||'.VDW_STITLE_WO_NODE_LOG_DETAILS AS
                  SELECT  
                          t.id_                 as title_id,
                          mdm.document_id       as document_id ,
                          CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id/text()'',mdm.document)::text[])[1]::text as VARCHAR) as provider_id,                          
                          CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Name/text()'',mdm.document)::text[])[1]::text as VARCHAR) as provider_name,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value/text()'', mdm.document)::text[])[1]::text as VARCHAR) as title_brief,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'',mdm.document)::text[])[1] as timestamp) as license_start_date,                          
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'',mdm.document)::text[])[1] as timestamp) as license_end_date,
                          CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'',mdm.document)::text[])[1]::text as VARCHAR) as package_asset_id,                          
                          CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'',mdm.document)::text[])[1]::text as VARCHAR) as asset_name,                          
                          jp.id_                as workorder_id,
                          JN.NAME_              as NODE_NAME,
                          JL.ENTER_             as NODE_ENTER_TIME, 
                          jl.leave_             as node_leave_time,
                          jl.duration_          as node_completion_time_seconds
                    FROM '||vschema||'.MDM_METADATA_SITE mdm 
                    join '||vschema||'.pmm_title t on ( t.mdmdocid= mdm.document_id )
                    join '||vschema||'.PMM_TITLESTATUS ts on (t.titlestatusid = ts.id_)
                    join '||vschema||'.jbpm_variableinstance vi on (t.id_::text = vi.stringvalue_ and vi.name_=''titleId'')
                    join '||vschema||'.jbpm_processinstance jp  on (vi.processinstance_ = jp.id_)
                    join '||vschema||'.jbpm_processdefinition jd on (jp.processdefinition_ = jd.id_)
                    join '||vschema||'.jbpm_token jt on (jt.processinstance_ = jp.id_ )
                    join '||vschema||'.jbpm_log jl  on (JL.token_ = jt.ID_)
                    join '||vschema||'.JBPM_NODE JN on (JL.NODE_ = JN.ID_ and JL.CLASS_ = ''N'')';

         when 'vsql_vdw_title_master_child' then
            vsql:= 'CREATE OR REPLACE  VIEW '||vschema||'.VDW_TITLE_MASTER_CHILD AS
                  SELECT  title_tree_level,
                          title_id,
                          title_status_id,
                          title_status_desc,
                          provider_id,
                          provider_name,
                          original_title_id,
                          content_class_id,
                          partner_id,
                          partner_name,
                          title_retirement_date,
                          title_create_date,
                          title_update_date,
                          nvl2(original_title_id,ydocument_id,xdocument_id)          AS document_id,
                          case when original_title_id is not null then ytitle_brief else xtitle_brief end         AS title_brief,
                          case when original_title_id is not null then yasset_name else xasset_name end           AS asset_name,
                          case when original_title_id is not null then yasset_id else xasset_id end             AS package_assetid,
                          to_timestamp(case when original_title_id is not null then ylicense_startdt else xlicense_startdt end,''YYYY-MM-DD"T"HH24:MI:SS.FF'') AS licensing_startdt,
                          to_timestamp(case when original_title_id is not null then ylicense_enddt  else xlicense_enddt end,''YYYY-MM-DD"T"HH24:MI:SS.FF'')   AS licensing_enddt
                  from (
                   SELECT level                  AS title_tree_level,
                          t.ID_                  AS title_id,
                          t.titlestatusid        AS title_status_id,
                          ts.description         AS title_status_desc,
                          t.providerid           AS provider_id,
                          prov.name              AS provider_name,
                          t.originaltitle_id     AS original_title_id,
                          t.content_class_id     AS content_class_id,
                          t.partner_id           AS partner_id,
                          ptnr.name              AS partner_name,
                          t.retirement_date      AS title_retirement_date,
                          t.createdate           AS title_create_date,
                          t.updatedate           AS title_update_date,
                          CAST((xpath(''/ECMFSpec/@documentId''::text, mdm.document)::text[])[1]::text as NUMERIC) AS xdocument_id,
                          CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'', mdm.document)::text[])[1]::text as VARCHAR) as xasset_name      ,
                          CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'', mdm.document)::text[])[1]::text as VARCHAR) as xasset_id,                           
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'', mdm.document)::text[])[1]::text as VARCHAR) as xlicense_startdt ,
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value/text()'', mdm.document)::text[])[1]::text as VARCHAR) as xtitle_brief     ,
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'', mdm.document)::text[])[1]::text as VARCHAR) as xlicense_enddt   ,
                          CAST((xpath(''/ECMFSpec/@documentId''::text, mdmsite.document)::text[])[1]::text as NUMERIC) AS ydocument_id,
                          CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'', mdmsite.document)::text[])[1]::text as VARCHAR) as yasset_name      ,
                          CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'', mdmsite.document)::text[])[1]::text as VARCHAR) as yasset_id,                     
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'', mdmsite.document)::text[])[1]::text as VARCHAR) as ylicense_startdt ,
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value/text()'', mdmsite.document)::text[])[1]::text as VARCHAR) as ytitle_brief     ,
                          CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'', mdmsite.document)::text[])[1]::text as VARCHAR) as ylicense_enddt
                    FROM '||vschema||'.pmm_title t
                    left outer join '||vschema||'.mdm_metadata mdm on ( t.mdmdocid= mdm.document_id)
                    left outer join '||vschema||'.mdm_metadata_site mdmsite on ( t.mdmdocid= mdmsite.document_id)
                    JOIN '||vschema||'.PMM_TITLESTATUS ts on (t.titlestatusid = ts.id_)
                    left outer join '||vschema||'.PMM_PARTNER prov on (t.providerid = prov.id_)
                    left outer join '||vschema||'.PMM_PARTNER ptnr on (t.partner_id = ptnr.id_)
                    START WITH t.originaltitle_id IS NULL
                  CONNECT BY  t.originaltitle_id = PRIOR t.id_
                  ORDER SIBLINGS BY t.id_)';  

         when 'vsql_vdw_title_metadata' then
            vsql:= 'CREATE OR REPLACE VIEW '||vschema||'.VDW_TITLE_METADATA AS
		   with tmp_mdm as (
			select
			CAST((xpath(''/ECMFSpec/@documentId''::text, document)::text[])[1]::text as NUMERIC) AS document_id,
			CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as provider_id      ,
			CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as provider_name      ,
			CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'', document)::text[])[1]::text as VARCHAR) as asset_name,
			CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as   asset_id    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'', document)::text[])[1]::text as VARCHAR) as license_start_date      ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'', document)::text[])[1]::text as VARCHAR) as      license_end_date ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_brief     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/AssetClass/text()'', document)::text[])[1]::text as VARCHAR) as  package_asset_class     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as  package_asset_id     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'', document)::text[])[1]::text as VARCHAR) as  package_asset_name     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/CreationInfo/CreateDate/text()'', document)::text[])[1]::text as VARCHAR) as  package_creation_date     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/Description/Text/text()'', document)::text[])[1]::text as VARCHAR) as  package_description     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/MetadataSpecVersion/text()'', document)::text[])[1]::text as VARCHAR) as   package_metadata_spec_version    ,
			CAST((xpath(''/ECMFSpec/Package/Fields/ProductInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as   package_product    ,
			CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as   package_provider    ,
			CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as    package_provider_id   ,
			CAST((xpath(''/ECMFSpec/Package/Fields/Version/Major/text()'', document)::text[])[1]::text as VARCHAR) as    package_version_major   ,
			CAST((xpath(''/ECMFSpec/Package/Fields/Version/Minor/text()'', document)::text[])[1]::text as VARCHAR) as       package_version_minor,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as       title_asset_id,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/AssetName/text()'', document)::text[])[1]::text as VARCHAR) as     title_asset_name  ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Description/Text/text()'', document)::text[])[1]::text as VARCHAR) as  title_asset_description     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/AssetClass/text()'', document)::text[])[1]::text as VARCHAR) as     title_asset_class  ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="AONDWEB_AVAILABLE"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as  title_aondweb_available     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="AONTV_AVAILABLE"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as   title_aontv_available    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="ASSOCIATION_ID"]/Value/text()'', document)::text[])[1]::text as VARCHAR) as title_association_id      ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/BillingInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as       TITLE_BILLING_ID,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Categories/Category/Category/Text/text()'', document)::text[])[1]::text as VARCHAR) as TITLE_Category,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Caption/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_closed_captioning     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/Contract/Name/text()'', document)::text[])[1]::text as VARCHAR) as   title_contract_name    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CreationInfo/Place/Country/text()'', document)::text[])[1]::text as VARCHAR) as   title_Country_of_Origin    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Duration/DisplayDuration/text()'', document)::text[])[1]::text as VARCHAR) as  title_Display_Run_Time     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="EXT_ASSET_ID"]/Value/text()'', document)::text[])[1]::text as VARCHAR) as   title_EXT_ASSET_ID    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="EXT_title_ID"]/Value/text()'', document)::text[])[1]::text as VARCHAR) as   title_EXT_title_ID    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Episode/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as   title_Episode_ID    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Episode/Name/Value/text()'', document)::text[])[1]::text as VARCHAR) as   title_Episode_Name    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Genres/Genre[1]/Value/text()'', document)::text[])[1]::text as VARCHAR) as   title_Genre    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="IAP_AVAILABLE"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as  title_IAP_AVAILABLE     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'', document)::text[])[1]::text as VARCHAR) as   title_Licensing_Window_End    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'', document)::text[])[1]::text as VARCHAR) as  title_Licensing_Window_Start     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/MaxViewingLimit/text()'', document)::text[])[1]::text as VARCHAR) as  title_Maximum_Viewing_Length     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/ProductInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as  title_Product     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/PropagationPriority/text()'', document)::text[])[1]::text as VARCHAR) as  title_Propagation_Priority     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/ProviderInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as  title_Provider     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/ProviderInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as title_Provider_ID      ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/ProviderQAContact/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Provider_QA_Contact     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="QC_COMPLETE"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as  title_QC_COMPLETE     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="QC_REQUIRED"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as  title_QC_REQUIRED     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rating/RatingValues/RatingValue[1]/Value/text()'', document)::text[])[1]::text as VARCHAR) as title_Rating      ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Duration/Duration/text()'', document)::text[])[1]::text as VARCHAR) as   title_Run_Time    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/ShowType/text()'', document)::text[])[1]::text as VARCHAR) as  title_Show_Type     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CreationInfo/Studio/Name/text()'', document)::text[])[1]::text as VARCHAR) as title_Studio_Name      ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyPercent/@value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Studio_Royalty_Percent     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/BillingInfo/SuggestedPrice/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Suggested_Price     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Summary/DisplaySummary/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Summary_Long     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Summary/MediumSummary/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Summary_Medium     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Summary/ShortSummary/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Summary_Short     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="TRAILER_NUM"]/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_TRAILER_NUM     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/DisplayTitle/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Title     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value/text()'', document)::text[])[1]::text as VARCHAR) as   title_Title_Brief    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/SortTitle/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Title_Sort_Name     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="VOD_CODE"]/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_VOD_CODE     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CreationInfo/PublicationDate/text()'', document)::text[])[1]::text as VARCHAR) as TITLE_YEAR    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Sources/Source/Role/Nam/text()'', document)::text[])[1]::text as VARCHAR) as TITLE_ROLE_NAME ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Sources/Source/CharacterName/text()'', document)::text[])[1]::text as VARCHAR) as TITLE_CHARACTER_NAME ,
			rownum as title_source_seqno,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Sources/Source/Contact/DisplayName/text()'', document)::text[])[1]::text as VARCHAR) as TITLE_CONTACT_DISPNAME,
			rownum as Movie_SEQNO,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/AssetClass/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Asset_Class,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Asset_ID,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/AssetName/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_ASSET_NAME,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Video/BitRate/@value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Bit_Rate,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Content/Locator/Uri/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Content,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Content/Checksum/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Content_CheckSum,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Content/Size/length/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Content_Filesize,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Copyright/CopyProtection/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Copy_Protection,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/CreationInfo/CreateDate/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Creation_Date,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Description/Text/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_DESCRIPTION,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Encryption/Value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Encryption,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Video/HDContent/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_HDCONTENT,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/ProviderInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Provider,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/ProviderInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Provider_ID,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Video/ScreenFormat/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Screen_Format,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/SubTitleLanguage/@value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Subtitle_Languages,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Video/StreamFormat/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_STREAM_FORMAT,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Video/AudioInfos/AudioInfo/Value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Audio_Type ,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/DubbedLanguages/DubbedLanguage/@value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Dubbed_Languages ,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Languages/Language/@value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Languages ,
			rownum as POSTER_SEQNO,
			CAST((xpath(''/ECMFSpec/Package/Poster/Fields/Content/Checksum/text()'', document)::text[])[1]::text as VARCHAR) as POSTER_Content_Checksum,
			CAST((xpath(''/ECMFSpec/Package/Poster/Fields/Content/Size/length/text()'', document)::text[])[1]::text as VARCHAR) as POSTER_Content_Filesize,
			CAST((xpath(''/ECMFSpec/Package/Poster/Fields/CreationInfo/CreateDate/text()'', document)::text[])[1]::text as VARCHAR) as POSTER_Creation_Date,
			CAST((xpath(''/ECMFSpec/Package/Poster/Fields/Image/AspectRatio/text()'', document)::text[])[1]::text as VARCHAR) as POSTER_IMAGE_ASPECT_RATIO,
			rownum as PREVIEW_SEQNO,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Video/BitRate/@value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_BIT_RATE,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Content/Locator/Uri/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_CONTENT,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Content/Checksum/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Content_Checksum,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Content/Size/length/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Content_Filesize,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/CreationInfo/CreateDate/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_CREATION_DATE,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Video/HDContent/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_HDContent,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/ProviderInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Provider,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/ProviderInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Provider_ID,
 		        CAST((xpath(''/ECMFSpec/Package/Preview/Fields/CustomFields/CustomField[@name="QC_COMPLETE"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_QC_COMPLETE,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Duration/Duration/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Run_Time,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Video/ScreenFormat/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Screen_Format,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/SubTitleLanguage/@value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_SUBTITLE_LANGUAGES,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Video/AudioInfos/AudioInfo/Value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Audio_Type,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/DubbedLanguages/DubbedLanguage/@value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Dubbed_Languages,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Languages/Language/@value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Languages,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Rating/RatingValues/RatingValue/Value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Rating,
			rownum as ENCRYPTED_SEQNO,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Content/Locator/Uri/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Content,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Content/Checksum/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Content_Checksum,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Content/Size/length/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Content_Filesize,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/CreationInfo/CreateDate/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Creation_Date,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Asset_Encrypted,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Encryption/KeyBlock/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Encryption_KeyBlock,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Encryption/SystemInfo/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Encryption_Sysinfo,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Encryption/Type/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Encryption_Type
			from MDM_METADATA )
			SELECT  T.ID_ AS TITLEID,
				T.ORIGINALTITLE_ID AS MASTER_TITLE_ID,
				ts.description as TITLE_STATUS,
				m.document_id,
				provider_id,
				provider_name,
				asset_name,
				tmp_mdm.asset_id,
				license_start_date,
				license_end_date,
				title_brief,
				package_asset_class,
				package_asset_id,
				package_asset_name,
				package_creation_date,
				package_description,
				package_metadata_spec_version,
				package_product,
				package_provider,
				package_provider_id,
				package_version_major,
				package_version_minor,
				title_asset_id,
				title_asset_name,
				title_asset_description,
				title_asset_class,
				title_aondweb_available,
				title_aontv_available,
				title_association_id,
				TITLE_BILLING_ID,
				TITLE_Category,
				title_closed_captioning,
				title_contract_name,
				title_Country_of_Origin,
				title_Display_Run_Time,
				title_EXT_ASSET_ID,
				title_EXT_title_ID,
				title_Episode_ID,
				title_Episode_Name,
				title_Genre,
				title_IAP_AVAILABLE,
				title_Licensing_Window_End,
				title_Licensing_Window_Start,
				title_Maximum_Viewing_Length,
				title_Product,
				title_Propagation_Priority,
				title_Provider,
				title_Provider_ID,
				title_Provider_QA_Contact,
				title_QC_COMPLETE,
				title_QC_REQUIRED,
				title_Rating,
				title_Run_Time,
				title_Show_Type,
				title_Studio_Name,
				title_Studio_Royalty_Percent,
				title_Suggested_Price,
				title_Summary_Long,
				title_Summary_Medium,
				title_Summary_Short,
				title_TRAILER_NUM,
				title_Title,
				title_Title_Brief,
				title_Title_Sort_Name,
				TITLE_VOD_CODE,
				TITLE_YEAR,
				TITLE_SOURCE_SEQNO,
				TITLE_ROLE_NAME,
				TITLE_CHARACTER_NAME,
				TITLE_CONTACT_DISPNAME,
				MOVIE_SEQNO ,
				MOVIE_Asset_Class,
				MOVIE_Asset_ID,
				MOVIE_Asset_Name,
				MOVIE_Audio_Type,
				MOVIE_Bit_Rate,
				MOVIE_Content,
				MOVIE_Content_CheckSum,
				MOVIE_Content_Filesize,
				MOVIE_Copy_Protection,
				MOVIE_Creation_Date,
				MOVIE_Description,
				MOVIE_Dubbed_Languages,
				MOVIE_Encryption,
				MOVIE_HDContent,
				MOVIE_Languages,
				MOVIE_Provider,
				MOVIE_Provider_ID,
				MOVIE_Screen_Format,
				MOVIE_SUBTITLE_LANGUAGES,
				MOVIE_STREAM_FORMAT,
				POSTER_SEQNO ,
				POSTER_Content_Checksum,
				POSTER_Content_Filesize,
				POSTER_CREATION_DATE,
				POSTER_IMAGE_ASPECT_RATIO,
				PREVIEW_SEQNO,
				PREVIEW_Audio_Type,
				PREVIEW_Bit_Rate,
				PREVIEW_Content,
				PREVIEW_Content_Checksum,
				PREVIEW_Content_Filesize,
				PREVIEW_Creation_Date,
				PREVIEW_Dubbed_Languages,
				PREVIEW_HDContent,
				PREVIEW_Languages,
				PREVIEW_Provider,
				PREVIEW_Provider_ID,
				PREVIEW_QC_COMPLETE,
				PREVIEW_Rating,
				PREVIEW_Run_Time,
				PREVIEW_SCREEN_FORMAT,
				PREVIEW_SUBTITLE_LANGUAGES,
				ENCRYPTED_SEQNO,
				ENCRYPTED_Content,
				ENCRYPTED_Content_Checksum,
				ENCRYPTED_Content_Filesize,
				ENCRYPTED_Creation_Date,
				ENCRYPTED_Asset_Encrypted,
				ENCRYPTED_Encryption_KeyBlock,
				ENCRYPTED_Encryption_Sysinfo,
				ENCRYPTED_Encryption_Type
			FROM  MDM_METADATA m
			join tmp_mdm on tmp_mdm.document_id = m.document_id
			JOIN WFS.PMM_TITLE T ON ( t.mdmdocid= m.document_id )
			JOIN WFS.PMM_TITLESTATUS TS ON (T.TITLESTATUSID = TS.ID_)';

         when 'vsql_vdw_sitetitle_metadata' then
            vsql:= 'CREATE OR REPLACE VIEW '||vschema||'.VDW_SITETITLE_METADATA AS
			with tmp_mdm as (
			select
			CAST((xpath(''/ECMFSpec/@documentId''::text, document)::text[])[1]::text as NUMERIC) AS document_id,
			CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as provider_id      ,
			CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as provider_name      ,
			CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'', document)::text[])[1]::text as VARCHAR) as asset_name,
			CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as   asset_id    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'', document)::text[])[1]::text as VARCHAR) as license_start_date      ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'', document)::text[])[1]::text as VARCHAR) as      license_end_date ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_brief     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/AssetClass/text()'', document)::text[])[1]::text as VARCHAR) as  package_asset_class     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as  package_asset_id     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'', document)::text[])[1]::text as VARCHAR) as  package_asset_name     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/CreationInfo/CreateDate/text()'', document)::text[])[1]::text as VARCHAR) as  package_creation_date     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/Description/Text/text()'', document)::text[])[1]::text as VARCHAR) as  package_description     ,
			CAST((xpath(''/ECMFSpec/Package/Fields/MetadataSpecVersion/text()'', document)::text[])[1]::text as VARCHAR) as   package_metadata_spec_version    ,
			CAST((xpath(''/ECMFSpec/Package/Fields/ProductInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as   package_product    ,
			CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as   package_provider    ,
			CAST((xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as    package_provider_id   ,
			CAST((xpath(''/ECMFSpec/Package/Fields/Version/Major/text()'', document)::text[])[1]::text as VARCHAR) as    package_version_major   ,
			CAST((xpath(''/ECMFSpec/Package/Fields/Version/Minor/text()'', document)::text[])[1]::text as VARCHAR) as       package_version_minor,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as       title_asset_id,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/AssetName/text()'', document)::text[])[1]::text as VARCHAR) as     title_asset_name  ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Description/Text/text()'', document)::text[])[1]::text as VARCHAR) as  title_asset_description     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/AssetClass/text()'', document)::text[])[1]::text as VARCHAR) as     title_asset_class  ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="AONDWEB_AVAILABLE"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as  title_aondweb_available     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="AONTV_AVAILABLE"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as   title_aontv_available    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="ASSOCIATION_ID"]/Value/text()'', document)::text[])[1]::text as VARCHAR) as title_association_id      ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/BillingInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as       TITLE_BILLING_ID,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Categories/Category/Category/Text/text()'', document)::text[])[1]::text as VARCHAR) as TITLE_Category,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Caption/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_closed_captioning     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/Contract/Name/text()'', document)::text[])[1]::text as VARCHAR) as   title_contract_name    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CreationInfo/Place/Country/text()'', document)::text[])[1]::text as VARCHAR) as   title_Country_of_Origin    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Duration/DisplayDuration/text()'', document)::text[])[1]::text as VARCHAR) as  title_Display_Run_Time     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="EXT_ASSET_ID"]/Value/text()'', document)::text[])[1]::text as VARCHAR) as   title_EXT_ASSET_ID    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="EXT_title_ID"]/Value/text()'', document)::text[])[1]::text as VARCHAR) as   title_EXT_title_ID    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Episode/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as   title_Episode_ID    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Episode/Name/Value/text()'', document)::text[])[1]::text as VARCHAR) as   title_Episode_Name    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Genres/Genre[1]/Value/text()'', document)::text[])[1]::text as VARCHAR) as   title_Genre    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="IAP_AVAILABLE"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as  title_IAP_AVAILABLE     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'', document)::text[])[1]::text as VARCHAR) as   title_Licensing_Window_End    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'', document)::text[])[1]::text as VARCHAR) as  title_Licensing_Window_Start     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/MaxViewingLimit/text()'', document)::text[])[1]::text as VARCHAR) as  title_Maximum_Viewing_Length     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/ProductInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as  title_Product     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/PropagationPriority/text()'', document)::text[])[1]::text as VARCHAR) as  title_Propagation_Priority     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/ProviderInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as  title_Provider     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/ProviderInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as title_Provider_ID      ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/ProviderQAContact/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Provider_QA_Contact     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="QC_COMPLETE"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as  title_QC_COMPLETE     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="QC_REQUIRED"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as  title_QC_REQUIRED     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rating/RatingValues/RatingValue[1]/Value/text()'', document)::text[])[1]::text as VARCHAR) as title_Rating      ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Duration/Duration/text()'', document)::text[])[1]::text as VARCHAR) as   title_Run_Time    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/ShowType/text()'', document)::text[])[1]::text as VARCHAR) as  title_Show_Type     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CreationInfo/Studio/Name/text()'', document)::text[])[1]::text as VARCHAR) as title_Studio_Name      ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyPercent/@value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Studio_Royalty_Percent     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/BillingInfo/SuggestedPrice/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Suggested_Price     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Summary/DisplaySummary/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Summary_Long     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Summary/MediumSummary/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Summary_Medium     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Summary/ShortSummary/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Summary_Short     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="TRAILER_NUM"]/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_TRAILER_NUM     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/DisplayTitle/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Title     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value/text()'', document)::text[])[1]::text as VARCHAR) as   title_Title_Brief    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/SortTitle/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_Title_Sort_Name     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField[@name="VOD_CODE"]/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_VOD_CODE     ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/CreationInfo/PublicationDate/text()'', document)::text[])[1]::text as VARCHAR) as TITLE_YEAR    ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Sources/Source/Role/Nam/text()'', document)::text[])[1]::text as VARCHAR) as TITLE_ROLE_NAME ,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Sources/Source/CharacterName/text()'', document)::text[])[1]::text as VARCHAR) as TITLE_CHARACTER_NAME ,
			rownum as title_source_seqno,
			CAST((xpath(''/ECMFSpec/Package/Title/Fields/Sources/Source/Contact/DisplayName/text()'', document)::text[])[1]::text as VARCHAR) as TITLE_CONTACT_DISPNAME,
			rownum as Movie_SEQNO,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/AssetClass/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Asset_Class,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Asset_ID,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/AssetName/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_ASSET_NAME,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Video/BitRate/@value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Bit_Rate,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Content/Locator/Uri/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Content,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Content/Checksum/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Content_CheckSum,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Content/Size/length/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Content_Filesize,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Copyright/CopyProtection/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Copy_Protection,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/CreationInfo/CreateDate/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Creation_Date,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Description/Text/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_DESCRIPTION,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Encryption/Value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Encryption,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Video/HDContent/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_HDCONTENT,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/ProviderInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Provider,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/ProviderInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Provider_ID,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Video/ScreenFormat/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Screen_Format,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/SubTitleLanguage/@value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Subtitle_Languages,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Video/StreamFormat/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_STREAM_FORMAT,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Video/AudioInfos/AudioInfo/Value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Audio_Type ,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/DubbedLanguages/DubbedLanguage/@value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Dubbed_Languages ,
			CAST((xpath(''/ECMFSpec/Package/Movie/Fields/Languages/Language/@value/text()'', document)::text[])[1]::text as VARCHAR) as MOVIE_Languages ,
			rownum as POSTER_SEQNO,
			CAST((xpath(''/ECMFSpec/Package/Poster/Fields/Content/Checksum/text()'', document)::text[])[1]::text as VARCHAR) as POSTER_Content_Checksum,
			CAST((xpath(''/ECMFSpec/Package/Poster/Fields/Content/Size/length/text()'', document)::text[])[1]::text as VARCHAR) as POSTER_Content_Filesize,
			CAST((xpath(''/ECMFSpec/Package/Poster/Fields/CreationInfo/CreateDate/text()'', document)::text[])[1]::text as VARCHAR) as POSTER_Creation_Date,
			CAST((xpath(''/ECMFSpec/Package/Poster/Fields/Image/AspectRatio/text()'', document)::text[])[1]::text as VARCHAR) as POSTER_IMAGE_ASPECT_RATIO,
			rownum as PREVIEW_SEQNO,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Video/BitRate/@value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_BIT_RATE,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Content/Locator/Uri/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_CONTENT,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Content/Checksum/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Content_Checksum,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Content/Size/length/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Content_Filesize,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/CreationInfo/CreateDate/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_CREATION_DATE,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Video/HDContent/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_HDContent,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/ProviderInfo/Name/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Provider,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/ProviderInfo/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Provider_ID,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/CustomFields/CustomField[@name="QC_COMPLETE"]/BooleanValue/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_QC_COMPLETE,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Duration/Duration/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Run_Time,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Video/ScreenFormat/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Screen_Format,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/SubTitleLanguage/@value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_SUBTITLE_LANGUAGES,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Video/AudioInfos/AudioInfo/Value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Audio_Type,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/DubbedLanguages/DubbedLanguage/@value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Dubbed_Languages,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Languages/Language/@value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Languages,
			CAST((xpath(''/ECMFSpec/Package/Preview/Fields/Rating/RatingValues/RatingValue/Value/text()'', document)::text[])[1]::text as VARCHAR) as PREVIEW_Rating,
			rownum as ENCRYPTED_SEQNO,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Content/Locator/Uri/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Content,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Content/Checksum/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Content_Checksum,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Content/Size/length/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Content_Filesize,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/CreationInfo/CreateDate/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Creation_Date,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Asset_Encrypted,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Encryption/KeyBlock/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Encryption_KeyBlock,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Encryption/SystemInfo/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Encryption_Sysinfo,
			CAST((xpath(''/ECMFSpec/Package/Encrypted/Fields/Encryption/Type/text()'', document)::text[])[1]::text as VARCHAR) as ENCRYPTED_Encryption_Type
			from MDM_METADATA_site )
			SELECT
				T.ID_ AS TITLEID,
				T.ORIGINALTITLE_ID AS MASTER_TITLE_ID,
				ts.description as TITLE_STATUS,
				m.document_id,
				provider_id,
				provider_name,
				asset_name,
				tmp_mdm.asset_id,
				license_start_date,
				license_end_date,
				title_brief,
				package_asset_class,
				package_asset_id,
				package_asset_name,
				package_creation_date,
				package_description,
				package_metadata_spec_version,
				package_product,
				package_provider,
				package_provider_id,
				package_version_major,
				package_version_minor,
				title_asset_id,
				title_asset_name,
				title_asset_description,
				title_asset_class,
				title_aondweb_available,
				title_aontv_available,
				title_association_id,
				TITLE_BILLING_ID,
				TITLE_Category,
				title_closed_captioning,
				title_contract_name,
				title_Country_of_Origin,
				title_Display_Run_Time,
				title_EXT_ASSET_ID,
				title_EXT_title_ID,
				title_Episode_ID,
				title_Episode_Name,
				title_Genre,
				title_IAP_AVAILABLE,
				title_Licensing_Window_End,
				title_Licensing_Window_Start,
				title_Maximum_Viewing_Length,
				title_Product,
				title_Propagation_Priority,
				title_Provider,
				title_Provider_ID,
				title_Provider_QA_Contact,
				title_QC_COMPLETE,
				title_QC_REQUIRED,
				title_Rating,
				title_Run_Time,
				title_Show_Type,
				title_Studio_Name,
				title_Studio_Royalty_Percent,
				title_Suggested_Price,
				title_Summary_Long,
				title_Summary_Medium,
				title_Summary_Short,
				title_TRAILER_NUM,
				title_Title,
				title_Title_Brief,
				title_Title_Sort_Name,
				TITLE_VOD_CODE,
				TITLE_YEAR,
				TITLE_SOURCE_SEQNO,
				TITLE_ROLE_NAME,
				TITLE_CHARACTER_NAME,
				TITLE_CONTACT_DISPNAME,
				MOVIE_SEQNO ,
				MOVIE_Asset_Class,
				MOVIE_Asset_ID,
				MOVIE_Asset_Name,
				MOVIE_Audio_Type,
				MOVIE_Bit_Rate,
				MOVIE_Content,
				MOVIE_Content_CheckSum,
				MOVIE_Content_Filesize,
				MOVIE_Copy_Protection,
				MOVIE_Creation_Date,
				MOVIE_Description,
				MOVIE_Dubbed_Languages,
				MOVIE_Encryption,
				MOVIE_HDContent,
				MOVIE_Languages,
				MOVIE_Provider,
				MOVIE_Provider_ID,
				MOVIE_Screen_Format,
				MOVIE_SUBTITLE_LANGUAGES,
				MOVIE_STREAM_FORMAT,
				POSTER_SEQNO ,
				POSTER_Content_Checksum,
				POSTER_Content_Filesize,
				POSTER_CREATION_DATE,
				POSTER_IMAGE_ASPECT_RATIO,
				PREVIEW_SEQNO,
				PREVIEW_Audio_Type,
				PREVIEW_Bit_Rate,
				PREVIEW_Content,
				PREVIEW_Content_Checksum,
				PREVIEW_Content_Filesize,
				PREVIEW_Creation_Date,
				PREVIEW_Dubbed_Languages,
				PREVIEW_HDContent,
				PREVIEW_Languages,
				PREVIEW_Provider,
				PREVIEW_Provider_ID,
				PREVIEW_QC_COMPLETE,
				PREVIEW_Rating,
				PREVIEW_Run_Time,
				PREVIEW_SCREEN_FORMAT,
				PREVIEW_SUBTITLE_LANGUAGES,
				ENCRYPTED_SEQNO,
				ENCRYPTED_Content,
				ENCRYPTED_Content_Checksum,
				ENCRYPTED_Content_Filesize,
				ENCRYPTED_Creation_Date,
				ENCRYPTED_Asset_Encrypted,
				ENCRYPTED_Encryption_KeyBlock,
				ENCRYPTED_Encryption_Sysinfo,
				ENCRYPTED_Encryption_Type
			FROM  MDM_METADATA_site m
			join tmp_mdm on tmp_mdm.document_id = m.document_id
			JOIN WFS.PMM_TITLE T ON ( t.mdmdocid= m.document_id )
			JOIN WFS.PMM_TITLESTATUS TS ON (T.TITLESTATUSID = TS.ID_)';  

         when 'vsql_vw_rep_templ_used_by_ttl' then
        -- Suresh Neravati adde a view for Templates used by Titles report on 03/11/2013.
        -- Sam modified the views from Oracle to EDB supported format
        vsql:= 'CREATE OR REPLACE VIEW vw_rep_templates_used_by_title AS 
                SELECT (xpath(''/ECMFSpec/@documentId''::text, mdm.document)::text[])[1]::numeric AS document_id,
                       (xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id/text()''::text, mdm.document)::text[])[1]::character varying AS provider_id,
                       (xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Name/text()''::text, mdm.document)::text[])[1]::character varying AS provider_name,
                       (xpath(''/ECMFSpec/Package/Title/Fields/Title/DisplayTitle/Value/text()''::text, mdm.document)::text[])[1]::character varying AS title_brief,
                       (xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()''::text, mdm.document)::text[])[1]::character varying AS asset_id,
                       jp.templateid AS template_id,
                       lpad('' ''::text, 2 * ((CASE WHEN jp.parentprocessid IS NULL THEN 1 ELSE 2 END) - 1)) || 
                       jd.name::text AS template_name,
                       t.id_ AS title_id,
                       jp.processid AS wo_id,
                       tt.startdate AS wo_start_time,
                       tt.enddate AS wo_end_time,
                       CASE WHEN jp.parentprocessid IS NOT NULL THEN 1 ELSE 0 END AS wo_level,
                       CASE WHEN jp.parentprocessid IS NOT NULL THEN 1 ELSE 0 END AS wo_count,
                       ((to_char(round(date_part(''day''::text, tt.enddate - tt.startdate)), ''0009''::text) || 
                         to_char(round(date_part(''hour''::text, tt.enddate - tt.startdate)), ''09''::text)) || 
                         to_char(round(date_part(''minute''::text, tt.enddate - tt.startdate)), ''09''::text)) || 
                         to_char(round(date_part(''second''::text, tt.enddate - tt.startdate)), ''09''::text) AS wo_duration,
                       CASE WHEN jp.parentprocessid IS NOT NULL THEN round(date_part(''second''::text, tt.enddate - tt.startdate) + 
                                                                           date_part(''minute''::text, tt.enddate - tt.startdate) * 60::double precision + 
                                                                           date_part(''hour''::text, tt.enddate - tt.startdate) * 3600::double precision + 
                                                                           date_part(''day''::text, tt.enddate - tt.startdate) * 86400::double precision )
                       ELSE 0::double precision
                       END AS wo_duration_seconds,
                       ps.processstatusid AS wo_process_status_id,
                       CASE WHEN ps.name::text = ''STOPPED''::text THEN ''COMPLETED''::character varying ELSE ps.name END AS wo_process_status
                   FROM wfs.ttv_token tt
                   JOIN wfs.ttv_processinstance jp ON jp.processid= tt.processid
                   JOIN wfs.ttv_processstatus ps ON tt.operationalstatus = ps.processstatusid
                   JOIN wfs.pmm_title t ON t.id_::text = (tt.vars->''titleId''->>''value'')
                   JOIN wfs.ttv_template jd ON jp.templateid = jd.id
                   JOIN wfs.mdm_metadata mdm ON t.mdmdocid = mdm.document_id
                  WHERE jp.isactive = 1 
                  ORDER BY (xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Name/text()''::text, mdm.document)::text[])[1]::character varying, 
                           (xpath(''/ECMFSpec/Package/Title/Fields/Title/DisplayTitle/Value/text()''::text, mdm.document)::text[])[1]::character varying, 
                           tt.startdate';


         when 'vsql_vw_rep_titls_prossby_tmpl' then
            vsql:= 'CREATE OR REPLACE VIEW vw_rep_titles_prossby_template AS
                     SELECT (xpath(''/ECMFSpec/@documentId''::text, mdm.document)::text[])[1]::numeric AS document_id,
                            (xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id/text()''::text, mdm.document)::text[])[1]::character varying AS provider_id,
                            (xpath(''/ECMFSpec/Package/Fields/ProviderInfo/Name/text()''::text, mdm.document)::text[])[1]::character varying AS provider_name,
                            (xpath(''/ECMFSpec/Package/Title/Fields/Title/DisplayTitle/Value/text()''::text, mdm.document)::text[])[1]::character varying AS title_brief,
                            (xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()''::text, mdm.document)::text[])[1]::character varying AS asset_id,
                            jp.templateid AS template_id,
                            jd.name AS template_name,
                            t.id_ AS title_id,
                            jp.processid AS wo_id,
                            tt.startdate AS wo_start_time,
                            tt.enddate AS wo_end_time,
                            1 AS wo_count,
                            ((to_char(round(date_part(''day''::text, tt.enddate - tt.startdate)), ''0009''::text) || 
                              to_char(round(date_part(''hour''::text, tt.enddate - tt.startdate)), ''09''::text)) || 
                              to_char(round(date_part(''minute''::text, tt.enddate - tt.startdate)), ''09''::text)) || 
                              to_char(round(date_part(''second''::text, tt.enddate - tt.startdate)), ''09''::text) AS wo_duration,
                            round(date_part(''second''::text, tt.enddate - tt.startdate) + 
                                  date_part(''minute''::text, tt.enddate - tt.startdate) * 60::double precision + 
                                  date_part(''hour''::text, tt.enddate - tt.startdate) * 3600::double precision + 
                                  date_part(''day''::text, tt.enddate - tt.startdate) * 86400::double precision ) AS wo_duration_seconds,
                            ps.processstatusid AS wo_process_status_id,
                            CASE WHEN ps.name::text = ''STOPPED''::text THEN ''COMPLETED''::character varying ELSE ps.name END AS wo_process_status        
                       FROM wfs.ttv_processinstance jp
                       JOIN wfs.ttv_template jd ON jp.templateid = jd.id
                       JOIN wfs.ttv_token tt ON jp.processid= tt.processid
                       JOIN wfs.ttv_processstatus ps ON tt.operationalstatus = ps.processstatusid
                       JOIN wfs.pmm_title t ON t.id_::text = (tt.vars->''titleId''->>''value'')
                       JOIN wfs.mdm_metadata mdm ON t.mdmdocid = mdm.document_id
                      WHERE jp.isactive = 1';
  

         when 'vsql_vdw_missingcontent' then
            vsql:= 'CREATE or replace VIEW '||vschema||'.vdw_MissingContent AS '||
              ' SELECT pp.PROVIDERID AS PROVIDER_ID, '|| ' pp.NAME AS PROVIDER_NAME, '||
              '        CAST((xpath(''/ECMFSpec/Package/Fields/AssetName/text()'', document)::text[])[1]::text as VARCHAR) as  asset_name , '||
              '        CAST((xpath(''/ECMFSpec/Package/Fields/Identifier/Id/text()'', document)::text[])[1]::text as VARCHAR) as  package_assetid , '||
              '        CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart/text()'', document)::text[])[1]::text as timestamp) as licensing_startdt , '||
              '        CAST((xpath(''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd/text()'', document)::text[])[1]::text as timestamp) as licensing_enddt , '|| 
              '        CAST((xpath(''/ECMFSpec/Package/Title/Fields/Title/DisplayTitle/Value/text()'', document)::text[])[1]::text as VARCHAR) as  title_brief '||
              '  FROM (SELECT id,  '||
              '               CAST((xpath(''/metadata/asset/@path'', xmldoc)::text[])[1]::text as VARCHAR) as path,  '||
              '                CAST((xpath(''/metadata/asset/@requiresFile'', xmldoc)::text[])[1]::text as VARCHAR) as requiresFile,  '||
              '                CAST((xpath(''/metadata/asset/@isHidden'', xmldoc)::text[])[1]::text as VARCHAR) as isHidden from (select id, XMLPARSE (DOCUMENT data) as xmldoc ' ||
              '          FROM '||vschema||'.PMM_CONTENT_CLASS ) ) XMLPCC, '||
              '        '||VSCHEMA||'.PMM_TITLE pt, '||
              '        '||vschema||'.mdm_metadata mm, '||
              '        '||vschema||'.pmm_partner pp '||
              ' WHERE XMLPCC.requiresFile=''true'' '||
              '   AND xmlpcc.isHidden is null '||
              '   AND xmlpcc.path!=''PACKAGE'' '||
              '   AND pt.CONTENT_CLASS_ID= xmlPCC.ID '||
              '   AND pp.id_ = pt.partner_id '||
              '   AND mm.document_id = pt.mdmdocid ' || 
              '   AND CAST((xpath(''/ECMFSpec''||replace(replace(initcap(xmlpcc.path), ''clip'',''Clip''),''segmentgroup'',''SegmentGroup'')||''/File/Fields/Locator/Description[Text="ORIGINAL"]''||''/text()'', document)::text[])[1]::text as VARCHAR) is null' || 
              '   AND CAST((xpath(''/ECMFSpec''||replace(replace(initcap(xmlpcc.path), ''clip'',''Clip''),''segmentgroup'',''SegmentGroup'')||''/text()'', document)::text[])[1]::text as VARCHAR) is not null';  

         when 'vsql_vdw_sites_dist_site_title' then
            vsql:= 'CREATE OR REPLACE VIEW '||vschema||'.VDW_SITES_DIST_SITE_TITLE AS
                  SELECT   sdst.titleid             as titleid, 
                           sdst.siteid              as dist_site_id, 
                           ss.name                  as dist_site_name,
                           sdst.status              as dist_site_status_id, 
                           sds.name                 as dist_site_status,
                           sdst.status_updated_time as dist_site_time,
                           ss.metadata_format       as dist_site_metadata_format,
                           ss.dist_template_name    as dist_template_name  
                    FROM '||vschema||'.sites_distsitetitle sdst 
                    JOIN '||vschema||'.sites_site ss on (sdst.siteid = ss.id_ ) and ss.active=1
                    JOIN '||vschema||'.sites_distribution_status sds on (sds.id_= sdst.status)';
    end case;
    return vsql;
EXCEPTION
    WHEN OTHERS THEN
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in createqueries function : '')';
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
       return '';
END;
$func_createqueries$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION CREATEQUERYVIEWS (vschema varchar, comp_name varchar, db_version varchar) RETURNS integer AS $func_createqueryviews$
DECLARE
    vsql                  varchar;
    wk_message            varchar:= '';
    tmp_result            smallint;
    errcnt                smallint;
    ischema               text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    -- Inserting into table 'SYSTEM_SETTINGS'
    vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values ('''||comp_name||''',''RELEASE'','''||db_version||''')';
    select CREATEOBJECT(vsql,'Unable to insert db version into SYSTEM_SETTINGS') INTO tmp_result;

    /*--------------------------------------------------------------------
                                CREATING TABLES
    --------------------------------------------------------------------*/
-- (1) VDW_WO_MASTER_CHILD
      SELECT createqueries(vschema,'vsql_vdw_wo_master_child') INTO vsql;
--      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_wo_master_child') INTO tmp_result;

-- (2) VDW_WO_NODE_LOG
      SELECT createqueries(vschema,'vsql_vdw_wo_node_log') INTO vsql;
      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_wo_node_log') INTO tmp_result;

-- (3) VDW_WO_VARIABLEINSTANCE
      SELECT createqueries(vschema,'vsql_vdw_wo_vi') INTO vsql;
      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_wo_vi') INTO tmp_result;

-- (4) VDW_TITLE_WO_DETAILS (no hierarchy)
      SELECT createqueries(vschema,'vsql_vdw_title_wo_details') INTO vsql;
      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_title_wo_details') INTO tmp_result;

-- (5) VDW_SITETITLE_WO_DETAILS (no hierarchy). SITE TITLES ONLY
      SELECT createqueries(vschema,'vsql_vdw_sitetitle_wo_details') INTO vsql;
      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_sitetitle_wo_details') INTO tmp_result;

-- (6) VDW_TITLE_WO_NODE_LOG_DETAILS (no hierarchy)
      SELECT createqueries(vschema,'vsql_vdw_title_wo_node_log_det') INTO vsql;
      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_title_wo_node_log_det') INTO tmp_result;

-- (7) VDW_SITETITLE_WO_NODE_LOG_DETAILS (no hierarchy). SITE TITLES ONLY
      SELECT createqueries(vschema,'vsql_vdw_stitl_wo_node_log_det') INTO vsql;
      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_stitl_wo_node_log_det') INTO tmp_result;

-- (8) VDW_TITLE_MASTER_CHILD (with hierarchy)
      SELECT createqueries(vschema,'vsql_vdw_title_master_child') INTO vsql;
--      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_title_master_child') INTO tmp_result;

-- (9) VDW_TITLE_METADATA (without hierarchy). MASTER TITLE ONLY
      SELECT createqueries(vschema,'vsql_vdw_title_metadata') INTO vsql;
--      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_title_metadata') INTO tmp_result;

-- (10) VDW_SITETITLE_METADATA (without hierarchy). SITE TITLES ONLY
      SELECT createqueries(vschema,'vsql_vdw_sitetitle_metadata') INTO vsql;
--      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_sitetitle_metadata') INTO tmp_result;

-- (11) VW_REP_TEMPL_USED_BY_TTL Report View (with hierarchy)
-- Suresh Neravati adde a view for Templates used by Titles report on 03/11/2013.
-- Sam modified the views from Oracle to EDB supported format
      SELECT createqueries(vschema,'vsql_vw_rep_templ_used_by_ttl') INTO vsql;
      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vw_rep_templ_used_by_ttl') INTO tmp_result;

-- (12) VW_REP_TITLES_PROSSBY_TEMPLATE Report View
      SELECT createqueries(vschema,'vsql_vw_rep_titls_prossby_tmpl') INTO vsql;
      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vw_rep_titls_prossby_tmpl') INTO tmp_result;

-- (13) vdw_MissingContent Report View
      SELECT createqueries(vschema,'vsql_vdw_missingcontent') INTO vsql;
--      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_missingcontent') INTO tmp_result;

-- (14) VDW_SITES_DIST_SITE_TITLE
      SELECT createqueries(vschema,'vsql_vdw_sites_dist_site_title') INTO vsql;
      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vdw_sites_dist_site_title') INTO tmp_result;

    execute 'select COUNT(*) from '||ischema||'.install_table where upper(install_message) like ''%ERROR%''' into errcnt;
    if errcnt = 0 then
       EXECUTE 'INSERT INTO '||ischema||'.install_table(install_message) values (''Installation of QUERYVIEWS database for version '||db_version||' completed SUCCESSFULLY'')';
    end if;
    return 0;

EXCEPTION
    WHEN OTHERS THEN
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in createqueryviews function : '')';
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
       return 1;
END;
$func_createqueryviews$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION CONVERTQUERYVIEWS (vschema varchar, comp_name varchar, db_version varchar) RETURNS integer AS $func_convertqueryviews$
DECLARE
  vsql       varchar;
  wk_message VARCHAR:= '';
  tmp_result smallint;
  wk_release varchar:='';    
  cms_comps  smallint;
  ischema    text;
BEGIN
  EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
  EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
  IF wk_release = '5.2.2' THEN	
    -- Changed the database scripts from EDB to Postgres
    select set_version(vschema, comp_name,'5.2.2','6.0.0') into tmp_result;
  END IF;

  EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
  IF (wk_release IN ('6.0.0','6.0.1','6.0.2','6.0.3','7.0.0')) THEN
      SELECT createqueries(vschema,'vsql_vw_rep_templ_used_by_ttl') INTO vsql;
      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vw_rep_templ_used_by_ttl') INTO tmp_result;
      SELECT createqueries(vschema,'vsql_vw_rep_titls_prossby_tmpl') INTO vsql;
      SELECT createobject(vsql,'unable to create view '||vschema||'.vsql_vw_rep_titls_prossby_tmpl') INTO tmp_result;
    select set_version(vschema, comp_name,'7.0.0',db_version) into tmp_result;
  END IF;

  EXECUTE 'INSERT INTO '||ischema||'.install_table (msgdate, install_message) values (now(),''Upgrading '||comp_name||' component to '||db_version||' completed SUCCESSFULLY'')';
  RETURN tmp_result;
EXCEPTION
    WHEN OTHERS THEN
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in convertrm function : '')';
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
      return 1;
END;
$func_convertqueryviews$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION INSTALL_QUERYVIEWS () RETURNS integer AS $func_installqueryviews$
DECLARE
    comp_name    varchar := 'QUERYVIEWS';
    tbl_count    smallint;
    vschema      varchar := 'wfs';
    func_results smallint;
    wk_release   varchar:='';    
    db_version   varchar := '7.0.1';
    ischema      text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    SELECT COUNT(*)
      INTO  tbl_count
      FROM  pg_views
     WHERE schemaname = vschema 
       AND upper(viewname) in ('VDW_WO_MASTER_CHILD', 'VDW_WO_NODE_LOG','VDW_WO_VARIABLEINSTANCE','VDW_TITLE_WO_DETAILS','VDW_SITETITLE_WO_DETAILS','VDW_TITLE_WO_NODE_LOG_DETAILS','VDW_STITLE_WO_NODE_LOG_DETAILS','VDW_TITLE_MASTER_CHILD','VDW_TITLE_METADATA','VDW_SITETITLE_METADATA','VW_REP_TEMPLATES_USED_BY_TITLE','VW_REP_TITLES_PROSSBY_TEMPLATE','VDW_MISSINGCONTENT','VDW_SITES_DIST_SITE_TITLE');

    IF tbl_count = 0 THEN
      SELECT CREATEQUERYVIEWS(vschema,comp_name,db_version) into func_results;
    ELSE
      EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
      IF wk_release < db_version  THEN
         SELECT CONVERTQUERYVIEWS(vschema,comp_name,db_version) into func_results;
      ELSIF wk_release = db_version  THEN
        EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''There are no database changes in '||comp_name||' component to upgrade'')';
      END IF;
    END IF;
    return func_results;
END;
$func_installqueryviews$ LANGUAGE plpgsql;

DO $$declare
   results    smallint;
begin
   select INSTALL_QUERYVIEWS() into results;
end$$;
