#!/bin/sh
#######################################################################
#        Script_name : installcms.sh                                  #
#        Purpose     : Install database objects for cms               #
#        Created by  : Suresh Neravati                                #
#        Created on  :  09/12/2016                                    #
#######################################################################
TIMESTAMP=`date +%Y%m%d_%H%M%S`
DB_SETTINGS="/opt/db/scripts/install/settings"

if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi

DB_INSTALL_LOG=cmsdbinstall
INSTALL_DIR=`pwd`
DB_NAME="${1:-ttv}"
DB_HOST="$2"
DB_TYPE="${DB_TYPE:-postgres}"
DB_HOST="${DB_HOST:-dbserver}"
sh ${INSTALL_DIR}/mastercms.sh "${INSTALL_DIR}" "$DB_NAME" "$DB_HOST" "$DB_TYPE" 2>&1 | tee "${INSTALL_DIR}/${DB_INSTALL_LOG}.log"

echo "*********************************************************"
if [ ! -f "${INSTALL_DIR}/${DB_INSTALL_LOG}.log" ]
then
     echo "CMS DB Install script probably failed! ${INSTALL_DIR}/${DB_INSTALL_LOG}.log file is not exists..!"
     echo "*********************************************************"
     exit 1
else

     echo "*********************************************************"
     if  grep -qi "FATAL\|ERROR\|ORA-\|SP2-\|Permission denied\|SQL-" "${INSTALL_DIR}/${DB_INSTALL_LOG}.log"
     then
	echo "Installcms DB script probably failed! Check ${INSTALL_DIR}/${DB_INSTALL_LOG}_${TIMESTAMP}.log file for any errors"
        echo "*********************************************************"
        /bin/mv "${INSTALL_DIR}/${DB_INSTALL_LOG}.log" "${INSTALL_DIR}/${DB_INSTALL_LOG}_${TIMESTAMP}.log"
	exit 1
     else
        /bin/mv "${INSTALL_DIR}/${DB_INSTALL_LOG}.log" "${INSTALL_DIR}/${DB_INSTALL_LOG}_${TIMESTAMP}.log"
	echo "Installcms DB SCRIPT SUCCEEDED!"
     fi
fi
     echo "*********************************************************"
exit 0