#!/bin/sh
##########################################################################
#        Script_name : installpostcms.sh                                #
#        Purpose     : creates postcms schema and database objects      #
#        Created by  : Suresh Neravati                                   #
#        Created on  : 10/13/2016                                        #
##########################################################################
TIMESTAMP=`date +%Y%m%d_%H%M%S`
DB_NAME=$1
HOST_NAME=$2
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
INSTALL_DIR=`pwd`
POSTCMS_LOGFILE="cms_post_dbinstall"
PGP="Wf\$1234"
DB_TYPE="${DB_TYPE:-postgres}"
PG_VER="${DB_VERSION:-9.5}"
PSQLHOME="/usr/pgsql-${PG_VER}/bin"
#DB_TYPE="postgres"
SSCHEMA="wfs"
DB_USER="wfs"
HOST_NAME="${HOST_NAME:-dbserver}"
if [ "X$1" = "X"  ]; then
     DB_NAME="ttv"
fi
if [ "X$2" = "X"  ]; then
     HOST_NAME="${HOST_NAME:-dbserver}"
fi
if [ "X${DB_TYPE}" = "Xazure" ]; then
     DB_USER="wfs@$AZURE_DB"
fi
PORT=${DB_PORT:-5432}
export PGPASSWORD=${PGP}
(
PRE_INST_CNT=$( ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "select count(*) from wfs.system_settings where component_name in ('PRECMS','WORKFLOW','CONTENT_MANAGEMENT','NEPTUNE','RULES','JOB_SCHEDULER','CATEGORY_MANAGEMENT','METADATA_ENHANCEMENT')"| sed 's/^ *//' )
if [ "${PRE_INST_CNT}" -eq "8"  ]; then
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -v "inst_schema=$SSCHEMA" -f ${INSTALL_DIR}/createqueryviews.sql
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -v "inst_schema=$SSCHEMA" -f ${INSTALL_DIR}/createpostcms.sql
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} <<EOF
grant select on wfs.ttv_template to wfsdw;
grant select on wfs.ttv_processdefinitiontype to wfsdw;
grant select on wfs.ttv_processinstance to wfsdw;
grant select on wfs.ttv_processpriority to wfsdw;
grant select on wfs.ttv_token to wfsdw;
grant select on wfs.ttv_monitoreddrivehistory to wfsdw;
grant select on wfs.ttv_monitoreddrivestatus to wfsdw;
grant select on wfs.ttv_monitoreddrive to wfsdw;
grant select on wfs.pmm_title_purge_history to wfsdw;
grant select on wfs.ttv_resource to wfsdw;
grant select on wfs.ttv_resourcetype to wfsdw;
grant select on wfs.jbpm_log to wfsdw;
grant select on wfs.ttv_resourcegroup to wfsdw;
grant select on wfs.ttv_accesslevel to wfsdw;
grant select on wfs.pmm_partner to wfsdw;
grant select on wfs.pmm_title to wfsdw;
grant select on wfs.mdm_metadata to wfsdw;
grant select on wfs.vdw_mdm_metadata_Fields to wfsdw;
grant select on wfs.vw_rep_templates_used_by_title to wfsdw;
grant select on wfs.vw_rep_titles_prossby_template to wfsdw;
EOF
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -c "select MSGDATE, INSTALL_MESSAGE from ${SSCHEMA}.install_table where INSTALL_MESSAGE like '%QUERYVIEWS%' or INSTALL_MESSAGE like '%POSTCMS%';"
else
   echo "ERROR: All CMS component scripts need to run first to create the database objects, exiting the script..."
   exit 1
fi
) 2>&1 | tee "${INSTALL_DIR}/${POSTCMS_LOGFILE}.log"
if  grep -qi "FATAL\|ERROR\|ORA-\|SP2-\|Permission denied\|SQL-" "${INSTALL_DIR}/${POSTCMS_LOGFILE}.log"
then
   /bin/mv "${INSTALL_DIR}/${POSTCMS_LOGFILE}.log" "${INSTALL_DIR}/${POSTCMS_LOGFILE}_${TIMESTAMP}.log"
   echo "*********************************************************"
   echo "Database postcms script probably failed! Check ${INSTALL_DIR}/${POSTCMS_LOGFILE}_${TIMESTAMP}.log file for any errors"
   echo "*********************************************************"
   exit 1
else
   /bin/mv "${INSTALL_DIR}/${POSTCMS_LOGFILE}.log" "${INSTALL_DIR}/${POSTCMS_LOGFILE}_${TIMESTAMP}.log"
   echo "*********************************************************"
   echo " Database postcms script completed successfully..."
   echo "*********************************************************"
fi

exit 0