#!/bin/sh
##########################################################################
#        Script_name : mastercms.sh                                      #
#        Purpose     : creates database schema wfs and its objects       #
#        Created by  : Suresh Neravati                                   #
#        Created on  : 10/13/2016                                        #
##########################################################################
#INSTALL_DIR=`pwd`
INSTALL_DIR="$1"
DB_NAME=$2
HOST_NAME=$3
DB_TYPE=$4
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
DB_TYPE="${DB_TYPE:-postgres}"
PGP="Wf\$1234"
DB_VER=${DB_VERSION:-9.5}
PSQLHOME="/usr/pgsql-${DB_VER}/bin"
SSCHEMA="wfs"
PGPD="${DB_ADMIN_PW:-n2bbsys}"
AZURE_DB="${AZURE_DB:-edb1}"
DB_USER="wfs"

if [ "X$2" = "X"  ]; then
     DB_NAME="ttv"
fi
if [ "X$3" = "X"  ]; then
     HOST_NAME="${HOST_NAME:-dbserver}"
fi

SUDB="postgres"
SUSER="postgres"
SUSERTOGRANT="postgres"
if [ "X${DB_TYPE}" = "Xedb" ]; then
     SUDB="edb"
     SUSER="edb"
     SUSERTOGRANT="edb"
elif [ "X${DB_TYPE}" = "Xazure" ]; then
     SUSER="postgres@$AZURE_DB"
     DB_USER="wfs@$AZURE_DB"
fi
PORT=${DB_PORT:-5432}
export PGPASSWORD=${PGPD}
dbrpms=( pg-installcms pg-workflow pg-content pg-neptune pg-rules pg-jobs pg-catmgmt pg-me pg-contractmgmt )
dbscripts=( createprecms.sql createworkflow.sql createcontent.sql createneptune.sql createrules.sql createjobs.sql createcatmgmt.sql createme.sql createcm.sql )
for (( i=0 ; i<${#dbscripts[@]} ; i++ ))
do
   dbscript=${dbscripts[$i]}
   dbrpm=${dbrpms[$i]}
   if [ ! -f ${INSTALL_DIR}/$dbscript ]; then
      echo -e "\nError: Database script ${INSTALL_DIR}/$dbscript is missing, since database rpm $dbrpm in not installed on this server.\nExiting the database installation."
      exit 1
   fi
done
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${SUDB} -U ${SUSER} -q -t -c "SELECT count(*) FROM pg_roles WHERE rolname='wfs';"| sed 's/^ *//'` -eq 0 ]]; then
   echo -e "\nCreating User wfs....\n"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${SUDB} -U ${SUSER} -q -t -c "CREATE ROLE wfs;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${SUDB} -U ${SUSER} -q -t -c "ALTER USER wfs PASSWORD 'Wf\$1234';"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${SUDB} -U ${SUSER} -q -t -c "ALTER USER wfs with login;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${SUDB} -U ${SUSER} -q -t -c "GRANT wfs TO ${SUSERTOGRANT};"
fi
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${SUDB} -U ${SUSER} -q -t -c "select count(*) from pg_database where datname = '${DB_NAME}';"| sed 's/^ *//'` -eq 0 ]]; then
   echo -e "\nCreating database ttv"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${SUDB} -U ${SUSER} -q -t -c "CREATE DATABASE "${DB_NAME}";"
fi
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "select count(*) from information_schema.schemata where schema_name='wfs';"| sed 's/^ *//'` -eq 0 ]]; then
   echo -e "\nCreating schema wfs"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${DB_NAME} -U ${SUSER} -q -t -c "CREATE SCHEMA wfs AUTHORIZATION wfs;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${DB_NAME} -U ${SUSER} -q -t -c "GRANT create ON DATABASE "${DB_NAME}" TO wfs;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${DB_NAME} -U ${SUSER} -q -t -c "GRANT all on schema ${SSCHEMA} to wfs;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${DB_NAME} -U ${SUSER} -q -t -c "GRANT SELECT ON PG_TABLES, PG_VIEWS,  PG_ATTRIBUTE, PG_INDEXES, PG_CONSTRAINT TO wfs;"

   echo -e "\n******* wfs schema created with permissions successfully *******\n"
fi
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "select count(*) from information_schema.schemata where schema_name='wfs';"| sed 's/^ *//'` -eq 0 ]]; then
   echo "wfs schema not exists, exiting the script....."
   exit 1
fi

export PGPASSWORD=${PGP}
dbscripts=( createprecms.sql createcontent.sql createneptune.sql createrules.sql createjobs.sql createcatmgmt.sql createme.sql createcm.sql )
var=1
for dbscript in ${dbscripts[@]}
do
  db_script=$( echo ${dbscript} | cut -f1 -d"." | sed 's/^create*//' )
  echo -e "\n${var}) Installing $db_script script, please wait....!!!!\n-----------------------------------------------------------------\n"
  ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${DB_NAME} -U ${DB_USER} -v "inst_schema=$SSCHEMA" -f ${INSTALL_DIR}/$dbscript
  var=$(expr $var + 1)
  if  grep -qi "FATAL\|ERROR\|ORA-\|SP2-\|Permission denied\|SQL-" "${INSTALL_DIR}/cmsdbinstall.log"
  then
    echo "$db_script Database script probably failed! Check ${INSTALL_DIR}/cmsdbinstall.log file for any errors"
    echo "*********************************************************"
    exit 1
  else
    echo "$db_script Database script completed successfully..."
  fi
done

crontab -l > ${INSTALL_DIR}/old_crontab
grep -q "^.*purge_cms_data\.sh.*" ${INSTALL_DIR}/old_crontab
if [ $? -ne 0 ]; then
   echo "0 0 * * * /opt/db/scripts/cms/purge_cms_data.sh 99999 10 100 180 >> /opt/db/scripts/cms/purge_cms.log" >> ${INSTALL_DIR}/old_crontab
fi
crontab ${INSTALL_DIR}/old_crontab

${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT}  -d ${DB_NAME} -U ${DB_USER} -q -c "SELECT msgdate, install_message FROM $SSCHEMA.install_table ORDER BY msgdate;"

exit 0