/*
-- created sequence from standard function for the following two triggers
--     CREATE OR REPLACE TRIGGER TRG_TTV_SELECTOR_SEQ removed, this functionality can be achived from default value.
--     CREATE OR REPLACE TRIGGER TRG_TTV_SELECTOR_UPD removed, and used the standard function to create trigger.
-- Removed procedure CREATE OR REPLACE PROCEDURE '||vschema||'.SP_REINITIALIZESEQUENCE which is not in use.
-- RAW datatype found in JBPM_BYTEBLOCK table 
-- changed # symbol to underscore in foreign key constraint names
*/
/*
================================================================================
Schema Name:    createworkflow.sql
Script purpose: Create the workflow database objects like
                tables, views, sequences and constraints etc.

Created by:     Suresh Neravati 09/26/2016

Modifications:
SwVer   DbVer     ModifiedBy      ModifiedDate    Details
-----   -----     -------------   ------------   -------
6.0     6.0.0     Suresh Neravati 09/26/2016     Converted the databse scripts from EDB to Postgres format.
6.0     6.0.1     Evan Huang      10/24/2016     Requested to remove Cluster resourcetype from workflow ttv tables.
6.0     6.0.2     Andrew          11/08/2016     Added new column createid on jbpm_processinstance table.
6.0     6.0.3     BO              12/21/2016     Added two new tables(ttv_template,ttv_selector_key) for workflow Denormalize.
6.0     6.0.4     BO              04/20/2017     Added three new tables (ttv_token, ttv_processinstance, and ttv_taskinstance)for workflow Denormalization.
6.0     6.0.5     BO              04/27/2017     Added ttv_processinstance, and ttv_taskinstance table constraints.
6.0     6.0.6     Bo              04/28/2017     Added a new column createid on ttv_processinstance table and an index on that column.
6.0     6.0.7     Suresh Neravati 08/25/2017     Deleted the foreign key constraints on denormalized ttv tables for Purge script performance.
6.0     6.0.8     Bo              09/15/2017     Added composite key index on ttv template table with Name and version number columns.
=======================================================================================================
-- on TTV_SELECTOR table default values current_data added to createdate and updatedate.
*/
PREPARE get_inst_schema AS SELECT :'inst_schema'::text;

CREATE OR REPLACE FUNCTION CREATEWF (vschema varchar, comp_name varchar, db_version varchar) RETURNS integer AS $func_createwf$
DECLARE
    vsql                  varchar;
    wk_message            varchar:= '';
    tmp_result            smallint;
    errcnt                smallint;
    ischema               text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    -- Inserting into table 'SYSTEM_SETTINGS'
    vsql := 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (COMPONENT_NAME, SETTING_TYPE, SETTING_VALUE) values ('''||comp_name||''',''RELEASE'','''||db_version||''')';
    select CREATEOBJECT(vsql,'Unable to insert db version into SYSTEM_SETTINGS') INTO tmp_result;

    /*--------------------------------------------------------------------
                                CREATING TABLES
    --------------------------------------------------------------------*/

    -- creating table JBPM_ACTION
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_ACTION ( 
          ID_                   	numeric(19,0) NOT NULL,
          CLASS                 	CHAR(1) NOT NULL,
          NAME_                 	varchar(255) NULL,
          ISPROPAGATIONALLOWED_ 	numeric NULL,
          ACTIONEXPRESSION_     	varchar(255) NULL,
          ISASYNC_              	numeric NULL,
          REFERENCEDACTION_     	numeric(19,0) NULL,
          ACTIONDELEGATION_     	numeric(19,0) NULL,
          EVENT_                	numeric(19,0) NULL,
          PROCESSDEFINITION_    	numeric(19,0) NULL,
          TIMERNAME_            	varchar(255) NULL,
          DUEDATE_              	varchar(255) NULL,
          REPEAT_               	varchar(255) NULL,
          TRANSITIONNAME_       	varchar(255) NULL,
          TIMERACTION_          	numeric(19,0) NULL,
          EXPRESSION_           	varchar(4000) NULL,
          EVENTINDEX_           	numeric NULL,
          EXCEPTIONHANDLER_     	numeric(19,0) NULL,
          EXCEPTIONHANDLERINDEX_	numeric NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_ACTION PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_ACTION','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_ACTION') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_ACTION') INTO tmp_result;
      
    -- Creating index IDX_JBPMACTION_REFERENCEACTION
       vsql :=  'CREATE INDEX IDX_JBPMACTION_REFERENCEACTION ON '||vschema||'.JBPM_ACTION(REFERENCEDACTION_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPMACTION_REFERENCEACTION') INTO tmp_result ;      

       vsql := 'create index idx_jbpmaction_event on '||vschema||'.jbpm_action (event_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpmaction_event on '||vschema||'.jbpm_action (event_)') INTO tmp_result;

       vsql := 'create index idx_jbpmaction_exceptionhndlr on '||vschema||'.jbpm_action (exceptionhandler_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpmaction_exceptionhndlr on '||vschema||'.jbpm_action (exceptionhandler_)') INTO tmp_result;
      
    -- creating table JBPM_BYTEARRAY
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_BYTEARRAY ( 
          ID_            	numeric(19,0) NOT NULL,
          NAME_          	varchar(255) NULL,
          FILEDEFINITION_	numeric(19,0) NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_BYTEARRAY PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_BYTEARRAY','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_BYTEARRAY') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_BYTEARRAY') INTO tmp_result;
      
    -- creating table JBPM_BYTEBLOCK
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_BYTEBLOCK ( 
          PROCESSFILE_	numeric(19,0) NOT NULL,
          BYTES_      	bytea NULL,                 -- RAW(1024) datatype
          INDEX_      	numeric NOT NULL,
          CREATEDATE  	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE  	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_BYTEBLOCK PRIMARY KEY (PROCESSFILE_, INDEX_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_BYTEBLOCK','N') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_BYTEBLOCK') INTO tmp_result;

    -- creating table JBPM_DECISIONCONDITIONS
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_DECISIONCONDITIONS ( 
          DECISION_      	numeric(19,0) NOT NULL,
          TRANSITIONNAME_	varchar(255) NULL,
          EXPRESSION_    	varchar(255) NULL,
          INDEX_         	numeric NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_DECISIONCONDITIONS PRIMARY KEY (DECISION_, INDEX_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_DECISIONCONDITIONS','N') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_DECISIONCONDITIONS') INTO tmp_result;
      
    -- creating table JBPM_DELEGATION
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_DELEGATION ( 
          ID_               	numeric(19,0) NOT NULL,
          CLASSNAME_        	varchar(4000) NULL,
          CONFIGURATION_    	varchar(4000) NULL,
          CONFIGTYPE_       	varchar(255) NULL,
          PROCESSDEFINITION_	numeric(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_DELEGATION PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_DELEGATION','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_DELEGATION') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_DELEGATION') INTO tmp_result;

    -- creating table JBPM_EVENT
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_EVENT ( 
          ID_               	numeric(19,0) NOT NULL,
          EVENTTYPE_        	varchar(255) NULL,
          TYPE_             	CHAR(1) NULL,
          GRAPHELEMENT_     	numeric(19,0) NULL,
          PROCESSDEFINITION_	numeric(19,0) NULL,
          NODE_             	numeric(19,0) NULL,
          TRANSITION_       	numeric(19,0) NULL,
          TASK_             	numeric(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_EVENT PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_EVENT','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_EVENT') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_EVENT') INTO tmp_result;
      
   -- Create index IDX_JBPMEVENT_TRANSITION
       vsql :=  'CREATE INDEX IDX_JBPMEVENT_TRANSITION ON '||vschema||'.JBPM_EVENT(TRANSITION_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPMEVENT_TRANSITION on JBPM_EVENT table') INTO tmp_result;      

       vsql := 'create index idx_jbpm_event_task_node on '||vschema||'.jbpm_event (task_,node_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpm_event_task_node on '||vschema||'.jbpm_event (task_,node_)') INTO tmp_result;
      
    -- creating table JBPM_EXCEPTIONHANDLER
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_EXCEPTIONHANDLER ( 
          ID_                	numeric(19,0) NOT NULL,
          EXCEPTIONCLASSNAME_	varchar(4000) NULL,
          TYPE_              	CHAR(1) NULL,
          GRAPHELEMENT_      	numeric(19,0) NULL,
          PROCESSDEFINITION_ 	numeric(19,0) NULL,
          GRAPHELEMENTINDEX_ 	numeric NULL,
          NODE_              	numeric(19,0) NULL,
          TRANSITION_        	numeric(19,0) NULL,
          TASK_              	numeric(19,0) NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_EXCEPTIONHANDLER PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_EXCEPTIONHANDLER','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_EXCEPTIONHANDLER') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_EXCEPTIONHANDLER') INTO tmp_result;
      
    -- creating table JBPM_ID_GROUP
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_ID_GROUP ( 
          ID_       	numeric(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	varchar(255) NULL,
          TYPE_     	varchar(255) NULL,
          PARENT_   	numeric(19,0) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_ID_GROUP PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_ID_GROUP','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_ID_GROUP') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_ID_GROUP') INTO tmp_result;
      
    -- creating table JBPM_ID_MEMBERSHIP
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_ID_MEMBERSHIP ( 
          ID_       	numeric(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	varchar(255) NULL,
          ROLE_     	varchar(255) NULL,
          USER_     	numeric(19,0) NULL,
          GROUP_    	numeric(19,0) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_ID_MEMBERSHIP PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_ID_MEMBERSHIP','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_ID_MEMBERSHIP') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_ID_MEMBERSHIP') INTO tmp_result;

    -- creating table JBPM_ID_PERMISSIONS
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_ID_PERMISSIONS ( 
          ENTITY_   	numeric(19,0) NOT NULL,
          CLASS_    	varchar(255) NULL,
          NAME_     	varchar(255) NULL,
          ACTION_   	varchar(255) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL 
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_ID_PERMISSIONS','N') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_ID_PERMISSIONS') INTO tmp_result;
  
    -- creating table JBPM_ID_USER
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_ID_USER ( 
          ID_       	numeric(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	varchar(255) NULL,
          EMAIL_    	varchar(255) NULL,
          PASSWORD_ 	varchar(255) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_ID_USER PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_ID_USER','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_ID_USER') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_ID_USER') INTO tmp_result;

    -- creating table JBPM_MESSAGE
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_MESSAGE ( 
          ID_            	numeric(19,0) NOT NULL,
          CLASS_         	CHAR(1) NOT NULL,
          DESTINATION_   	varchar(255) NULL,
          EXCEPTION_     	varchar(255) NULL,
          ISSUSPENDED_   	numeric NULL,
          TOKEN_         	numeric(19,0) NULL,
          TEXT_          	varchar(255) NULL,
          ACTION_        	numeric(19,0) NULL,
          NODE_          	numeric(19,0) NULL,
          TRANSITIONNAME_	varchar(255) NULL,
          TASKINSTANCE_  	numeric(19,0) NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_MESSAGE PRIMARY KEY (ID_)
          )';
      SELECT CREATEOBJECT(vsql,'Unable to create table JBPM_MESSAGE') INTO tmp_result;


    -- creating table JBPM_MODULEDEFINITION
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_MODULEDEFINITION ( 
          ID_               	numeric(19,0) NOT NULL,
          CLASS_            	CHAR(1) NOT NULL,
          NAME_             	varchar(4000) NULL,
          PROCESSDEFINITION_	numeric(19,0) NULL,
          STARTTASK_        	numeric(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_MODULEDEFINITION PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_MODULEDEFINITION','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_MODULEDEFINITION') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_MODULEDEFINITION') INTO tmp_result;
      
    -- creating table JBPM_NODE
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_NODE ( 
          ID_                  	numeric(19,0) NOT NULL,
          CLASS_               	CHAR(1) NOT NULL,
          NAME_                	varchar(255) NULL,
          PROCESSDEFINITION_   	numeric(19,0) NULL,
          ISASYNC_             	numeric NULL,
          ACTION_              	numeric(19,0) NULL,
          SUPERSTATE_          	numeric(19,0) NULL,
          SUBPROCESSDEFINITION_	numeric(19,0) NULL,
          DECISIONEXPRESSION_  	varchar(255) NULL,
          DECISIONDELEGATION   	numeric(19,0) NULL,
          SIGNAL_              	numeric NULL,
          CREATETASKS_         	numeric NULL,
          ENDTASKS_            	numeric NULL,
          NODECOLLECTIONINDEX_ 	numeric NULL,
          RESOURCEGROUPID      	numeric NULL,
          DURATION             	varchar(500) NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          DURATIONDESCRIPTION  	varchar(500) NULL,
          CONSTRAINT PK_JBPM_NODE PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_NODE','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_NODE') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_NODE') INTO tmp_result;
    
    -- Creating Index IDX_JBPM_NODE_01
       vsql :=  'CREATE INDEX IDX_JBPM_NODE_01 ON '||vschema||'.JBPM_NODE(PROCESSDEFINITION_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_NODE_01') INTO tmp_result;

    -- creating table JBPM_POOLEDACTOR
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_POOLEDACTOR ( 
          ID_              	numeric(19,0) NOT NULL,
          ACTORID_         	varchar(255) NULL,
          SWIMLANEINSTANCE_	numeric(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_POOLEDACTOR PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_POOLEDACTOR','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_POOLEDACTOR') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_POOLEDACTOR') INTO tmp_result;

    -- Creating index IX_JBPM_POOLEDACTOR_1
       vsql :=  'CREATE INDEX IDX_PLDACTR_ACTID ON '||vschema||'.JBPM_POOLEDACTOR(ACTORID_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IX_JBPM_POOLEDACTOR_1') INTO tmp_result;

    -- creating table JBPM_PROCESSDEFINITION
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_PROCESSDEFINITION ( 
          ID_                    	numeric(19,0) NOT NULL,
          NAME_                  	varchar(255) NULL,
          VERSION_               	numeric NULL,
          ISTERMINATIONIMPLICIT_ 	numeric NULL,
          STARTSTATE_            	numeric(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          PROCESSDEFINITIONTYPEID	numeric DEFAULT (1) NOT NULL,
          CONSTRAINT PK_JBPM_PROCESSDEFINITION PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_PROCESSDEFINITION','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_PROCESSDEFINITION') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_PROCESSDEFINITION') INTO tmp_result;

    -- Creating index IDX_JBPM_PROCESSDEFINITION_01
       vsql :=  'CREATE INDEX IDX_JBPM_PROCESSDEFINITION_01 ON '||vschema||'.JBPM_PROCESSDEFINITION (NAME_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_PROCESSDEFINITION_01 on JBPM_PROCESSDEFINITION table') INTO tmp_result;

    -- Create index IDX_JBPM_PROCESSDEFINITION_02
       vsql :=  'CREATE INDEX IDX_JBPM_PROCESSDEFINITION_02 ON '||vschema||'.JBPM_PROCESSDEFINITION(PROCESSDEFINITIONTYPEID)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_PROCESSDEFINITION_02 on JPBM_PROCESSDEFINITION table') INTO tmp_result;

    -- creating table JBPM_RUNTIMEACTION
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_RUNTIMEACTION ( 
          ID_                  	numeric(19,0) NOT NULL,
          VERSION_             	numeric NOT NULL,
          EVENTTYPE_           	varchar(255) NULL,
          TYPE_                	CHAR(1) NULL,
          GRAPHELEMENT_        	numeric(19,0) NULL,
          PROCESSINSTANCE_     	numeric(19,0) NULL,
          ACTION_              	numeric(19,0) NULL,
          PROCESSINSTANCEINDEX_	numeric NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_RUNTIMEACTION PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_RUNTIMEACTION','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_RUNTIMEACTION') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_RUNTIMEACTION') INTO tmp_result;

    -- Creating index IDX_RUNTIMEACTION_01
       vsql :=  'CREATE INDEX IDX_RUNTIMEACTION_01 ON '||vschema||'.JBPM_RUNTIMEACTION(PROCESSINSTANCE_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_RUNTIMEACTION_01') INTO tmp_result;

    -- creating table JBPM_SWIMLANE
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_SWIMLANE ( 
          ID_                    	numeric(19,0) NOT NULL,
          NAME_                  	varchar(255) NULL,
          ACTORIDEXPRESSION_     	varchar(255) NULL,
          POOLEDACTORSEXPRESSION_	varchar(255) NULL,
          ASSIGNMENTDELEGATION_  	numeric(19,0) NULL,
          TASKMGMTDEFINITION_    	numeric(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_SWIMLANE PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_SWIMLANE','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_SWIMLANE') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_SWIMLANE') INTO tmp_result;

    -- creating table JBPM_SWIMLANEINSTANCE
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_SWIMLANEINSTANCE ( 
          ID_              	numeric(19,0) NOT NULL,
          NAME_            	varchar(255) NULL,
          ACTORID_         	varchar(255) NULL,
          SWIMLANE_        	numeric(19,0) NULL,
          TASKMGMTINSTANCE_	numeric(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_SWIMLANEINSTANCE PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_SWIMLANEINSTANCE','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_SWIMLANEINSTANCE') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_SWIMLANEINSTANCE') INTO tmp_result;

    -- Creating Index IDX_JBPM_SWIMLANEINSTANCE_01
       vsql :=  'CREATE INDEX IDX_JBPM_SWIMLANEINSTANCE_01 ON '||vschema||'.JBPM_SWIMLANEINSTANCE(TASKMGMTINSTANCE_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_SWIMLANEINSTANCE_01') INTO tmp_result;

    -- creating table JBPM_TASK
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_TASK ( 
          ID_                    	numeric(19,0) NOT NULL,
          NAME_                  	varchar(255) NULL,
          PROCESSDEFINITION_     	numeric(19,0) NULL,
          DESCRIPTION_           	varchar(4000) NULL,
          ISBLOCKING_            	numeric NULL,
          ISSIGNALLING_          	numeric NULL,
          DUEDATE_               	varchar(255) NULL,
          ACTORIDEXPRESSION_     	varchar(255) NULL,
          POOLEDACTORSEXPRESSION_	varchar(255) NULL,
          TASKMGMTDEFINITION_    	numeric(19,0) NULL,
          TASKNODE_              	numeric(19,0) NULL,
          STARTSTATE_            	numeric(19,0) NULL,
          ASSIGNMENTDELEGATION_  	numeric(19,0) NULL,
          SWIMLANE_              	numeric(19,0) NULL,
          TASKCONTROLLER_        	numeric(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_TASK PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_TASK','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_TASK') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_TASK') INTO tmp_result;

    -- Creating index IDX_JBPM_TASK_01
       vsql :=  'CREATE INDEX IDX_JBPM_TASK_01 ON '||vschema||'.JBPM_TASK(TASKNODE_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TASK_01') INTO tmp_result;

    -- Creating index IDX_JBPM_TASK_02
       vsql :=  'CREATE INDEX IDX_JBPM_TASK_02 ON '||vschema||'.JBPM_TASK(STARTSTATE_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TASK_02') INTO tmp_result;

    -- creating table JBPM_TASKACTORPOOL
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_TASKACTORPOOL ( 
          TASKINSTANCE_	numeric(19,0) NOT NULL,
          POOLEDACTOR_ 	numeric(19,0) NOT NULL,
          CREATEDATE   	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE   	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL 
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_TASKACTORPOOL','N') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_TASKACTORPOOL') INTO tmp_result;
      
    -- Creating Primary Key on JBPM_TASKACTORPOOL
       vsql :=  'ALTER TABLE '||vschema||'.JBPM_TASKACTORPOOL ADD CONSTRAINT PK_JBPM_TASKACTORPOOL PRIMARY KEY (TASKINSTANCE_, POOLEDACTOR_)';
      SELECT CREATEOBJECT(vsql,'Unable to create Primary Key for JBPM_TASKACTORPOOL') INTO tmp_result;

    -- creating table JBPM_TASKCONTROLLER
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_TASKCONTROLLER ( 
          ID_                      	numeric(19,0) NOT NULL,
          TASKCONTROLLERDELEGATION_	numeric(19,0) NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_TASKCONTROLLER PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_TASKCONTROLLER','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_TASKCONTROLLER') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_TASKCONTROLLER') INTO tmp_result;
      
    -- creating table JBPM_TIMER
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_TIMER ( 
          ID_              	numeric(19,0) NOT NULL,
          NAME_            	varchar(255) NULL,
          DUEDATE_         	TIMESTAMP(6) NULL,
          REPEAT_          	varchar(255) NULL,
          TRANSITIONNAME_  	varchar(255) NULL,
          EXCEPTION_       	varchar(4000) NULL,
          ISSUSPENDED_     	numeric NULL,
          ACTION_          	numeric(19,0) NULL,
          TOKEN_           	numeric(19,0) NULL,
          PROCESSINSTANCE_ 	numeric(19,0) NULL,
          TASKINSTANCE_    	numeric(19,0) NULL,
          GRAPHELEMENTTYPE_	varchar(255) NULL,
          GRAPHELEMENT_    	numeric(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_TIMER PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_TIMER','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_TIMER') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_TIMER') INTO tmp_result;

    -- creating table JBPM_TOKEN
    /* Partition: Master Table */
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_TOKEN ( 
          ID_                      	numeric(19,0) NOT NULL,
          VERSION_                 	numeric NOT NULL,
          NAME_                    	varchar(255) NULL,
          START_                   	TIMESTAMP(6) NULL,
          END_                     	TIMESTAMP(6) NULL,
          NODEENTER_               	TIMESTAMP(6) NULL,
          NEXTLOGINDEX_            	numeric NULL,
          ISABLETOREACTIVATEPARENT_	numeric NULL,
          ISTERMINATIONIMPLICIT_   	numeric NULL,
          ISSUSPENDED_             	numeric NULL,
          NODE_                    	numeric(19,0) NULL,
          PROCESSINSTANCE_         	numeric(19,0) NULL,
          PARENT_                  	numeric(19,0) NULL,
          SUBPROCESSINSTANCE_      	numeric(19,0) NULL,
          TOKENTYPEID              	numeric NOT NULL,
          OPERATIONALSTATUS      	  numeric(19,0) NULL,
          ADMINISTRATIVESTATUS   	  numeric(19,0) NULL,
          RETRYCOUNT                numeric DEFAULT 0 NOT NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_TOKEN PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_TOKEN','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_TOKEN') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_TOKEN') INTO tmp_result;

    -- Creating Index IDX_JBPM_TOKEN_01
       vsql :=  'CREATE INDEX IDX_JBPM_TOKEN_01 ON '||vschema||'.JBPM_TOKEN(PARENT_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TOKEN_01') INTO tmp_result;

    -- Creating Index IDX_JBPM_TOKEN_02
       vsql :=  'CREATE INDEX IDX_JBPM_TOKEN_02 ON '||vschema||'.JBPM_TOKEN(NODE_)';
      SELECT CREATEOBJECT(VSQL,'Unable to create index IDX_JBPM_TOKEN_02') INTO tmp_result;

       vsql := 'CREATE INDEX idx_jbpm_token_pi ON '||vschema||'.jbpm_token (processinstance_)';
      SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX idx_jbpm_token_pi ON '||vschema||'.jbpm_token') INTO tmp_result;

    -- creating table JBPM_PROCESSINSTANCE
    /* Partition: Child Table 1*/
    vsql :=  'CREATE TABLE '||vschema||'.JBPM_PROCESSINSTANCE ( 
          ID_                          	numeric(19,0) NOT NULL,
          VERSION_                     	numeric NOT NULL,
          START_                       	TIMESTAMP(6) NULL,
          END_                         	TIMESTAMP(6) NULL,
          ISSUSPENDED_                 	numeric NULL,
          PROCESSDEFINITION_           	numeric(19,0) NULL,
          ROOTTOKEN_                   	numeric(19,0) NULL,
          SUPERPROCESSTOKEN_           	numeric(19,0) NULL,
          ADMINISTRATIVEPROCESSSTATUSID	numeric NOT NULL,
          OPERATIONALPROCESSSTATUSID   	numeric NOT NULL,
          PROCESSINSTANCETYPEID        	numeric NOT NULL,
          CREATEDATE                   	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE                   	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          PROCESSPRIORITYID            	numeric NULL,
          ISACTIVE                     	numeric(1,0) DEFAULT (1) NOT NULL,
          CREATEID                      VARCHAR(100) NULL,
          CONSTRAINT PK_JBPM_PROCESSINSTANCE PRIMARY KEY (ID_),
          CONSTRAINT JBPM_PINSTANCE_JBPM_TOKEN2  FOREIGN KEY (ROOTTOKEN_) REFERENCES '||vschema||'.JBPM_TOKEN (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_PROCESSINSTANCE','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_PROCESSINSTANCE',3) INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_PROCESSINSTANCE') INTO tmp_result;
      --CREATESEQ('JBPM_PROCESSINSTANCE',3,vcache=>1);
    
    -- Creating index IDX_JBPM_PROCESSINSTANCE_01
       vsql :=  'CREATE INDEX IDX_JBPM_PROCESSINSTANCE_01 ON '||vschema||'.JBPM_PROCESSINSTANCE(PROCESSDEFINITION_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_PROCESSINSTANCE_01') INTO tmp_result;
      
    -- Creating index  IDX_PI_OPERATIONALSTATUSID
       vsql :=  'CREATE INDEX IDX_PI_OPERATIONALSTATUSID ON '||vschema||'.JBPM_PROCESSINSTANCE(OPERATIONALPROCESSSTATUSID)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_PI_OPERATIONALSTATUSID') INTO tmp_result;

    -- creating table JBPM_VARIABLEINSTANCE
    /* Partition: Child Table 2*/
    vsql :=  'CREATE TABLE '||vschema||'.JBPM_VARIABLEINSTANCE ( 
          ID_              	numeric(19,0) NOT NULL,
          CLASS_           	CHAR(1) NOT NULL,
          NAME_            	varchar(255) NULL,
          CONVERTER_       	CHAR(1) NULL,
          TOKEN_           	numeric(19,0) NULL,
          TOKENVARIABLEMAP_	numeric(19,0) NULL,
          PROCESSINSTANCE_ 	numeric(19,0) NULL,
          BYTEARRAYVALUE_  	numeric(19,0) NULL,
          DATEVALUE_       	TIMESTAMP(6) NULL,
          DOUBLEVALUE_     	FLOAT NULL,
          LONGIDCLASS_     	varchar(255) NULL,
          LONGVALUE_       	numeric(19,0) NULL,
          STRINGIDCLASS_   	varchar(255) NULL,
          STRINGVALUE_     	varchar(4000) NULL,
          TASKINSTANCE_    	numeric(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_VARIABLEINSTANCE PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_VARIABLEINSTANCE','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_VARIABLEINSTANCE',1,100) INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_VARIABLEINSTANCE') INTO tmp_result;
      --CREATESEQ('JBPM_VARIABLEINSTANCE',vcache=>100);

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_WOID on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX IDX_JBPM_VARIABLEINSTANCE_WOID ON '||vschema||'.JBPM_VARIABLEINSTANCE (PROCESSINSTANCE_)';
      SELECT CREATEOBJECT(vsql,'Unable to index IDX_JBPM_VARIABLEINSTANCE_WOID on JBPM_VARIABLEINSTANCE') INTO tmp_result;

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_02 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX IDX_JBPM_VARIABLEINSTANCE_02 ON '||vschema||'.JBPM_VARIABLEINSTANCE (PROCESSINSTANCE_, NAME_, STRINGVALUE_, TOKENVARIABLEMAP_, CLASS_)';
      SELECT CREATEOBJECT(vsql,'Unable to index IDX_JBPM_VARIABLEINSTANCE_02 on JBPM_VARIABLEINSTANCE') INTO tmp_result;

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_04 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX IDX_JBPM_VARIABLEINSTANCE_04 ON '||vschema||'.JBPM_VARIABLEINSTANCE(TOKENVARIABLEMAP_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_VARIABLEINSTANCE_04 on JBPM_VARIABLEINSTANCE') INTO tmp_result;

      vsql := 'CREATE INDEX idx_jbpm_vinstance_longval ON '||vschema||'.JBPM_VARIABLEINSTANCE(LONGVALUE_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index idx_jbpm_vinstance_longval') INTO tmp_result;

      -- On 09-24-2014 Suresh Neravati added two new indexes on JBPM_VARIABLEINSTANCE table and brought back the longval index.
      vsql :=  'CREATE INDEX IDX_JBPM_VINSTANCE_DBLVAL ON '||vschema||'.JBPM_VARIABLEINSTANCE (DOUBLEVALUE_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_VINSTANCE_DBLVAL ON WFS.JBPM_VARIABLEINSTANCE') INTO tmp_result;

      vsql :=  'CREATE INDEX IDX_JBPM_VINSTANCE_NAME ON '||vschema||'.JBPM_VARIABLEINSTANCE(NAME_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_VINSTANCE_NAME ON WFS.JBPM_VARIABLEINSTANCE') INTO tmp_result;

      vsql :=  'alter table '||vschema||'.jbpm_variableinstance set (autovacuum_vacuum_scale_factor = 0.01, autovacuum_analyze_scale_factor = 0.005, fillfactor = 70)';
      SELECT CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.jbpm_variableinstance set autovacuum_vacuum_scale_factor, autovacuum_analyze_scale_factor, fillfactor') INTO tmp_result;


    -- creating table JBPM_MODULEINSTANCE
    /* Partition: Child Table 3*/    
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_MODULEINSTANCE ( 
          ID_                	numeric(19,0) NOT NULL,
          CLASS_             	CHAR(1) NOT NULL,
          PROCESSINSTANCE_   	numeric(19,0) NULL,
          TASKMGMTDEFINITION_	numeric(19,0) NULL,
          NAME_              	varchar(255) NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_MODULEINSTANCE PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_MODULEINSTANCE','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_MODULEINSTANCE',1,100) INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_MODULEINSTANCE') INTO tmp_result;
      --CREATESEQ('JBPM_MODULEINSTANCE',vcache=>100);

    -- Creating index IDX_JBPM_MODULEINSTANCE_01
       vsql :=  'CREATE INDEX IDX_JBPM_MODULEINSTANCE_01 ON '||vschema||'.JBPM_MODULEINSTANCE(PROCESSINSTANCE_)';
      SELECT CREATEOBJECT(VSQL,'Unable to create index IDX_JBPM_MODULEINSTANCE_01') INTO tmp_result;

    -- creating table JBPM_TOKENVARIABLEMAP
    /* Partition: Child Table 4*/   
    vsql :=  'CREATE TABLE '||vschema||'.JBPM_TOKENVARIABLEMAP ( 
          ID_             	numeric(19,0) NOT NULL,
          TOKEN_          	numeric(19,0) NULL,
          CONTEXTINSTANCE_	numeric(19,0) NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_TOKENVARIABLEMAP PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_TOKENVARIABLEMAP','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_TOKENVARIABLEMAP',1,100) INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_TOKENVARIABLEMAP') INTO tmp_result;
      --CREATESEQ('JBPM_TOKENVARIABLEMAP',vcache=>100);
      
    -- Creating index IDX_JBPM_TOKENVARIABLEMAP_01
       vsql :=  'CREATE INDEX IDX_JBPM_TOKENVARIABLEMAP_01 ON '||vschema||'.JBPM_TOKENVARIABLEMAP(CONTEXTINSTANCE_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TOKENVARIABLEMAP_01') INTO tmp_result;

    -- creating table JBPM_LOG
    /* Partition: Child Table 5*/       
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_LOG ( 
          ID_                   	numeric(19,0) NOT NULL,
          CLASS_                	CHAR(1) NOT NULL,
          INDEX_                	numeric NULL,
          DATE_                 	TIMESTAMP(6) NULL,
          TOKEN_                	numeric(19,0) NULL,
          PARENT_               	numeric(19,0) NULL,
          MESSAGE_              	varchar(4000) NULL,
          EXCEPTION_            	varchar(4000) NULL,
          ACTION_               	numeric(19,0) NULL,
          NODE_                 	numeric(19,0) NULL,
          ENTER_                	TIMESTAMP(6) NULL,
          LEAVE_                	TIMESTAMP(6) NULL,
          DURATION_             	numeric(19,0) NULL,
          TRANSITION_           	numeric(19,0) NULL,
          CHILD_                	numeric(19,0) NULL,
          SOURCENODE_           	numeric(19,0) NULL,
          DESTINATIONNODE_      	numeric(19,0) NULL,
          VARIABLEINSTANCE_     	numeric(19,0) NULL,
          OLDBYTEARRAY_         	numeric(19,0) NULL,
          NEWBYTEARRAY_         	numeric(19,0) NULL,
          OLDDATEVALUE_         	TIMESTAMP(6) NULL,
          NEWDATEVALUE_         	TIMESTAMP(6) NULL,
          OLDDOUBLEVALUE_       	FLOAT NULL,
          NEWDOUBLEVALUE_       	FLOAT NULL,
          OLDLONGIDCLASS_       	varchar(255) NULL,
          OLDLONGIDVALUE_       	numeric(19,0) NULL,
          NEWLONGIDCLASS_       	varchar(255) NULL,
          NEWLONGIDVALUE_       	numeric(19,0) NULL,
          OLDSTRINGIDCLASS_     	varchar(255) NULL,
          OLDSTRINGIDVALUE_     	varchar(255) NULL,
          NEWSTRINGIDCLASS_     	varchar(255) NULL,
          NEWSTRINGIDVALUE_     	varchar(255) NULL,
          OLDLONGVALUE_         	numeric(19,0) NULL,
          NEWLONGVALUE_         	numeric(19,0) NULL,
          OLDSTRINGVALUE_       	varchar(4000) NULL,
          NEWSTRINGVALUE_       	varchar(4000) NULL,
          TASKINSTANCE_         	numeric(19,0) NULL,
          TASKACTORID_          	varchar(255) NULL,
          TASKOLDACTORID_       	varchar(255) NULL,
          SWIMLANEINSTANCE_     	numeric(19,0) NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          RESOURCEGROUPID       	numeric NULL,
          RESOURCEID            	numeric NULL,
          OPERATIONALSTATUSID   	numeric NULL,
          ADMINISTRATIVESTATUSID	numeric NULL,
          CONSTRAINT PK_JBPM_LOG PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_LOG','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_LOG',1,100) INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_LOG') INTO tmp_result;
      --CREATESEQ('JBPM_LOG',vcache=>100);

   -- Create index IDX_JBPM_LOG_01
       vsql :=  'CREATE INDEX IDX_JBPM_LOG_01 ON '||vschema||'.JBPM_LOG (CLASS_, NODE_, TOKEN_)';
      SELECT CREATEOBJECT(VSQL,'Unable to create index IDX_JBPM_LOG_01 on JBPM_LOG table') INTO tmp_result;
 
      vsql :=  'CREATE INDEX idx_jbpm_log_node ON '||vschema||'.jbpm_log(node_)';
      SELECT CREATEOBJECT(VSQL,'Unable to create index idx_jbpm_log_node on JBPM_LOG table') INTO tmp_result;
     
    -- creating table TTV_MESSAGELOG
       vsql :=  'CREATE TABLE '||vschema||'.TTV_MESSAGELOG ( 
          MESSAGELOGID   	numeric(19,0) NOT NULL,
          LOGID          	numeric(19,0) NOT NULL,
          TYPE           	varchar(16) NOT NULL,
          MESSAGEUID     	varchar(16) NOT NULL,
          NAME           	varchar(64) NULL,
          ISINCOMING     	numeric(1,0) NOT NULL,
          MESSAGE        	varchar(4000) NOT NULL,
          RESOURCEID     	numeric NULL,
          MESSAGEDATETIME	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_MESSAGELOG PRIMARY KEY (MESSAGELOGID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_MESSAGELOG','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_MESSAGELOG') INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_MESSAGELOG') INTO tmp_result;

    -- Creating Index on TTV_MESSAGELOG (LOGID)
       vsql :=  'CREATE INDEX IDX_TTV_MESSAGELOG_01 ON '||vschema||'.TTV_MESSAGELOG (LOGID ASC)';
      SELECT CREATEOBJECT(VSQL,'Unable to create Index on TTV_MESSAGELOG') INTO tmp_result;

    -- creating table TTV_PROCESSINSTANCENOTE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_PROCESSINSTANCENOTE ( 
          PROCESSINSTANCENOTEID	numeric NOT NULL,
          PROCESSINSTANCEID    	numeric NOT NULL,
          NOTE                 	varchar(4000) NOT NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSINSTANCENOTE PRIMARY KEY (PROCESSINSTANCENOTEID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_PROCESSINSTANCENOTE','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_PROCESSINSTANCENOTE') INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_PROCESSINSTANCENOTE') INTO tmp_result;

    -- Creating Index IDX_TTV_PROCESSINSTANCENOTE_01
       VSQL :=  'CREATE INDEX IDX_TTV_PROCESSINSTANCENOTE_01 ON '||vschema||'.TTV_PROCESSINSTANCENOTE(PROCESSINSTANCEID)';
      SELECT CREATEOBJECT(VSQL,'Unable to create index IDX_TTV_PROCESSINSTANCENOTE_01') INTO tmp_result;

    -- creating table JBPM_TASKINSTANCE
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_TASKINSTANCE ( 
          ID_              	numeric(19,0) NOT NULL,
          CLASS_           	CHAR(1) NOT NULL,
          NAME_            	varchar(255) NULL,
          DESCRIPTION_     	varchar(4000) NULL,
          ACTORID_         	varchar(255) NULL,
          CREATE_          	TIMESTAMP(6) NULL,
          START_           	TIMESTAMP(6) NULL,
          END_             	TIMESTAMP(6) NULL,
          DUEDATE_         	TIMESTAMP(6) NULL,
          PRIORITY_        	numeric NULL,
          ISCANCELLED_     	numeric NULL,
          ISSUSPENDED_     	numeric NULL,
          ISOPEN_          	numeric NULL,
          ISSIGNALLING_    	numeric NULL,
          ISBLOCKING_      	numeric NULL,
          TASK_            	numeric(19,0) NULL,
          TOKEN_           	numeric(19,0) NULL,
          SWIMLANINSTANCE_ 	numeric(19,0) NULL,
          TASKMGMTINSTANCE_	numeric(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_TASKINSTANCE PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_TASKINSTANCE','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_TASKINSTANCE') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_TASKINSTANCE') INTO tmp_result;

    -- Creating index IX_JBPM_TASKINSTANCE_1
       vsql :=  'CREATE INDEX IX_JBPM_TASKINSTANCE_1 ON '||vschema||'.JBPM_TASKINSTANCE(ACTORID_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IX_JBPM_TASKINSTANCE_1') INTO tmp_result;
    
    -- Creating index IDX_JBPM_TASKINSTANCE_02
       vsql :=  'CREATE INDEX IDX_JBPM_TASKINSTANCE_02 ON '||vschema||'.JBPM_TASKINSTANCE(TASKMGMTINSTANCE_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TASKINSTANCE_02') INTO tmp_result;
      
    -- creating table JBPM_COMMENT
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_COMMENT ( 
          ID_               	numeric(19,0) NOT NULL,
          VERSION_          	numeric NOT NULL,
          ACTORID_          	varchar(255) NULL,
          TIME_             	TIMESTAMP(6) NULL,
          MESSAGE_          	varchar(4000) NULL,
          TOKEN_            	numeric(19,0) NULL,
          TASKINSTANCE_     	numeric(19,0) NULL,
          TOKENINDEX_       	numeric NULL,
          TASKINSTANCEINDEX_	numeric NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_COMMENT PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_COMMENT','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_COMMENT') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_COMMENT') INTO tmp_result;
      
    -- Creating index IDX_JBPM_COMMENT_01
       vsql :=  'CREATE INDEX IDX_JBPM_COMMENT_01 ON '||vschema||'.JBPM_COMMENT(TOKEN_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_COMMENT_01') INTO tmp_result;

    -- Creating index IDX_JBPM_COMMENT_02
       vsql :=  'CREATE INDEX IDX_JBPM_COMMENT_02 ON '||vschema||'.JBPM_COMMENT (TASKINSTANCE_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_COMMENT_02') INTO tmp_result;
  
    -- creating table JBPM_TRANSITION
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_TRANSITION ( 
          ID_               	numeric(19,0) NOT NULL,
          NAME_             	varchar(255) NULL,
          PROCESSDEFINITION_	numeric(19,0) NULL,
          FROM_             	numeric(19,0) NULL,
          TO_               	numeric(19,0) NULL,
          FROMINDEX_        	numeric NULL,
          TRANSITIONTYPEID		numeric DEFAULT(2) NOT NULL, 
          CREATEDATE        	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_JBPM_TRANSITION PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_TRANSITION','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_TRANSITION') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_TRANSITION') INTO tmp_result;
      
    -- Creating index IDX_JBPMTRANS_PROCDEFINITION
       vsql :=  'CREATE INDEX IDX_JBPMTRANS_PROCDEFINITION ON '||vschema||'.JBPM_TRANSITION(PROCESSDEFINITION_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_JBPMTRANS_PROCDEFINITION') INTO tmp_result;       

       vsql := 'create index idx_jbpm_transition_from on '||vschema||'.jbpm_transition (from_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index idx_jbpm_transition_from on '||vschema||'.jbpm_transition (from_)') INTO tmp_result;

       vsql := 'create index idx_jbpm_transition_to on '||vschema||'.jbpm_transition (to_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index idx_jbpm_transition_to on '||vschema||'.jbpm_transition (to_)') INTO tmp_result;
      
    -- creating table JBPM_VARIABLEACCESS
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_VARIABLEACCESS ( 
          ID_                 	numeric(19,0) NOT NULL,
          VARIABLENAME_       	varchar(255) NULL,
          ACCESS_             	varchar(255) NULL,
          MAPPEDNAME_         	varchar(255) NULL,
          PROCESSSTATE_       	numeric(19,0) NULL,
          TASKCONTROLLER_     	numeric(19,0) NULL,
          INDEX_              	numeric NULL,
          SCRIPT_             	numeric(19,0) NULL,
          DATATYPEID          	numeric DEFAULT (2) NOT NULL,
          CREATEDATE          	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE          	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          VARIABLEACCESSTYPEID	numeric DEFAULT (2) NOT NULL,
          CONSTRAINT PK_JBPM_VARIABLEACCESS PRIMARY KEY (ID_)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.JBPM_VARIABLEACCESS','N') INTO tmp_result;
    SELECT createseq(vschema,'JBPM_VARIABLEACCESS') INTO tmp_result;
    SELECT createupdatetrg(vschema,'JBPM_VARIABLEACCESS') INTO tmp_result;

      vsql := 'create index idx_jbpm_variableaccess_taskc on '||vschema||'.jbpm_variableaccess(taskcontroller_)';
      SELECT CREATEOBJECT(vsql,'Unable to create index idx_jbpm_variableaccess_taskc on '||vschema||'.jbpm_variableaccess') INTO tmp_result;

    -- creating table TTV_ACCESSLEVEL
       vsql :=  'CREATE TABLE '||vschema||'.TTV_ACCESSLEVEL ( 
          ACCESSLEVELID	numeric NOT NULL,
          NAME         	varchar(50) NOT NULL,
          CREATEDATE   	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE   	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_ACCESSLEVEL PRIMARY KEY (ACCESSLEVELID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_ACCESSLEVEL','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_ACCESSLEVEL') INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_ACCESSLEVEL') INTO tmp_result;
      
    -- creating table TTV_CONNECTIONTYPE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_CONNECTIONTYPE ( 
          CONNECTIONTYPEID	numeric NOT NULL,
          NAME            	varchar(30) NOT NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_CONNECTIONTYPE PRIMARY KEY (CONNECTIONTYPEID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_CONNECTIONTYPE','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_CONNECTIONTYPE',4) INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_CONNECTIONTYPE') INTO tmp_result;
      --CREATESEQ('TTV_CONNECTIONTYPE',4);
      
    -- creating table TTV_DATATYPE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_DATATYPE ( 
          DATATYPEID  	numeric NOT NULL,
          DATATYPENAME	varchar(30) NOT NULL,
          CREATEDATE  	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE  	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_DATATYPE PRIMARY KEY (DATATYPEID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_DATATYPE','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_DATATYPE',8) INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_DATATYPE') INTO tmp_result;
      --CREATESEQ('TTV_DATATYPE',8);

    -- creating table TTV_MONITOREDDRIVE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_MONITOREDDRIVE (
          MONITOREDDRIVEID       	numeric NOT NULL,
          NAME                   	varchar(500) NOT NULL,
          DESCRIPTION            	varchar(500) DEFAULT ('''') NOT NULL,
          PATH                   	varchar(1000) NOT NULL,
          RESOURCEID             	numeric NULL,
          INTERNALDRIVEID        	numeric NOT NULL,
          TOTALCAPACITY          	numeric(19,0) NULL,
          WARNINGTHRESHOLDPERCENT	numeric NOT NULL,
          ERRORTHRESHOLDPERCENT  	numeric NOT NULL,
          CURRENTBYTESUSED       	numeric(19,0) DEFAULT (0) NULL,
          CURRENTDRIVESTATUSID   	numeric DEFAULT (0) NOT NULL,
          LASTSAMPLEDATETIME     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_MONITOREDDRIVE PRIMARY KEY (MONITOREDDRIVEID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_MONITOREDDRIVE','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_MONITOREDDRIVE',3) INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_MONITOREDDRIVE') INTO tmp_result;
      --CREATESEQ('TTV_MONITOREDDRIVE',3);
      
    -- Creating index IX_TTV_MONITOREDDRIVE_1
       vsql :=  'CREATE INDEX IX_TTV_MONITOREDDRIVE_1 ON '||vschema||'.TTV_MONITOREDDRIVE (RESOURCEID,INTERNALDRIVEID)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IX_TTV_MONITOREDDRIVE_1') INTO tmp_result;

    -- creating table TTV_MONITOREDDRIVEHISTORY
       vsql :=  'CREATE TABLE '||vschema||'.TTV_MONITOREDDRIVEHISTORY ( 
          MONITOREDDRIVEHISTORYID	numeric(19,0) NOT NULL,
          MONITOREDDRIVEID       	numeric NOT NULL,
          CURRENTBYTESUSED       	numeric(19,0) NOT NULL,
          TOTALCAPACITY          	numeric(19,0) NOT NULL,
          WARNINGTHRESHOLDPERCENT	numeric NOT NULL,
          ERRORTHRESHOLDPERCENT  	numeric NOT NULL,
          CURRENTDRIVESTATUSID   	numeric NOT NULL,
          SAMPLEDATETIME         	TIMESTAMP(6) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_MONITOREDDRIVEHISTORY PRIMARY KEY (MONITOREDDRIVEHISTORYID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_MONITOREDDRIVEHISTORY','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_MONITOREDDRIVEHISTORY',9) INTO tmp_result;
      --CREATESEQ('TTV_MONITOREDDRIVEHISTORY',9);

    -- creating table TTV_MONITOREDDRIVESTATUS
       vsql :=  'CREATE TABLE '||vschema||'.TTV_MONITOREDDRIVESTATUS ( 
          MONITOREDDRIVESTATUSID	numeric NOT NULL,
          NAME                  	varchar(50) NOT NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_MONITOREDDRIVESTATUS PRIMARY KEY (MONITOREDDRIVESTATUSID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_MONITOREDDRIVESTATUS','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_MONITOREDDRIVESTATUS',3) INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_MONITOREDDRIVESTATUS') INTO tmp_result;
      --CREATESEQ('TTV_MONITOREDDRIVESTATUS',3);
      
    -- creating table TTV_PROCDEFACCESSLEVEL
       vsql :=  'CREATE TABLE '||vschema||'.TTV_PROCDEFACCESSLEVEL ( 
          PROCESSDEFINITIONID	numeric(19,0) NOT NULL,
          ACCESSLEVELID      	numeric NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL 
          )';
      SELECT CREATEOBJECT(vsql,'Unable to create table TTV_PROCDEFACCESSLEVEL') INTO tmp_result;

    -- Creating Primary Key on TTV_PROCDEFACCESSLEVEL
       vsql :=  'ALTER TABLE '||vschema||'.TTV_PROCDEFACCESSLEVEL ADD CONSTRAINT PK_TTV_PROCDEFACCESSLEVEL PRIMARY KEY (PROCESSDEFINITIONID, ACCESSLEVELID)';
      SELECT CREATEOBJECT(vsql,'Unable to create Primary Key for TTV_PROCDEFACCESSLEVEL') INTO tmp_result;
   
    -- creating table TTV_PROCESSDEFINITIONTYPE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_PROCESSDEFINITIONTYPE ( 
          PROCESSDEFINITIONTYPEID	numeric NOT NULL,
          NAME                   	varchar(50) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSDEFINITIONTYPE PRIMARY KEY (PROCESSDEFINITIONTYPEID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_PROCESSDEFINITIONTYPE','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_PROCESSDEFINITIONTYPE',4) INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_PROCESSDEFINITIONTYPE') INTO tmp_result;
      --CREATESEQ('TTV_PROCESSDEFINITIONTYPE',4);


    -- creating table TTV_PROCESSINSTANCETYPE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_PROCESSINSTANCETYPE ( 
          PROCESSINSTANCETYPEID	numeric NOT NULL,
          NAME                 	varchar(50) NOT NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSINSTANCETYPE PRIMARY KEY (PROCESSINSTANCETYPEID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_PROCESSINSTANCETYPE','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_PROCESSINSTANCETYPE') INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_PROCESSINSTANCETYPE') INTO tmp_result;

    -- creating table TTV_PROCESSPRIORITY
       vsql :=  'CREATE TABLE '||vschema||'.TTV_PROCESSPRIORITY ( 
          PROCESSPRIORITYID	numeric NOT NULL,
          NAME             	varchar(50) NOT NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSPRIORITY PRIMARY KEY (PROCESSPRIORITYID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_PROCESSPRIORITY','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_PROCESSPRIORITY') INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_PROCESSPRIORITY') INTO tmp_result;

      vsql := 'ALTER SEQUENCE '||vschema||'.TTV_PROCESSPRIORITY_SEQ minvalue 0 RESTART WITH 0';
      SELECT CREATEOBJECT(vsql,'Unable to ALTER SEQUENCE '||vschema||'.TTV_PROCESSPRIORITY_SEQ minvalue 0.') INTO tmp_result;

    -- creating table TTV_PROCESSSTATUS
       vsql :=  'CREATE TABLE '||vschema||'.TTV_PROCESSSTATUS ( 
          PROCESSSTATUSID	numeric NOT NULL,
          NAME           	varchar(50) NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSSTATUS PRIMARY KEY (PROCESSSTATUSID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_PROCESSSTATUS','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_PROCESSSTATUS',8) INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_PROCESSSTATUS') INTO tmp_result;
      --CREATESEQ('TTV_PROCESSSTATUS',8);

    -- creating table TTV_RESOURCE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_RESOURCE ( 
          RESOURCEID                    	numeric NOT NULL,
          NAME                          	varchar(50) NOT NULL,
          CONNECTIONSTRING              	varchar(255) NOT NULL,
          RESOURCETYPEID                	numeric NOT NULL,
          MAXCONCURRENTUSERS            	numeric NOT NULL,
          ADMINISTRATIVERESOURCESTATUSID	numeric NOT NULL,
          OPERATIONALRESOURCESTATUSID   	numeric NOT NULL,
          HEARTBEATCONNECTIONSTRING     	varchar(255) NULL,
          HEARTBEATFREQUENCY            	numeric NULL,
          ISACTIVE                      	numeric(1,0) NOT NULL,
          FUNCTIONALTYPE 			varchar(1024) NULL,
          IGNORETIMEOUT                   numeric(1,0) DEFAULT 0 NOT NULL,
          CREATEDATE                    	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE                    	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          USER_NAME                     	varchar(96) NULL,
          CONSTRAINT PK_TTV_RESOURCE PRIMARY KEY (RESOURCEID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_RESOURCE','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_RESOURCE') INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_RESOURCE') INTO tmp_result;
      
    -- creating table TTV_RESOURCEGROUP
       vsql :=  'CREATE TABLE '||vschema||'.TTV_RESOURCEGROUP ( 
          RESOURCEGROUPID          	numeric NOT NULL,
          NAME                     	varchar(50) NOT NULL,
          RESOURCETYPEID           	numeric NOT NULL,
          ISINTERNALLYACQUIRED     	numeric(1,0) NOT NULL,
          ALLOCATIONSTRATEGYCLASSID	numeric NULL,
          ACCESSLEVELID            	numeric DEFAULT (0) NOT NULL, 
          FUNCTIONALTYPE 		        varchar(1024)  NULL,
          ISVISIBLE      		        numeric(1) DEFAULT(0) NOT NULL,  
          IMAGEPATH      		        varchar(4000)  NULL,
          ISALLOCATABLE                 numeric(1) DEFAULT(1),
          CREATEDATE               	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCEGROUP PRIMARY KEY (RESOURCEGROUPID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_RESOURCEGROUP','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_RESOURCEGROUP',115) INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_RESOURCEGROUP') INTO tmp_result;
      --CREATESEQ('TTV_RESOURCEGROUP',115);
      
    -- creating table TTV_RESOURCEGROUPMEMBERSHIP
       vsql :=  'CREATE TABLE '||vschema||'.TTV_RESOURCEGROUPMEMBERSHIP ( 
          RESOURCEID     	numeric NOT NULL,
          RESOURCEGROUPID	numeric NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL 
          )';
      SELECT CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCEGROUPMEMBERSHIP') INTO tmp_result;
  
    -- Creating Primary Key on TTV_RESOURCEGROUP
       vsql :=  'ALTER TABLE '||vschema||'.TTV_RESOURCEGROUPMEMBERSHIP
          ADD  CONSTRAINT PK_TTV_RESOURCEGROUPMEMBERSHIP
          PRIMARY KEY (RESOURCEID, RESOURCEGROUPID)';
      SELECT CREATEOBJECT(vsql,'Unable to create Primary Key for TTV_RESOURCEGROUPMEMBERSHIP') INTO tmp_result;

    -- creating table TTV_RESOURCESTATUS
       vsql :=  'CREATE TABLE '||vschema||'.TTV_RESOURCESTATUS ( 
          RESOURCESTATUSID	numeric NOT NULL,
          NAME            	varchar(50) NOT NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCESTATUS PRIMARY KEY (RESOURCESTATUSID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_RESOURCESTATUS','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_RESOURCESTATUS') INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_RESOURCESTATUS') INTO tmp_result;
      
    -- creating table TTV_RESOURCETYPE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_RESOURCETYPE ( 
          RESOURCETYPEID               	numeric NOT NULL,
          NAME                         	varchar(50) NOT NULL,
          RESOURCECONNECTIONTYPEID     	numeric NOT NULL,
          INITIALIZATIONSTRATEGYCLASSID	numeric NULL,
          HEARTBEATSTRATEGYCLASSID     	numeric NULL,
          HEARTBEATCONNECTIONTYPEID    	numeric NULL,
          SYSTEMID       			varchar(4000)  NULL,
          CREATEDATE                   	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE                   	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCETYPE PRIMARY KEY (RESOURCETYPEID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_RESOURCETYPE','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_RESOURCETYPE',34) INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_RESOURCETYPE') INTO tmp_result;
      --CREATESEQ('TTV_RESOURCETYPE',34);
    
    -- Create Unique index on the SYSTEMID column of the TTV_RESOURCETYPE table.
       vsql :=  'CREATE UNIQUE INDEX IDX_TTV_RESOURCETYPE_UK ON '||vschema||'.TTV_RESOURCETYPE(SYSTEMID)';
      SELECT CREATEOBJECT(vsql,'Unable to create a Unique index on SYSTEMID.TTV_RESOURCETYPE') INTO tmp_result;
      
    -- creating table TTV_STRATEGYCLASS
       vsql :=  'CREATE TABLE '||vschema||'.TTV_STRATEGYCLASS ( 
          STRATEGYCLASSID    	numeric NOT NULL,
          NAME               	varchar(50) NOT NULL,
          DESCRIPTION        	varchar(500) NOT NULL,
          CLASSNAME          	varchar(4000) NULL,
          STRATEGYCLASSTYPEID	numeric NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_STRATEGYCLASS PRIMARY KEY (STRATEGYCLASSID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_STRATEGYCLASS','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_STRATEGYCLASS',10) INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_STRATEGYCLASS') INTO tmp_result;
       --CREATESEQ('TTV_STRATEGYCLASS',10);

    -- creating table TTV_STRATEGYCLASSTYPE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_STRATEGYCLASSTYPE ( 
          STRATEGYCLASSTYPEID	numeric NOT NULL,
          NAME               	varchar(50) NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_STRATEGYCLASSTYPE PRIMARY KEY (STRATEGYCLASSTYPEID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_STRATEGYCLASSTYPE','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_STRATEGYCLASSTYPE',4) INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_STRATEGYCLASSTYPE') INTO tmp_result;
      --CREATESEQ('TTV_STRATEGYCLASSTYPE',4);

      
    -- creating table TTV_TOKENTYPE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_TOKENTYPE ( 
          TOKENTYPEID	numeric NOT NULL,
          NAME       	varchar(50) NULL,
          CREATEDATE 	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE 	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_TOKENTYPE PRIMARY KEY (TOKENTYPEID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_TOKENTYPE','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_TOKENTYPE') INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_TOKENTYPE') INTO tmp_result;
      
    -- creating table TTV_VARIABLEACCESSTYPE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_VARIABLEACCESSTYPE ( 
          VARIABLEACCESSTYPEID	numeric NOT NULL,
          NAME                	varchar(50) NOT NULL,
          CREATEDATE          	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          UPDATEDATE          	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
          CONSTRAINT PK_TTV_VARIABLEACCESSTYPE PRIMARY KEY (VARIABLEACCESSTYPEID)
          )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_VARIABLEACCESSTYPE','N') INTO tmp_result;
    SELECT createseq(vschema,'TTV_VARIABLEACCESSTYPE',3) INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_VARIABLEACCESSTYPE') INTO tmp_result;
      --CREATESEQ('TTV_VARIABLEACCESSTYPE',3);

  
  -- Creating table UI_PROPERTIES
       vsql :=  'CREATE TABLE '||vschema||'.UI_PROPERTIES ( 
          NAME      	varchar(254) NOT NULL,
          VALUE     	varchar(254) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL 
          )';
      SELECT CREATEOBJECT(vsql,'Unable to create table UI_PROPERTIES') INTO tmp_result;
  
      -- Create table TTV_SELECTOR
       vsql :=  'CREATE TABLE '||vschema||'.TTV_SELECTOR ( 
                                SELECTIONKEY       varchar(4000) NOT NULL,
                               PROCESSDEFINITIONID numeric(19,0) NULL,
                               CREATEDATE          DATE DEFAULT (current_date) NOT NULL,
                               UPDATEDATE          DATE DEFAULT (current_date) NOT NULL
                              )';
      SELECT CREATEOBJECT(vsql,'Unable to create table TTV_SELECTOR') INTO tmp_result;
      SELECT createupdatetrg(vschema,'TTV_SELECTOR') INTO tmp_result;
      
      -- Create Primary Key for TTV_SELECTOR
       vsql :=  'ALTER TABLE '||vschema||'.TTV_SELECTOR ADD CONSTRAINT PK_TTV_SELECTOR PRIMARY KEY (SELECTIONKEY)';
      SELECT CREATEOBJECT(vsql,'Unable to create primary key for TTV_SELECTOR') INTO tmp_result;
      
      -- Create table TTV_TRANSITIONTYPE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_TRANSITIONTYPE (
                               TRANSITIONTYPEID    numeric NOT NULL,
                               NAME        varchar(50) NULL,
                               CREATEDATE  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                               UPDATEDATE  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                               CONSTRAINT PK_TTV_TRANSITIONTYPE PRIMARY KEY (TRANSITIONTYPEID)
                              )';
    select CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_TRANSITIONTYPE','N') INTO tmp_result;
    SELECT createupdatetrg(vschema,'TTV_TRANSITIONTYPE') INTO tmp_result;
      
      -- added a new column initialvalue on jbpm_variableaccess table by Sahil on 08-19-2010
      vsql := 'ALTER TABLE '||vschema||'.jbpm_variableaccess ADD initialvalue varchar(1024)';
      SELECT CREATEOBJECT(vsql,'Unable to add new column INITIALVALUE in jbpm_variableaccess') INTO tmp_result;
      
      
      -- creating table TTV_SELECTOR_KEY
      vsql :=  'CREATE TABLE '||vschema||'.TTV_SELECTOR_KEY ( 
             KEY                    	varchar(255) NOT NULL,
             TEMPLATENAME               varchar(255) NOT NULL,
             CONSTRAINT PK_TTV_SELECTOR_KEY PRIMARY KEY (KEY)
             )';
      SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_SELECTOR_KEY','N') INTO tmp_result;

      -- Creating index IDX_TTV_SELECTOR_KEY_TNAME
      vsql :=  'CREATE INDEX IDX_TTV_SELECTOR_KEY_TNAME ON '||vschema||'.TTV_SELECTOR_KEY (TEMPLATENAME)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_SELECTOR_KEY_TNAME on TTV_SELECTOR_KEY table') INTO tmp_result;

      -- creating table TTV_TEMPLATE
     vsql :=  'CREATE TABLE '||vschema||'.TTV_TEMPLATE ( 
            ID                       numeric(19) NOT NULL,
            NAME                     varchar(255) NOT NULL,
            VERSION                  numeric NOT NULL,
            PROCESSDEFINITION        varchar NOT NULL,
            VARS                     json,
            NODETIMEOUTS             json,
            TYPEID                   numeric ,
            CONTENTTYPE              numeric ,
            CREATEDATE               TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            UPDATEDATE               TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            CONSTRAINT PK_TTV_TEMPLATE PRIMARY KEY (ID)
            )';
      SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_TEMPLATE','N') INTO tmp_result;
      SELECT createupdatetrg(vschema,'TTV_TEMPLATE') INTO tmp_result;

      -- Creating index IDX_TTV_TEMPLATE_NAME
      vsql :=  'CREATE INDEX IDX_TTV_TEMPLATE_NAME ON '||vschema||'.TTV_TEMPLATE (NAME,VERSION)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_TEMPLATE_NAME on TTV_TEMPLATE table') INTO tmp_result;

      vsql :=  'CREATE UNIQUE INDEX IDX_TTV_TEMPLATE_NAME_VERSION_UK ON '||vschema||'.TTV_TEMPLATE (NAME,VERSION) WHERE (TYPEID = 2)';
      SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_TEMPLATE_NAME_VERSION_UK on TTV_TEMPLATE table') INTO tmp_result;

       vsql :=  'CREATE TABLE '||vschema||'.TTV_TOKEN ( 
            TOKENID                      numeric(19) NOT NULL,
            PARENTTOKENID                numeric(19) ,
            PROCESSID                    numeric(19) ,
            TOKENNAME                    varchar(255) ,
            CURRENTNODENAME              varchar(255) ,
            VARS                         json ,
            OPERATIONALSTATUS            numeric(19) ,
            ADMINSTATUS                  numeric(19) ,
            COMMENTS                     json,
            STARTDATE                    TIMESTAMP(6),
            ENDDATE                      TIMESTAMP(6),
            CREATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            UPDATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            CONSTRAINT PK_TTV_TOKEN PRIMARY KEY (TOKENID)
            )';
       SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_TOKEN','N') INTO tmp_result;
       SELECT createupdatetrg(vschema,'TTV_TOKEN') INTO tmp_result;
      
       vsql :=  'CREATE INDEX IDX_TTV_TOKEN_PTID ON '||vschema||'.TTV_TOKEN (PARENTTOKENID)';
       SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_TOKEN_PTID on TTV_TOKEN table') INTO tmp_result;

       vsql :=  'CREATE INDEX IDX_TTV_TOKEN_PID ON '||vschema||'.TTV_TOKEN (PROCESSID)';
       SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_TOKEN_PID on TTV_TOKEN table') INTO tmp_result;
      
       -- Adding comment on the JBPM_TOKEN table
       vsql :='COMMENT ON TABLE '||vschema||'.TTV_TOKEN IS ''Stores information about the token representing execution location in the process instance''';
       SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_TOKEN table') INTO tmp_result; 
      
       -- creating table TTV_PROCESSINSTANCE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_PROCESSINSTANCE ( 
            PROCESSID                    numeric(19) NOT NULL,
            PARENTPROCESSID              numeric(19) ,
            ROOTTOKENID                  numeric(19) ,
            TEMPLATEID                   numeric(19) ,
            PRIORITY                     numeric,
            NOTES                        json ,
            CREATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            UPDATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            ISACTIVE                     numeric(1) NOT NULL DEFAULT 1,
            CREATEID                     VARCHAR(255),
            CONSTRAINT PK_TTV_PROCESSINSTANCE PRIMARY KEY (PROCESSID)
            )';
       SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_PROCESSINSTANCE','N') INTO tmp_result;
       SELECT createupdatetrg(vschema,'TTV_PROCESSINSTANCE') INTO tmp_result;
      
       vsql :=  'CREATE INDEX IDX_TTV_PROCESSINSTANCE_PPID ON '||vschema||'.TTV_PROCESSINSTANCE (PARENTPROCESSID)';
       SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_PROCESSINSTANCE_PPID on TTV_PROCESSINSTANCE table') INTO tmp_result;

       vsql :=  'CREATE UNIQUE INDEX IDX_TTV_PROCESSINSTANCE_CID_UK ON '||vschema||'.TTV_PROCESSINSTANCE (CREATEID)';
       SELECT CREATEOBJECT(vsql,'Unable to CREATE UNIQUE INDEX IDX_TTV_PROCESSINSTANCE_CID_UK on TTV_PROCESSINSTANCE table') INTO tmp_result;
      
      
       -- Adding comment on the TTV_PROCESSINSTANCE
       vsql :='COMMENT ON TABLE '||vschema||'.TTV_PROCESSINSTANCE IS ''Stores runtime information about an instance of a process. 
               Foreign keys
               TTV_TEMPLATE table - the process definition to be followed for this process instance execution 
               TTV_Token table - the root token that follows where the process execution is currently''';
       SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSINSTANCE table') INTO tmp_result; 
      
       -- creating table TTV_TASKINSTANCE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_TASKINSTANCE (
            TASKID                       numeric(19) NOT NULL,
            TOKENID                      numeric(19) NOT NULL,
            CURRENTNODENAME              varchar(255) ,
            STARTDATE                    TIMESTAMP(6),
            ENDDATE                      TIMESTAMP(6),
            CREATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            UPDATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            CONSTRAINT PK_TTV_TASKINSTANCE PRIMARY KEY (TASKID)
            )';
       SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_TASKINSTANCE','N') INTO tmp_result;
       SELECT createupdatetrg(vschema,'TTV_TASKINSTANCE') INTO tmp_result;
      
       -- Adding comment on the TTV_TASKINSTANCE
       vsql :='COMMENT ON TABLE '||vschema||'.TTV_TASKINSTANCE IS ''Stores task information about an instance of a process.''';
       SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_TASKINSTANCE table') INTO tmp_result;

 /*
  -----------------------------------------
   CREATING ALL VIEWS
  -----------------------------------------
  */
  
  -- Creating View VDW_NODE
       vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_NODE ( NODEID, NODECLASS, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKID, TASKNAME, ISSTARTNODE, RESOURCEGROUPID, RESOURCEGROUPNAME, RESOURCETYPEID, RESOURCETYPENAME, TASKCONTROLLERID, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  n.ID_ NodeId,
                                  CASE when n.CLASS_= ''D'' then ''DECISION''
                                       when n.CLASS_= ''E'' then ''END''
                                       when n.CLASS_= ''R'' then ''START''
                                       when n.CLASS_= ''Y'' then ''MANUAL''
                                       when n.CLASS_= ''Z'' then ''AUTOMATED''
                                       else ''UNKNOWN''
                                       end as  NodeClass,
                                  n.NAME_ NodeName,
                                  n.PROCESSDEFINITION_ ProcessDefinitionId,
                                  d.NAME_ ProcessDefinitionName,
                                  n.NODECOLLECTIONINDEX_ NodeIndex,
                                  t.ID_ TaskId,
                                  t.NAME_ TaskName,
                                  case when COALESCE(d.STARTSTATE_, -1)=-1 then 0
                                       else 1 end as IsStartNode,
                                  n.ResourceGroupId,
                                  COALESCE (g.Name, ''[N/A]'') ResourceGroupName,
                                  g.ResourceTypeId,
                                  COALESCE (ty.Name, ''[N/A]'') ResourceTypeName,
                                  TASKCONTROLLER_ TaskControllerId,
                                  d.ProcessDefinitionTypeId,
                                  dt.Name ProcessDefinitionTypeName,
                                  n.CreateDate,
                                  n.UpdateDate
                          FROM    '||vschema||'.JBPM_NODE n
                          JOIN    '||vschema||'.JBPM_PROCESSDEFINITION d
                          ON (    d.ID_ = n.PROCESSDEFINITION_)
                          JOIN    '||vschema||'.TTV_ProcessDefinitionType dt
                          ON (    dt.ProcessDefinitionTypeId = d.ProcessDefinitionTypeId)
                          LEFT JOIN '||vschema||'.TTV_ResourceGroup g
                          ON (    g.ResourceGroupId = n.ResourceGroupId)
                          LEFT JOIN '||vschema||'.TTV_ResourceType ty
                          ON (    ty.ResourceTypeId = g.ResourceTypeId)
                          LEFT JOIN '||vschema||'.JBPM_TASK t
                          ON (    t.TASKNODE_ = n.ID_
                          OR              t.STARTSTATE_ = n.ID_)';
       SELECT CREATEOBJECT(vsql,'Unable to create view VDW_NODE') INTO tmp_result;
 
  -- Creating View VDW_PROCESSINSTANCE
       vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_PROCESSINSTANCE ( PROCESSINSTANCEID, LOCALSTARTDATE, LOCALENDDATE, ISSUSPENDED, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, ADMINSTATUSID, ADMINSTATUS, OPERSTATUSID, OPERSTATUS, PRIORITYID, PRIORITY, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  I.ID_ PROCESSINSTANCEID,
                                  START_ LOCALSTARTDATE,
                                  END_ LOCALENDDATE,
                                  ISSUSPENDED_ ISSUSPENDED,
                                  PROCESSDEFINITION_ PROCESSDEFINITIONID,
                                  NAME_ PROCESSDEFINITIONNAME,
                                  ADMINISTRATIVEPROCESSSTATUSID ADMINSTATUSID,
                                  ADS.NAME ADMINSTATUS,
                                  OPERATIONALPROCESSSTATUSID OPERSTATUSID,
                                  OPS.NAME OPERSTATUS,
                                  I.PROCESSPRIORITYID PRIORITYID,
                                  COALESCE(P.NAME, ''[N/A]'') PRIORITY,
                                  d.ProcessDefinitionTypeId,
                                  dt.Name ProcessDefinitionTypeName,
                                  I.CREATEDATE,
                                  I.UPDATEDATE
                          FROM    '||vschema||'.JBPM_PROCESSINSTANCE I
                          JOIN    '||vschema||'.JBPM_PROCESSDEFINITION D
                          ON (    D.ID_ = PROCESSDEFINITION_)
                          JOIN    '||vschema||'.TTV_ProcessDefinitionType dt
                          ON (    dt.ProcessDefinitionTypeId = d.ProcessDefinitionTypeId)
                          LEFT JOIN '||vschema||'.TTV_PROCESSPRIORITY P
                          ON (    P.PROCESSPRIORITYID = I.PROCESSPRIORITYID)
                          JOIN    '||vschema||'.TTV_PROCESSSTATUS ADS
                          ON (    ADS.PROCESSSTATUSID = ADMINISTRATIVEPROCESSSTATUSID)
                          JOIN    '||vschema||'.TTV_PROCESSSTATUS OPS
                          ON (    OPS.PROCESSSTATUSID = OPERATIONALPROCESSSTATUSID)';
      SELECT CREATEOBJECT(vsql,'Unable to create view VDW_PROCESSINSTANCE') INTO tmp_result;
 
  -- Creating View VDW_LOG
       vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_LOG
                          AS 
                  SELECT	l.ID_ LogId,
                          l.CLASS_ LogClass,
                          case when l.CLASS_=''N'' then ''NODE''
                               when l.CLASS_=''7'' then ''MESSAGE''
                               when l.CLASS_=''8'' then ''USAGE''
                               when l.CLASS_=''9'' then ''QUEUE''	
                               else ''UNKNOWN'' 
                               end as LogClassName,
                          l.DATE_ LocalDate,
                          n.ProcessDefinitionId,
                          n.ProcessDefinitionName,
                          p.ProcessInstanceId,
                          p.ProcessDefinitionTypeId,
                          l.NODE_ NodeId,
                          n.NodeClass,
                          n.NodeName,
                          n.NodeIndex,
                          n.IsStartNode,
                          l.ENTER_ LocalEnterDate,
                          l.LEAVE_ LocalLeaveDate,
                          l.DURATION_ Duration,
                          l.ResourceGroupId,
                          COALESCE(g.Name, ''[N/A]'') ResourceGroupName,
                          g.ResourceTypeId,
                          COALESCE(ty.Name, ''[N/A]'') ResourceTypeName,
                          l.ResourceId,
                          COALESCE (r.Name, ''[N/A]'') ResourceName,
                          AdministrativeStatusId	AdminStatusId,
                          ads.Name AdminStatus,
                          OperationalStatusId	OperStatusId,
                          ops.Name OperStatus,
                          INDEX_,
                          l.TOKEN_ TokenId,
                          l.CreateDate,
                          l.UpdateDate
                    FROM	'||vschema||'.JBPM_LOG l
                          JOIN	'||vschema||'.vDW_NODE n
                          ON (	n.NodeId = l.NODE_)
                          JOIN	'||vschema||'.JBPM_TOKEN t
                          ON (	t.ID_ = l.TOKEN_)
                          JOIN	'||vschema||'.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = t.PROCESSINSTANCE_)
                          LEFT JOIN '||vschema||'.TTV_ResourceGroup g
                          ON (	g.ResourceGroupId = l.ResourceGroupId)
                          LEFT JOIN '||vschema||'.TTV_ResourceType ty
                          ON (	ty.ResourceTypeId = g.ResourceTypeId)
                          LEFT JOIN '||vschema||'.TTV_Resource r
                          ON (	r.ResourceId = l.ResourceId)
                          LEFT JOIN '||vschema||'.TTV_ProcessStatus ads
                          ON (	ads.ProcessStatusId = l.AdministrativeStatusId)
                          LEFT JOIN '||vschema||'.TTV_ProcessStatus ops
                          ON (	ops.ProcessStatusId = l.OperationalStatusId)';
      SELECT CREATEOBJECT(vsql,'Unable to create view VDW_LOG') INTO tmp_result;
 
  -- Creating View VDW_TASKINSTANCE
  
       vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_TASKINSTANCE ( TASKINSTANCEID, TASKINSTANCENAME, LOCALCREATEDATE, LOCALENDDATE, ISCANCELLED, ISSUSPENDED, ISOPEN, TASKID, NODEID, NODECLASS, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKNAME, ISSTARTNODE, TASKCONTROLLERID, TOKENID, PROCESSINSTANCEID, CURRENTADMINSTATUSID, CURRENTADMINSTATUS, CURRENTOPERSTATUSID, CURRENTOPERSTATUS, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	i.ID_ TaskInstanceId,
                                  i.NAME_ TaskInstanceName,
                                  i.CREATE_ LocalCreateDate,
                                  i.END_ LocalEndDate,
                                  i.ISCANCELLED_ IsCancelled,
                                  i.ISSUSPENDED_ IsSuspended,
                                  i.ISOPEN_ IsOpen,
                                  i.TASK_ TaskId,
                                  n.NodeId,
                                  n.NodeClass,
                                  n.NodeName,
                                  n.ProcessDefinitionId,
                                  n.ProcessDefinitionName,
                                  n.NodeIndex,
                                  n.TaskName,
                                  n.IsStartNode,
                                  n.TaskControllerId,
                                  i.TOKEN_ TokenId,
                                  p.ProcessInstanceId,
                                  p.AdminStatusId CurrentAdminStatusId,
                                  p.AdminStatus CurrentAdminStatus,
                                  p.OperStatusId CurrentOperStatusId,
                                  p.OperStatus CurrentOperStatus,
                                  n.ProcessDefinitionTypeId,
                                  n.ProcessDefinitionTypeName,
                                  i.CREATEDATE,
                                  i.UPDATEDATE
                          FROM	'||vschema||'.JBPM_TASKINSTANCE i
                          JOIN	'||vschema||'.vDW_NODE n
                          ON (	n.TaskId = i.TASK_)
                          JOIN	'||vschema||'.JBPM_TOKEN t
                          ON (	t.ID_ = i.TOKEN_)
                          JOIN	'||vschema||'.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = t.PROCESSINSTANCE_)';
      SELECT CREATEOBJECT(vsql,'Unable to create view VDW_TASKINSTANCE') INTO tmp_result;

  -- Creating View VDW_VARIABLEACCESS
       vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_VARIABLEACCESS ( VARIABLEACCESSID, VARIABLENAME, ACCESSTYPE, MAPPEDNAME, TASKCONTROLLERID, VARIABLEINDEX, DATATYPEID, DATATYPENAME, NODEID, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKNAME, ISSTARTNODE, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	v.ID_ VariableAccessId,
                                  v.VARIABLENAME_ VariableName,
                                  v.ACCESS_ AccessType,
                                  v.MAPPEDNAME_ MappedName,
                                  v.TASKCONTROLLER_ TaskControllerId,
                                  v.Index_ VariableIndex,
                                  v.DataTypeId,
                                  t.DataTypeName,
                                  n.NodeId,
                                  n.NodeName,
                                  n.ProcessDefinitionId,
                                  n.ProcessDefinitionName,
                                  n.NodeIndex,
                                  n.TaskName,
                                  n.IsStartNode,
                                  n.ProcessDefinitionTypeId,
                                  n.ProcessDefinitionTypeName,
                                  v.CreateDate,
                                  v.UpdateDate
                          FROM	'||vschema||'.JBPM_VARIABLEACCESS v
                          JOIN	'||vschema||'.TTV_DATATYPE t
                          ON (	t.DataTypeId = v.DataTypeId)
                          JOIN	'||vschema||'.vDW_Node n
                          ON (	n.TaskControllerId = v.TASKCONTROLLER_)';
      SELECT CREATEOBJECT(vsql,'Unable to create view VDW_VARIABLEACCESS') INTO tmp_result;

  -- Creating View VDW_VARIABLEINSTANCE
       vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.VDW_VARIABLEINSTANCE ( VARIABLEINSTANCEID, CLASSCODE, CLASSNAME, VARIABLEINSTANCENAME, TOKENID, ISGLOBALVARIABLE, PROCESSINSTANCEID, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NUMERICVALUE, STRINGVALUE, LONGVALUE_, STRINGVALUE_, DOUBLEVALUE_, TOKENVARIABLEMAP_, TASKINSTANCEID, TASKINSTANCENAME, TASKID, NODEID, NODECLASS, NODENAME, NODEINDEX, TASKNAME, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  i.ID_    VariableInstanceId,
                                  i.CLASS_ ClassCode,
                                  case when i.CLASS_=''N'' then ''NULL''
                                       when i.CLASS_=''S'' then ''STRING''
                                       when i.CLASS_=''L'' then ''LONG''
                                       else ''[UNKNOWN]'' end as ClassName,
                                  i.NAME_ VariableInstanceName,
                                  i.TOKEN_ TokenId,
                                  case when COALESCE(i.TOKENVARIABLEMAP_, -1)=-1 then 0
                                       else 1 end as IsGlobalVariable,
                                  i.PROCESSINSTANCE_ ProcessInstanceId,
                                  p.ProcessDefinitionId,
                                  p.ProcessDefinitionName,
                                  case when i.CLASS_=''L'' then 
                                      COALESCE(i.LONGVALUE_,TO_number(i.DOUBLEVALUE_::text,''9999999999999999D999999''::text))
                                  else 
                                      NULL 
                                  end as NumericValue,
                                  case when i.CLASS_=''L'' then NULL
                                  else i.STRINGVALUE_ end as StringValue,
                                  i.LONGVALUE_,
                                  i.STRINGVALUE_,
                                  i.DOUBLEVALUE_,
                                  i.TOKENVARIABLEMAP_,
                                  i.TASKINSTANCE_ TaskInstanceId,
                                  t.TaskInstanceName,
                                  t.TaskId,
                                  t.NodeId,
                                  t.NodeClass,
                                  t.NodeName,
                                  t.NodeIndex,
                                  t.TaskName,
                                  p.ProcessDefinitionTypeId,
                                  p.ProcessDefinitionTypeName,
                                  i.CREATEDATE,
                                  i.UPDATEDATE
                          FROM	'||vschema||'.JBPM_VARIABLEINSTANCE i
                          JOIN	'||vschema||'.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = i.PROCESSINSTANCE_)
                          LEFT JOIN '||vschema||'.vDW_TaskInstance t
                          ON (	t.TaskInstanceId = i.TASKINSTANCE_)';
      SELECT CREATEOBJECT(vsql,'Unable to create view VDW_VARIABLEINSTANCE') INTO tmp_result;
  
  /*
  -----------------------------------------
   INSERTING DEFAULT DATA INTO TABLES
  -----------------------------------------
  */

  -- Inserting default TTV_CONNECTIONTYPE data
    EXECUTE 'INSERT INTO '||vschema||'.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE) VALUES(1,''URL'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE) VALUES(2,''IP Address[:Port]'',now(),now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE) VALUES(3,''Email'', now(), now())';
  
  -- Inserting default TTV_STRATEGYCLASSTYPE data
    EXECUTE 'INSERT INTO '||vschema||'.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE) 
     VALUES(1, ''Resource Initialization Strategy'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(2, ''Resource HeartBeat Strategy'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(3, ''Resource Allocation Strategy'', now(), now())';
  
  -- Inserting default TTV_PROCESSPRIORITY data
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSPRIORITY (NAME) VALUES
           (''P20''), (''P19''), (''P18''), (''P17''), (''P16''), (''P15''), (''P14''), (''P13''), (''P12''), (''P11''), 
           (''P10''), (''P9''), (''P8''), (''P7''), (''P6''), (''P5''), (''P4''), (''P3''), (''P2''), (''P1'')';
  
  -- Inserting default TTV_PROCESSSTATUS data 
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(0, ''CREATED'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(1, ''RUNNING'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(2, ''ERROR'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(3, ''PAUSED'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(4, ''QUEUED'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(5, ''CANCELLED'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(6, ''STOPPED'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(7, ''BUSY'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(8, ''BRANCH'', now(), now())';
  
  -- Inserting default PROCESSINSTANCETYPE data
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSINSTANCETYPE(PROCESSINSTANCETYPEID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(1, ''Standard JBPM ProcessInstance'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSINSTANCETYPE(PROCESSINSTANCETYPEID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(2, ''TTV ProcessInstance'', now(), now())';
  
  -- Inserting default TTV_TOKENTYPE data 
    EXECUTE 'INSERT INTO '||vschema||'.TTV_TOKENTYPE(TOKENTYPEID, NAME, CREATEDATE, UPDATEDATE) VALUES(1, ''Standard JBPM Token'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_TOKENTYPE(TOKENTYPEID, NAME, CREATEDATE, UPDATEDATE) VALUES(2, ''TTV Token'', now(), now())';
  
  -- Inserting default TTV_ACCESSLEVEL data 
    EXECUTE 'INSERT INTO '||vschema||'.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE) VALUES(0, ''NON-ADULT'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE) VALUES(1, ''ADULT'', now(), now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE) VALUES(2, ''COMMON'', now(), now())';
  
  -- Inserting default TTV_VARIABLEACCESSTYPE data
    EXECUTE 'INSERT INTO '||vschema||'.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(1, ''Standard JBPM VariableAccess'', now(), now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(2, ''TTV VariableAccess'', now(),now())';
  
  -- Inserting default TTV_MONITOREDDRIVESTATUS data 
    EXECUTE 'INSERT INTO '||vschema||'.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(0,''OK'',now(),now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(1,''WARNING'',now(),now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE) VALUES(2,''ERROR'',now(),now())';
  
  -- Inserting default TTV_DATATYPE data
    EXECUTE 'INSERT INTO '||vschema||'.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE) VALUES(1, ''int'', now(),now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE) VALUES(2, ''string'', now(),now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE) VALUES(3, ''boolean'', now(),now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE) VALUES(4, ''date'', now(),now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE) VALUES(5, ''file'', now(),now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE) VALUES(6, ''destination'', now(),now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE) VALUES(7, ''duration'', now(),now())';
    EXECUTE 'INSERT INTO '||vschema||'.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE) VALUES(8, ''url'', now(),now())';
  
    -- Kinjal requested to insert a list value in the table on 03-22-2011
    EXECUTE 'INSERT INTO '||VSCHEMA||'.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE) 
     VALUES(9, ''list'', current_timestamp, current_timestamp)';
  
  -- Inserting default TTV_PROCESSDEFINITIONTYPE
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(1, ''Standard JBPM ProcessDefinition'', now(),now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(2, ''TTV ProcessDefinition'', now(),now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(3, ''TTV Invisible ProcessDefinition'', now(),now())';
  
  -- Inserting default TTV_RESOURCESTATUSID data 
    EXECUTE 'INSERT INTO '||vschema||'.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(1, ''Initializing'', now(),now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(2, ''Online'', now(),now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(3, ''Offline'', now(),now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(4, ''Initialization Error'', now(),now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
     VALUES(5, ''HeartBeat Error'', now(),now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
     VALUES (6, ''Error'')';
    
    EXECUTE 'INSERT INTO '||vschema||'.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
     VALUES (7, ''Inactive'')';
    
    EXECUTE 'INSERT INTO '||vschema||'.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
     VALUES (8, ''Invalid'')';
  
  -- Inserting default TTV_STRATEGYCLASS data
    EXECUTE 'INSERT INTO '||vschema||'.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
     VALUES(1, ''XPort Initialization'', ''Initializes the XPort Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.initialization.XPortInitializationStrategy'', 1, now(), now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
     VALUES(2, ''VTPS Ping HeartBeat'', ''Sends periodic Ping messages to the VTPS Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.VTPSHeartBeatStrategy'', 2, now(), now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
     VALUES(3, ''Default Resource Allocation'', ''Allocates resources within the Resource Group'', ''com.tandbergtv.workflow.resourcemanager.mgmt.allocation.DefaultResourceAllocationStrategy'', 3, now(), now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
     VALUES(5, ''Round Robin Resource Allocation'', ''Allocates resources within the Resource Group using Round Robin'', ''com.tandbergtv.workflow.resourcemanager.mgmt.allocation.RoundRobinResourceAllocationStrategy'', 3, now(), now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
     VALUES(6, ''Anystream Transcode Initialization'', ''Initializes the Anystream Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.initialization.AnystreamInitializationStrategy'', 1, now(), now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
     VALUES(7, ''Webservice HeartBeat'', ''HeartBeats for any subsystem that interfaces with a Webservice'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.WebserviceHeartBeatStrategy'', 2, now(), now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
     VALUES(8, ''XPort HeartBeat'', ''HeartBeats for XPort producer'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.XPortHeartBeatStrategy'', 2, now(), now())';
  
    EXECUTE 'INSERT INTO '||vschema||'.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
     VALUES(9, ''Anystream Heartbeat'', ''Heartbeats for Anystream Agility Transcoder'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.AnystreamHeartBeatStrategy'', 2, now(), now())';
  
      -- Insert Default TTV_TRANSITIONTYPE   
    EXECUTE 'Insert Into '||vschema||'.TTV_TRANSITIONTYPE(TRANSITIONTYPEID, NAME,CREATEDATE,UPDATEDATE) 
     Values(1,''JBPM Standard Transition'',current_timestamp,current_timestamp)';
  
    EXECUTE 'Insert into '||vschema||'.TTV_TRANSITIONTYPE(TRANSITIONTYPEID, NAME,CREATEDATE,UPDATEDATE)
     Values(2,''TTV Transition'',current_timestamp,current_timestamp)';
          
  
    -- Creating Foreign Key on JBPM_ACTION
     vsql := 'ALTER TABLE '||vschema||'.JBPM_ACTION ADD CONSTRAINT JBPM_ACTION_JBPM_ACTION1 FOREIGN KEY (TIMERACTION_) 
               REFERENCES '||vschema||'.JBPM_ACTION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_ACTION1 for JBPM_ACTION') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_ACTION ADD CONSTRAINT JBPM_ACTION_JBPM_ACTION2  FOREIGN KEY (REFERENCEDACTION_) 
               REFERENCES '||vschema||'.JBPM_ACTION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_ACTION2 for JBPM_ACTION') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_ACTION ADD CONSTRAINT JBPM_ACTION_JBPM_PDEFINITION FOREIGN KEY (PROCESSDEFINITION_) 
               REFERENCES '||vschema||'.JBPM_PROCESSDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_PDEFINITION for JBPM_ACTION') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_ACTION ADD CONSTRAINT JBPM_ACTION_JBPM_EHANDLER FOREIGN KEY (EXCEPTIONHANDLER_) 
               REFERENCES '||vschema||'.JBPM_EXCEPTIONHANDLER (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_EHANDLER for JBPM_ACTION') INTO tmp_result;
    
     vsql := 'ALTER TABLE '||vschema||'.JBPM_ACTION ADD CONSTRAINT JBPM_ACTION_JBPM_EVENT FOREIGN KEY (EVENT_) 
               REFERENCES '||vschema||'.JBPM_EVENT (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_EVENT for JBPM_ACTION') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_ACTION ADD CONSTRAINT JBPM_ACTION_JBPM_DELEGATION FOREIGN KEY (ACTIONDELEGATION_) 
               REFERENCES '||vschema||'.JBPM_DELEGATION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_DELEGATION for JBPM_ACTION') INTO tmp_result; 
  
    -- Creating Foreign Key on JBPM_BYTEARRAY
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_BYTEARRAY ADD CONSTRAINT JBPM_BYTEARRAY_JBPM_MDEFINITN FOREIGN KEY (FILEDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_MODULEDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_BYTEARRAY') INTO tmp_result; 
  
    -- Creating Foreign Key on JBPM_BYTEBLOCK
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_BYTEBLOCK ADD CONSTRAINT JBPM_BYTEBLOCK_JBPM_BYTEARRAY  FOREIGN KEY (PROCESSFILE_) 
                REFERENCES '||vschema||'.JBPM_BYTEARRAY (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_BYTEBLOCK') INTO tmp_result;             
  
    -- Creating Foreign Key on JBPM_DELEGATION
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_DELEGATION ADD CONSTRAINT JBPM_DELEGATION_JBPM_PDEF  FOREIGN KEY (PROCESSDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_PROCESSDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_DELEGATION') INTO tmp_result; 

    -- Creating Foreign Key on JBPM_EVENT
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_EVENT ADD CONSTRAINT JBPM_EVENT_JBPM_TRANSITION FOREIGN KEY (TRANSITION_) 
                REFERENCES '||vschema||'.JBPM_TRANSITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_TRANSITION for JBPM_EVENT') INTO tmp_result;
         
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_EVENT ADD CONSTRAINT JBPM_EVENT_JBPM_TASK FOREIGN KEY (TASK_) 
                REFERENCES '||vschema||'.JBPM_TASK (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_TASK for JBPM_EVENT') INTO tmp_result;
     
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_EVENT ADD CONSTRAINT JBPM_EVENT_JBPM_PDEFINITION FOREIGN KEY (PROCESSDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_PROCESSDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_PDEFINITION for JBPM_EVENT') INTO tmp_result; 

    -- Creating Foreign Key on JBPM_ID_GROUP
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_ID_GROUP ADD CONSTRAINT JBPM_ID_GROUP_JBPM_ID_GROUP FOREIGN KEY (PARENT_) 
                REFERENCES '||vschema||'.JBPM_ID_GROUP (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_ID_GROUP for JBPM_ID_GROUP') INTO tmp_result; 

    -- Creating Foreign Key on JBPM_ID_MEMBERSHIP
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_ID_MEMBERSHIP ADD CONSTRAINT JBPM_ID_MEMBERSHIP_JBPM_ID_USR FOREIGN KEY (USER_) 
                REFERENCES '||vschema||'.JBPM_ID_USER (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_ID_USR for JBPM_ID_MEMBERSHIP') INTO tmp_result; 

     vsql :=  'ALTER TABLE '||vschema||'.JBPM_ID_MEMBERSHIP ADD CONSTRAINT JBPM_ID_MEMBERSHIP_JBPM_ID_GRP FOREIGN KEY (GROUP_) 
                REFERENCES '||vschema||'.JBPM_ID_GROUP (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_ID_GRP for JBPM_ID_MEMBERSHIP') INTO tmp_result; 

    -- Creating Foreign Key on JBPM_MODULEDEFINITION
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_MODULEDEFINITION ADD CONSTRAINT JBPM_MDEFINITION_JBPM_TASK FOREIGN KEY (STARTTASK_) 
                REFERENCES '||vschema||'.JBPM_TASK (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_TASK for JBPM_MODULEDEFINITION') INTO tmp_result; 
    
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_MODULEDEFINITION ADD CONSTRAINT JBPM_MDEFINITION_JBPM_PDEF FOREIGN KEY (PROCESSDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_PROCESSDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_PDEF for JBPM_MODULEDEFINITION') INTO tmp_result; 

    -- Creating Foreign Key on JBPM_NODE
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_NODE ADD CONSTRAINT JBPM_NODE_JBPM_PDEFINITION1 FOREIGN KEY (SUBPROCESSDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_PROCESSDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_PDEFINITION1 for JBPM_NODE') INTO tmp_result; 

     vsql :=  'ALTER TABLE '||vschema||'.JBPM_NODE ADD CONSTRAINT JBPM_NODE_JBPM_NODE FOREIGN KEY (SUPERSTATE_) 
                REFERENCES '||vschema||'.JBPM_NODE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_NODE for JBPM_NODE') INTO tmp_result; 

     vsql :=  'ALTER TABLE '||vschema||'.JBPM_NODE ADD CONSTRAINT JBPM_NODE_JBPM_PDEFINITION2 FOREIGN KEY (PROCESSDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_PROCESSDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_PDEFINITION2 for JBPM_NODE') INTO tmp_result; 

     vsql :=  'ALTER TABLE '||vschema||'.JBPM_NODE ADD CONSTRAINT JBPM_NODE_JBPM_ACTION FOREIGN KEY (ACTION_) 
                REFERENCES '||vschema||'.JBPM_ACTION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_ACTION for JBPM_NODE') INTO tmp_result; 

     vsql :=  'ALTER TABLE '||vschema||'.JBPM_NODE ADD CONSTRAINT JBPM_NODE_TTV_RESOURCEGROUP FOREIGN KEY (RESOURCEGROUPID) 
                REFERENCES '||vschema||'.TTV_RESOURCEGROUP (RESOURCEGROUPID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_RESOURCEGROUP for JBPM_NODE') INTO tmp_result; 

     vsql :=  'ALTER TABLE '||vschema||'.JBPM_NODE ADD CONSTRAINT JBPM_NODE_JBPM_DELEGATION FOREIGN KEY (DECISIONDELEGATION) 
                REFERENCES '||vschema||'.JBPM_DELEGATION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_DELEGATION for JBPM_NODE') INTO tmp_result; 
  
    -- Creating Foreign Key on JBPM_POOLEDACTOR
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_POOLEDACTOR ADD CONSTRAINT JBPM_POOLACTR_JBPM_SLINSTANCE FOREIGN KEY (SWIMLANEINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_SWIMLANEINSTANCE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_POOLEDACTOR') INTO tmp_result; 
  
    -- Creating Foreign Key on JBPM_PROCESSDEFINITION
     vsql := 'ALTER TABLE '||vschema||'.JBPM_PROCESSDEFINITION ADD CONSTRAINT JBPM_PDEFINITION_TTV_PDEFTYPE FOREIGN KEY (PROCESSDEFINITIONTYPEID) 
                REFERENCES '||vschema||'.TTV_PROCESSDEFINITIONTYPE (PROCESSDEFINITIONTYPEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_PDEFTYPE for JBPM_PROCESSDEFINITION') INTO tmp_result; 

    -- Creating Foreign Key on JBPM_RUNTIMEACTION
     vsql := 'ALTER TABLE '||vschema||'.JBPM_RUNTIMEACTION ADD CONSTRAINT JBPM_RUNTIMEACTION_JBPM_ACTION FOREIGN KEY (ACTION_) 
                REFERENCES '||vschema||'.JBPM_ACTION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_ACTION for JBPM_RUNTIMEACTION') INTO tmp_result; 

    -- Creating Foreign Key on JBPM_SWIMLANE
     vsql := 'ALTER TABLE '||vschema||'.JBPM_SWIMLANE ADD CONSTRAINT JBPM_SWIMLANE_JBPM_MDEFINITION FOREIGN KEY (TASKMGMTDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_MODULEDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_MDEFINITION for JBPM_SWIMLANE') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_SWIMLANE ADD CONSTRAINT JBPM_SWIMLANE_JBPM_DELEGATION FOREIGN KEY (ASSIGNMENTDELEGATION_) 
                REFERENCES '||vschema||'.JBPM_DELEGATION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_DELEGATION for JBPM_SWIMLANE') INTO tmp_result; 
  
    -- Creating Foreign Key on JBPM_TASK
     vsql := 'ALTER TABLE '||vschema||'.JBPM_TASK ADD CONSTRAINT JBPM_TASK_JBPM_TASKCONTROLLER FOREIGN KEY (TASKCONTROLLER_) 
                REFERENCES '||vschema||'.JBPM_TASKCONTROLLER (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_TASKCONTROLLER for JBPM_TASK') INTO tmp_result; 

     vsql := 'ALTER TABLE '||vschema||'.JBPM_TASK ADD CONSTRAINT JBPM_TASK_JBPM_MDEFINITION FOREIGN KEY (TASKMGMTDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_MODULEDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_MDEFINITION for JBPM_TASK') INTO tmp_result; 

     vsql := 'ALTER TABLE '||vschema||'.JBPM_TASK ADD CONSTRAINT JBPM_TASK_JBPM_SWIMLANE FOREIGN KEY (SWIMLANE_) 
                REFERENCES '||vschema||'.JBPM_SWIMLANE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_SWIMLANE for JBPM_TASK') INTO tmp_result; 

     vsql := 'ALTER TABLE '||vschema||'.JBPM_TASK ADD CONSTRAINT JBPM_TASK_JBPM_PDEFINITION FOREIGN KEY (PROCESSDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_PROCESSDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_PDEFINITION for JBPM_TASK') INTO tmp_result; 

     vsql := 'ALTER TABLE '||vschema||'.JBPM_TASK ADD CONSTRAINT JBPM_TASK_JBPM_DELEGATION FOREIGN KEY (ASSIGNMENTDELEGATION_) 
                REFERENCES '||vschema||'.JBPM_DELEGATION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_DELEGATION for JBPM_TASK') INTO tmp_result; 

    -- Creating Foreign Key on JBPM_TASKCONTROLLER
     vsql := 'ALTER TABLE '||vschema||'.JBPM_TASKCONTROLLER ADD CONSTRAINT JBPM_TCONTROLR_JBPM_DELEGATION FOREIGN KEY (TASKCONTROLLERDELEGATION_) 
                REFERENCES '||vschema||'.JBPM_DELEGATION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_DELEGATION for JBPM_TASKCONTROLLER') INTO tmp_result; 
  
  -- Creating Foreign Key on JBPM_TRANSITION
     vsql := 'ALTER TABLE '||vschema||'.JBPM_TRANSITION ADD CONSTRAINT JBPM_TRANSITION_JBPM_PDEF FOREIGN KEY (PROCESSDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_PROCESSDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_PDEF for JBPM_TRANSITION') INTO tmp_result; 
  
  -- Creating Foreign Key on JBPM_VARIABLEACCESS
     vsql := 'ALTER TABLE '||vschema||'.JBPM_VARIABLEACCESS ADD CONSTRAINT FK_VARACC_TSKCTRL FOREIGN KEY(TASKCONTROLLER_) 
                REFERENCES '||vschema||'.JBPM_TASKCONTROLLER(ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_VARACC_TSKCTRL for JBPM_VARIABLEACCESS') INTO tmp_result; 

     vsql := 'ALTER TABLE '||vschema||'.JBPM_VARIABLEACCESS ADD CONSTRAINT FK_VARACC_SCRIPT FOREIGN KEY(SCRIPT_) 
                REFERENCES '||vschema||'.JBPM_ACTION(ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_VARACC_SCRIPT for JBPM_VARIABLEACCESS') INTO tmp_result; 

     vsql := 'ALTER TABLE '||vschema||'.JBPM_VARIABLEACCESS ADD CONSTRAINT FK_JBPM_VARIABLEACCESS_VATYPE FOREIGN KEY(VARIABLEACCESSTYPEID) 
                REFERENCES '||vschema||'.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_JBPM_VARIABLEACCESS_VATYPE for JBPM_VARIABLEACCESS') INTO tmp_result; 

     vsql := 'ALTER TABLE '||vschema||'.JBPM_VARIABLEACCESS ADD CONSTRAINT FK_JBPM_VARIABLEACCESS_TYPE FOREIGN KEY(DATATYPEID) 
                REFERENCES '||vschema||'.TTV_DATATYPE(DATATYPEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_JBPM_VARIABLEACCESS_TYPE for JBPM_VARIABLEACCESS') INTO tmp_result; 

    -- Creating Foreign Key on JBPM_LOG
    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_TTV_PSTATUS1 FOREIGN KEY (ADMINISTRATIVESTATUSID) 
                REFERENCES '||vschema||'.TTV_PROCESSSTATUS (PROCESSSTATUSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_PSTATUS1 for JBPM_LOG') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_TTV_PSTATUS2 FOREIGN KEY (OPERATIONALSTATUSID) 
                REFERENCES '||vschema||'.TTV_PROCESSSTATUS (PROCESSSTATUSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_PSTATUS2 for JBPM_LOG') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_TTV_RESOURCE FOREIGN KEY (RESOURCEID) 
                REFERENCES '||vschema||'.TTV_RESOURCE (RESOURCEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_RESOURCE for JBPM_LOG') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_TTV_RESOURCEGROUP FOREIGN KEY (RESOURCEGROUPID) 
                REFERENCES '||vschema||'.TTV_RESOURCEGROUP (RESOURCEGROUPID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_RESOURCEGROUP for JBPM_LOG') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_JBPM_VARIABLEINSTANCE FOREIGN KEY (VARIABLEINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_VARIABLEINSTANCE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_VARIABLEINSTANCE for JBPM_LOG') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_JBPM_TRANSITION FOREIGN KEY (TRANSITION_) 
                REFERENCES '||vschema||'.JBPM_TRANSITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_TRANSITION for JBPM_LOG') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_JBPM_TASKINSTANCE FOREIGN KEY (TASKINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_TASKINSTANCE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_TASKINSTANCE for JBPM_LOG') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_JBPM_SWIMLANEINSTANCE FOREIGN KEY (SWIMLANEINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_SWIMLANEINSTANCE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_SWIMLANEINSTANCE for JBPM_LOG') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_JBPM_LOG1 FOREIGN KEY (PARENT_) 
                REFERENCES '||vschema||'.JBPM_LOG (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_LOG1 for JBPM_LOG') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_JBPM_BYTEARRAY1 FOREIGN KEY (OLDBYTEARRAY_) 
                REFERENCES '||vschema||'.JBPM_BYTEARRAY (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_BYTEARRAY1 for JBPM_LOG') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_JBPM_BYTEARRAY2 FOREIGN KEY (NEWBYTEARRAY_) 
                REFERENCES '||vschema||'.JBPM_BYTEARRAY (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_BYTEARRAY2 for JBPM_LOG') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.JBPM_LOG ADD CONSTRAINT JBPM_LOG_JBPM_ACTION FOREIGN KEY (ACTION_) 
                REFERENCES '||vschema||'.JBPM_ACTION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_ACTION for JBPM_LOG') INTO tmp_result; 
    
    -- Creating Foreign Key on JBPM_MODULEINSTANCE    
    vsql :=      'ALTER TABLE '||vschema||'.JBPM_MODULEINSTANCE ADD CONSTRAINT JBPM_MINSTANCE_JBPM_MDEF FOREIGN KEY (TASKMGMTDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_MODULEDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_MDEF for JBPM_MODULEINSTANCE') INTO tmp_result;    
        
     vsql := 'ALTER TABLE '||vschema||'.JBPM_PROCESSINSTANCE ADD CONSTRAINT JBPM_PINSTANCE_TTV_PPRIORITY FOREIGN KEY (PROCESSPRIORITYID) 
                REFERENCES '||vschema||'.TTV_PROCESSPRIORITY (PROCESSPRIORITYID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_PPRIORITY for JBPM_PROCESSINSTANCE') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_PROCESSINSTANCE ADD CONSTRAINT JBPM_PINSTANCE_JBPM_TOKEN1 FOREIGN KEY (SUPERPROCESSTOKEN_) 
                REFERENCES '||vschema||'.JBPM_TOKEN (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_TOKEN1 for JBPM_PROCESSINSTANCE') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_PROCESSINSTANCE ADD CONSTRAINT JBPM_PINSTANCE_JBPM_PDEF FOREIGN KEY (PROCESSDEFINITION_) 
                REFERENCES '||vschema||'.JBPM_PROCESSDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_PDEF for JBPM_PROCESSINSTANCE') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_PROCESSINSTANCE ADD CONSTRAINT JBPM_PINSTANCE_TTV_PSTATUS1 FOREIGN KEY (OPERATIONALPROCESSSTATUSID) 
                REFERENCES '||vschema||'.TTV_PROCESSSTATUS (PROCESSSTATUSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_PSTATUS1 for JBPM_PROCESSINSTANCE') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_PROCESSINSTANCE ADD CONSTRAINT JBPM_PINSTANCE_TTV_PSTATUS2 FOREIGN KEY (ADMINISTRATIVEPROCESSSTATUSID) 
                REFERENCES '||vschema||'.TTV_PROCESSSTATUS (PROCESSSTATUSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_PSTATUS2 for JBPM_PROCESSINSTANCE') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_PROCESSINSTANCE ADD CONSTRAINT JBPM_PINSTANCE_TTV_PINSTTYPE FOREIGN KEY (PROCESSINSTANCETYPEID) 
                REFERENCES '||vschema||'.TTV_PROCESSINSTANCETYPE (PROCESSINSTANCETYPEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_PINSTTYPE for JBPM_PROCESSINSTANCE') INTO tmp_result;
    
  -- Creating Foreign Key on JBPM_TOKEN
    vsql := 'ALTER TABLE '||vschema||'.JBPM_TOKEN ADD CONSTRAINT FK_TOKEN_SUBPI FOREIGN KEY(SUBPROCESSINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_PROCESSINSTANCE(ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_TOKEN_SUBPI for JBPM_TOKEN') INTO tmp_result;

    vsql := 'ALTER TABLE '||vschema||'.JBPM_TOKEN ADD CONSTRAINT FK_TOKEN_PROCINST FOREIGN KEY(PROCESSINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_PROCESSINSTANCE(ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_TOKEN_PROCINST for JBPM_TOKEN') INTO tmp_result;

    vsql := 'ALTER TABLE '||vschema||'.JBPM_TOKEN ADD CONSTRAINT FK_TOKEN_PARENT FOREIGN KEY(PARENT_) 
                REFERENCES '||vschema||'.JBPM_TOKEN(ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_TOKEN_PARENT for JBPM_TOKEN') INTO tmp_result;

    vsql := 'ALTER TABLE '||vschema||'.JBPM_TOKEN ADD CONSTRAINT FK_TOKEN_NODE FOREIGN KEY(NODE_) 
                REFERENCES '||vschema||'.JBPM_NODE(ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_TOKEN_NODE for JBPM_TOKEN') INTO tmp_result;

    vsql := 'ALTER TABLE '||vschema||'.JBPM_TOKEN ADD CONSTRAINT FK_JBPM_TOKEN_TTV_TOKENTYPE FOREIGN KEY(TOKENTYPEID) 
                REFERENCES '||vschema||'.TTV_TOKENTYPE(TOKENTYPEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_JBPM_TOKEN_TTV_TOKENTYPE for JBPM_TOKEN') INTO tmp_result;

    vsql := 'ALTER TABLE '||vschema||'.JBPM_TOKEN ADD Constraint FK_TOKEN_PROCESSSTATUS_OPER Foreign Key(OPERATIONALSTATUS) 
                REFERENCES '||vschema||'.TTV_PROCESSSTATUS(PROCESSSTATUSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key PROCESSSTATUS_OPER for JBPM_TOKEN') INTO tmp_result;

    vsql := 'ALTER TABLE '||vschema||'.JBPM_TOKEN ADD Constraint FK_TOKEN_PROCESSSTATUS_ADMIN Foreign Key(ADMINISTRATIVESTATUS) 
                REFERENCES '||vschema||'.TTV_PROCESSSTATUS(PROCESSSTATUSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key PROCESSSTATUS_ADMIN for JBPM_TOKEN') INTO tmp_result;
    
  -- Create Foreign Key on JBPM_TOKENVARIABLEMAP
     vsql := 'ALTER TABLE '||vschema||'.JBPM_TOKENVARIABLEMAP ADD CONSTRAINT FK_TKVARMAP_CTXT FOREIGN KEY(CONTEXTINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_MODULEINSTANCE(ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_TKVARMAP_CTXT for JBPM_TOKENVARIABLEMAP') INTO tmp_result; 
    
  -- Creating Foreign Key on JBPM_VARIABLEINSTANCE
    vsql := 'ALTER TABLE '||vschema||'.JBPM_VARIABLEINSTANCE ADD CONSTRAINT FK_VAR_TSKINST FOREIGN KEY(TASKINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_TASKINSTANCE(ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_VAR_TSKINST for JBPM_VARIABLEINSTANCE') INTO tmp_result; 

    vsql := 'ALTER TABLE '||vschema||'.JBPM_VARIABLEINSTANCE ADD CONSTRAINT FK_VARINST_TKVARMP FOREIGN KEY(TOKENVARIABLEMAP_) 
                REFERENCES '||vschema||'.JBPM_TOKENVARIABLEMAP(ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_VARINST_TKVARMP for JBPM_VARIABLEINSTANCE') INTO tmp_result; 

    vsql := 'ALTER TABLE '||vschema||'.JBPM_VARIABLEINSTANCE ADD CONSTRAINT FK_BYTEINST_ARRAY FOREIGN KEY(BYTEARRAYVALUE_) 
                REFERENCES '||vschema||'.JBPM_BYTEARRAY(ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_BYTEINST_ARRAY for JBPM_VARIABLEINSTANCE') INTO tmp_result; 

 -- Creating Foreign Key on TTV_MESSAGELOG
     vsql := 'ALTER TABLE '||vschema||'.TTV_MESSAGELOG ADD CONSTRAINT TTV_MESSAGELOG_TTV_RESOURCE FOREIGN KEY (RESOURCEID) 
                REFERENCES '||vschema||'.TTV_RESOURCE (RESOURCEID)';
    SELECT CREATEOBJECT(VSQL,'Unable to create foreign Key TTV_RESOURCE for TTV_MESSAGELOG') INTO tmp_result; 
      vsql := 'ALTER TABLE '||vschema||'.TTV_MESSAGELOG ADD CONSTRAINT TTV_MESSAGELOG_JBPM_LOG FOREIGN KEY (LOGID) 
                REFERENCES '||vschema||'.JBPM_LOG (ID_)';
    SELECT CREATEOBJECT(VSQL,'Unable to create foreign Key JBPM_LOG for TTV_MESSAGELOG') INTO tmp_result; 

    -- Creating Foreign Key on TTV_PROCESSINSTANCENOTE
     vsql :=     'ALTER TABLE '||vschema||'.TTV_PROCESSINSTANCENOTE ADD CONSTRAINT TTV_PINSTANCENOTE_JBPM_PINST FOREIGN KEY (PROCESSINSTANCEID) 
                REFERENCES '||vschema||'.JBPM_PROCESSINSTANCE (ID_)';
    SELECT CREATEOBJECT(VSQL,'Unable to create foreign Keys for TTV_PROCESSINSTANCENOTE') INTO tmp_result;

     --Partioning: Disabling FK linkage b/w JBPM_SWIMLANEINSTANCE and JBPM_MODULEINSTANCE
     -- Creating Foreign Key on JBPM_SWIMLANEINSTANCE
     vsql := 'ALTER TABLE '||vschema||'.JBPM_SWIMLANEINSTANCE ADD CONSTRAINT JBPM_SLINSTANCE_JBPM_MINSTANCE FOREIGN KEY (TASKMGMTINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_MODULEINSTANCE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_MINSTANCE for JBPM_SWIMLANEINSTANCE') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_SWIMLANEINSTANCE ADD CONSTRAINT JBPM_SLINSTANCE_JBPM_SWIMLANE FOREIGN KEY (SWIMLANE_) 
                REFERENCES '||vschema||'.JBPM_SWIMLANE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_SWIMLANE for JBPM_SWIMLANEINSTANCE') INTO tmp_result; 
    
    --Partioning: Disabling FK linkage b/w JBPM_MESSAGE and JBPM_TASKINSTANCE
    -- Creating Foreign Key on JBPM_MESSAGE
     vsql :=  'ALTER TABLE '||vschema||'.JBPM_MESSAGE ADD CONSTRAINT JBPM_MESSAGE_JBPM_TASKINSTANCE FOREIGN KEY (TASKINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_TASKINSTANCE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_TASKINSTANCE for JBPM_MESSAGE') INTO tmp_result;

     vsql :=  'ALTER TABLE '||vschema||'.JBPM_MESSAGE ADD CONSTRAINT JBPM_MESSAGE_JBPM_ACTION FOREIGN KEY (ACTION_) 
                REFERENCES '||vschema||'.JBPM_ACTION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_ACTION for JBPM_MESSAGE') INTO tmp_result; 

    --Partioning: Disabling FK linkage b/w JBPM_TIMER and JBPM_TASKINSTANCE
    -- Creating Foreign Key on JBPM_TIMER
     vsql := 'ALTER TABLE '||vschema||'.JBPM_TIMER ADD CONSTRAINT JBPM_TIMER_JBPM_TINSTANCE FOREIGN KEY (TASKINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_TASKINSTANCE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_TINSTANCE for JBPM_TIMER') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_TIMER ADD CONSTRAINT JBPM_TIMER_JBPM_ACTION FOREIGN KEY (ACTION_) 
                REFERENCES '||vschema||'.JBPM_ACTION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_ACTION for JBPM_TIMER') INTO tmp_result;

    --Partioning: Disabling FK linkage b/w JBPM_TASKACTORPOOL and JBPM_TASKINSTANCE
    -- Creating Foreign Key on JBPM_TASKACTORPOOL
     vsql := 'ALTER TABLE '||vschema||'.JBPM_TASKACTORPOOL ADD CONSTRAINT JBPM_TACTRPOOL_JBPM_POOLEDACTR FOREIGN KEY (POOLEDACTOR_) 
                REFERENCES '||vschema||'.JBPM_POOLEDACTOR (ID_)';
    SELECT CREATEOBJECT(VSQL,'Unable to create foreign Key JBPM_POOLEDACTR for JBPM_TASKACTORPOOL') INTO tmp_result; 

     vsql := 'ALTER TABLE '||vschema||'.JBPM_TASKACTORPOOL ADD CONSTRAINT JBPM_TACTRPOOL__JBPM_TINSTANCE FOREIGN KEY (TASKINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_TASKINSTANCE (ID_)';
    SELECT CREATEOBJECT(VSQL,'Unable to create foreign Key JBPM_TINSTANCE for JBPM_TASKACTORPOOL') INTO tmp_result; 
        
    -- Creating Foreign Key on JBPM_TASKINSTANCE
     vsql := 'ALTER TABLE '||vschema||'.JBPM_TASKINSTANCE ADD CONSTRAINT JBPM_TINSTANCE_JBPM_MINSTANCE FOREIGN KEY (TASKMGMTINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_MODULEINSTANCE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_MINSTANCE for JBPM_TASKINSTANCE') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_TASKINSTANCE ADD CONSTRAINT JBPM_TINSTANCE_JBPM_TASK FOREIGN KEY (TASK_) 
                REFERENCES '||vschema||'.JBPM_TASK (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_TASK for JBPM_TASKINSTANCE') INTO tmp_result;

     vsql := 'ALTER TABLE '||vschema||'.JBPM_TASKINSTANCE ADD CONSTRAINT JBPM_TINSTANCE_JBPM_SLINSTANCE FOREIGN KEY (SWIMLANINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_SWIMLANEINSTANCE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_SLINSTANCE for JBPM_TASKINSTANCE') INTO tmp_result;  
        
        -- Creating Foreign Key on JBPM_COMMENT
    VSQL :=  'ALTER TABLE '||vschema||'.JBPM_COMMENT ADD CONSTRAINT JBPM_COMMENT_JBPM_TASKINSTANCE FOREIGN KEY (TASKINSTANCE_) 
                REFERENCES '||vschema||'.JBPM_TASKINSTANCE (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_TASKINSTANCE for JBPM_COMMENT') INTO tmp_result; 

    -- Creating Foreign Key on TTV_MONITOREDDRIVE
     vsql := 'ALTER TABLE '||vschema||'.TTV_MONITOREDDRIVE ADD CONSTRAINT TTV_MDRIVE_TTV_MDRIVESTATUS FOREIGN KEY (CURRENTDRIVESTATUSID) 
                REFERENCES '||vschema||'.TTV_MONITOREDDRIVESTATUS (MONITOREDDRIVESTATUSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_MONITOREDDRIVE') INTO tmp_result; 

     vsql := 'ALTER TABLE '||vschema||'.TTV_MONITOREDDRIVE ADD CONSTRAINT TTV_MDRIVE_TTV_RESOURCE FOREIGN KEY (RESOURCEID) 
                REFERENCES '||vschema||'.TTV_RESOURCE (RESOURCEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_MONITOREDDRIVE') INTO tmp_result; 

    -- Creating Foreign Key on TTV_MONITOREDDRIVEHISTORY
     vsql := 'ALTER TABLE '||vschema||'.TTV_MONITOREDDRIVEHISTORY ADD CONSTRAINT TTV_MDRIVEHIST_TTV_MDRIVE FOREIGN KEY (MONITOREDDRIVEID) 
                REFERENCES '||vschema||'.TTV_MONITOREDDRIVE (MONITOREDDRIVEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_MONITOREDDRIVEHISTORY') INTO tmp_result; 

  
    -- Creating Foreign Key on TTV_PROCDEFACCESSLEVEL
     vsql :=     'ALTER TABLE '||vschema||'.TTV_PROCDEFACCESSLEVEL ADD CONSTRAINT TTV_PROCDEFALEVEL_TTV_ALEVEL FOREIGN KEY (ACCESSLEVELID) 
                REFERENCES '||vschema||'.TTV_ACCESSLEVEL (ACCESSLEVELID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_ALEVEL for TTV_PROCDEFACCESSLEVEL') INTO tmp_result;

     vsql :=     'ALTER TABLE '||vschema||'.TTV_PROCDEFACCESSLEVEL ADD CONSTRAINT TTV_PDEFALEVEL_JBPM_PDEF FOREIGN KEY (PROCESSDEFINITIONID) 
                REFERENCES '||vschema||'.JBPM_PROCESSDEFINITION (ID_)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key JBPM_PDEF for TTV_PROCDEFACCESSLEVEL') INTO tmp_result;

    -- Creating Foreign Key on TTV_RESOURCE
     vsql :=   'ALTER TABLE '||vschema||'.TTV_RESOURCE ADD CONSTRAINT TTV_RESOURCE_TTV_RTYPE FOREIGN KEY (RESOURCETYPEID) 
                REFERENCES '||vschema||'.TTV_RESOURCETYPE (RESOURCETYPEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_RTYPE for TTV_RESOURCE') INTO tmp_result; 

     vsql :=   'ALTER TABLE '||vschema||'.TTV_RESOURCE ADD CONSTRAINT TTV_RESOURCE_TTV_RSTATUS1 FOREIGN KEY (OPERATIONALRESOURCESTATUSID) 
                REFERENCES '||vschema||'.TTV_RESOURCESTATUS (RESOURCESTATUSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_RSTATUS1 for TTV_RESOURCE') INTO tmp_result; 

     vsql :=   'ALTER TABLE '||vschema||'.TTV_RESOURCE ADD CONSTRAINT TTV_RESOURCE_TTV_RSTATUS2 FOREIGN KEY (ADMINISTRATIVERESOURCESTATUSID) 
                REFERENCES '||vschema||'.TTV_RESOURCESTATUS (RESOURCESTATUSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_RSTATUS2 for TTV_RESOURCE') INTO tmp_result; 
  
    -- Creating Foreign Key on TTV_RESOURCEGROUP
     vsql :=   'ALTER TABLE '||vschema||'.TTV_RESOURCEGROUP ADD CONSTRAINT TTV_RESOURCEGROUP_TTV_ALEVEL FOREIGN KEY (ACCESSLEVELID) 
                REFERENCES '||vschema||'.TTV_ACCESSLEVEL (ACCESSLEVELID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_ALEVEL for TTV_RESOURCEGROUP') INTO tmp_result; 

     vsql :=   'ALTER TABLE '||vschema||'.TTV_RESOURCEGROUP ADD CONSTRAINT TTV_RESOURCEGROUP_TTV_SGYCLASS FOREIGN KEY (ALLOCATIONSTRATEGYCLASSID) 
                REFERENCES '||vschema||'.TTV_STRATEGYCLASS (STRATEGYCLASSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_SGYCLASS for TTV_RESOURCEGROUP') INTO tmp_result; 

     vsql :=   'ALTER TABLE '||vschema||'.TTV_RESOURCEGROUP ADD CONSTRAINT TTV_RESOURCEGROUP_TTV_RTYPE FOREIGN KEY (RESOURCETYPEID) 
                REFERENCES '||vschema||'.TTV_RESOURCETYPE (RESOURCETYPEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_RTYPE for TTV_RESOURCEGROUP') INTO tmp_result; 

    -- Creating Foreign Key on TTV_RESOURCEGROUPMEMBERSHIP
     vsql :=   'ALTER TABLE '||vschema||'.TTV_RESOURCEGROUPMEMBERSHIP ADD CONSTRAINT TTV_RGRPMBRSHIP_TTV_RGROUP FOREIGN KEY (RESOURCEGROUPID) 
                REFERENCES '||vschema||'.TTV_RESOURCEGROUP (RESOURCEGROUPID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_RGROUP for TTV_RESOURCEGROUPMEMBERSHIP') INTO tmp_result; 

     vsql :=   'ALTER TABLE '||vschema||'.TTV_RESOURCEGROUPMEMBERSHIP ADD CONSTRAINT TTV_RGRPMBRSHIP_TTV_RESOURCE FOREIGN KEY (RESOURCEID) 
                REFERENCES '||vschema||'.TTV_RESOURCE (RESOURCEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_RESOURCE for TTV_RESOURCEGROUPMEMBERSHIP') INTO tmp_result; 

    -- Creating Foreign Key on TTV_RESOURCETYPE
     vsql :=     'ALTER TABLE '||vschema||'.TTV_RESOURCETYPE ADD CONSTRAINT TTV_RESOURCETYPE_TTV_SGYCLASS1 FOREIGN KEY (INITIALIZATIONSTRATEGYCLASSID) 
                REFERENCES '||vschema||'.TTV_STRATEGYCLASS (STRATEGYCLASSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_SGYCLASS1 for TTV_RESOURCETYPE') INTO tmp_result; 

     vsql :=     'ALTER TABLE '||vschema||'.TTV_RESOURCETYPE ADD CONSTRAINT TTV_RESOURCETYPE_TTV_SGYCLASS2 FOREIGN KEY (HEARTBEATSTRATEGYCLASSID) 
                REFERENCES '||vschema||'.TTV_STRATEGYCLASS (STRATEGYCLASSID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_SGYCLASS2 for TTV_RESOURCETYPE') INTO tmp_result; 

     vsql :=     'ALTER TABLE '||vschema||'.TTV_RESOURCETYPE ADD CONSTRAINT TTV_RESOURCETYPE_TTV_CTYPE1 FOREIGN KEY (HEARTBEATCONNECTIONTYPEID) 
                REFERENCES '||vschema||'.TTV_CONNECTIONTYPE (CONNECTIONTYPEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_CTYPE1 for TTV_RESOURCETYPE') INTO tmp_result; 

     vsql :=     'ALTER TABLE '||vschema||'.TTV_RESOURCETYPE ADD CONSTRAINT TTV_RESOURCETYPE_TTV_CTYPE2 FOREIGN KEY (RESOURCECONNECTIONTYPEID) 
                REFERENCES '||vschema||'.TTV_CONNECTIONTYPE (CONNECTIONTYPEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Key TTV_CTYPE2 for TTV_RESOURCETYPE') INTO tmp_result; 

    -- Creating Foreign Key on TTV_STRATEGYCLASS
     vsql :=   'ALTER TABLE '||vschema||'.TTV_STRATEGYCLASS ADD CONSTRAINT TTV_SGYCLASS_TTV_SGYCLASSTYPE FOREIGN KEY (STRATEGYCLASSTYPEID) 
                REFERENCES '||vschema||'.TTV_STRATEGYCLASSTYPE (STRATEGYCLASSTYPEID)';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_STRATEGYCLASS') INTO tmp_result; 

   -- Creating Foreign Key on TTV_SELECTOR
     vsql :=     'ALTER TABLE '||vschema||'.TTV_SELECTOR ADD CONSTRAINT TTV_SELECTOR_JBPM_PROCESSDEF FOREIGN KEY(PROCESSDEFINITIONID) 
                REFERENCES '||vschema||'.JBPM_PROCESSDEFINITION(ID_)'; 
               --'ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE VALIDATE';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_SELECTOR') INTO tmp_result; 
      
      -- Create Foreign Key on JBPM_TRANSITION
     vsql := 'ALTER TABLE '||vschema||'.JBPM_TRANSITION ADD CONSTRAINT FK_JBPM_TRANS_TTV_TRANSTYPE FOREIGN KEY(TRANSITIONTYPEID) 
                REFERENCES '||vschema||'.TTV_TRANSITIONTYPE(TRANSITIONTYPEID)';
               --'ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE VALIDATE';
    SELECT CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TRANSITION') INTO tmp_result; 

  /*
  ----------------------------------------
     ADD TABLE AND COLUMN COMMNETS
  ----------------------------------------
  */
  -- Adding Comment on the JBPM_PROCESSDEFINITION table
     vsql := 'COMMENT ON TABLE '||vschema||'.JBPM_PROCESSDEFINITION IS ''Stores general information about the process definition. Foreign Keys Node table - Start-state node in the process''';
    SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_PROCESSDEFINITION table') INTO tmp_result; 

  -- Adding comment on the JBPM_NODE table
     vsql := 'COMMENT ON TABLE '||vschema||'.JBPM_NODE IS ''Stores definition information about a node in a process definition.
                Foreign Keys
                Process Definition table - The process definition that the node belongs to 
                Process Definition table - Specify that this node calls a sub process. The sub process would complete execution before the parent process leaves this node
                Action table - Specify an action class to be executed for the node
                Node table - Specify that this node belongs to a superstate. Multiple nodes can belong to a superstate
                Delegation table - Specify that a decision has been delegated to a class''';
    SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_NODE table') INTO tmp_result; 
  
  -- Adding comment on the JBPM_TRANSITION table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_TRANSITION IS ''Stores definition information about a transition in a process definition. 
              Foreign Keys
              Process Definition table - Specify the definition that the transition belongs to
              Node table - Specify the node that starts the transition
              Node table - Specify the node that the transition ends on''';
    SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TRANSITION table') INTO tmp_result; 
 
  -- Adding comment on the JBPM_ACTION table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_ACTION IS ''Stores definition information about an action in a process definition.
              Foreign Keys 
              Process Definition table - Specify the definition that the action belongs to
              Event table - Specify the event that triggers the action
              Delegation table - Specify the action is delegated to
              ExceptionHandler? table - Specify the exception handler class for this action
              Action table - Specify the action is referenced by another action and
              Action table - Specify if there is a timer action''';
    SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ACTION table') INTO tmp_result; 
   
  -- Adding comment on the JBPM_DELEGATION table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_DELEGATION IS ''Stores definition information about Java business classes that are specified in the process definition. 
              Foreign key
              Process Definition table - Specify the process definition that the delegation belongs to.''';
    SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_DELEGATION table') INTO tmp_result; 
 
  -- Adding comment on the JBPM_EVENT table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_EVENT IS ''Stores definition information about an event that triggers an action in the process definition. 
              Foreign Keys Process Definition table - Specify the process definition that the event belongs to
              Node table - Specify the event belongs to a node
              Transition table - Specify the event belongs to a transition
              Task table - Specify the event belongs to a task''';
    SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_EVENT table') INTO tmp_result; 

  -- Adding comment on the JBPM_EXCEPTIONHANDLER table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_EXCEPTIONHANDLER IS ''Stores definition information about an exception handler for an action.''';
    SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_EXEPTIONHANDLER table') INTO tmp_result; 

  -- Adding comment on the JBPM_DECISIONCONDITIONS table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_DECISIONCONDITIONS IS ''Stores definition information about conditions specified in the process definition.''';
    SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_DECISIONCONDITIONS table') INTO tmp_result; 
  
  -- Adding comment on the JBPM_TASK table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_TASK IS ''Stores definition information about tasks defined in the process definition. 
            Foreign Keys
            Process Definition table - Specify the process definition the task belongs to
            Module Definition table - Specify the TaskMgmtDefintion to be used for this task.
            Node table - Specify the node the task belongs to 
            Node table - Specify that this task belongs to the start-state of a process
            Delegation table - Specify the delegation of the task to a class
            Swimlane table - Specify the swimlane that the task uses for assignment
            Task Controller table - Specify the task assignment is delegated to a class''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASK table') INTO tmp_result; 
  
  -- Adding comment on the JBPM_TASKCONTROLLER table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_TASKCONTROLLER IS ''Stores information that refers a task to a delegation class. 
              Foreign key
              Delegation table - Specify the class that is the controller for the task.''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASKCONTROLLER table') INTO tmp_result; 

  -- Adding comment on the JBPM_VARIABLEACCESS table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_VARIABLEACCESS IS ''Stores information about the access levels for each variable associated to a particular node or task
            Foreign keys
            Node table - Specify the node that the variables belong to
            Task Controller table - Specify the task that the variables belong to
            Action table - Specify the action that the variables belong to''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_VARIABLEACCESS table') INTO tmp_result; 

  -- Adding comment on the JBPM_SWIMLANE table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_SWIMLANE IS ''Stores information about the swimlanes defined in the process definition.
              Foreign Keys
              Delegation table - Specify the class that determines assignment for this swimlane
              Module Definition table - All of the swimlanes for a process definition belong to a TaskMgmtDefintion. This is specified in the Module Definition table.''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_SWIMLANE table') INTO tmp_result; 

  -- Adding comment on the JBPM_MODULEDEFINITION table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_MODULEDEFINITION IS ''Stores information about modules used in the process definition
              Foreign Keys
              Process Definition table - Specify the process definition this module is used in
              Task table - Specify the task this module is used in''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_MODULEDEFINITION table') INTO tmp_result; 
  
  -- Adding comment on the JBPM_ID_USER table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_ID_USER IS ''Stores information about users in jBPM''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_USER table') INTO tmp_result; 
  
  -- Adding comment on the JBPM_ID_GROUP table
     vsql :='COMMENT ON TABLE '||vschema||'.JBPM_ID_GROUP IS ''Stores information about groups that users can belong to.
            Foreign Key
            ID Group - Parent/Child relationship between groups.''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_GROUP table') INTO tmp_result; 
  
  -- Adding comment on the JBPM_ID_MEMBERSHIP
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_ID_MEMBERSHIP IS ''Cross reference table storing information about role and which groups a user belongs to.
        Foreign Keys
        ID Users table - Specify the user that belongs to the membership.
        ID Group table - Specify the group the membership belongs to.''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_MEMBERSHIP table') INTO tmp_result; 
 
  -- Adding comment on the JBPM_ID_PERMISSIONS
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_ID_PERMISSIONS IS ''Defines permissions for a user''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_PERMISSIONS table') INTO tmp_result; 
  
  -- Adding comment on the JBPM_PROCESSINSTANCE
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_PROCESSINSTANCE IS ''Stores runtime information about an instance of a process. 
              Foreign keys
              Process Definition table - the process definition to be followed for this process instance execution 
              Token table - the root token that follows where the process execution is currently
              Token table - the super process token (if this process instance was called from another process instance)''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_PROCESSINSTANCE table') INTO tmp_result; 

  -- Adding comment on the JBPM_TOKEN table
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_TOKEN IS ''Stores information about the token representing execution location in the process instance
            Foreign keys
            Process Instance table - the process instance this token belongs to.
            Process Instance table - the sub process instance that the token belongs to.
            Node table - the node that the token points to as the current location of execution.
            Token table - parent/child relationship between tokens for a fork or sub process.''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TOKEN table') INTO tmp_result; 
  
  -- Adding comment on the JBPM_MESSAGE table
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_MESSAGE IS ''Stores messages to create asynchronous processing of nodes.
            Foreign keys
            Token table - token the message belongs to
            Action table - action the message belongs to
            Node table - node the message belongs to
            Task Instance table - task instance the message belongs to''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_MESSAGE table') INTO tmp_result; 
  
  -- Adding comment on JBPM_TASKINSTANCE
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_TASKINSTANCE IS ''Stores runtime information about an instance of a task
              Foreign keys
              Task table - the task that defines the instance
              Token table - the token the task belongs to
              Swimlane Instance table - the swimlane instance used to determine who works this task instance
              Module Instance table - the instance of the module to manage the task''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASKINSTANCE table') INTO tmp_result; 

  -- Adding comment on JBPM_SWIMLANEINSTANCE 
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_SWIMLANEINSTANCE IS ''Stores runtime information about an instance of a swimlane
            Foreign keys
            Swimlane table - the swimlane that defines the instance
            Module Instance table - the instance of the module to manage the task''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_SWIMLANEINSTANCE table') INTO tmp_result; 

  -- Adding comment JBPM_POOLEDACTOR table
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_POOLEDACTOR IS ''Stores a list of actors for a swimlane instance
            Foreign Key 
            Swimlane Instance table - the swimlane instance the actor belongs to''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_POOLEDACTOR table') INTO tmp_result; 
  
  -- Adding comment JBPM_TASKACTORPOOL table 
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_TASKACTORPOOL IS ''Cross reference table between Pooled Actor and Task Instance
              Foreign Keys
              Pooled Actor - Actors for a swimlane instance
              Task Instance - Task the pooled actor belongs to''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASKACTORPOOL table') INTO tmp_result; 

  -- Adding comment JBPM_COMMENT table 
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_COMMENT IS ''tores a comment message related to a token or task instance
              Foreign Keys
              Token table - the token the comment belongs to.
              Task Instance table - the task instance the comment belongs to.''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_COMMENT table') INTO tmp_result; 

  -- Adding comment to JBPM_TOKENVARIABLEMAP table
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_TOKENVARIABLEMAP IS ''Cross reference table between token and module instances for context
            Foreign Keys
            Token table - the token representing the process execution
            Module Instance table - the context module instance for the token''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TOKENVARIABLEMAP table') INTO tmp_result;

  -- Adding comment to JBPM_MODULEINSTANCE table
  
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_MODULEINSTANCE IS ''Stores runtime information about an instance of a module
            Foreign Keys
            Process Instance table - the process instance the module instance belongs to
            Module Definition table - the module definition that defines the module instance''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_MODULEINSTANCE table') INTO tmp_result;

  -- Adding comment on JBPM_RUNTIMEACTION table
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_RUNTIMEACTION IS ''Stores information about actions that are created at runtime
              Foreign Keys
              Process Instance table - the process instance the action belongs to
              Action table - the action definition that defines the action instance''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_RUNTIMEACTION table') INTO tmp_result;
 
  -- Adding comment on JBPM_TIME table
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_TIMER IS ''Stores information about instances of timers that are running
            Foreign Keys
            Action table - The action that the timer belongs to
            Token table - the token that the timer belongs to
            Process Instance table - the process instance the timer belongs to
            Task Instance table - the task instance the timer belongs to''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TIMER table') INTO tmp_result;
  
  -- Adding comment on JBPM_VARIABLEINSTANCE
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_VARIABLEINSTANCE IS ''Stores information about process variable instances
            Foreign Keys
            Token table - the token that the variables belong to
            Token Variable Map table - mapping to the module instance for the token
            Process Instance table - the process instance the variables belong to
            Byte Array table - the byte array stored for a serialized object process variable instance
            Task Instance table - the task instance the variables belong to''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_VARIABLEINSTANCE table') INTO tmp_result;

  -- Adding comment on JBPM_LOG table
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_LOG IS ''Stores process logs created by jBPM or application code during process execution
              Foreign Keys
              Token table - the token that the logs belong to
              Token table - the child token that the logs belong to
              Log table - parent/child relationship between logs
              Transition table - the transition the logs belong to
              Node table - the source node the logs belong to
              Node table - the destination node the logs belong to
              Variable Instance table - the variable instance that is referred to in the log
              Byte Array table - the old value of the byte array
              Byte Array table - the new value of the byte array
              Task Instance table - The task instance that is referred to in the log
              Swim Lane Instance table - the swimlane instance that is referred to in the log''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_LOG table') INTO tmp_result;
  
  -- Adding comment on JBPM_BYTEARRAY table
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_BYTEARRAY IS ''Specifies the file definition module for a serialized process instance variable
            Foreign Key
            Module Definition table - Specify the file definition module''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_BYTEARRAY table') INTO tmp_result;

  -- Adding comment on JBPM_BYTEBLOCK table 
    vsql :='COMMENT ON TABLE '||vschema||'.JBPM_BYTEBLOCK IS ''Stores the serialized process instance variable
            Foreign Key
            Byte Array table - The byte array that the byte block belongs to''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the JBPM_BYTEBLOCK table') INTO tmp_result;
  
  -- Adding comment on TTV_ACCESSLEVEL table
     vsql :='COMMENT ON TABLE '||vschema||'.TTV_ACCESSLEVEL IS ''Contains all the protection keys''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_ACCESSLEVEL table') INTO tmp_result;
 
  -- Adding comment on TTV_CONNECTIONTYPE table
     vsql :='COMMENT ON TABLE '||vschema||'.TTV_CONNECTIONTYPE IS ''The different types of Connection String values supported by Resource Manager. Resource Type declares the Connection Type and it expects for Resource Connection String values and Resource Heartbeat Connection String values''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_CONNECTIONTYPE table') INTO tmp_result;
 
  -- Adding comment on TTV_DATATYPE table
     vsql :='COMMENT ON TABLE '||vschema||'.TTV_DATATYPE IS ''Contains list of data type supported for variables defined in the template''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_DATATYPE table') INTO tmp_result;
  
  -- Adding comment on TTV_MESSAGELOG table
     vsql :='COMMENT ON TABLE '||vschema||'.TTV_MESSAGELOG IS ''Stores messages for each node''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_MESSAGELOG table') INTO tmp_result;

  -- Adding comment on TTV_MONITOREDDRIVE table
     vsql :='COMMENT ON TABLE '||vschema||'.TTV_MONITOREDDRIVE IS ''configuration information for san drives to be monitored''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_MONITOREDDRIVE table') INTO tmp_result;
  
  -- Adding comment on TTV_MONITOREDDRIVEHISTORY table
     vsql :='COMMENT ON TABLE '||vschema||'.TTV_MONITOREDDRIVEHISTORY  IS ''Stores history for each of the drives configured in TTV_MONITORDRIVE''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_MONITOREDDRIVEHISTORY table') INTO tmp_result;
  
  -- Adding comment on TTV_MONITOREDDRIVESTATUS table
     vsql :='COMMENT ON TABLE '||vschema||'.TTV_MONITOREDDRIVESTATUS IS ''Contains all possible status a drive can be in''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_MONITOREDDRIVESTATUS table') INTO tmp_result;

  -- Adding comment on TTV_PROCDEFACCESSLEVEL table
      vsql := 'COMMENT ON TABLE '||vschema||'.TTV_PROCDEFACCESSLEVEL IS ''Mapping information between process definitions and access levels (protection keys)''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCDEFACCESSLEVEL table') INTO tmp_result;
  
  -- Adding comment on TTV_PROCESSDEFINITIONTYPE table
      vsql := 'COMMENT ON TABLE '||vschema||'.TTV_PROCESSDEFINITIONTYPE IS ''Required as a result of sub-classing JBPM_PROCESSDEFINITION entity''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSDEFINITIONTYPE table') INTO tmp_result;

  -- Adding comment on TTV_PROCESSINSTANCENOTE table
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_PROCESSINSTANCENOTE IS ''Table to store notes attached to work orders while specifying reason for cancel, pause, e.t.c''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSINSTANCENOTE table') INTO tmp_result;
  
  -- Adding comment on TTV_PROCESSINSTANCETYPE table
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_PROCESSINSTANCETYPE IS ''Required as a result of sub-classing JBPM_PROCESSINSTANCE entity''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSINSTANCETYPE table') INTO tmp_result;
  
  -- Adding comment on TTV_PROCESSPRIORITY table
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_PROCESSPRIORITY IS ''Table contains the list of all possible Process Priorities available to the Workflow System.The process priority Ids assigned must be sorted from lowest priority to highest priority''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSPRIORITY table') INTO tmp_result;
  
  -- Adding comment on TTV_PROCESSSTATUS table ALERTS
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_PROCESSSTATUS IS ''The different Work Order / Process Status values allowed for the Operational and Administrative Status of a Process''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSSTATUS table') INTO tmp_result;
  
  -- Adding comment on TTV_RESOURCE table
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_RESOURCE IS ''The Resources used by the Workflow System''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCE table') INTO tmp_result;
  
  -- Adding comment on TTV_RESOURCEGROUP table
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_RESOURCEGROUP IS ''The Resource Groups used by the Workflow System''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCEGROUP table') INTO tmp_result;
  
  -- Adding comment on TTV_RESOURCEGROUPMEMBERSHIP table
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_RESOURCEGROUPMEMBERSHIP IS ''Table contains the many-to-many relationship between Resource Groups and Resources. The data shows the membership of each resource in a set of resource groups''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCEGROUPMEMBERSHIP table') INTO tmp_result;
  
  -- Adding comment to TTV_RESOURCESTATUS table
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_RESOURCESTATUS IS ''The different possible value for the Operational or Administrative Status of a Resource in the system''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCESTATUS table') INTO tmp_result;
  
  -- Adding comment to TTV_RESOURCETYPE table
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_RESOURCETYPE IS ''The different Resource Types supported by the system''';
     SELECT CREATEOBJECT(VSQL,'Unable to add comment on the TTV_RESOURCETYPE table') INTO tmp_result;

  -- Adding comment to TTV_STRATEGYCLASS table
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_STRATEGYCLASS IS ''The Strategy class implementations used by the Resource Manager in different scenarios (heartbeat, initialization, allocation). Each Strategy class is also aware of its Strategy Class Type''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_STRATEGYCLASS table') INTO tmp_result;

  -- Adding comment to TTV_STRATEGYCLASSTYPE table
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_STRATEGYCLASSTYPE IS ''The different types of strategies that Resource Manager supports''';
     SELECT CREATEOBJECT(VSQL,'Unable to add comment on the TTV_STRATEGYCLASSTYPE table') INTO tmp_result;

  -- Adding comment to TTV_TOKENTYPE table
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_TOKENTYPE IS ''Required as a result of sub-classing JBPM_TOKEN entity''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_TOKENTYPE table') INTO tmp_result;

  -- Adding comment to TTV_VARIABLEACCESSTYPE table ALERTS
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_VARIABLEACCESSTYPE IS ''Required as a result of sub-classing JBPM_VARIABLEACCESS entity''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_VARIABLEACCESSYTPE table') INTO tmp_result;
  
  -- Adding comment to UI_PROPERTIES table
      vsql :='COMMENT ON TABLE '||vschema||'.UI_PROPERTIES IS ''UNUSED TABLE''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the UI_PROPERTIES table') INTO tmp_result;

      -- Adding comment to TTV_TRANSITIONTYPE
      vsql :='COMMENT ON TABLE '||vschema||'.TTV_TRANSITIONTYPE IS ''Required as a result of sub-classing JBPM_TRANSITION entity''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_TRANSITIONTYPE table') INTO tmp_result;
     
     -- Adding Comment on the TTV_SELECTOR_KEY table
     vsql := 'COMMENT ON TABLE '||vschema||'.TTV_SELECTOR_KEY IS ''Stores selector keys which refer to the latest version of a template''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_SELECTOR_KEY table') INTO tmp_result; 
     
      -- Adding Comment on the TTV_TEMPLATE table
     vsql := 'COMMENT ON TABLE '||vschema||'.TTV_TEMPLATE IS ''Stores template definition and UI variables''';
     SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_TEMPLATE table') INTO tmp_result; 
  /*
  ----------------------------------------
    Creating indexes on FK of JBPM_LOG table
  ----------------------------------------
  */
/*  
   --Create indexes on all Foreign keys of JBPM_LOG to prevent it getting locked exclusively when deleting rows from JBPM_VARIABLEINSTANCE table
    DECLARE
      cursor c1 is select 'CREATE INDEX IDX_JPLOG_'||substr(ucc.column_name,1,12)||'_'||ucc.position||' on '||vschema||'.JBPM_LOG('||ucc.column_name||')' as crindex
                        from dba_constraints uc, dba_cons_columns ucc , dba_constraints uc1
                        where uc.constraint_name = ucc.constraint_name
                        and uc.table_name = ucc.table_name
                        and uc.owner=ucc.owner
                        and upper(uc.owner) = upper(vschema)
                        and upper(uc.constraint_type)='F'
                        and upper(uc.table_name) = 'JBPM_LOG'
                        and uc.r_constraint_name = uc1.constraint_name
                        and uc.owner = uc1.owner;
    begin
      for r1 in c1 loop
          CREATEOBJECT(r1.crindex,'Unable to create index on JBPM_LOG table','Y');
      end loop;
    end;
*/

    execute 'select COUNT(*) from '||ischema||'.install_table where upper(install_message) like ''%ERROR%''' into errcnt;
    if errcnt = 0 then
       EXECUTE 'INSERT INTO '||ischema||'.install_table(install_message) values (''Installation of '||comp_name||' database for version '||db_version||' completed SUCCESSFULLY'')';
    end if;
    return 0;

EXCEPTION
    WHEN OTHERS THEN
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in createwf function : '')';
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
       return 1;
END;
$func_createwf$ LANGUAGE plpgsql;



CREATE OR REPLACE FUNCTION CONVERTWF (vschema varchar, comp_name varchar, db_version varchar) RETURNS integer AS $func_convertwf$
DECLARE
    vsql       varchar;
    wk_message VARCHAR:= '';
    tmp_result smallint;
    wk_release varchar:='';    
    cms_comps  smallint;
    myvar      smallint:=0;
    ischema    text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '5.2.2' THEN	
       EXECUTE 'SELECT max(processpriorityid) FROM '||vschema||'.TTV_PROCESSPRIORITY' INTO myvar;
       IF myvar =  '20'  THEN
          -- On 07/01/2016 Fixed the defect D-06400 created by Priyanka for the cms5.1 fresh install setups.
          vsql := 'UPDATE '||vschema||'.TTV_PROCESSPRIORITY SET processpriorityid=(processpriorityid-1)';
          SELECT CREATEOBJECT(vsql,'Unable to UPDATE '||vschema||'.TTV_PROCESSPRIORITY SET processpriorityid.','Y') into tmp_result ;

          vsql := 'ALTER SEQUENCE '||vschema||'.TTV_PROCESSPRIORITY_SEQ RESTART WITH 20';
          SELECT CREATEOBJECT(vsql,'Unable to ALTER SEQUENCE '||vschema||'.TTV_PROCESSPRIORITY_SEQ RESTART WITH 20.','Y') into tmp_result;
       END IF;
       select set_version(vschema, comp_name,'5.2.2','5.2.3') into tmp_result;
    END IF;

    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '5.2.3' THEN
        -- Changed the database scripts from EDB to Postgres
        select set_version(vschema, comp_name,'5.2.3','6.0.0') into tmp_result;
    END IF;

    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '6.0.0' THEN

        --On 10/24/2016 Evan Huang requested to remove Cluster resourcetype from workflow ttv tables.
        vsql := 'DELETE FROM '||vschema||'.ttv_resourcegroupmembership WHERE resourcegroupid IN 
                     (SELECT resourcegroupid FROM '||vschema||'.ttv_resourcegroup WHERE resourcetypeid = 
                         (SELECT resourcetypeid FROM '||vschema||'.ttv_resourcetype WHERE name =''Cluster''))';
        SELECT CREATEOBJECT(vsql,'Unable to DELETE data from '||vschema||'.ttv_resourcegroupmembership for resourcetype Cluster.','Y') into tmp_result;

        vsql := 'DELETE FROM '||vschema||'.ttv_resource WHERE resourcetypeid = (SELECT resourcetypeid FROM '||vschema||'.ttv_resourcetype WHERE name =''Cluster'')';
        SELECT CREATEOBJECT(vsql,'Unable to DELETE data from '||vschema||'.ttv_resource for resourcetype Cluster.','Y') into tmp_result;

        vsql := 'DELETE FROM '||vschema||'.ttv_resourcegroup WHERE resourcetypeid = (SELECT resourcetypeid FROM '||vschema||'.ttv_resourcetype WHERE name =''Cluster'')';
        SELECT CREATEOBJECT(vsql,'Unable to DELETE data from '||vschema||'.ttv_resourcegroup for resourcetype Cluster.','Y') into tmp_result;

        vsql := 'DELETE FROM '||vschema||'.ttv_resourcetype WHERE name =''Cluster''';
        SELECT CREATEOBJECT(vsql,'Unable to DELETE data from '||vschema||'.ttv_resourcetype for resourcetype Cluster.','Y') into tmp_result;

        select set_version(vschema, comp_name,'6.0.0','6.0.1') into tmp_result;
    END IF;


    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '6.0.1' THEN

        -- on 11/8/2016 Andrew added a new column createid on jbpm_processinstance table
        vsql := 'ALTER TABLE '||vschema||'.jbpm_processinstance ADD COLUMN createid VARCHAR(100) NULL';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.jbpm_processinstance to ADD COLUMN createid','Y') into tmp_result;

        select set_version(vschema, comp_name,'6.0.1','6.0.2') into tmp_result;
    END IF;
    
    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '6.0.2' THEN
        -- creating table TTV_SELECTOR_KEY
        vsql :=  'CREATE TABLE '||vschema||'.TTV_SELECTOR_KEY ( 
             KEY                    	varchar(255) NOT NULL,
             TEMPLATENAME               varchar(255) NOT NULL,
             CONSTRAINT PK_TTV_SELECTOR_KEY PRIMARY KEY (KEY)
             )';
        SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_SELECTOR_KEY','Y') into tmp_result;

        -- Creating index IDX_TTV_SELECTOR_KEY_TNAME
        vsql :=  'CREATE INDEX IDX_TTV_SELECTOR_KEY_TNAME ON '||vschema||'.TTV_SELECTOR_KEY (TEMPLATENAME)';
        SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_SELECTOR_KEY_TNAME on TTV_SELECTOR_KEY table','Y') into tmp_result;

        -- creating table TTV_TEMPLATE
        vsql :=  'CREATE TABLE '||vschema||'.TTV_TEMPLATE ( 
            ID                          varchar(255) NOT NULL,
            NAME                        varchar(255) NOT NULL,
            VERSION                     numeric NOT NULL,
            PROCESS_DEFINITION 	        varchar NOT NULL,
            VARS            	        varchar ,
            NODE_TIMEOUTS               varchar ,
            TYPE_ID                     numeric ,
            CREATE_DATE                 TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            UPDATE_DATE                 TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            CONSTRAINT PK_TTV_TEMPLATE PRIMARY KEY (ID)
            )';
       SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_TEMPLATE','Y') into tmp_result;
       SELECT createupdatetrg(vschema,'TTV_TEMPLATE','Y') into tmp_result;

       -- Creating index IDX_TTV_TEMPLATE_NAME
       vsql :=  'CREATE INDEX IDX_TTV_TEMPLATE_NAME ON '||vschema||'.TTV_TEMPLATE (NAME,VERSION)';
       SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_TEMPLATE_NAME on TTV_TEMPLATE table','Y') into tmp_result;
       
       -- Adding Comment on the TTV_SELECTOR_KEY table
       vsql := 'COMMENT ON TABLE '||vschema||'.TTV_SELECTOR_KEY IS ''Stores selector keys which refer to the latest version of a template''';
       SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_SELECTOR_KEY table','Y') into tmp_result; 
     
       -- Adding Comment on the TTV_TEMPLATE table
       vsql := 'COMMENT ON TABLE '||vschema||'.TTV_TEMPLATE IS ''Stores template definition and UI variables''';
       SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_TEMPLATE table','Y') into tmp_result; 
       
       select set_version(vschema, comp_name,'6.0.2','6.0.3') into tmp_result;
    END IF;

    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '6.0.3' THEN

       vsql := 'ALTER TABLE '||vschema||'.TTV_TEMPLATE RENAME COLUMN node_timeouts TO NODETIMEOUTS';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.TTV_TEMPLATE RENAME COLUMN NODETIMEOUTS','Y') INTO tmp_result;

       vsql := 'ALTER TABLE '||vschema||'.TTV_TEMPLATE ALTER COLUMN id TYPE numeric(19) using ID::numeric, ALTER COLUMN id SET NOT NULL,'||
               'ALTER COLUMN vars TYPE json USING to_json(vars) , ALTER COLUMN  NODETIMEOUTS TYPE json USING to_json(NODETIMEOUTS)';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.TTV_TEMPLATE ALTER COLUMNS to jsons','Y') INTO tmp_result;

       vsql := 'ALTER TABLE '||vschema||'.TTV_TEMPLATE ADD COLUMN CONTENTTYPE numeric';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.TTV_TEMPLATE ADD COLUMN CONTENTTYPE','Y') INTO tmp_result;

       vsql := 'ALTER TABLE '||vschema||'.TTV_TEMPLATE RENAME COLUMN CREATE_DATE TO CREATEDATE';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.TTV_TEMPLATE RENAME COLUMN CREATEDATE','Y') INTO tmp_result;

       vsql := 'ALTER TABLE '||vschema||'.TTV_TEMPLATE RENAME COLUMN UPDATE_DATE TO UPDATEDATE';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.TTV_TEMPLATE RENAME COLUMN UPDATEDATE','Y') INTO tmp_result;
       SELECT createupdatetrg(vschema,'TTV_TEMPLATE','Y') into tmp_result;

       vsql :=  'CREATE TABLE '||vschema||'.TTV_TOKEN ( 
            TOKENID                      numeric(19) NOT NULL,
            PARENTTOKENID                numeric(19) ,
            PROCESSID                    numeric(19) ,
            TOKENNAME                    varchar(255) ,
            CURRENTNODENAME              varchar(255) ,
            VARS                         json ,
            OPERATIONALSTATUS            numeric(19) ,
            ADMINSTATUS                  numeric(19) ,
            COMMENTS                     json,
            STARTDATE                    TIMESTAMP(6),
            ENDDATE                      TIMESTAMP(6),
            CREATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            UPDATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            CONSTRAINT PK_TTV_TOKEN PRIMARY KEY (TOKENID)
            )';
       SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_TOKEN','Y') INTO tmp_result;
       SELECT createupdatetrg(vschema,'TTV_TOKEN','Y') INTO tmp_result;
      
       vsql :=  'CREATE INDEX IDX_TTV_TOKEN_PTID ON '||vschema||'.TTV_TOKEN (PARENTTOKENID)';
       SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_TOKEN_PTID on TTV_TOKEN table','Y') INTO tmp_result;

       vsql :=  'CREATE INDEX IDX_TTV_TOKEN_PID ON '||vschema||'.TTV_TOKEN (PROCESSID)';
       SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_TOKEN_PID on TTV_TOKEN table','Y') INTO tmp_result;
      
       -- Adding comment on the JBPM_TOKEN table
       vsql :='COMMENT ON TABLE '||vschema||'.TTV_TOKEN IS ''Stores information about the token representing execution location in the process instance''';
       SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_TOKEN table','Y') INTO tmp_result; 
      
       -- creating table TTV_PROCESSINSTANCE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_PROCESSINSTANCE ( 
            PROCESSID                    numeric(19) NOT NULL,
            PARENTPROCESSID              numeric(19) ,
            ROOTTOKENID                  numeric(19) ,
            TEMPLATEID                   numeric(19) ,
            PRIORITY                     numeric,
            NOTES                        json ,
            CREATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            UPDATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            ISACTIVE                     numeric(1) NOT NULL DEFAULT 1 ,
            CONSTRAINT PK_TTV_PROCESSINSTANCE PRIMARY KEY (PROCESSID)
            )';
       SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_PROCESSINSTANCE','Y') INTO tmp_result;
       SELECT createupdatetrg(vschema,'TTV_PROCESSINSTANCE','Y') INTO tmp_result;
      
       vsql :=  'CREATE INDEX IDX_TTV_PROCESSINSTANCE_PPID ON '||vschema||'.TTV_PROCESSINSTANCE (PARENTPROCESSID)';
       SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_PROCESSINSTANCE_PPID on TTV_PROCESSINSTANCE table','Y') INTO tmp_result;
      
       -- Adding comment on the TTV_PROCESSINSTANCE
       vsql :='COMMENT ON TABLE '||vschema||'.TTV_PROCESSINSTANCE IS ''Stores runtime information about an instance of a process. 
               Foreign keys
               TTV_TEMPLATE table - the process definition to be followed for this process instance execution 
               TTV_Token table - the root token that follows where the process execution is currently''';
       SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSINSTANCE table','Y') INTO tmp_result; 
      
       -- creating table TTV_TASKINSTANCE
       vsql :=  'CREATE TABLE '||vschema||'.TTV_TASKINSTANCE (
            TASKID                       numeric(19) NOT NULL,
            TOKENID                      numeric(19) NOT NULL,
            CURRENTNODENAME              varchar(255) ,
            STARTDATE                    TIMESTAMP(6),
            ENDDATE                      TIMESTAMP(6),
            CREATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            UPDATEDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
            CONSTRAINT PK_TTV_TASKINSTANCE PRIMARY KEY (TASKID)
            )';
       SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.TTV_TASKINSTANCE','Y') INTO tmp_result;
       SELECT createupdatetrg(vschema,'TTV_TASKINSTANCE','Y') INTO tmp_result;
      
       -- Adding comment on the TTV_TASKINSTANCE
       vsql :='COMMENT ON TABLE '||vschema||'.TTV_TASKINSTANCE IS ''Stores task information about an instance of a process.''';
       SELECT CREATEOBJECT(vsql,'Unable to add comment on the TTV_TASKINSTANCE table','Y') INTO tmp_result;

       select set_version(vschema, comp_name,'6.0.3','6.0.4') into tmp_result;
    END IF;

    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '6.0.4' THEN
      
       -- Create Foreign Key on TTV_PROCESSINSTANCE
       vsql := 'ALTER TABLE '||vschema||'.TTV_PROCESSINSTANCE ADD CONSTRAINT FK_TTV_PINSTANCE_TTV_TEMPLATE FOREIGN KEY (TEMPLATEID) 
                 REFERENCES '||vschema||'.TTV_TEMPLATE (ID)';
       SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_TTV_PINSTANCE_TTV_TEMPLATE for TTV_PROCESSINSTANCE','Y') INTO tmp_result;
    
       vsql := 'ALTER TABLE '||vschema||'.TTV_PROCESSINSTANCE ADD CONSTRAINT FK_TTV_PINSTANCE_TTV_TOKEN FOREIGN KEY (ROOTTOKENID) 
                 REFERENCES '||vschema||'.TTV_TOKEN (TOKENID)';
       SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_TTV_PINSTANCE_TTV_TOKEN for TTV_PROCESSINSTANCE','Y') INTO tmp_result;
      
       vsql := 'ALTER TABLE '||vschema||'.TTV_PROCESSINSTANCE ADD CONSTRAINT FK_TTV_PINSTANCE_TTV_PRIORITY FOREIGN KEY (PRIORITY) 
                 REFERENCES '||vschema||'.TTV_PROCESSPRIORITY (PROCESSPRIORITYID)';
       SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_TTV_PINSTANCE_TTV_TOKEN for TTV_PROCESSINSTANCE','Y') INTO tmp_result;

       vsql := 'ALTER TABLE '||vschema||'.TTV_TASKINSTANCE ADD CONSTRAINT FK_TTV_TINSTANCE_TTV_TOKEN FOREIGN KEY (TOKENID) 
                 REFERENCES '||vschema||'.TTV_TOKEN (TOKENID)';
       SELECT CREATEOBJECT(vsql,'Unable to create foreign Key FK_TTV_TINSTANCE_TTV_TOKEN for TTV_TASKINSTANCE','Y') INTO tmp_result;

       vsql := 'ALTER TABLE '||vschema||'.TTV_TEMPLATE RENAME COLUMN PROCESS_DEFINITION TO PROCESSDEFINITION';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.TTV_TEMPLATE RENAME COLUMN PROCESS_DEFINITION','Y') INTO tmp_result;

       vsql := 'ALTER TABLE '||vschema||'.TTV_TEMPLATE RENAME COLUMN TYPE_ID TO TYPEID';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.TTV_TEMPLATE RENAME COLUMN TYPE_ID','Y') INTO tmp_result;

       select set_version(vschema, comp_name,'6.0.4', '6.0.5') into tmp_result;
    END IF;

    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '6.0.5' THEN

       vsql := 'ALTER TABLE '||vschema||'.TTV_PROCESSINSTANCE ADD COLUMN CREATEID VARCHAR(255)';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.TTV_PROCESSINSTANCE ADD COLUMN CREATEID','Y') INTO tmp_result;

       vsql :=  'CREATE UNIQUE INDEX IDX_TTV_PROCESSINSTANCE_CID_UK ON '||vschema||'.TTV_PROCESSINSTANCE (CREATEID)';
       SELECT CREATEOBJECT(vsql,'Unable to CREATE UNIQUE INDEX IDX_TTV_PROCESSINSTANCE_CID_UK on TTV_PROCESSINSTANCE table','Y') INTO tmp_result;

       select set_version(vschema, comp_name,'6.0.5', '6.0.6') into tmp_result;
    END IF;

    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '6.0.6' THEN

       vsql := 'ALTER TABLE '||vschema||'.ttv_taskinstance drop constraint fk_ttv_tinstance_ttv_token';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.ttv_taskinstance drop constraint fk_ttv_tinstance_ttv_token','Y') INTO tmp_result;

       vsql := 'ALTER TABLE '||vschema||'.ttv_processinstance drop constraint fk_ttv_pinstance_ttv_template';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.ttv_processinstance drop constraint fk_ttv_pinstance_ttv_template','Y') INTO tmp_result;

       vsql := 'ALTER TABLE '||vschema||'.ttv_processinstance drop constraint fk_ttv_pinstance_ttv_token';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.ttv_processinstance drop constraint fk_ttv_pinstance_ttv_token','Y') INTO tmp_result;

       vsql := 'ALTER TABLE '||vschema||'.ttv_processinstance drop constraint fk_ttv_pinstance_ttv_priority';
       SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.ttv_processinstance drop constraint fk_ttv_pinstance_ttv_priority','Y') INTO tmp_result;

       select set_version(vschema, comp_name,'6.0.6', '6.0.7') into tmp_result;
    END IF;

    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '6.0.7' THEN
       vsql :=  'CREATE UNIQUE INDEX IDX_TTV_TEMPLATE_NAME_VERSION_UK ON '||vschema||'.TTV_TEMPLATE (NAME,VERSION) WHERE (TYPEID = 2)';
       SELECT CREATEOBJECT(vsql,'Unable to create index IDX_TTV_TEMPLATE_NAME_VERSION_UK on TTV_TEMPLATE table','Y') INTO tmp_result;

       select set_version(vschema, comp_name,'6.0.7', '6.0.8') into tmp_result;
    END IF;

    EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
    IF wk_release = '6.0.8' THEN
       -- Incremented the version to cms7.0
       select set_version(vschema, comp_name,'6.0.8', db_version) into tmp_result;
    END IF;

  EXECUTE 'INSERT INTO '||ischema||'.install_table (msgdate, install_message) values (now(),''Upgrading '||comp_name||' component to '||db_version||' completed SUCCESSFULLY'')';
  RETURN tmp_result;
EXCEPTION
    WHEN OTHERS THEN
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in '||comp_name||' convertwf function : '')';
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
      return 1;
END;
$func_convertwf$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION INSTALL_WF () RETURNS integer AS $func_installwf$
DECLARE
    comp_name    varchar := 'WORKFLOW';
    tbl_count    smallint;
    vschema      varchar := 'wfs';
    func_results smallint;
    wk_release   varchar :='';    
    db_version   varchar := '7.0.0';
    ischema      text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    select count(*) into tbl_count from pg_tables where schemaname = vschema and UPPER(tablename) like 'JBPM_%';
    IF tbl_count = 0 THEN
      select CREATEWF(vschema,comp_name,db_version) into func_results;
    ELSE
      EXECUTE 'SELECT get_version('''||vschema||''','''||comp_name||''')' into wk_release;
      IF wk_release < db_version  THEN
         select CONVERTWF(vschema,comp_name,db_version) into func_results;
      ELSIF wk_release = db_version  THEN
        EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''There are no database changes in '||comp_name||' component to upgrade'')';
      END IF;
    END IF;
    return func_results;
END;
$func_installwf$ LANGUAGE plpgsql;

DO $$declare
   results    smallint;
begin
   select INSTALL_WF() into results;
end$$;
