#!/bin/sh
##########################################################################
#        Script_name : installworkflow.sh                                #
#        Purpose     : creates workflow schema and database objects      #
#        Created by  : Suresh Neravati                                   #
#        Created on  : 10/13/2016                                        #
##########################################################################
TIMESTAMP=`date +%Y%m%d_%H%M%S`
INSTALL_DIR=`pwd`
DB_NAME="${1:-ttv}"
HOST_NAME=$2
WF_LOGFILE="cms_wf_dbinstall"
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
PGP="Wf\$1234"
DB_TYPE="${DB_TYPE:-postgres}"
PG_VER=${DB_VERSION:-9.5}
PSQLHOME="/usr/pgsql-${PG_VER}/bin"
SSCHEMA="wfs"
HOST_NAME="${HOST_NAME:-dbserver}"
AZURE_DB="${AZURE_DB:-edb1}"
DB_USER="wfs"

if [ "X$1" = "X"  ]; then
     DB_NAME="ttv"
fi
if [ "X$2" = "X"  ]; then
     HOST_NAME="${HOST_NAME:-dbserver}"
fi
if [ "X${DB_TYPE}" = "Xazure" ]; then
     DB_USER="wfs@$AZURE_DB"
fi
PORT=${DB_PORT:-5432}
export PGPASSWORD=${PGP}
(
PRE_INST_CNT=$( ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "select count(*) from wfs.system_settings where component_name='PRECMS'"| sed 's/^ *//' )
if [ "${PRE_INST_CNT}" -eq "1"  ]; then
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -v "inst_schema=$SSCHEMA" -f ${INSTALL_DIR}/createworkflow.sql
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -c "grant select on wfs.JBPM_PROCESSDEFINITION to wfsdw;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -c "grant select on wfs.TTV_PROCESSSTATUS to wfsdw;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -c "select MSGDATE, INSTALL_MESSAGE from ${SSCHEMA}.install_table where INSTALL_MESSAGE like '%WORKFLOW%' order by MSGDATE;"
else
   echo "ERROR: installcms script need to ran first to create the database schema, exiting the script..."
   exit 1
fi
) 2>&1 | tee "${INSTALL_DIR}/${WF_LOGFILE}.log"
if  grep -qi "FATAL\|ERROR\|ORA-\|SP2-\|Permission denied\|SQL-" "${INSTALL_DIR}/${WF_LOGFILE}.log"
then
   /bin/mv "${INSTALL_DIR}/${WF_LOGFILE}.log" "${INSTALL_DIR}/${WF_LOGFILE}_${TIMESTAMP}.log"
   echo "*********************************************************"
   echo "Database workflow script probably failed! Check ${INSTALL_DIR}/${WF_LOGFILE}_${TIMESTAMP}.log file for any errors"
   echo "*********************************************************"
   exit 1
else
   /bin/mv "${INSTALL_DIR}/${WF_LOGFILE}.log" "${INSTALL_DIR}/${WF_LOGFILE}_${TIMESTAMP}.log"
   echo "*********************************************************"
   echo " Database workflow script completed successfully..."
   echo "*********************************************************"
fi

exit 0