#!/bin/bash
source /opt/cms/shell_lib/common.sh

SCRIPT=$(readlink -f "$0")
SCRIPTPATH=$(dirname "$SCRIPT")
CMSCONF="/opt/cms/cms.var"
BUNDLEFOLDER="/opt/cms/ConfigBundle"
PRODUCTSVAR_FILE="${BUNDLEFOLDER}/products-var.yaml"
ENABLE_EPG=false

CMS_NAMESPACE=$(get_product_parameter cms_namespace)

if [ $? -ne 0 ]; then 
  echo "Get cms namespace failed."
  exit 1
fi

if kubectl get sts -n $CMS_NAMESPACE cms-pg-epg-stolon-keeper &>/dev/null ; then
  ENABLE_EPG=true
fi

echo "Disable db related cronjobs....."
if [ "$ENABLE_EPG" = true ]; then
  kubectl patch cronjobs cms-common-backup cms-pg-epg-fullbackup cms-pg-epg-vacuum-analyzeonly cms-pg-epg-vacuum-vacuum cms-pg-metadata-manager-fullbackup cms-pg-metadata-manager-vacuum-analyzeonly cms-pg-metadata-manager-vacuum-vacuum cms-pg-purge cms-pg-workflow-fullbackup cms-pg-workflow-vacuum-analyzeonly cms-pg-workflow-vacuum-vacuum  -p '{"spec" : {"suspend" : true }}' -n ${CMS_NAMESPACE}
else
  kubectl patch cronjobs cms-common-backup cms-pg-metadata-manager-fullbackup cms-pg-metadata-manager-vacuum-analyzeonly cms-pg-metadata-manager-vacuum-vacuum cms-pg-purge cms-pg-workflow-fullbackup cms-pg-workflow-vacuum-analyzeonly cms-pg-workflow-vacuum-vacuum  -p '{"spec" : {"suspend" : true }}' -n ${CMS_NAMESPACE} 
fi


echo "Stop cms metadata manager database service....."
kubectl scale --replicas=1 statefulset/cms-pg-metadata-manager-stolon-keeper -n $CMS_NAMESPACE 
count_to_retry=0
while :; do
    EXISTS_KEEPER_NUM=$(kubectl get pods -n ${CMS_NAMESPACE} | grep cms-pg-metadata-manager-stolon-keeper-1 | wc | awk '{print $1}')
    if [ ${EXISTS_KEEPER_NUM} -eq 0 ]; then
      break
    fi
    ((count_to_retry++))
    if [[ $count_to_retry -gt 20 ]]; then
      echo "Time out of stop database pod cms-pg-metadata-manager-stolon-keeper."
      exit 1
    fi
    sleep 3
    echo "Wait for cms-pg-metadata-manager-stolon-keeper to stop..."
done
sleep 40
kubectl scale --replicas=0 statefulset/cms-pg-metadata-manager-stolon-keeper -n $CMS_NAMESPACE

if [ "$ENABLE_EPG" = true ]; then
  echo "Stop epg manager database service....."
  kubectl scale --replicas=1 statefulset/cms-pg-epg-stolon-keeper -n $CMS_NAMESPACE
  count_to_retry=0
  while :; do
    EXISTS_KEEPER_NUM=$(kubectl get pods -n ${CMS_NAMESPACE} | grep cms-pg-epg-stolon-keeper-1 | wc | awk '{print $1}')
    if [ ${EXISTS_KEEPER_NUM} -eq 0 ]; then
      break
    fi
    ((count_to_retry++))
    if [[ $count_to_retry -gt 20 ]]; then
      echo "Time out of stop database pod cms-pg-epg-stolon-keeper."
      exit 1
    fi
    sleep 3
    echo "Wait for cms-pg-epg-stolon-keeper to stop..."
  done
  sleep 40
  kubectl scale --replicas=0 statefulset/cms-pg-epg-stolon-keeper -n $CMS_NAMESPACE
fi

echo "Stop workflow database service....."
kubectl scale --replicas=1 statefulset/cms-pg-workflow-stolon-keeper -n $CMS_NAMESPACE
count_to_retry=0
while :; do
    EXISTS_KEEPER_NUM=$(kubectl get pods -n ${CMS_NAMESPACE} | grep cms-pg-workflow-stolon-keeper-1 | wc | awk '{print $1}')
    if [ ${EXISTS_KEEPER_NUM} -eq 0 ]; then
      break
    fi
    ((count_to_retry++))
    if [[ $count_to_retry -gt 20 ]]; then
      echo "Time out of stop database pod cms-pg-workflow-stolon-keeper."
      exit 1
    fi
    sleep 3
    echo "Wait for cms-pg-workflow-stolon-keeper to stop..."
done
sleep 40
kubectl scale --replicas=0 statefulset/cms-pg-workflow-stolon-keeper -n $CMS_NAMESPACE

echo "Stop cms metadata manager service....."
kubectl exec -i -n $CMS_NAMESPACE cms-cli-0 -c cms-cli -- cmscli service stop -s cms-metadata-manager

echo "Stop workflow service....."
kubectl exec -i -n $CMS_NAMESPACE cms-cli-0 -c cms-cli -- cmscli service stop -s cms-workflow

if [ "$ENABLE_EPG" = true ]; then
  echo "Stop epg manager service....."
  kubectl exec -i -n $CMS_NAMESPACE cms-cli-0 -c cms-cli -- cmscli service stop -s cms-epg
fi
