function rpm_install_all_node()
{
  K8S_NODE=$(kubectl get node -o wide |grep -v STATUS |awk '{print $6}')
  if [[ -z $K8S_NODE ]]; then
     echo "[Error] kubectl command failed! Make sure the kube-config is configured properly for current user."
     exit 1
  fi
  RPM_PKG=$1
  fail_nodes=""
  skip_install="false"
  for NODE in ${K8S_NODE}
  do
    if [[ $(ssh -o StrictHostKeyChecking=no -o BatchMode=yes $NODE "hostname" > /dev/null 2>&1; echo $?) -ne 0 ]];then
      fail_nodes="$fail_nodes $NODE"
    fi
  done
  if [[ -n "$fail_nodes" ]]; then
    user_confirm "!! *NOTICE* !! Bootstrap Node is not able to connect to below nodes:
$fail_nodes
Do you confirm the required rpm [$RPM_PKG] has been installed in all kubernete cluster nodes?
Enter 'No' if not. And rerun this step after the rpm is intalled in all nodes by user;
Enter 'Yes' to continue this deployment scripts."
    skip_install="true"
  fi
  if [[ "$skip_install" == "false" ]]; then
  for NODE in ${K8S_NODE}
  do
    if [[ $(ssh -o StrictHostKeyChecking=no $NODE "sudo yum list installed $RPM_PKG" > /dev/null 2>&1; echo $?) -eq 0 ]];then
      echo "The $RPM_PKG has been installed in $NODE"
    else
      echo "Copy $RPM_PKG related RPM packages to $NODE"
      scp -o StrictHostKeyChecking=no -rp $RPMFOLDER/$RPM_PKG $NODE:/tmp/$RPM_PKG
      echo "Installing $RPM_PKG related packages"
      ssh -o StrictHostKeyChecking=no $NODE "sudo yum install -y /tmp/$RPM_PKG/*.rpm"
    fi
  done
  fi
}
  
function prepare_installer(){
#########################
# Function: prepare_installer
# Make sure bind-utils, docker, gcloud, helm and kubectl is installed in this machine
#########################
  trap 'echo "[Error] Scripts failed when running function [lib/${FUNCNAME[0]}] - error line: $LINENO, error cmd: $BASH_COMMAND"' ERR

  reset_function_timer
  cd $SCRIPTPATH
  
  beginLogging "Start Preparing installer machine with necessary tools."

##   # Prepare local yum repo
##   if [[ ! -f /etc/yum.repos.d/cms_repo.repo ]]; then
##     check_packages "$CMS_RPM_PACKAGE"
##   
##     #if [[  $(yum version > /dev/null 2>&1; echo $?) -ne 0 ]]; then
##     #  echo "[INFO] Installing yum-util."
##     #  sudo rpm -Uvh $RPMFOLDER/yum-utils-*.rpm
##     #fi
##       
##     if [[  $(httpd -v > /dev/null 2>&1; echo $?) -ne 0 ]]; then
##       echo "[INFO] Installing httpd."
##       sudo rpm -Uvh $RPMFOLDER/httpd/*.rpm
##     fi
##     sudo sed -i 's/^Listen .*/Listen 8181/' /etc/httpd/conf/httpd.conf
##     sudo systemctl restart httpd
##     sudo systemctl enable httpd
##   
##     sudo mkdir -p /var/www/cms_repo
##     sudo tar -xzf $SCRIPTPATH/packages/$CMS_RPM_PACKAGE -C /var/www/cms_repo
##   
##     sudo tee -a /etc/yum.repos.d/cms_repo.repo << EOM
## [cms_repo]
## baseurl = http://127.0.0.1:8181/cms_repo
## enabled = 1
## gpgcheck = 0
## name = CMS Yum repository
## proxy = _none_
## EOM
##   
##   fi

  check_packages "$CMS_RPM_PACKAGE"
  mkdir -p $RPMFOLDER
  sudo tar -xzf packages/cms-tool-rpms-$(ls packages/$CMS_RPM_PACKAGE|awk -F'-' '{print $NF}'|sort -Vr|head -1) -C $RPMFOLDER
#  for rpmpkg in $CMS_RPM_PACKAGE
#  do
#    sudo tar -xzf $(ls -rt packages/$rpmpkg | tail -1) -C $RPMFOLDER
#  done

  # Install rpm to all kubernetes nodes in bare metal scenario
  if [[ ${CLOUDPLATFORM} == "" ]];then
    echo "[INFO]Install nfs-utils related package to all nodes"
    rpm_install_all_node nfs-utils
  fi
  # End Install rpm to all kubernetes nodes in bare metal scenario

  # Prepare docker
  if [[  $(docker -v > /dev/null 2>&1; echo $?) -ne 0 ]]; then
    echo "[INFO] Installing docker-ce ..."
    #sudo yum install -y yum-utils
    #sudo yum-config-manager \
    #     --add-repo https://download.docker.com/linux/centos/docker-ce.repo
    #sudo yum install -y docker-ce docker-ce-cli containerd.io
    sudo rpm -Uvh --force --replacepkgs $RPMFOLDER/docker/*.rpm
    sudo systemctl enable docker >& /dev/null &
  fi
  sudo systemctl start docker >& /dev/null &
  if [[ $(groups|grep ' docker '|wc -l) -eq 0 ]]; then
    #group=$(id $(whoami)|grep -o gid=[0-9]*\([^\)]*|cut -d '(' -f 2)
    sudo usermod -a -G docker $(whoami)
    sudo usermod -a -G docker root
    #newgrp docker || true
    #newgrp $group || true
  fi
  # End Prepare docker

  # Prepare yq
  if [[  $(yq -V > /dev/null 2>&1; echo $?) -ne 0 ]]; then
    echo "[INFO] Installing yq ..."
    # yq version should be v3.x for using the merge function
    sudo cp $RPMFOLDER/yq/yq_linux_amd64_v3.4.1 /usr/bin
    sudo chmod +x /usr/bin/yq_linux_amd64_v3.4.1
    sudo ln -fs /usr/bin/yq_linux_amd64_v3.4.1 /usr/bin/yq

    #by far we change to yq v4.x, add binary and make yq link to yq4
    if [[ -f $RPMFOLDER/yq/yq_linux_amd64_v4.32.2 ]]; then
      echo "[INFO] yq4 exists, upgrading ..."
      sudo cp $RPMFOLDER/yq/yq_linux_amd64_v4.32.2 /usr/bin
      sudo chmod +x /usr/bin/yq_linux_amd64_v4.32.2
      sudo ln -fs /usr/bin/yq_linux_amd64_v4.32.2 /usr/bin/yq4
      sudo ln -fs /usr/bin/yq_linux_amd64_v4.32.2 /usr/bin/yq
      sudo ln -fs /usr/bin/yq_linux_amd64_v3.4.1 /usr/bin/yq3
    fi
  else
    YQ_VER=`yq -V|awk -F "version " '{print $2}'|cut -c1`
    #if [[ "$YQ_VER" == "3" ]]; then
    if [[ $YQ_VER =~ ^3 || "$YQ_VER" == "4.25" ]]; then
      if [[ -f $RPMFOLDER/yq/yq_linux_amd64_v4.32.2 ]]; then
        echo "[INFO] Upgrading yq to v4.32.2..."
        sudo cp $RPMFOLDER/yq/yq_linux_amd64_v4.32.2 /usr/bin
        sudo chmod +x /usr/bin/yq_linux_amd64_v4.32.2
        sudo ln -fs /usr/bin/yq_linux_amd64_v4.32.2 /usr/bin/yq4
        sudo ln -fs /usr/bin/yq_linux_amd64_v4.32.2 /usr/bin/yq
        sudo ln -fs /usr/bin/yq_linux_amd64_v3.4.1 /usr/bin/yq3
        sudo ln -fs /usr/bin/yq_linux_amd64_v4.32.2 /usr/local/bin/yq
      fi
    fi
  fi
  # End Prepare yq

  # Prepare kubectl
  if [[ -n $CLOUDPLATFORM ]]; then
    #[[ $(echo -e "1.20\n$(echo $K8S_SERVER_VERSION|cut -d. -f1,2)"|sort -Vr|head -1) == "1.20" ]] && kubectl_version="1.20" || kubectl_version="1.23"
    kc_major=$(echo $K8S_SERVER_VERSION|cut -d. -f1)
    kc_minor=$(echo $K8S_SERVER_VERSION|cut -d. -f2)
    kc_major_deserve=$kc_major
    if [[ $kc_major -eq 1 ]]; then
      if [[ $kc_minor -ge 19 ]] && [[ $kc_minor -le 21 ]]; then
        kc_minor_deserve=20
      elif [[ $kc_minor -ge 22 ]] && [[ $kc_minor -le 24 ]]; then
        kc_minor_deserve=23
      elif [[ $kc_minor -ge 25 ]]; then
        kc_minor_deserve=$(($kc_minor - 1))
      fi
    fi
    echo "[INFO] Installing or updating kubectl ..."
#    cat <<EOF > /etc/yum.repos.d/kubernetes.repo
#[kubernetes]
#name=Kubernetes
#baseurl=https://packages.cloud.google.com/yum/repos/kubernetes-el7-x86_64
#enabled=1
#gpgcheck=1
#repo_gpgcheck=1
#gpgkey=https://packages.cloud.google.com/yum/doc/yum-key.gpg https://packages.cloud.google.com/yum/doc/rpm-package-key.gpg
#EOF
    #sudo yum install -y kubectl
    #[[ $(sudo rpm -qa|grep kubectl-${kubectl_version}) =~ kubectl* ]] && echo "Kubectl-${kubectl_version} is already installed" || sudo rpm -Uvh $RPMFOLDER/kubectl/kubectl-${kubectl_version}*.x86_64.rpm
    kc_version_current=$(if which kubectl &>/dev/null; then kubectl version --client=true -o yaml 2>/dev/null; fi)
    kc_minor_current=$(echo "$kc_version_current"|yq '.clientVersion.minor')
    kc_install="false"
    if [[ $kc_major -eq 1 ]] && [[ $kc_minor -ge 19 ]]; then
      #assume kubectl to be installed
      if [[ -z "$kc_minor_current" ]] || [[ "$kc_minor_current" == "null" ]]; then
        kc_install="true"
      #assume kubectl to be upgraded
      elif [[ $kc_minor_current -lt $kc_minor_deserve ]]; then
        kc_install="true"
      fi
    fi
    if [[ $kc_install == "true" ]]; then
      kc_package=$(ls $RPMFOLDER/kubectl/kubectl-${kc_major_deserve}.${kc_minor_deserve}.*.x86_64.rpm|sort -V|tail -n 1)
      echo "[INFO] Installing kubectl ${kc_major_deserve}.${kc_minor_deserve}"
      sudo rpm -Uv $kc_package
    else
      echo "[INFO] Current kubectl client info: $kc_version_current"
    fi
  fi
  # End Prepare kubectl

  # Prepare terraform
  if [[  $(terraform -v > /dev/null 2>&1; echo $?) -ne 0 ]] && [[ -n $CLOUDPLATFORM ]]; then
    #sudo mkdir -p terraform_temp
    echo "[INFO] Installing terraform ..."
    #sudo yum install -y unzip
    #sudo curl  https://releases.hashicorp.com/terraform/${TERRAFORM_VERSION}/terraform_${TERRAFORM_VERSION}_linux_amd64.zip -o terraform_temp/terraform_${TERRAFORM_VERSION}_linux_amd64.zip
    #sudo cp $RPMFOLDER/terraform/terraform_${TERRAFORM_VERSION}_linux_amd64.zip terraform_temp
    #cd terraform_temp
    #sudo unzip -o terraform_${TERRAFORM_VERSION}_linux_amd64.zip
    #sudo mv terraform /usr/sbin
    #cd -
    #sudo rm -rf terraform_temp
    sudo tar -xzf $RPMFOLDER/terraform/terraform_${TERRAFORM_VERSION}_linux_amd64.tgz -C /usr/sbin
    echo "[INFO] Installed Terraform Version:"
    sudo terraform -v | head -1
  fi
  # End Prepare terraform

  # Prepare dig
  if [[  $(dig -h > /dev/null 2>&1; echo $?) -ne 0 ]] && [[ -n $CLOUDPLATFORM ]]; then
    echo "[INFO] Installing bind-utils for dig command."
    sudo yum install -y bind-utils
  fi
  # End Prepare dig

  # Prepare gcloud
  # !! Basicall we require user to run this script from GCP bastion VM, gcloud should has always been installed.
  # !! If not running from GCP bastion VM, this step requires user to enter the account information during initiative.
  if [[ ${CLOUDPLATFORM} == "GCP" ]] && [[ $(gcloud -v > /dev/null 2>&1; echo $?) -ne 0 ]]; then
    echo "[INFO] Installing gcloud ..."
#    sudo tee -a /etc/yum.repos.d/google-cloud-sdk.repo << EOM
#[google-cloud-sdk]
#name=Google Cloud SDK
#baseurl=https://packages.cloud.google.com/yum/repos/cloud-sdk-el7-x86_64
#enabled=1
#gpgcheck=1
#repo_gpgcheck=1
#gpgkey=https://packages.cloud.google.com/yum/doc/yum-key.gpg
#       https://packages.cloud.google.com/yum/doc/rpm-package-key.gpg
#EOM
    #sudo yum install -y google-cloud-sdk
    sudo rpm -Uvh $RPMFOLDER/google-cloud-sdk/google-cloud-sdk-321.0.0-1.x86_64.rpm
    gcloud init --skip-diagnostics
# Note: Follow below instruction to finish the authantication 
#You must log in to continue. Would you like to log in (Y/n)?  y
#Go to the following link in your browser:
#    https://accounts.google.com/o/oauth2/auth?response_type=code&client_id=32555940559.apps.googleusercontent.com&redirect_uri=urn%3Aietf%3Awg%3Aoauth%3A2.0%3Aoob&scope=openid+https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fuserinfo.email+https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fcloud-platform+https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fappengine.admin+https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fcompute+https%3A%2F%2Fwww.googleapis.com%2Fauth%2Faccounts.reauth&state=3lUv3sglggeS5WdEQgTn16h9qMrciD&code_challenge=TI4360zLEmL0E-1Br1Lsf8DeWzPAfU3t42XKcrzKDEk&prompt=consent&code_challenge_method=S256&access_type=offline
#Enter verification code:
  fi
  # End Prepare gcloud

  # Prepare Azure-CLI
  if [[ ${CLOUDPLATFORM} == "AZURE" ]]; then
    if [ -f /etc/yum.repos.d/azure-cli.repo ] && grep -qw '\[azure-cli\]' /etc/yum.repos.d/azure-cli.repo; then
       :
    else
      sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc
      sudo tee -a /etc/yum.repos.d/azure-cli.repo << EOM
[azure-cli]
name=Azure CLI
baseurl=https://packages.microsoft.com/yumrepos/azure-cli
enabled=1
gpgcheck=1
gpgkey=https://packages.microsoft.com/keys/microsoft.asc
EOM
    fi
    if [[ $(az version > /dev/null 2>&1; echo $?) -ne 0 ]]; then
      echo "[INFO] Installing Azure-CLI ..."
      sudo yum install -y azure-cli
    else
      if [[ $(sudo yum -q --disablerepo=* --enablerepo=azure-cli check-updates azure-cli &>/dev/null; echo $?) -eq 100 ]]; then
        sudo yum update -q -y --disablerepo=* --enablerepo=azure-cli azure-cli
      fi
    fi
    # login to enable the connection to azure
    echo "[INFO] Initilizing login to Azure ..."
    sudo az login --service-principal -u $AZURE_CLIENTID -p $AZURE_CLIENTSECRET --tenant $AZURE_TENANTID
    sudo az account set --subscription $AZURE_SUBID
  fi
  # End Prepare Azure-CLI

  ## Prepare keepalived
  # This will be considered as a prerequisite, not need to implemented by code
  #if [[  $(sudo keepalived -version > /dev/null 2>&1; echo $?) -ne 0 ]] && [[ $SETUP_VIP == true ]] && [[ -z $CLOUDPLATFORM ]]; then
  #  # setup keepalived on all master nodes
  #  echo "[INFO] Installing keepalived on all master nodes to set the VIP."
  #  #[TODO]
  #fi

  #[TODO]
  # update kubenetes manifest configuraion files with necessary modifications.
  
  # Prepare openssl
  if ! openssl version &>/dev/null; then
    echo "[INFO] Installing openssl ..."
    sudo rpm -Uvh $RPMFOLDER/openssl/*
    if [[ $? -ne 0 ]];then
      for openssl_file in $RPMFOLDER/openssl/*;do
        sudo rpm -Uvh $openssl_file
      done
    fi
  fi
  # End Prepare openssl

  # Prepare openjdk:keytool
  if (! which keytool &>/dev/null ); then
    echo "[INFO] Installing openjdk for keytool utility..."
    if ! which keytool &>/dev/null; then
       [ -d /usr/java/openjdk8 ] || sudo mkdir -p /usr/java/openjdk8
       sudo tar zxf $RPMFOLDER/openjdk-keytool/OpenJDK8U-jdk_x64_linux_hotspot_8u262b10.tar.gz -C /usr/java/openjdk8
       if [[ $? -eq 0 ]]; then
	  sudo ln -s /usr/java/openjdk8/jdk8u262-b10/bin/keytool /bin/keytool
       fi
    fi
  fi
  # End Prepare openjdk:keytool
  running_time

}
