function instanciate(){
#########################
# Function: instanciate
# To install GKE cluster with terraform scripts
#########################
    trap 'echo "[Error] Scripts failed when running function [lib/${FUNCNAME[0]}] - error line: $LINENO, error cmd: $BASH_COMMAND"' ERR
    
    reset_function_timer
    cd $SCRIPTPATH

    # Retrieve IP to be added in cluster white list
    CLIENT_IP=$(dig +short myip.opendns.com @resolver1.opendns.com)
    # To support using configmap for cms.var, the scripts should avoid writing into cms.var file
    #sed -i '/^bastion_vm_public_ip/d; /#bastion_vm_public_ip/abastion_vm_public_ip = "'$CLIENT_IP'"' $CMSCONF
    # From CMS10.1 on, update the value into variables.tf file
    if ! $RUN_AS_CONTAINER ; then
      sed -i '/^bastion_vm_public_ip /d' $CMSCONF
    fi
    sed -i '/variable "bastion_vm_public_ip"/{:a;N;/default[[:space:]]*=.*/!{$!ba};s/default[[:space:]]*=.*/default = "'$CLIENT_IP'"/}' $TF_DEFAULT_VARIABLES
    echo "OUTPUT_BASTION_IP=\"$CLIENT_IP\"" > $CLOUD_ENV

    ## Ensure to use the correct resource group name
    ##Use az to check whether the resource group with legacy resource group name exist
    ##If exist, use this legacy resource group name, otherwise, use the new formated resource group name
    #set_azure_resource_group

    beginLogging "Start deploying Cloud Kubernetes Cluster with terraform scripts."
    
    #Clear the existing products-matrix file as the AKS cluster will be recreated
    rm -rf ${MATRIXFILE}

    # Disable exit on error
    set +e
    
    if [[ ${CLOUDPLATFORM} == "GCP" ]];then
	TF_DIR="tf-gke"
    else
	TF_DIR="tf-aks"
    fi

    # Ensure any existing logs are owned by current user
    if [[ -f $SCRIPTPATH/$TF_DIR/terraform.tfstate ]];then
      _file_owner=$(ls -la $SCRIPTPATH/$TF_DIR/terraform.tfstate|awk '{print $3}')
      if [[ $(whoami > /dev/null 2>&1; echo $?) -eq 0 ]]; then
        _current_user=$(whoami 2>&1)
      else
        _current_user=$(id -u)
      fi
      if [[ "${_file_owner}" != "${_current_user}" ]];then
        user_confirm "Ensure all files and folders under \"$SCRIPTPATH/$TF_DIR\" are owned by current user [$_current_user] before continue."
      fi
    fi


    [ -f $LOG.terraform ] && mv -f $LOG.terraform $LOG.terraform.last

    cd $TERRAFORM_FOLDER
    /usr/sbin/terraform init -upgrade |& tee -a $LOG.terraform
    if [ ${PIPESTATUS[0]} -ne 0 ];then
       echo "[Error] Terraform init failed!"
       echo "Check $LOG.terraform.fail for more error details."
       mv -f $LOG.terraform $LOG.terraform.fail
       exit 1
    fi
    #if [[ ${CLOUDPLATFORM} == "AZURE" ]];then
    #  echo "[Info] Importing Azure Resource Group created before."
    #  sudo terraform import -var-file=$CMSCONF azurerm_resource_group.cms_rg /subscriptions/$AZURE_SUBID/resourceGroups/$CLUSTER_NAME-cms-resourcegroup
    #fi
    #
    (set +e; cat $CMSCONF; grep -w -e ^setup_trafficmanager_peer -e ^remote_resource_group -e ^remote_cluster_name $CMSGEOCONF; set +e) > $CMSCONF_COMBINE
    /usr/sbin/terraform plan -var-file=$CMSCONF_COMBINE -out=cms.tfplan |& tee -a $LOG.terraform
    if [ ${PIPESTATUS[0]} -ne 0 ];then
       echo "[Error] Terraform plan failed!"
       echo "Check $LOG.terraform.fail for more error details."
       mv -f $LOG.terraform $LOG.terraform.fail
       exit 1
    fi
    if [[ $1 != "--always-continue" ]];then
       user_confirm "Please confirm that the output of the terraform plan is as expected.\nEnter 'y' after confirm to continue or 'n' to abort the deployment. "
    fi
    /usr/sbin/terraform apply -auto-approve cms.tfplan|& tee -a $LOG.terraform
    if [ ${PIPESTATUS[0]} -ne 0 ];then
       echo "[Error] Terraform apply failed!"
       echo "Check $LOG.terraform.fail for more error details."
       mv -f $LOG.terraform $LOG.terraform.fail
       exit 1
    fi
    
    # Enable exit on error
    set -e

    # Terraform scripts executed successfully, remove any previous failure log.
    rm -f $LOG.terraform.fail
    
    # Save the output parameters as env for further usage
    grep "^OUTPUT_" $LOG.terraform | sed -e 's/ = /=/' >> $CLOUD_ENV
    # Remove the color characters
    sed -i 's/\x1b\[[0-9;]*m//g' $CLOUD_ENV

    #echo "[INFO] Complete deploying GKE Cluster with terraform scripts."
    #echo "[INFO] Complete date : $(date +"%Hh%Mm%Ss%3Nms")"
    
    # Change back to previous folder
    cd -

    # Get cluster credentials
    echo "[INFO] Get cluster credentials for kubectl command."
    if [[ ${CLOUDPLATFORM} == "GCP" ]];then
      #gcloud --quiet container clusters get-credentials "${CLOUD_CLUSTER_INSTANCE_NAME}" --zone "${GCP_ZONE}" --project "${GCP_PROJECT}"
      gcloud --quiet container clusters get-credentials "${CLUSTER_NAME}" --region ${GCP_REGION}
      # Grant admin right on cluster to service account
      if [[ $(kubectl get clusterrolebinding cluster-admin > /dev/null 2>&1; echo $?) -ne 0 ]];then
        echo "[INFO] Grant admin right on cluster to service account."
        #kubectl create clusterrolebinding cluster-admin-binding --clusterrole cluster-admin --user $(gcloud config get-value account)
        kubectl create clusterrolebinding cluster-admin --clusterrole cluster-admin --user $(gcloud config get-value account)
        if [[ "$(whoami)" != "root" ]]; then
          mkdir -p ~/.kube
          \cp /root/.kube/config ~/.kube/config
          chown -R $(whoami) ~/.kube
        fi
      fi
    fi
    if [[ ${CLOUDPLATFORM} == "AZURE" ]];then
      azure_get_aks_credentials
    fi

    running_time
}
