# cms-workflow

[cms-workflow]cms workflow server exporting service port 8080 and 8443.

## TL;DR;

```bash
$ helm install helm_repo/cms-workflow
```

## Introduction


## Prerequisites

- Kubernetes 1.4+ with Beta APIs enabled
- PV provisioner support in the underlying infrastructure

## Installing the Chart

To install the chart with the release name `my-release`:

```bash
$ helm install --name my-release helm_repo/cms-workflow
```

> **Tip**: List all releases using `helm list`

## Uninstalling the Chart

To uninstall/delete the `my-release` deployment:

```bash
$ helm delete my-release
```

The command removes all the Kubernetes components associated with the chart and deletes the release.

## Configuration

The following tables lists the configurable parameters of the Redis chart and their default values.

|           Parameter           |                Description                       |           Default            |
|-------------------------------|--------------------------------------------------|------------------------------|
| `image`                       | cms-workflow image                               | `cms-workflow:{VERSION}`     |
| `tag`                         | cms-workflow image tag                           | latest                       |
|`pullPolicy`                   | cms-workflow image pull policy                   | IfNotPresent                 |
| `nodeSelector`                | node labels for pod assignment                   | {}                           |
| `resources`                   | pod resource requests & limits                   |  requests: cpu: "300m" , memory: "300Mi"   limits: cpu: "3000m" memory: "6Gi" |
| `cms_pvc.cmsconf`             | cms-workflow PVC name which is mount to /opt/tandbergtv/cms/conf | pvc-cms-conf                   |   
| `cms_pvc.cmsplugin`           | cms-workflow PVC name which is mount to /opt/tandbergtv/cms/plugins/workflow | pvc-cms-plugin                   |
| `cms_pvc.cmsworkflowruntime`  | cms-workflow PVC name which is mount to /mnt/workflow-runtime | pvc-cms-workflow-runtime                   |

## NetworkPolicy


## Persistence


### Existing PersistentVolumeClaim

