{{- if eq .Release.Name "cms-pg-metadata-manager" -}}
{
  "proxyCheckInterval": "{{ .Values.clusterSpec.proxyCheckInterval }}",
  "proxyTimeout": "{{ .Values.clusterSpec.proxyTimeout }}",
  "pgParameters": {
    "recovery_target_inclusive": "off",
    "effective_cache_size": "{{ .Values.cmsPgParameters.effective_cache_size }}",
    "shared_buffers": "{{ .Values.cmsPgParameters.shared_buffers }}",
    "maintenance_work_mem": "{{ .Values.cmsPgParameters.maintenance_work_mem }}",
    "work_mem": "{{ .Values.cmsPgParameters.work_mem }}",
    "max_connections": "{{ .Values.cmsPgParameters.max_connections }}"
  }
}
{{- else if eq .Release.Name "cms-pg-workflow" -}}
{
  "proxyCheckInterval": "{{ .Values.clusterSpec.proxyCheckInterval }}",
  "proxyTimeout": "{{ .Values.clusterSpec.proxyTimeout }}",
  "pgParameters": {
    "recovery_target_inclusive": "off",
    "effective_cache_size": "{{ .Values.wfsPgParameters.effective_cache_size }}",
    "shared_buffers": "{{ .Values.wfsPgParameters.shared_buffers }}",
    "maintenance_work_mem": "{{ .Values.wfsPgParameters.maintenance_work_mem }}",
    "work_mem": "{{ .Values.wfsPgParameters.work_mem }}",
    "max_connections": "{{ .Values.wfsPgParameters.max_connections }}"
  }
}
{{- else if eq .Release.Name "cms-pg-epg" -}}
{
  "proxyCheckInterval": "{{ .Values.clusterSpec.proxyCheckInterval }}",
  "proxyTimeout": "{{ .Values.clusterSpec.proxyTimeout }}",
  "pgParameters": {
    "recovery_target_inclusive": "off",
    "effective_cache_size": "{{ .Values.epgPgParameters.effective_cache_size }}",
    "shared_buffers": "{{ .Values.epgPgParameters.shared_buffers }}",
    "maintenance_work_mem": "{{ .Values.epgPgParameters.maintenance_work_mem }}",
    "work_mem": "{{ .Values.epgPgParameters.work_mem }}",
    "max_connections": "{{ .Values.epgPgParameters.max_connections }}"
  }
}
{{- else -}}
{"pgParameters": {"recovery_target_inclusive": "off" }}
{{- end -}}