function post_check(){
  local fail warn j k pod_stats cronjob_pod pod_stats_error_1 pod_stats_error_2 exception_count_1 exception_count_2 current_container desired_container
  trap 'echo "[Error] Scripts failed when running function [lib/${FUNCNAME[0]}] - error line: $LINENO, error cmd: $BASH_COMMAND"' ERR

  reset_function_timer
  cd $SCRIPTPATH
        
  beginLogging "Start post-check."
  
  NAMESPACE=$1
  fail=0
  
  echo -e "\n[INFO] 25min checking CMS kubenetes pods deployment status.."
  j=0
  while [[ $j -lt 30 ]]; do
    pod_stats=$(kubectl get pod -n $NAMESPACE --no-headers=true 2>/dev/null)
    cronjob_pod=$(kubectl get cronjobs -n $NAMESPACE --no-headers=true 2>/dev/null|awk '{print $1}')
    for k in $cronjob_pod; do
      pod_stats=$(echo "$pod_stats"|grep -v ${k}-)
    done
    pod_stats_error_1=$(echo "$pod_stats"|awk '($3 != "Running" && $3 != "Completed")')
    pod_stats_error_2=$(echo "$pod_stats"|awk '($3 == "Running" )'|while read line; do
      current_container=$(echo "$line"|awk '{print $2}'|cut -f1 -d/)
      desired_container=$(echo "$line"|awk '{print $2}'|cut -f2 -d/)
      if [[ $desired_container -eq 0 ]]; then
        echo "$line"
      elif [[ $current_container -ne $desired_container ]]; then
        echo "$line"
      fi
    done)
    exception_count_1=$(echo "$pod_stats_error_1"|grep -v ^$|wc -l)
    if [[ $exception_count_1 -gt 0 ]]; then
      fail=1
    elif [[ $exception_count_1 -eq 0 ]]; then
      fail=0
    fi
    exception_count_2=$(echo "$pod_stats_error_2"|grep -v ^$|wc -l)
    if [[ $exception_count_2 -gt 0 ]]; then
      warn=1
    elif [[ $pod_stats_error_2 -eq 0 ]]; then
      warn=0
    fi
    if [[ $fail -eq 0 ]] && [[ $warn -eq 0 ]]; then
      break
    elif [[ $fail -eq 1 ]]; then
      #sleep 30
      sleep_pot 30
      ((++j))
      continue
    elif [[ $warn -eq 1 ]]; then
      #sleep 50
      sleep_pot 50
      ((++j))
      continue
    fi
  done
  if [[ $fail -eq 1 ]]; then
    echo -e "\n[WARN] The CMS pods are not started up fully yet, but checking time exceeded. Please find the current pods status:"
    echo "$pod_stats_error_1"
  fi
  if [[ $warn -eq 1 ]]; then
    echo -e "\n[WARN] The CMS services are not started up fully yet, but checking time exceeded. Please find the current services status:"
    echo "$pod_stats_error_2"
  fi

  echo
  if [[ $fail -eq 0 ]] && [[ $warn -eq 0 ]]; then
    echo -e '\n[INFO] ALL CMS pods are running as bellow:'
    kubectl get pod -n $NAMESPACE
    echo -e '\n[INFO] CMS Deployed Completed.'
    exit 0
  elif [[ $fail -eq 1 ]]; then
    exit 1
  elif [[ $warn -eq 1 ]]; then
    exit 1
  fi
}
