#!/usr/bin/python

import os
import sys
import yaml

def yamltodic(filepath):
  _dict = {}
  _file = open(filepath, 'r')
  _dict = yaml.load(_file, Loader=yaml.FullLoader)
  _file.close()
  return _dict

if __name__ == "__main__":

  sample_var_file = sys.argv[1]
  var_file = sys.argv[2]
  
  print(sample_var_file)
  print(var_file)

  path = os.path.dirname(sample_var_file)
  merged_file = os.path.join(path, "merged.yaml")

  sample_var_dict = yamltodic(sample_var_file)
  var_dict = yamltodic(var_file)
  merged_dict = {}

  merged_dict = sample_var_dict.copy()
  merged_dict.update(var_dict)

  with open(merged_file, 'w') as f:
    yaml.dump(merged_dict, f, default_flow_style=False)
    f.truncate() 

