function init_cfgBundle() {
    trap 'echo "[Error] Scripts failed when running function [lib/${FUNCNAME[0]}] - error line: $LINENO, error cmd: $BASH_COMMAND"' ERR

    reset_function_timer
    cd $SCRIPTPATH
        
    beginLogging "Start initializing config bundle."
    
    check_packages $CONFIG_PACKAGE

    ###mkdir -p $BUNDLEFOLDER/kube
    ###touch $BUNDLEFOLDER/kube/kube-config.yaml
    ###mkdir -p $BUNDLEFOLDER/products
    ###touch $BUNDLEFOLDER/products/products-config.yaml
    
    mkdir -p $BUNDLEFOLDER
    tar xzf packages/cms-config-bundle-$(ls packages/$CONFIG_PACKAGE|awk -F'-' '{print $NF}'|sort -Vr|head -1) -C $BUNDLEFOLDER
    #tar xzf $(ls -rt packages/$CONFIG_PACKAGE|tail -1) -C $BUNDLEFOLDER
    #### Only need to extra the products folder from the bundld package file
    ###tar xvzf $(ls -rt packages/$CONFIG_PACKAGE|tail -1) -C $BUNDLEFOLDER products
 
    ########################################
    # Create products-matrix file only when the file is not there
    # For Core Compact deployment, only initilize one (first) node with all profiles.
    # For Core Enterprise deployment, initilize the first 3 nodes with db profiles, and no db profiles from the 4th node on.
    # The db profiles on the first 3 nodes initilized as below,
    # node-1: cms-db-epg, cms-db-workflow
    # node-2: cms-db-metadata-manager, cms-db-workflow
    # node-3: cms-db-metadata-manager, cms-db-epg
    # For external CT deployment, initilize all nodes with cms-common and cms-ct profiles.
    
    #if [[ -f ${MATRIXFILE} ]]; then
    #  cp ${MATRIXFILE} ${MATRIXFILE}.backup.$(date +"%Y%m%d-%H%M%S")
    #fi
    
    #Remove empty matrix file in case it was created by error scenario
    if [[ -f ${MATRIXFILE} ]] && [[ $(cat ${MATRIXFILE}|wc -l) -eq 0 ]]; then
      echo "[WARNING] Removing empty products-matrix.yaml file" 
      rm -f ${MATRIXFILE}
    fi

    if [[ ${CLOUDPLATFORM} == "GCP" ]]; then
      rm -f ${MATRIXFILE}	#need to remove matrix file, because of node pool auto-scaling
    fi

    if [[ ! -f ${MATRIXFILE} ]]; then  
       > $MATRIXFILE
  
      # Update configBundle with node names, meanwhile bypass the nodes from aks default pool.
      echo "[INFO] Getting K8S node information."
      set +e
      NODES_INFO=$(kubectl get nodes --no-headers --request-timeout=60s 2>/dev/null)
      retry_get=4
      while [[ -z "$NODES_INFO" ]]; do
        echo "[WARNING] No K8S node information can be fetched, Kubernetes cluster maybe not ready yet, retry getting node info."
        sleep 30
        NODES_INFO=$(kubectl get node --no-headers --request-timeout=60s 2>/dev/null)
        if [[ $retry_get -gt 0 ]]; then
          let "retry_get-=1"
        else
          echo "[ERROR] Kubernetes nodes maybe not ready yet, please make sure the command \"kubectl get node\" can get nodes information and then re-run this init-config step again."
          exit 1  
        fi  
      done
      set -e
      NODES=$(echo "$NODES_INFO" | grep -v defaultpool | awk '{print $1}' | xargs)
      NODE_AMOUNT=$(echo "$NODES_INFO" | grep -v defaultpool | wc -l)
  
      if [[ $K8S_PLATFORM == "openshift" ]]; then
        NODES=$(echo "$NODES_INFO" | grep -v defaultpool | egrep -v 'control-plane|master' | awk '{print $1}' | xargs)
        NODE_AMOUNT=$(echo "$NODES_INFO" | grep -v defaultpool | egrep -v 'control-plane|master' | wc -l)
      fi

      #For Core deployment
      if [[ $CLUSTER_ROLE != "externalct" ]]; then
        #For Compact Core deployment
        if [[ $CMS_TYPE != "enterprise" ]];then
          nodename=${NODES%% *}
          echo "[INFO] Setting Node $nodename with all profiles within products-matrix.yaml file for Core Compact deployment."
          cat << EOM >> ${MATRIXFILE}
- node: $nodename
  profiles:
  - name: cms
    version: $CMS_PROFILE_VERSION
  - name: cms-common
    version: $COMMON_PROFILE_VERSION
  - name: cms-ct
    version: $CT_PROFILE_VERSION
  - name: cms-es-application
    version: $ES_PROFILE_VERSION
  - name: cms-etcd
    version: $ETCD_PROFILE_VERSION
  - name: cms-db-epg
    version: $DB_PROFILE_VERSION
  - name: cms-db-workflow
    version: $DB_PROFILE_VERSION
  - name: cms-db-metadata-manager
    version: $DB_PROFILE_VERSION
EOM

        #For Enterprise Core deployment
        else
          if [[ $NODE_AMOUNT -lt 3 ]]; then
            echo "[ERROR] Minimum Node amount for Core Enterprise deployment is 3"
            exit 1
          fi
          DBPOFILESNODE1="  - name: cms-db-epg
    version: $DB_PROFILE_VERSION
  - name: cms-db-workflow
    version: $DB_PROFILE_VERSION
  - name: cms-etcd
    version: $ETCD_PROFILE_VERSION"
        DBPOFILESNODE2="  - name: cms-db-workflow
    version: $DB_PROFILE_VERSION
  - name: cms-db-metadata-manager
    version: $DB_PROFILE_VERSION
  - name: cms-etcd
    version: $ETCD_PROFILE_VERSION"
        DBPOFILESNODE3="  - name: cms-db-epg
    version: $DB_PROFILE_VERSION
  - name: cms-db-metadata-manager
    version: $DB_PROFILE_VERSION
  - name: cms-etcd
    version: $ETCD_PROFILE_VERSION"
          # For Enterprise Core with internal CT
          if [[ $CLUSTER_ROLE == "core" ]] && [[ $INTERNAL_CT_ENABLED == "true" ]]; then
            i=0
            for nodename in $NODES;
            do
              i=$(($i+1))
              echo "[INFO] Setting Node $nodename with CMS CORE profiles within products-matrix.yaml file."
              dbprofiles=DBPOFILESNODE$i
              cat << EOM >> ${MATRIXFILE}
- node: $nodename
  profiles:
  - name: cms
    version: $CMS_PROFILE_VERSION
  - name: cms-common
    version: $COMMON_PROFILE_VERSION
  - name: cms-ct
    version: $CT_PROFILE_VERSION
  - name: cms-es-application
    version: $ES_PROFILE_VERSION
${!dbprofiles}
EOM
            done
          fi # End Enterprise Core with internal CT
          
          # For Enterprise Core without internal CT
          if [[ $CLUSTER_ROLE == "core" ]] && [[ $INTERNAL_CT_ENABLED == "false" ]]; then
            i=0
            for nodename in $NODES;
            do
              i=$(($i+1))
              echo "[INFO] Setting Node $nodename with CMS CORE profiles (No CT) within products-matrix.yaml file."
              dbprofiles=DBPOFILESNODE$i
              cat << EOM >> ${MATRIXFILE}
- node: $nodename
  profiles:
  - name: cms
    version: $CMS_PROFILE_VERSION
  - name: cms-common
    version: $COMMON_PROFILE_VERSION
  - name: cms-es-application
    version: $ES_PROFILE_VERSION
${!dbprofiles}
EOM
            done
          fi # End Enterprise Core without internal CT
        fi # End Compact or Enterprise
      fi # End Core deployment

      # For external CT deployment
      if [[ $CLUSTER_ROLE == "externalct" ]]; then
        for nodename in $NODES;
        do
          #[TODO] Create products-matrix based on the pre-defined matrix sample files
          echo "[INFO] Setting Node $nodename with CMS EXTERNALCT profiles within products-matrix.yaml file."
          cat << EOM >> ${MATRIXFILE}
- node: $nodename
  profiles:
  - name: cms-common
    version: $COMMON_PROFILE_VERSION
  - name: cms-ct
    version: $CT_PROFILE_VERSION
EOM
        done
      fi # End external CT deployment
    else # If matrix file exist
      echo "[INFO] Updating products-matrix.yaml"
      cp -a ${MATRIXFILE} ${MATRIXFILE}.backup.$(date +"%Y%m%d-%H%M%S")
      matrix=$(cat $MATRIXFILE)
      #matrix_length=$(echo "$matrix"|yq r - --length)	#change to yq4
      matrix_length=$(echo "$matrix"|yq 'length' -)
      for ((i=0; i<$matrix_length; i++))
      do
        #matrix_profile_length=$(echo "$matrix"|yq r - --length '['$i'].profiles')
        matrix_profile_length=$(echo "$matrix"|yq '.['$i'].profiles|length' -)
        for ((j=0; j<$matrix_profile_length; j++))
        do
          for k in ${!PROFILES[*]}
          do
            #name=$(echo "$matrix"|yq r - '['$i'].profiles.['$j'].name')
            name=$(echo "$matrix"|yq '.['$i'].profiles.['$j'].name' -)
            if [[ "$k" == "$name" ]];
            then
              #yq w -i $MATRIXFILE '['$i'].profiles.['$j'].version' ${PROFILES["$k"]}
	      PRK=${PROFILES["$k"]}
	      yq -i ".["$i"].profiles.["$j"].version=\"$PRK\"" $MATRIXFILE
            fi
          done
        done
      done
    fi #End if matrix file exist decision

    ########################################
    # For profiles
    # For Azure deployment, update profile to remove cms-nfs deploy
    if [[ ${CLOUDPLATFORM} == "AZURE" ]]; then
      echo "[INFO] Updating profile to remove nfs deploy for AKS deployment."
      #yq d -i $PROFILEFOLDER/prof_cms-common_$COMMON_PROFILE_VERSION.yaml 'packages.(deploy-package==cms-nfs)'
      yq -i 'del(.packages.[] | select (.deploy-package == "cms-nfs") )' $PROFILEFOLDER/prof_cms-common_$COMMON_PROFILE_VERSION.yaml
    fi

    # For cms core deployment, update profile to remove cms-redis deploy
    if [[ $CLUSTER_ROLE == "core" ]]; then
      echo "[INFO] Updating profile to remove redis deploy for CMS CORE deployment."
      #yq d -i $PROFILEFOLDER/prof_cms-ct_$CT_PROFILE_VERSION.yaml 'packages.(deploy-package==cms-redis)'
      yq -i 'del(.packages.[] | select (.deploy-package == "cms-redis") )' $PROFILEFOLDER/prof_cms-ct_$CT_PROFILE_VERSION.yaml
    fi

    # For limited deployment, update profile to remove below components
    # - cms-webhook
    # - cms-nfs
    # - cms-ftp
    if ${LIMITED_DEPLOYMENT}; then
      echo "[INFO] Updating profile to remove cms-webhook component for limited deployment."
      #yq d -i $PROFILEFOLDER/prof_cms-common_$COMMON_PROFILE_VERSION.yaml 'packages.(deploy-package==cms-webhook)'
      yq -i 'del(.packages.[] | select (.deploy-package == "cms-webhook") )' $PROFILEFOLDER/prof_cms-common_$COMMON_PROFILE_VERSION.yaml

      echo "[INFO] Updating profile to remove cms-nfs component for limited deployment."
      #yq d -i $PROFILEFOLDER/prof_cms-common_$COMMON_PROFILE_VERSION.yaml 'packages.(deploy-package==cms-nfs)'
      yq -i 'del(.packages.[] | select (.deploy-package == "cms-nfs") )' $PROFILEFOLDER/prof_cms-common_$COMMON_PROFILE_VERSION.yaml

      echo "[INFO] Updating profile to remove cms-ftp component for limited deployment."
      #yq d -i $PROFILEFOLDER/prof_cms-ct_$CT_PROFILE_VERSION.yaml 'packages.(deploy-package==cms-ftp)'
      yq -i 'del(.packages.[] | select (.deploy-package == "cms-ftp") )' $PROFILEFOLDER/prof_cms-ct_$CT_PROFILE_VERSION.yaml
    fi
 
    if ! ${ALLOW_WEBHOOK}; then
      # Webhook is not allowed, remove cms-webhook component
      echo "[INFO] Updating profile to remove cms-webhook component for webhook is not allowed."
      yq -i 'del(.packages.[] | select (.deploy-package == "cms-webhook") )' $PROFILEFOLDER/prof_cms-common_$COMMON_PROFILE_VERSION.yaml
    fi

    # When user provides storageclass_name in cms.var,
    # and this storageclass name is not equal to 'cms-data', 
    # which means user has predefined provisioner/CSI ready in the cluster and no need to deploy cms-nfs.
    # Update profile to remove cms-nfs components in this case.
    if ([[ -n ${STORAGECLASS_NAME} ]] && [[ ${STORAGECLASS_NAME} != "cms-data" ]]) || [[ ${CLOUDPLATFORM} == "AWS" ]]; then
      echo "[INFO] Updating profile to remove cms-nfs component while using user provided storageclass [$STORAGECLASS_NAME]."
      #yq d -i $PROFILEFOLDER/prof_cms-common_$COMMON_PROFILE_VERSION.yaml 'packages.(deploy-package==cms-nfs)'
      yq -i 'del(.packages.[] | select (.deploy-package == "cms-nfs") )' $PROFILEFOLDER/prof_cms-common_$COMMON_PROFILE_VERSION.yaml
    fi

    ########################################
    # For products-var.yaml
    echo "[INFO] Updating products-var.yaml to pass values from cms.var."
    # Use yq to merge the sample with existing products-var.yaml if exist
    if [[ -f ${PRODUCTSVAR_FILE} ]]; then
      PRODUCTSVAR_FILE_EXIS=true
      #backup the products-var.yaml
      cp ${BUNDLEFOLDER}/products-var.yaml ${BUNDLEFOLDER}/products-var.yaml.backup.$(date +"%Y%m%d-%H%M%S")

      if [[ "$DEV_MODE" == "true" ]];then
        #yq m -x ${PRODUCTSVAR_FILE}.sample.${CMS_TYPE_LOWER}.dev ${PRODUCTSVAR_FILE} > /tmp/temp.yaml
        #yq d -i /tmp/temp.yaml cms_images_tag.
        #yq r ${PRODUCTSVAR_FILE}.sample.${CMS_TYPE_LOWER}.dev -p pv cms_images_tag cms_images_tag. |yq m -ix /tmp/temp.yaml -

	yq eval-all "select(fileIndex == 0) * select(filename == \"${PRODUCTSVAR_FILE}\")" ${PRODUCTSVAR_FILE}.sample.${CMS_TYPE_LOWER}.dev ${PRODUCTSVAR_FILE} > /tmp/temp1.yaml
	yq -i 'del(.cms_images_tag)' /tmp/temp1.yaml
	yq 'with_entries(select(.key | test("cms_images_tag")))' ${PRODUCTSVAR_FILE}.sample.${CMS_TYPE_LOWER}.dev > /tmp/temp2.yaml
        yq eval-all "select(fileIndex == 0) * select(filename == \"/tmp/temp2.yaml\")" /tmp/temp1.yaml /tmp/temp2.yaml > /tmp/temp.yaml
      else
        #yq m -x ${PRODUCTSVAR_FILE}.sample.${CMS_TYPE_LOWER} ${PRODUCTSVAR_FILE} > /tmp/temp.yaml
        #yq d -i /tmp/temp.yaml cms_images_tag.
        #yq r ${PRODUCTSVAR_FILE}.sample.${CMS_TYPE_LOWER} -p pv cms_images_tag cms_images_tag. |yq m -ix /tmp/temp.yaml -

	yq eval-all "select(fileIndex == 0) * select(filename == \"${PRODUCTSVAR_FILE}\")" ${PRODUCTSVAR_FILE}.sample.${CMS_TYPE_LOWER} ${PRODUCTSVAR_FILE} > /tmp/temp1.yaml
	yq -i 'del(.cms_images_tag)' /tmp/temp1.yaml
	yq 'with_entries(select(.key | test("cms_images_tag")))' ${PRODUCTSVAR_FILE}.sample.${CMS_TYPE_LOWER} > /tmp/temp2.yaml
        yq eval-all "select(fileIndex == 0) * select(filename == \"/tmp/temp2.yaml\")" /tmp/temp1.yaml /tmp/temp2.yaml > /tmp/temp.yaml
      fi

      mv -f /tmp/temp.yaml ${PRODUCTSVAR_FILE}
      rm -f /tmp/temp1.yaml
      rm -f /tmp/temp2.yaml

    fi
    
    # Create the products-var file when file is not existing.
    [[ "$DEV_MODE" == "true" ]] && [[ ! -f ${PRODUCTSVAR_FILE} ]] && cp ${PRODUCTSVAR_FILE}.sample.${CMS_TYPE_LOWER}.dev ${PRODUCTSVAR_FILE}
    [[ "$DEV_MODE" != "true" ]] && [[ ! -f ${PRODUCTSVAR_FILE} ]] && cp ${PRODUCTSVAR_FILE}.sample.${CMS_TYPE_LOWER} ${PRODUCTSVAR_FILE}
        

    #[[ -n ${CMS_NAMESPACE} ]] && sed -i 's/^cms_namespace:.*/cms_namespace: '${CMS_NAMESPACE}'/' ${PRODUCTSVAR_FILE}
    #[[ -n ${CLUSTER_NAME} ]] && sed -i 's/^cms_cluster_name:.*/cms_cluster_name: '${CLUSTER_NAME}'/' ${PRODUCTSVAR_FILE}
    #[[ -n ${CLUSTER_ROLE} ]] && sed -i 's/^cms_role:.*/cms_role: '${CLUSTER_ROLE}'/' ${PRODUCTSVAR_FILE}

    #[[ -n ${K8S_PLATFORM} ]] && yq -i ".k8s_platform=\"${K8S_PLATFORM}\"" ${PRODUCTSVAR_FILE}
    yq -i ".k8s_platform=\"${K8S_PLATFORM}\"" ${PRODUCTSVAR_FILE}

    [[ -n ${RUN_FILEBEAT_USERID} ]] && yq -i ".runFilebeatAsUserID=\"${RUN_FILEBEAT_USERID}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${RUN_FILEBEAT_GROUPID} ]] && yq -i ".runFilebeatAsGroupID=\"${RUN_FILEBEAT_GROUPID}\"" ${PRODUCTSVAR_FILE}

    [[ -n ${CMS_NAMESPACE} ]] && yq -i ".cms_namespace=\"${CMS_NAMESPACE}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${CMS_TIMEZONE} ]] && yq -i ".timezone=\"${CMS_TIMEZONE}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${CMS_TOMCAT_UMASK} ]] && yq -i ".cms_tomcat.umask=\"${CMS_TOMCAT_UMASK}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${CLUSTER_NAME} ]] && yq -i ".cms_cluster_name=\"${CLUSTER_NAME}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${CLUSTER_ROLE} ]] && yq -i ".cms_role=\"${CLUSTER_ROLE}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${INTERNAL_CT_ENABLED} ]] && yq -i ".internal_ct_enabled=\"${INTERNAL_CT_ENABLED}\"" ${PRODUCTSVAR_FILE}

    yq -i ".cmsAdminServiceAccountName=\"${CMS_ADMIN_SERVICE_ACCOUNT_NAME}\"" ${PRODUCTSVAR_FILE}
    if [[ -z "${CMS_ADMIN_SERVICE_ACCOUNT_NAME}" ]];then
      yq -i ".cms_nfs.serviceAccountName=\"${DEFAULT_CMS_ADMIN_SERVICE_ACCOUNT_NAME}\"" ${PRODUCTSVAR_FILE}
      yq -i ".cms_filebeat.serviceAccountName=\"${DEFAULT_CMS_ADMIN_SERVICE_ACCOUNT_NAME}\"" ${PRODUCTSVAR_FILE}
      yq -i ".cms_metricbeat.serviceAccountName=\"${DEFAULT_CMS_ADMIN_SERVICE_ACCOUNT_NAME}\"" ${PRODUCTSVAR_FILE}
    else
      yq -i ".cms_nfs.serviceAccountName=\"${CMS_ADMIN_SERVICE_ACCOUNT_NAME}\"" ${PRODUCTSVAR_FILE}
      yq -i ".cms_filebeat.serviceAccountName=\"${CMS_ADMIN_SERVICE_ACCOUNT_NAME}\"" ${PRODUCTSVAR_FILE}
      yq -i ".cms_metricbeat.serviceAccountName=\"${CMS_ADMIN_SERVICE_ACCOUNT_NAME}\"" ${PRODUCTSVAR_FILE}
    fi

    [[ -n ${CONTENT_NAS_SIZE} ]] && yq -i ".cms_pvc.cmscontent.size=\"${CONTENT_NAS_SIZE}\"" ${PRODUCTSVAR_FILE}

    [[ -n ${FTP_ENABLED} ]] && yq -i ".cms_ftp.enable=\"${FTP_ENABLED}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${FTP_PASSIVEPORTMIN} ]] && yq -i ".cms_ftp.passiveportMin=\"${FTP_PASSIVEPORTMIN}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${FTP_PASSIVEPORTMAX} ]] && yq -i ".cms_ftp.passiveportMax=\"${FTP_PASSIVEPORTMAX}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${FTP_USER} ]] && yq -i ".cms_ftp.user=\"${FTP_USER}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${FTP_PASSWORD_B64} ]] && yq -i ".cms_ftp.password_b64=\"${FTP_PASSWORD_B64}\"" ${PRODUCTSVAR_FILE}

    # for cms geo install.
    [[ -n ${GEO_KUBERNETES_SERVER_FQDN} ]] && yq -i ".cms_geo.kubernetes_server_fqdn=\"${GEO_KUBERNETES_SERVER_FQDN}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_REMOTE_CLUSTER_IP} ]] && yq -i ".cms_geo.remote_cluster_ip=\"${GEO_REMOTE_CLUSTER_IP}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_REMOTE_CLUSTER_NAME} ]] && yq -i ".cms_geo.remote_cluster_name=\"${GEO_REMOTE_CLUSTER_NAME}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_REMOTE_KUBE_CONFIG_BASE64} ]] && yq -i ".cms_geo.remote_kube_config_base64=\"${GEO_REMOTE_KUBE_CONFIG_BASE64}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_REMOTE_NAMESPACE} ]] && yq -i ".cms_geo.remote_namespace=\"${GEO_REMOTE_NAMESPACE}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_SSH_AUTH_KEY} ]] && yq -i ".cms_geo.ssh_auth_key=\"${GEO_SSH_AUTH_KEY}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_SSH_PRIVATE_KEY} ]] && yq -i ".cms_geo.ssh_private_key=\"${GEO_SSH_PRIVATE_KEY}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_FILERSYNC_SSH_PORT} ]] && yq -i ".cms_geo.filersync_ssh_port=\"${GEO_FILERSYNC_SSH_PORT}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_RABBITMQ_RSYNC_SSH_PORT} ]] && yq -i ".cms_geo.rabbitmq_rsync_ssh_port=\"${GEO_RABBITMQ_RSYNC_SSH_PORT}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_METADATA_MANAGER_STOLON_PROXY_NODE_PORT} ]] && yq -i ".cms_geo.metadata_manager_stolon_proxy_node_port=\"${GEO_METADATA_MANAGER_STOLON_PROXY_NODE_PORT}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_WORKFLOW_STOLON_PROXY_NODE_PORT} ]] && yq -i ".cms_geo.workflow_stolon_proxy_node_port=\"${GEO_WORKFLOW_STOLON_PROXY_NODE_PORT}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_EPG_STOLON_PROXY_NODE_PORT} ]] && yq -i ".cms_geo.epg_stolon_proxy_node_port=\"${GEO_EPG_STOLON_PROXY_NODE_PORT}\"" ${PRODUCTSVAR_FILE}
    [[ -n ${GEO_ES_APPLICATION_CLIENT_PORT} ]] && yq -i ".cms_geo.es_application_client_port=\"${GEO_ES_APPLICATION_CLIENT_PORT}\"" ${PRODUCTSVAR_FILE}

    # For ImagePullSecret
    if [[ -n "$IMAGE_REGISTRY" ]]; then
      if ([[ -n "$IMAGE_PULL_USER" ]] && [[ -z "$IMAGE_PULL_PASSWORD" ]]) || ([[ -z "$IMAGE_PULL_USER" ]] && [[ -n "$IMAGE_PULL_PASSWORD" ]]); then
        echo "[Error] One of image_pull_user and image_pull_password is empty, ensure both variables have values provided before rerun."
        exit 1
      #elif [[ -n "$IMAGE_PULL_USER" ]] && [[ -n "$IMAGE_PULL_PASSWORD" ]] && [[ -z "$(yq r ${PRODUCTSVAR_FILE} 'imagePullSecrets.(name=='$IMAGE_PULL_SECRET_NAME')')" ]]; then
      elif [[ -n "$IMAGE_PULL_USER" ]] && [[ -n "$IMAGE_PULL_PASSWORD" ]] && [[ -z "$(yq ".imagePullSecrets[]|select(.[] == \"$IMAGE_PULL_SECRET_NAME\")" ${PRODUCTSVAR_FILE})" ]]; then
        # append cms-image-pull-secret into products-var when both pull user and password are provided
	#yq w -i ${PRODUCTSVAR_FILE} 'imagePullSecrets[+].name' "$IMAGE_PULL_SECRET_NAME"
	yq -i ".imagePullSecrets += [{\"name\": \"$IMAGE_PULL_SECRET_NAME\"}]" ${PRODUCTSVAR_FILE}
      #elif [[ -z "$IMAGE_PULL_USER" ]] && [[ -z "$IMAGE_PULL_PASSWORD" ]]; then
      #  # clean cms-image-pull-secret from products-var when both pull user and password are empty
      #  yq d -i ${PRODUCTSVAR_FILE} 'imagePullSecrets.(name=='$IMAGE_PULL_SECRET_NAME')'
      fi
    fi
 
    # for apparmor profile
    [[ -n ${APPARMOR_PROFILE_NAME} ]] && yq -i ".apparmorProfileName=\"${APPARMOR_PROFILE_NAME}\"" ${PRODUCTSVAR_FILE}

    # for limited deployment
    yq -i ".allowWebhook=\"${ALLOW_WEBHOOK}\"" ${PRODUCTSVAR_FILE}
    yq -i ".limitedDeployment=\"${LIMITED_DEPLOYMENT}\"" ${PRODUCTSVAR_FILE}
    yq -i ".k8s_cluster_domain=\"${K8S_CLUSTER_DOMAIN}\"" ${PRODUCTSVAR_FILE}
    if ${LIMITED_DEPLOYMENT}; then
      if [[ -z ${STORAGECLASS_NAME} ]]; then
        echo "[Error] Ensure to provide valid storageclass_name in limited_deployment scenario."
        exit 1
      fi

      ALLOW_ROOT_USER_FOR_INIT_CONTAINER=false
      ALLOW_HOST_PATH=false
      #yq -i '.allowRootUserForInitContainer="false"' ${PRODUCTSVAR_FILE}
      #yq -i '.allowHostPath="false"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Clear all nodeSelector settings for limited deployment scenario."
      sed -i 's/  nodeSelector: .*/  nodeSelector:/' ${PRODUCTSVAR_FILE}
    fi

    # For nodes are not allowed to be labeled
    # Only need to ensure using pre-defined storageclass for On-Prem case.
    # For Cloud cases, we set ALLOW_CREATE_NODE_LABEL to false because we don't need to lable the node,
    # as the node label already being set in the node pool level.
    if [[ -z "$CLOUDPLATFORM" ]] && ! ${ALLOW_CREATE_NODE_LABEL} ; then
      if [[ -z ${STORAGECLASS_NAME} ]]; then
        echo "[Error] Ensure to provide valid storageclass_name if the allow_create_node_label parameter is set to false."
        exit 1
      fi
      echo "[INFO] Clear all nodeselector settings in the scenario where node labeling is not allowed."
      sed -i 's/  nodeSelector: .*/  nodeSelector:/' ${PRODUCTSVAR_FILE}
      sed -i 's/  nodeAffinityLabels: .*/  nodeAffinityLabels:/' ${PRODUCTSVAR_FILE}
    fi

    echo "[INFO] Updating allowRootUserForInitContainer to ${ALLOW_ROOT_USER_FOR_INIT_CONTAINER}."
    yq -i ".allowRootUserForInitContainer=${ALLOW_ROOT_USER_FOR_INIT_CONTAINER}" ${PRODUCTSVAR_FILE}

    echo "[INFO] Updating allowHostPath to ${ALLOW_HOST_PATH}."
    yq -i ".allowHostPath=${ALLOW_HOST_PATH}" ${PRODUCTSVAR_FILE}

    # for PSP name
    yq -i ".podSecurityPolicyName=\"${POD_SECURITY_POLICY_NAME}\"" ${PRODUCTSVAR_FILE}
    #[[ -n ${STORAGECLASS_NAME} ]] && yq w -i ${PRODUCTSVAR_FILE} 'apparmorProfileName' "${APPARMOR_PROFILE_NAME}"

    # Create CMS namespace
    create_namespace $CMS_NAMESPACE

    if [[ $CLUSTER_ROLE == "core" ]]; then
      # Init the license base64
      gen_base64 $LICENSE_FILE cms_license_xml_base64 ERROR
      # Init the SSL CA base64, no need since new cert generation method
      #gen_base64 $SSL_FOLDER/server.keystore cms_ssl.serverkeystoreb64 WARN
      #gen_base64 $SSL_FOLDER/client_auth_keystore.jks cms_ssl.client_auth_keystorejksb64 WARN
      #gen_base64 $SSL_FOLDER/cms_truststore.jks cms_ssl.cms_truststorejksb64 WARN
      #gen_base64 $SSL_FOLDER/keystore.pass cms_ssl.keystorepassb64 WARN
      #gen_base64 $SSL_FOLDER/.cms_fingerprint cms_ssl.cms_fingerprintb64 WARN
      #gen_base64 $SSL_FOLDER/haproxy.pem cms_ssl.haproxypemb64 WARN
      #gen_base64 $SSL_FOLDER/app.pem cms_ssl.apppemb64 WARN
      #gen_base64 $SSL_FOLDER/clients.pem cms_ssl.clientpemb64 WARN

      # Generate certificate files for elastic stacks
      # Only necessary for core cluster
      if kubectl get secret --request-timeout 30s -n $CMS_NAMESPACE elastic-tls &>/dev/null ; then
        echo "[INFO] ELK certs exists, skip create"
      else
        echo "[INFO] Generating CMS cluster signed certificate for elastic stacks"
        if [[ -z "$CLOUDPLATFORM" ]]; then
          gen_self_cert "elastic" $CMS_NAMESPACE ""
        else
          gen_self_cert "elastic" "$CMS_NAMESPACE" "$CLOUD_CLUSTER_INSTANCE_NAME"
        fi
        echo "[INFO] Preparing elastic-tls secret with cluster signed certificate files"
        cat <<- EOF | kubectl apply -f -
			apiVersion: v1
			kind: Secret
			metadata:
			  name: elastic-tls
			  namespace: $CMS_NAMESPACE
			  labels:
			    app: elastic
			type: Opaque
			data:
			  ca.crt: $SELF_CA_CRT
			  tls.crt: $SELF_TLS_CRT
			  tls.key: $SELF_TLS_KEY
			  tls.pkcs8.key: $SELF_TLS_PKCS8_KEY
			  tls.pem: $SELF_TLS_PEM
			EOF
      fi

      ## Generate es java keystore/truststore and insert into elastic-tls
      gen_java_cert $CMS_NAMESPACE

      ## Check if to update elastic users
      if kubectl get pod cms-es-logging-master-0 cms-es-application-master-0 -n $CMS_NAMESPACE &>/dev/null; then
        if [[ -n "$ELASTICSTACK_MANAGE_PASSWORD" || -n "$ELASTICSTACK_MONITOR_PASSWORD" ]];then
          if kubectl exec -i cms-es-logging-master-0 -c cms-es-logging-master -n $CMS_NAMESPACE -- bash -c 'curl -s -o /dev/null -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD https://localhost:9200' &>/dev/null && kubectl exec -i cms-es-application-master-0 -c cms-es-application-master -n $CMS_NAMESPACE -- bash -c 'curl -s -o /dev/null -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD https://localhost:9200' &>/dev/null ; then
            for es_pod in "cms-es-logging-master-0" "cms-es-application-master-0"; do
            [ "$es_pod" == "cms-es-logging-master-0" ] && es_container="cms-es-logging-master" || true
            [ "$es_pod" == "cms-es-application-master-0" ] && es_container="cms-es-application-master" || true
            local es_passwords_env=$(kubectl exec -n $CMS_NAMESPACE -i $es_pod -c $es_container -- bash -c 'echo $ELASTIC_PASSWORD; echo $ELASTIC_MONITOR_PASSWORD')
            local es_passwords_1=$(echo "$es_passwords_env"|head -1)
            local es_passwords_2=$(echo "$es_passwords_env"|tail -1)
            if [[ "$ELASTICSTACK_MONITOR_PASSWORD" != "$es_passwords_2" ]]; then
              #escape special charactors
              local ELASTICSTACK_MONITOR_PASSWORD_temp=$ELASTICSTACK_MONITOR_PASSWORD
              [[ -z $ELASTICSTACK_MONITOR_PASSWORD ]] || ELASTICSTACK_MONITOR_PASSWORD=$(sed 's/\$/\\$/g' <<<$ELASTICSTACK_MONITOR_PASSWORD)
              #update password ELASTICSTACK_MONITOR_PASSWORD
              echo "[INFO] $ELASTICSTACK_MONITOR_USER password is modified, updating it to ES $es_pod"
              kubectl exec -n $CMS_NAMESPACE -i $es_pod -c $es_container -- bash -c 'curl -sSf -k --connect-timeout 30 -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -XPOST -H "Content-Type: application/json" https://localhost:9200/_security/user/$ELASTIC_MONITOR_USERNAME/_password -d "{\"password\" : \"'''$ELASTICSTACK_MONITOR_PASSWORD'''\"}" '
              ELASTICSTACK_MONITOR_PASSWORD=$ELASTICSTACK_MONITOR_PASSWORD_temp
            fi
            if [[ "$ELASTICSTACK_MANAGE_PASSWORD" != "$es_passwords_1" ]]; then
              #escape special charactors
              local ELASTICSTACK_MANAGE_PASSWORD_temp=$ELASTICSTACK_MANAGE_PASSWORD
              [[ -z $ELASTICSTACK_MANAGE_PASSWORD ]] || ELASTICSTACK_MANAGE_PASSWORD=$(sed 's/\$/\\$/g' <<<$ELASTICSTACK_MANAGE_PASSWORD)
              #update password ELASTICSTACK_MANAGE_PASSWORD
              echo "[INFO] $ELASTICSTACK_MANAGE_USER password is modified, updating it to ES $es_pod"
              kubectl exec -n $CMS_NAMESPACE -i $es_pod -c $es_container -- bash -c 'curl -sSf -k --connect-timeout 30 -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -XPOST -H "Content-Type: application/json" https://localhost:9200/_security/user/$ELASTIC_USERNAME/_password -d "{\"password\" : \"'''$ELASTICSTACK_MANAGE_PASSWORD'''\"}" '
              [[ $? -ne 0 ]] || local es_user_password_updated=1
              ELASTICSTACK_MANAGE_PASSWORD=$ELASTICSTACK_MANAGE_PASSWORD_temp
            fi
            if [[ $es_user_password_updated -eq 1 ]]; then
              echo "[WARN] Passwords for Elasticsearch users are updated, the ES pods are required restart to take effect"
            fi
            done
          fi
        fi
      fi

    fi

    if [[ $CLUSTER_ROLE == "externalct" ]]; then
      # Fill the core side's VIP to let external CT cluster know where to find the core cluster.
      #[[ -n ${CORE_VIP} ]] && sed -i 's/^cms_core_vip:.*/cms_core_vip: '${CORE_VIP}'/' ${PRODUCTSVAR_FILE}
      [[ -n ${CORE_VIP} ]] && yq -i ".cms_core_vip=\"${CORE_VIP}\"" ${PRODUCTSVAR_FILE}

      # Init the SSL CA base64, no need for since cert generation method
      #gen_base64 $SSL_FOLDER/server.keystore cms_ssl.serverkeystoreb64 WARN
      #gen_base64 $SSL_FOLDER/client_auth_keystore.jks cms_ssl.client_auth_keystorejksb64 WARN
      #gen_base64 $SSL_FOLDER/cms_truststore.jks cms_ssl.cms_truststorejksb64 WARN
      #gen_base64 $SSL_FOLDER/keystore.pass cms_ssl.keystorepassb64 WARN
      #gen_base64 $SSL_FOLDER/.cms_fingerprint cms_ssl.cms_fingerprintb64 WARN
      #gen_base64 $SSL_FOLDER/haproxy.pem cms_ssl.haproxypemb64 WARN
      #gen_base64 $SSL_FOLDER/app.pem cms_ssl.apppemb64 WARN
      #gen_base64 $SSL_FOLDER/clients.pem cms_ssl.clientpemb64 WARN

      # Init the Peer SSL CA base64, no need since new cert generation method
      #gen_base64 $PEER_SSL_FOLDER/server.keystore cms_peer_ssl.serverkeystoreb64 WARN
      #gen_base64 $PEER_SSL_FOLDER/client_auth_keystore.jks cms_peer_ssl.client_auth_keystorejksb64 WARN
      #gen_base64 $PEER_SSL_FOLDER/cms_truststore.jks cms_peer_ssl.cms_truststorejksb64 WARN
      #gen_base64 $PEER_SSL_FOLDER/keystore.pass cms_peer_ssl.keystorepassb64 WARN
      #gen_base64 $PEER_SSL_FOLDER/.cms_fingerprint cms_peer_ssl.cms_fingerprintb64 WARN
      ##gen_base64 $PEER_SSL_FOLDER/haproxy.pem cms_peer_ssl.haproxypemb64 WARN
      ##gen_base64 $PEER_SSL_FOLDER/app.pem cms_peer_ssl.apppemb64 WARN
      #gen_base64 $PEER_SSL_FOLDER/clients.pem cms_peer_ssl.clientpemb64 WARN
    fi

    # Prepare the elastic-env for elastic stacks user/password, both core and externalct(for Geo Case) required.
    echo "[INFO] Preparing elastic-env secret for elastic stacks user/password"
    #if kubectl create secret generic --help|grep -qE '\-\-dry\-run=server|\-\-dry\-run=client|\-\-dry\-run=none'; then
    if kubectl create secret generic --help|grep -qE -- '--dry-run=server|--dry-run=client|--dry-run=none'; then
      _dry_run="client"
    else
      _dry_run="true"
    fi
    kubectl create secret -n $CMS_NAMESPACE generic elastic-env \
      --from-literal=ELASTIC_USERNAME=$ELASTICSTACK_MANAGE_USER \
      --from-literal=ELASTIC_PASSWORD=$ELASTICSTACK_MANAGE_PASSWORD \
      --from-literal=ELASTIC_MONITOR_USERNAME=$ELASTICSTACK_MONITOR_USER \
      --from-literal=ELASTIC_MONITOR_PASSWORD=$ELASTICSTACK_MONITOR_PASSWORD \
      -o yaml --dry-run="$_dry_run" | kubectl apply -f -

    # Modification for deployment on Bare Metal
    if [[ -z ${CLOUDPLATFORM} ]]; then
      # Retain es pv size
      # From cms10.1 on, the cms_elasticsearch.persistentVolume field in products-var is deprecated,
      # in order to keep same size of previous settings in products-var,
      # this scripts will fetch the old pv size from cms_elasticsearch.persistentVolume and update to the new fields.
      # Meanwhile, remove the old field after value moved to the new fields.
      OLD_MASTER_SIZE=$(yq '.cms_elasticsearch.persistentVolume.master.size' ${PRODUCTSVAR_FILE})
      OLD_DATA_SIZE=$(yq '.cms_elasticsearch.persistentVolume.data.size' ${PRODUCTSVAR_FILE})

      if [[ ! -z "${OLD_MASTER_SIZE}" ]] && [[ ! -z "${OLD_DATA_SIZE}" ]];then
       if [[ "${OLD_MASTER_SIZE}" != "null" ]] && [[ "${OLD_DATA_SIZE}" != "null" ]];then
	      echo "[WARN] Find new cms_esLogging.persistentVolume.."
        yq -i ".cms_esLogging.persistentVolume.master.size=\"${OLD_MASTER_SIZE}\"" ${PRODUCTSVAR_FILE}
        yq -i ".cms_esLogging.persistentVolume.data.size=\"${OLD_DATA_SIZE}\"" ${PRODUCTSVAR_FILE}

	      echo "[WARN] Find new cms_esApplication.persistentVolume.."
        yq -i ".cms_esApplication.persistentVolume.master.size=\"${OLD_MASTER_SIZE}\"" ${PRODUCTSVAR_FILE}
        yq -i ".cms_esApplication.persistentVolume.data.size=\"${OLD_DATA_SIZE}\"" ${PRODUCTSVAR_FILE}

        echo "[WARN] Remove deprecated field cms_elasticsearch.persistentVolume from products-var."
        yq -i "del(.cms_elasticsearch.persistentVolume)" ${PRODUCTSVAR_FILE}
       fi
      fi

      #sed -i 's/^platformProvider:.*/platformProvider: BM/' ${PRODUCTSVAR_FILE}
      yq -i '.platformProvider="BM"' ${PRODUCTSVAR_FILE}

      # Update the docker registry with customer provided registry
      ##IMAGE_REGISTRY_sed=$(echo $IMAGE_REGISTRY|sed -e 's/\//\\\//g')
      ##[[ -n ${IMAGE_REGISTRY} ]] && sed -i 's/^docker_registry:.*/docker_registry: '${IMAGE_REGISTRY_sed}'/' ${PRODUCTSVAR_FILE}
      yq -i ".docker_registry=\"${IMAGE_REGISTRY}\"" ${PRODUCTSVAR_FILE}

      # cms_nfs:
      #   server: X.X.X.X
      #   path: /srv/nfs/kube-pv
      ##NAS_SHARE_sed=$(echo $NAS_SHARE|sed -e 's/\//\\\//g')
      ##[[ -n ${NAS_SERVER_IP} ]] && sed -i "/^cms_nfs:/{n;s/server:.*/server: $NAS_SERVER_IP/}" ${PRODUCTSVAR_FILE}
      ##[[ -n ${NAS_SHARE} ]] && sed -i '/^cms_nfs:/{:a;N;/  path:.*/!{$!ba};s/  path:.*/  path: '$NAS_SHARE_sed'/}' ${PRODUCTSVAR_FILE}
      [[ -n ${NAS_SERVER_IP} ]] && yq -i ".cms_nfs.server=\"${NAS_SERVER_IP}\"" ${PRODUCTSVAR_FILE}
      [[ -n ${NAS_SHARE} ]] && yq -i ".cms_nfs.path=\"${NAS_SHARE}\"" ${PRODUCTSVAR_FILE}

      ##CONTENT_NAS_SHARE_sed=$(echo $CONTENT_NAS_SHARE|sed -e 's/\//\\\//g')
      ##[[ -n ${CONTENT_NAS_SERVER_IP} ]] && sed -i '/^  cmscontent:/{:a;N;/pvServer:.*/!{$!ba};s/pvServer:.*/pvServer: '$CONTENT_NAS_SERVER_IP'/}' ${PRODUCTSVAR_FILE}
      ##[[ -n ${CONTENT_NAS_SHARE} ]] && sed -i '/^  cmscontent:/{:a;N;/pvPath:.*/!{$!ba};s/pvPath:.*/pvPath: '$CONTENT_NAS_SHARE_sed'/}' ${PRODUCTSVAR_FILE}
      [[ -n ${CONTENT_NAS_SERVER_IP} ]] && yq -i ".cms_pvc.cmscontent.pvServer=\"${CONTENT_NAS_SERVER_IP}\"" ${PRODUCTSVAR_FILE}
      [[ -n ${CONTENT_NAS_SHARE} ]] && yq -i ".cms_pvc.cmscontent.pvPath=\"${CONTENT_NAS_SHARE}\"" ${PRODUCTSVAR_FILE}

      [[ -n ${BACKUP_NAS_SERVER_IP} ]] && yq -i ".cms_pvc.backuprestore.pvServer=\"${BACKUP_NAS_SERVER_IP}\"" ${PRODUCTSVAR_FILE}
      [[ -n ${BACKUP_NAS_SHARE} ]] && yq -i ".cms_pvc.backuprestore.pvPath=\"${BACKUP_NAS_SHARE}\"" ${PRODUCTSVAR_FILE}
      
      if [[ $PRODUCTSVAR_FILE_EXIS != "true" || $USER_MODIFIED_STORAGECLASS == "false" ]]; then
        if [[ -n ${STORAGECLASS_NAME} ]]; then
          if [[ "${STORAGECLASS_NAME}" != "cms-data" ]]; then
            echo "[INFO] Update CMS PVCs with storageclass [${STORAGECLASS_NAME}]."
            sed -i 's/storageClass: "cms-data"/storageClass: "'${STORAGECLASS_NAME}'"/' ${PRODUCTSVAR_FILE}
          fi

          echo "[INFO] Update Database PVC with storageclass [${STORAGECLASS_NAME}]."
          yq -i ".cms_postgresql.persistentVolume.storageClass=\"${STORAGECLASS_NAME}\"" ${PRODUCTSVAR_FILE}

          echo "[INFO] Update ETCD PVC with storageclass [${STORAGECLASS_NAME}]."
          yq -i ".cms_etcd.persistentVolume.storageClass=\"${STORAGECLASS_NAME}\"" ${PRODUCTSVAR_FILE}
        fi
      fi

      ##[[ -n ${EXTERNAL_VIP} ]] && sed -i 's/^cms_vip:.*/cms_vip: '${EXTERNAL_VIP}'/' ${PRODUCTSVAR_FILE}
      ##[[ -n ${INTERNAL_VIP} ]] && sed -i 's/^cms_internal_vip:.*/cms_internal_vip: '${INTERNAL_VIP}'/' ${PRODUCTSVAR_FILE}
      [[ -n ${EXTERNAL_VIP} ]] && yq -i ".cms_vip=\"${EXTERNAL_VIP}\"" ${PRODUCTSVAR_FILE}
      [[ -n ${INTERNAL_VIP} ]] && yq -i ".cms_internal_vip=\"${INTERNAL_VIP}\"" ${PRODUCTSVAR_FILE}
    fi

    # Modification for deployment on GCP cloud platform
    if [[ ${CLOUDPLATFORM} == "GCP" ]]; then
      #sed -i 's/^platformProvider:.*/platformProvider: GKE/' ${PRODUCTSVAR_FILE}
      yq -i '.platformProvider="GKE"' ${PRODUCTSVAR_FILE}

      # Update the FileStore IP address and share folder, Only need this for GCP
      # cms_nfs:
      #   server: 10.116.55.237
      #   path: /srv/nfs/kube-pv
      filestore_ip=$(grep OUTPUT_FILESTORE_IP ${CLOUD_ENV} | awk -F '=' '{print $2}')
      filestore_share=$(grep OUTPUT_FILESTORE_SHARE ${CLOUD_ENV} | awk -F '=' '{print $2}')
      ##sed -i "/^cms_nfs:/{n;s/server:.*/server: $filestore_ip/}" ${PRODUCTSVAR_FILE}
      ##sed -i '/^cms_nfs:/{:a;N;/  path:.*/!{$!ba};s/  path:.*/  path: \/'$filestore_share'/}' ${PRODUCTSVAR_FILE}
      yq -i ".cms_nfs.server=${filestore_ip}" ${PRODUCTSVAR_FILE}
      yq -i ".cms_nfs.path=${filestore_share}" ${PRODUCTSVAR_FILE}

      echo "[INFO] Update NFS mountOptions [nfsvers=3.0]"
      yq -i '.cms_nfs.mountOptions[0]="nfsvers=3.0"' ${PRODUCTSVAR_FILE}
      yq -i '.cms_pvc.cmscontent.mountOptions[0]="nfsvers=3.0"' ${PRODUCTSVAR_FILE}
      yq -i '.cms_pvc.backuprestore.mountOptions[0]="nfsvers=3.0"' ${PRODUCTSVAR_FILE}

      if [[ -z "$IMAGE_REGISTRY" ]] && [[ -z "$GCP_GCR" ]]; then
        echo "[ERROR] Both image_registry and gcp_gcr are empty, make sure one of them has proper value provided in cms.var file."
        exit 1
      fi

      # Update the docker registry with GCR
      #sed -i 's/^docker_registry:.*/docker_registry: '${GCP_GCR}'\/'${GCP_PROJECT}'/' ${PRODUCTSVAR_FILE}
      if [[ -z "$IMAGE_REGISTRY" ]];then
        yq -i ".docker_registry=\"${GCP_GCR}/${GCP_PROJECT}\"" ${PRODUCTSVAR_FILE}
      else
        yq -i ".docker_registry=\"${IMAGE_REGISTRY}\"" ${PRODUCTSVAR_FILE}
      fi

      echo "[INFO] Update ES data PVC with storageclass [cms-disk]."
      yq -i '.cms_esLogging.persistentVolume.data.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
      yq -i '.cms_esLogging.persistentVolume.master.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
      yq -i '.cms_esApplication.persistentVolume.data.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
      yq -i '.cms_esApplication.persistentVolume.master.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update RabbitMQ PVC with storageclass [cms-disk]."
      yq -i '.cms_rabbitmq.persistentVolume.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update logstash PVC with storageclass [cms-disk]."
      yq -i '.cms_pvc.cms_logstash.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update Database PVC with storageclass [cms-disk]."
      yq -i '.cms_postgresql.persistentVolume.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update ETCD PVC with storageclass [cms-disk]."
      yq -i '.cms_etcd.persistentVolume.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
    fi

    # Modification for deployment on AZURE cloud platform
    if [[ ${CLOUDPLATFORM} == "AZURE" ]]; then
      #sed -i 's/^platformProvider:.*/platformProvider: AKS/' ${PRODUCTSVAR_FILE}
      yq -i '.platformProvider="AKS"' ${PRODUCTSVAR_FILE}

      # Pass the azure resource group name to products-var
      #sed -i 's/^azureResourceGroup:.*/azureResourceGroup: '$RESOURCEGROUP_NAME'/' ${PRODUCTSVAR_FILE}
      yq -i ".azureResourceGroup=\"${RESOURCEGROUP_NAME}\"" ${PRODUCTSVAR_FILE}
      yq -i ".azureRegion=\"${AZURE_REGION}\"" ${PRODUCTSVAR_FILE}

      if [[ -z "$IMAGE_REGISTRY" ]] && [[ -z "$ACR_NAME" ]]; then
        echo "[ERROR] Both image_registry and acr_name are empty, make sure one of them has proper value provided in cms.var file."
        exit 1
      fi
 
      # Update the docker registry with ACR if docker_registry was not provided from cms.var
      if [[ -z "$IMAGE_REGISTRY" ]];then
        if $RUN_AS_CONTAINER; then
          echo "[ERROR] Ensure to have correct image_registry provided in cms.var."
          exit 1
        else
          AZURE_ACR=$(az acr list -g $ACR_RESOURCEGROUP -o table --query [].loginServer|grep -i $ACR_NAME|tail -1)
          #sed -i 's/^docker_registry:.*/docker_registry: '${AZURE_ACR}'/' ${PRODUCTSVAR_FILE}
          yq -i ".docker_registry=\"${AZURE_ACR}\"" ${PRODUCTSVAR_FILE}
        fi
      else 
        yq -i ".docker_registry=\"${IMAGE_REGISTRY}\"" ${PRODUCTSVAR_FILE}
      fi

      ## Update the whitelist with SLB outbound public IP
      #outbound_ip=$(grep OUTPUT_OUTBOUND_IP ${CLOUD_ENV} | awk -F '=' '{print $2}')
      #if [[ -z "$outbound_ip" ]]; then
      #  echo "[ERROR] OUTPUT_OUTBOUND_IP can not be found in file ${CLOUD_ENV}."
      #  exit 1
      #fi
      #EXT_WHITE_LIST="$(echo $EXT_WHITE_LIST|sed -e 's/]/,/g')$(echo $outbound_ip|sed -e 's/"//g')/32]"
      
      echo "[INFO] Set azureBlobStorage to ${USE_AZURE_BLOB_STORAGE}."
      yq -i ".azureBlobStorage=\"${USE_AZURE_BLOB_STORAGE}\"" ${PRODUCTSVAR_FILE}
      
      if [[ "${USE_AZURE_BLOB_STORAGE}" == "true" ]]; then
        # Set AZURE_BLOB_STORAGE_ACCOUNT_NAME from aks.env to products-var
        AZURE_BLOB_STORAGE_ACCOUNT_NAME=$(grep OUTPUT_BLOB_STORAGEACCOUNT_NAME ${CLOUD_ENV} | awk -F '=' '{print $2}')
        yq -i ".azureBlobStorageAccountName=${AZURE_BLOB_STORAGE_ACCOUNT_NAME}" ${PRODUCTSVAR_FILE}
      fi

      if [[ "${USE_AZURE_FILE_STORAGE}" == "true" ]]; then
        # Use Auzre file as CMS StoregeClass, need to create this storageClass in deploy-cms step
        # Only cms-es-snapshot PVC will use this cms-azure-file storageclass to create dynamic PVs
        echo "[INFO] Update CMS PVCs with storageclass [cms-azure-file]."
        sed -i 's/storageClass: "cms-data"/storageClass: "cms-azure-file"/' ${PRODUCTSVAR_FILE}
  
        # Use azure-file static shares
        # For Fresh installation, always use static share folders
        # For upgrade, depents on the migrate_azure_file_storage_class parameter
        prepare_azure_file_static_sc="false"
        EXISTING_SC=$(kubectl get sc --request-timeout 60s|awk '{print $1}')
        if [[ -z $EXISTING_SC ]]; then
          [Error] Can not fetch StorageClass information from the AKS cluster.
          exit 1
        fi
  
        # For upgrade case
        if [[ -n $(echo "$EXISTING_SC"|grep ^cms-azure-file$) ]]; then
          if [[ -n $(echo "$EXISTING_SC"|grep ^azure-file-cms-conf$) ]]; then
            # set to true if the system was fresh installed with static PV SCs.
            prepare_azure_file_static_sc="true"
          fi
        # For fresh installation case
        else
          prepare_azure_file_static_sc="true"
        fi
  
        if  [[ "$prepare_azure_file_static_sc" == "true" ]]; then
          echo "[INFO] Update cms-conf PVCs with azure-file static share storageclass [azure-file-cms-conf]."
          yq -i '.cms_pvc.cmsconf.storageClass="azure-file-cms-conf"' ${PRODUCTSVAR_FILE}
          echo "[INFO] Update cms-plugin PVCs with azure-file static share storageclass [azure-file-cms-plugin]."
          yq -i '.cms_pvc.cmsplugin.storageClass="azure-file-cms-plugin"' ${PRODUCTSVAR_FILE}
          echo "[INFO] Update cms-content PVCs with azure-file static share storageclass [azure-file-cms-content]."
          yq -i '.cms_pvc.cmscontent.storageClass="azure-file-cms-content"' ${PRODUCTSVAR_FILE}
          #echo "[INFO] Update cms-content-heavy PVCs with azure-file static share storageclass [azure-file-cms-content-heavy]."
          #yq w -i ${PRODUCTSVAR_FILE} 'cms_pvc.cmscontentheavy.storageClass' "azure-file-cms-content-heavy"
          echo "[INFO] Update cms-metadata-manager-content PVCs with azure-file static share storageclass [azure-file-cms-metadata-manager-content]."
          yq -i '.cms_pvc.cmsmetadatamanagercontent.storageClass="azure-file-cms-metadata-manager-content"' ${PRODUCTSVAR_FILE}
          echo "[INFO] Update backup-restore PVCs with azure-file static share storageclass [azure-file-backup-restore]."
          yq -i '.cms_pvc.backuprestore.storageClass="azure-file-backup-restore"' ${PRODUCTSVAR_FILE}
          echo "[INFO] Update cmscli-plugin PVCs with azure-file static share storageclass [azure-file-cmscli-plugin]."
          yq -i '.cms_pvc.cmscliplugin.storageClass="azure-file-cmscli-plugin"' ${PRODUCTSVAR_FILE}
          echo "[INFO] Update cms-sync-utils PVCs with azure-file static share storageclass [azure-file-cms-sync-utils]."
          yq -i '.cms_pvc.cmssyncutils.storageClass="azure-file-cms-sync-utils"' ${PRODUCTSVAR_FILE}
          echo "[INFO] Update cms-service-client PVCs with azure-file static share storageclass [azure-file-cms-service-client]."
          yq -i '.cms_pvc.cmsserviceclient.storageClass="azure-file-cms-service-client"' ${PRODUCTSVAR_FILE}
          echo "[INFO] Update cms-workflow-runtime PVCs with azure-file static share storageclass [azure-file-cms-workflow-runtime]."
          yq -i '.cms_pvc.cmsworkflowruntime.storageClass="azure-file-cms-workflow-runtime"' ${PRODUCTSVAR_FILE}
          echo "[INFO] Update cms-watchfolder-runtime PVCs with azure-file static share storageclass [azure-file-cms-watchfolder-runtime]."
          yq -i '.cms_pvc.cmswatchfolderruntime.storageClass="azure-file-cms-watchfolder-runtime"' ${PRODUCTSVAR_FILE}
        fi
      fi # End handling azure-file storageclass

      echo "[INFO] Update ES data PVC with storageclass [cms-disk]."
      yq -i '.cms_esLogging.persistentVolume.data.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
      yq -i '.cms_esLogging.persistentVolume.master.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
      yq -i '.cms_esApplication.persistentVolume.data.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
      yq -i '.cms_esApplication.persistentVolume.master.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update RabbitMQ PVC with storageclass [cms-disk]."
      #sed -i '/^cms_rabbitmq:/{:a;N;/  storageClass:.*/!{$!ba};s/  storageClass:.*/  storageClass: \"cms-disk\"/}' ${PRODUCTSVAR_FILE}
      yq -i '.cms_rabbitmq.persistentVolume.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update logstash PVC with storageclass [cms-disk]."
      #sed -i '/^  cms_logstash:/{:a;N;/  storageClass:.*/!{$!ba};s/  storageClass:.*/  storageClass: \"cms-disk\"/}' ${PRODUCTSVAR_FILE}
      yq -i '.cms_pvc.cms_logstash.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update Database PVC with storageclass [cms-disk]."
      yq -i '.cms_postgresql.persistentVolume.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update ETCD PVC with storageclass [cms-disk]."
      yq -i '.cms_etcd.persistentVolume.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
    fi

    # Modification for deployment on AWS cloud platform
    if [[ ${CLOUDPLATFORM} == "AWS" ]]; then
      yq -i '.platformProvider="EKS"' ${PRODUCTSVAR_FILE}
      yq -i ".awsRegion=\"${AWS_REGION}\"" ${PRODUCTSVAR_FILE}


      if [[ -z "$IMAGE_REGISTRY" ]]; then
        echo "[ERROR] image_registry is empty and required with EKS, make a proper value is provided in cms.var file."
        exit 1
      else 
        echo "[INFO] Update the docker registry with \"${IMAGE_REGISTRY}\"."
        yq -i ".docker_registry=\"${IMAGE_REGISTRY}\"" ${PRODUCTSVAR_FILE}
      fi
     
      file_storage_class='efs'
      
      echo "[INFO] Update CMS PVCs with storageclass [$file_storage_class]."
      sed -i "s/storageClass: "cms-data"/storageClass: \"$file_storage_class\"/" ${PRODUCTSVAR_FILE}

      echo "[INFO] Update cms-conf PVCs with static share storageclass [$file_storage_class]."
      yq -i ".cms_pvc.cmsconf.storageClass=\"$file_storage_class\"" ${PRODUCTSVAR_FILE}
      echo "[INFO] Update cms-plugin PVCs with static share storageclass [$file_storage_class]."
      yq -i ".cms_pvc.cmsplugin.storageClass=\"$file_storage_class\"" ${PRODUCTSVAR_FILE}
      echo "[INFO] Update cms-content PVCs with static share storageclass [$file_storage_class]."
      yq -i ".cms_pvc.cmscontent.storageClass=\"$file_storage_class\"" ${PRODUCTSVAR_FILE}
      #echo "[INFO] Update cms-content-heavy PVCs with static share storageclass [$file_storage_class]."
      #yq w -i ${PRODUCTSVAR_FILE} "cms_pvc.cmscontentheavy.storageClass" "$file_storage_class"
      echo "[INFO] Update cms-metadata-manager-content PVCs with static share storageclass [$file_storage_class]."
      yq -i ".cms_pvc.cmsmetadatamanagercontent.storageClass=\"$file_storage_class\"" ${PRODUCTSVAR_FILE}
      echo "[INFO] Update backup-restore PVCs with static share storageclass [$file_storage_class]."
      yq -i ".cms_pvc.backuprestore.storageClass=\"$file_storage_class\"" ${PRODUCTSVAR_FILE}
      echo "[INFO] Update cmscli-plugin PVCs with static share storageclass [$file_storage_class]."
      yq -i ".cms_pvc.cmscliplugin.storageClass=\"$file_storage_class\"" ${PRODUCTSVAR_FILE}
      echo "[INFO] Update cms-sync-utils PVCs with static share storageclass [$file_storage_class]."
      yq -i ".cms_pvc.cmssyncutils.storageClass=\"$file_storage_class\"" ${PRODUCTSVAR_FILE}
      echo "[INFO] Update cms-service-client PVCs with static share storageclass [$file_storage_class]."
      yq -i ".cms_pvc.cmsserviceclient.storageClass=\"$file_storage_class\"" ${PRODUCTSVAR_FILE}
      echo "[INFO] Update cms-workflow-runtime PVCs with static share storageclass [$file_storage_class]."
      yq -i ".cms_pvc.cmsworkflowruntime.storageClass=\"$file_storage_class\"" ${PRODUCTSVAR_FILE}
      echo "[INFO] Update cms-watchfolder-runtime PVCs with static share storageclass [$file_storage_class]."
      yq -i ".cms_pvc.cmswatchfolderruntime.storageClass=\"$file_storage_class\"" ${PRODUCTSVAR_FILE}

      echo "[INFO] Update CMS PVCs with storageclass [$file_storage_class]."
      sed -i "s/storageClass: \"cms-data\"/storageClass: \"$file_storage_class\"/" ${PRODUCTSVAR_FILE}


      echo "[INFO] Update ES data PVC with storageclass [cms-disk]."
      yq -i '.cms_esLogging.persistentVolume.data.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
      yq -i '.cms_esLogging.persistentVolume.master.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
      yq -i '.cms_esApplication.persistentVolume.data.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
      yq -i '.cms_esApplication.persistentVolume.master.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update RabbitMQ PVC with storageclass [cms-disk]."
      #sed -i '/^cms_rabbitmq:/{:a;N;/  storageClass:.*/!{$!ba};s/  storageClass:.*/  storageClass: \"cms-disk\"/}' ${PRODUCTSVAR_FILE}
      yq -i '.cms_rabbitmq.persistentVolume.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update logstash PVC with storageclass [cms-disk]."
      #sed -i '/^  cms_logstash:/{:a;N;/  storageClass:.*/!{$!ba};s/  storageClass:.*/  storageClass: \"cms-disk\"/}' ${PRODUCTSVAR_FILE}
      yq -i '.cms_pvc.cms_logstash.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update Database PVC with storageclass [cms-disk]."
      yq -i '.cms_postgresql.persistentVolume.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}

      echo "[INFO] Update ETCD PVC with storageclass [cms-disk]."
      yq -i '.cms_etcd.persistentVolume.storageClass="cms-disk"' ${PRODUCTSVAR_FILE}
    fi
    # Modification for deployment on AWS cloud platform


    # Modification for deployment on AWS cloud platform
    #TODO: remove?
    if [[ ${CLOUDPLATFORM} == "AWS" ]]; then
       AWS_EKS_ARN=$(grep OUTPUT_EKS_ARN "${CLOUD_ENV}" | awk -F '=' '{gsub(/"/, "", $2); print $2}')
    fi

    # Modification for cloud deployment cases
    
    if [[ -n ${CLOUDPLATFORM} ]]; then
      # Update the External static IP (No need to create LoadBalancer in advance)
      external_vip=$(grep OUTPUT_EXTERNAL_VIP ${CLOUD_ENV} | awk -F '=' '{print $2}')
      #sed -i 's/^cms_vip:.*/cms_vip: '$external_vip'/' ${PRODUCTSVAR_FILE}
      echo "[INFO] Updating cms_vip: $external_vip"
      #yq -i ".cms_vip=${external_vip}" ${PRODUCTSVAR_FILE}
      yq -i ".cms_vip=${external_vip}" ${PRODUCTSVAR_FILE}
  
      # Update the Internal static IP
      internal_vip=$(grep OUTPUT_INTERNAL_VIP ${CLOUD_ENV} | awk -F '=' '{print $2}')
      #sed -i 's/^cms_internal_vip:.*/cms_internal_vip: '$internal_vip'/' ${PRODUCTSVAR_FILE}
      echo "[INFO] Updating cms_internal_vip: $internal_vip"
      yq -i ".cms_internal_vip=${internal_vip}" ${PRODUCTSVAR_FILE}
   
      # Update lbWhiteList with 
      # Have to keep using sed, yq is not able to handle the list updating
      if [[ -z "$(grep OUTPUT_BASTION_IP ${CLOUD_ENV})" ]] && [[ -z "$(get_parameter_value bastion_vm_public_ip)" ]]; then
        BASTION_VM_IP_sed="[]"
        echo "[WARNING] Bastion IP is set as empty"
      elif [[ -z "$(grep OUTPUT_BASTION_IP ${CLOUD_ENV})" ]]; then
        BASTION_VM_IP_sed="[$(get_parameter_value bastion_vm_public_ip)\/32]"
      else
        BASTION_VM_IP_sed="[$(grep OUTPUT_BASTION_IP ${CLOUD_ENV} | awk -F '=' '{print $2}'|sed -e 's/"//g')\/32]"
      fi
      echo "[INFO] Bastion VM's IP list: $BASTION_VM_IP_sed"

      outbound_ip=$(grep OUTPUT_OUTBOUND_IP ${CLOUD_ENV} | awk -F '=' '{print $2}')
      if [[ -z "$outbound_ip" ]]; then
        echo "[WARNING] OUTPUT_OUTBOUND_IP is empty or not found, skip adding it to lbWhiteList."
        OUTBOUND_IP_sed="[]"
      else
        OUTBOUND_IP_sed="[$(echo $outbound_ip | sed -e 's/"//g')\/32]"
        echo "[INFO] Cloud platform's OUTBOUND_IP list: $OUTBOUND_IP_sed"
      fi

      EXT_WHITE_LIST_sed=$(echo $EXT_WHITE_LIST|sed -e 's/\//\\\//g')
      if [[ $BASTION_VM_IP_sed != "[]" ]]; then
        LB_WHITE_LIST_sed=$(echo $BASTION_VM_IP_sed|sed -e 's/]/,/g')$(echo $EXT_WHITE_LIST_sed|sed -e 's/\[//g')
      else
        LB_WHITE_LIST_sed=$EXT_WHITE_LIST_sed
      fi

      ## add pod cidr to lbWhitelist
      if [[ -n "$POD_CIDR" ]] && [[ ${CLOUDPLATFORM} == "AZURE" ]]; then
        LB_WHITE_LIST_sed_podcidr=$(echo "[$POD_CIDR]"|sed -e 's/\//\\\//g'|sed -e 's/]/,/g')$(echo $LB_WHITE_LIST_sed|sed -e 's/\[//g')
        LB_WHITE_LIST_sed=$LB_WHITE_LIST_sed_podcidr
      fi

      echo "[INFO] Updating cms_haproxy lbWhiteList ${LB_WHITE_LIST_sed}"
      sed -i '/^cms_haproxy:/{:a;N;/  lbWhiteList:.*/!{$!ba};s/  lbWhiteList:.*/  lbWhiteList: '$LB_WHITE_LIST_sed'/}' ${PRODUCTSVAR_FILE}
      
      echo "[INFO] Set cms_haproxy lbWhiteList to ${LB_WHITE_LIST_sed}."


      if [[ ${CLOUDPLATFORM} != "AWS" ]]; then
        LB_WHITE_LIST_sed2=$(echo $OUTBOUND_IP_sed|sed -e 's/]/,/g')$(echo $LB_WHITE_LIST_sed|sed -e 's/\[//g')     
        echo "[INFO] Updating cms_haproxy lbWhiteList ${LB_WHITE_LIST_sed2}"
        sed -i '/^cms_haproxy:/{:a;N;/  lbWhiteList:.*/!{$!ba};s/  lbWhiteList:.*/  lbWhiteList: '$LB_WHITE_LIST_sed2'/}' ${PRODUCTSVAR_FILE}

        echo "[INFO] Added outbound IP to cms_haproxy lbWhiteList :${LB_WHITE_LIST_sed2}."
      fi

      # Update database storageclass and PV size
      # Common setting for both AKS and GKE
      # Only update the db size for metadata-manager keeper
      # For workflow and epg, the db size is based on the values from products-var
      # Note: This code change happens from cms10.2 on, for upgrade from 10.1, 
      # user need to ensure the pg_disk_size in cms.var has the same value aligned with previous metadata-manager pg PV size.
      db_size=$PG_DISK_SIZE"Gi"
    
      echo "[INFO] Update Metadata-manager PG keeper PV sizing as [$db_size] from cms.var."
      yq -i ".cms_pg_metadata_manager.keeper.storage=\"$db_size\"" ${PRODUCTSVAR_FILE}
      #yq -i ".cms_pg_workflow.keeper.storage=\"$db_size\"" ${PRODUCTSVAR_FILE}
      #yq -i ".cms_pg_epg.keeper.storage=\"$db_size\"" ${PRODUCTSVAR_FILE}

    fi

    # Make sure all 'X.X.X.X' threshold value is set to null 
    sed -i 's/X.X.X.X//' ${PRODUCTSVAR_FILE}

    #For pods with extra labels defined in cms.var
    echo "[INFO] Update extra labels defined in cms.var to products-var.yaml"
    check_extra_labels

    #Generate certificate, save them in secrets
    echo "[INFO] Generate certificates and java keystores used by CMS"
    cert_gen_update

    running_time
}
