#!/bin/bash

function _create_repo(){
  local _check_repo_exist _return
  _check_repo_exist=$($_es_kubectl curl -s -o /dev/null -w %{http_code} "localhost:9200/_snapshot/cms_es_snap_repo?pretty")
  if [[ "$_check_repo_exist" != "200" ]]; then
    echo "[INFO] Snapshot repo cms_es_snap_repo does not exist, create it.."
    _return=$($_es_kubectl curl -w %{http_code} -s -XPUT -H 'Content-Type: application/json' "localhost:9200/_snapshot/cms_es_snap_repo?pretty" -d '
      {
        "type": "fs",
        "settings": {
          "location": "/usr/share/elasticsearch/backup/cms_es_snap_repo",
          "compress": true
        }
      }' )
    if echo "$_return"|tail -1|grep -q "200" ; then
      echo "[INFO] Snapshot repo cms_es_snap_repo is created"
    else
      echo "[ERROR] Snapshot repo cms_es_snap_repo failed to create"
      echo "$_return"
      exit 1
    fi
  fi
}
function _create_repo_tls(){
  local _check_repo_exist _return
  _check_repo_exist=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -o /dev/null -w %{http_code} "https://localhost:9200/_snapshot/cms_es_snap_repo?pretty"')
  if [[ "$_check_repo_exist" != "200" ]]; then
    echo "[INFO] Snapshot repo cms_es_snap_repo does not exist, create it.."
    _return=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -w %{http_code} -XPUT -H "Content-Type: application/json" "https://localhost:9200/_snapshot/cms_es_snap_repo?pretty" -d "
      {
        \"type\": \"fs\",
        \"settings\": {
          \"location\": \"/usr/share/elasticsearch/backup/cms_es_snap_repo\",
          \"compress\": true
        }
      }" ' )
    if echo "$_return"|tail -1|grep -q "200" ; then
      echo "[INFO] Snapshot repo cms_es_snap_repo is created"
    else
      echo "[ERROR] Snapshot repo cms_es_snap_repo failed to create"
      echo "$_return"
      exit 1
    fi
  fi
}

function tls_or_not() {
  _namespace=${CMS_NAMESPACE}
  _es_kubectl="kubectl exec -i -n $_namespace cms-es-logging-master-0 --"
  if kubectl get pod cms-es-logging-master-0 -n $_namespace &>/dev/null ; then
    if $_es_kubectl curl -s -o /dev/null http://localhost:9200 &>/dev/null ; then
      #tls is not enable
      printf 0
    elif $_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -o /dev/null https://localhost:9200' &>/dev/null ; then
      #tls is enable
      printf 1
    else
      #ES is not accessable
      printf 2
    fi
  else
    #ES pod not found
    printf 3
  fi
}

function es_query(){
  #es instance name: logging, application
  local _cert_enable _es_instance _namespace _es_pod _es_container _es_kubectl _query_snapshot
  _cert_enable=$1
  _es_instance=$2
  _namespace=${CMS_NAMESPACE}
  _es_pod="cms-es-${_es_instance}-master-0"
  _es_container="cms-es-${_es_instance}-master"
  _es_kubectl="kubectl exec -i -n $_namespace $_es_pod -c $_es_container --"
  if [[ -z "$_es_instance" ]] ; then
    echo "Please specific the target elasticsearch: logging or application"
    exit
  fi
  
  set +e
  if [[ "$_cert_enable" == "tls_disable" ]]; then
    _create_repo
    _query_snapshot=$($_es_kubectl curl -s localhost:9200/_snapshot/cms_es_snap_repo/_all?pretty|grep -e '"snapshot"' -e '"state"')
  elif [[ "$_cert_enable" == "tls_enable" ]]; then
    _create_repo_tls
    _query_snapshot=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD https://localhost:9200/_snapshot/cms_es_snap_repo/_all?pretty'|grep -e '"snapshot"' -e '"state"')
  fi
  if [[ -z "$_query_snapshot" ]]; then
    echo "[INFO] No snapshot backup found"
  else
    echo "[INFO] Following snapshot backup found in the repo cms_es_snap_repo:"
    echo "$_query_snapshot"
  fi
  set -e
}

function es_backup(){
  #es instance name: logging, application
  local _cert_enable _es_instance _backup_prefix _namespace _es_pod _es_container _es_kubectl _timestamp _query_result _prefix
  _cert_enable=$1
  _es_instance=$2
  _backup_prefix=$3
  _namespace=${CMS_NAMESPACE}
  _es_pod="cms-es-${_es_instance}-master-0"
  _es_container="cms-es-${_es_instance}-master"
  _es_kubectl="kubectl exec -i -n $_namespace $_es_pod -c $_es_container --"
  _timestamp=$(date +%Y%m%d_%H%M%S)
  if [[ -z "$_es_instance" ]] ; then
    echo "Please specific the target elasticsearch: logging or application"
    exit
  fi

  function _query_snapshot_running(){
    set +e
    if [[ "$_cert_enable" == "tls_disable" ]]; then
      _query_result=$($_es_kubectl curl -s localhost:9200/_snapshot/cms_es_snap_repo/_current?pretty|grep '"snapshot"')
    elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _query_result=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD https://localhost:9200/_snapshot/cms_es_snap_repo/_current?pretty'|grep '"snapshot"')
    fi
    set -e
    if [[ -n "$_query_result" ]]; then
      echo "There are running snapshot jobs, please wait for its completion then run again"
      exit
    fi
  }

  if [[ "$_es_instance" == "logging" ]]; then
    function _snapshot(){
      _indice="$1"
      if [[ -z "$2" ]]; then
        _prefix="manual"
      else
        _prefix="$2"
      fi
      echo "[INFO] Applying snapshot backup indices cms-es-logging/$_indice .."
      if [[ "$_cert_enable" == "tls_disable" ]]; then
        _return=$($_es_kubectl curl -w %{http_code} -s -XPUT -H 'Content-Type: application/json' "localhost:9200/_snapshot/cms_es_snap_repo/${_prefix}_${_timestamp}_${_indice}?wait_for_completion=true&pretty" -d '
          {
            "indices": "'$_indice'-*",
            "ignore_unavailable": true,
            "include_global_state": false,
            "index_settings": 
            {
              "index.number_of_replicas": 0
            }
          }' )
      elif [[ "$_cert_enable" == "tls_enable" ]]; then
        _return=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -w %{http_code} -XPUT -H "Content-Type: application/json" "https://localhost:9200/_snapshot/cms_es_snap_repo/'''${_prefix}'''_'''${_timestamp}'''_'''${_indice}'''?wait_for_completion=true&pretty" -d "
          {
            \"indices\": \"'''$_indice'''-*\",
            \"ignore_unavailable\": true,
            \"include_global_state\": false,
            \"index_settings\":
            {
              \"index.number_of_replicas\": 0
            }
          }" ' )
      fi
      if echo "$_return"|tail -1|grep -q "200" ; then
        echo "[INFO] Snapshot ${_prefix}_${_timestamp}_${_indice} created sucessfully"
      elif [[ -z $(echo "$_return"|tail -1|tr -d ' ') ]]; then
        echo "[WARNNING] Snapshot backup request connection could be disconnected while the backup procedure is still running in ES cluster, please query the backup status (./deploy-cms.sh es-snapshot query <logging|application>) and rerun if there are failures"
        echo "$_return"
        exit
      else
        echo "[ERROR] Snapshot backup $_indice failed:"
        echo "$_return"
        exit 1
      fi
      sleep 5
    }
    function _snapshot_kibana(){
      if [[ -z "$1" ]]; then
        _prefix="manual"
      else
        _prefix="$1"
      fi
      echo "[INFO] Applying snapshot backup build-in system indices .kibana*,.apm-*,.tasks*,.async-search on cms-es-logging .."
      #Backup include kibana, cluster globle state, index templates etc
      if [[ "$_cert_enable" == "tls_disable" ]]; then
      _return=$($_es_kubectl curl -w %{http_code} -s -XPUT -H 'Content-Type: application/json' "localhost:9200/_snapshot/cms_es_snap_repo/${_prefix}_${_timestamp}_kibana?wait_for_completion=true&pretty" -d '
        {
          "indices": ".kibana*,.apm-*,.tasks*,.async-search",
          "ignore_unavailable": true,
          "include_global_state": true,
          "index_settings": 
          {
            "index.number_of_replicas": 0
          }
        }' )
      elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _return=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -w %{http_code} -XPUT -H "Content-Type: application/json" "https://localhost:9200/_snapshot/cms_es_snap_repo/'''${_prefix}'''_'''${_timestamp}'''_kibana?wait_for_completion=true&pretty" -d "
        {
          \"indices\": \".kibana*,.apm-*,.tasks*,.async-search\",
          \"ignore_unavailable\": true,
          \"include_global_state\": true,
          \"index_settings\":
          {
            \"index.number_of_replicas\": 0
          }
        }" ' )
      fi
      if echo "$_return"|tail -1|grep -q "200" ; then
        echo "[INFO] Snapshot ${_prefix}_${_timestamp}_kibana created sucessfully"
      else
        echo "[ERROR] Snapshot backup .kibana*,.apm-*,.tasks*,.async-search failed:"
        echo "$_return"
        exit 1
      fi
      sleep 5
    }

    if [[ "$_cert_enable" == "tls_disable" ]]; then
      _create_repo
    elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _create_repo_tls
    fi
    echo "[INFO] Checking if any snapshot is in running"
    _query_snapshot_running
    _snapshot_kibana $_backup_prefix
    _snapshot cms-application-logs $_backup_prefix
    _snapshot cms-system-metrics $_backup_prefix
    _snapshot cms-application-metrics $_backup_prefix
    _snapshot cms-application-server-metrics $_backup_prefix
    _snapshot cms-default $_backup_prefix

  fi
  if [[ "$_es_instance" == "application" ]]; then
    function _snapshot(){
      _indice=$1
      if [[ -z "$2" ]]; then
        _prefix="manual"
      else
        _prefix="$2"
      fi
      echo "[INFO] Applying snapshot backup indices cms-es-application/$_indice .."
      if [[ "$_cert_enable" == "tls_disable" ]]; then
        if [[ "$_indice" == "history_logs" ]]; then
        _return=$($_es_kubectl curl -w %{http_code} -s -XPUT -H 'Content-Type: application/json' "localhost:9200/_snapshot/cms_es_snap_repo/${_prefix}_${_timestamp}_${_indice}?wait_for_completion=true&pretty" -d '
          {
            "indices": "'$_indice'_*",
            "ignore_unavailable": true,
            "include_global_state": false,
            "index_settings":
            {
              "index.number_of_replicas": 0
            }
          }' )
        else
        _return=$($_es_kubectl curl -w %{http_code} -s -XPUT -H 'Content-Type: application/json' "localhost:9200/_snapshot/cms_es_snap_repo/${_prefix}_${_timestamp}_${_indice}?wait_for_completion=true&pretty" -d '
          {
            "indices": "'$_indice'",
            "ignore_unavailable": true,
            "include_global_state": false,
            "index_settings": 
            {
              "index.number_of_replicas": 0
            }
          }' )
        fi
      elif [[ "$_cert_enable" == "tls_enable" ]]; then
        if [[ "$_indice" == "history_logs" ]]; then
        _return=$($_es_kubectl bash -c 'curl -w %{http_code} -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -XPUT -H "Content-Type: application/json" "https://localhost:9200/_snapshot/cms_es_snap_repo/'''${_prefix}'''_'''${_timestamp}'''_'''${_indice}'''?wait_for_completion=true&pretty" -d "
          {
            \"indices\": \"'''$_indice'''_*\",
            \"ignore_unavailable\": true,
            \"include_global_state\": false,
            \"index_settings\":
            {
              \"index.number_of_replicas\": 0
            }
          }" ' )
        else
        _return=$($_es_kubectl bash -c 'curl -w %{http_code} -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -XPUT -H "Content-Type: application/json" "https://localhost:9200/_snapshot/cms_es_snap_repo/'''${_prefix}'''_'''${_timestamp}'''_'''${_indice}'''?wait_for_completion=true&pretty" -d "
          {
            \"indices\": \"'''$_indice'''\",
            \"ignore_unavailable\": true,
            \"include_global_state\": false,
            \"index_settings\": 
            {
              \"index.number_of_replicas\": 0
            }
          }" ' )
        fi
      fi
      if echo "$_return"|tail -1|grep -q "200" ; then
        echo "[INFO] Snapshot ${_prefix}_${_timestamp}_${_indice} created sucessfully"
      else
        echo "[ERROR] Snapshot backup $_indice failed:"
        echo "$_return"
        exit 1
      fi
      sleep 5
    }
    function _snapshot_system(){
      if [[ -z "$1" ]]; then
        _prefix="manual"
      else
        _prefix="$1"
      fi
      echo "[INFO] Applying snapshot backup build-in system indices .geoip_databases on cms-es-application .."
      #Backup include cluster globle state, index templates
      if [[ "$_cert_enable" == "tls_disable" ]]; then
        _return=$($_es_kubectl curl -w %{http_code} -s -XPUT -H 'Content-Type: application/json' "localhost:9200/_snapshot/cms_es_snap_repo/${_prefix}_${_timestamp}_system?wait_for_completion=true&pretty" -d '
          {
            "indices": ".geoip_databases",
            "ignore_unavailable": true,
            "include_global_state": true,
            "index_settings": 
            {
              "index.number_of_replicas": 0
            }
          }' )
      elif [[ "$_cert_enable" == "tls_enable" ]]; then
        _return=$($_es_kubectl bash -c 'curl -w %{http_code} -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -XPUT -H "Content-Type: application/json" "https://localhost:9200/_snapshot/cms_es_snap_repo/'''${_prefix}'''_'''${_timestamp}'''_system?wait_for_completion=true&pretty" -d "
          {
            \"indices\": \".geoip_databases\",
            \"ignore_unavailable\": true,
            \"include_global_state\": true,
            \"index_settings\": 
            {
              \"index.number_of_replicas\": 0
            }
          }" ' )
      fi
      if echo "$_return"|tail -1|grep -q "200" ; then
        echo "[INFO] Snapshot ${_prefix}_${_timestamp}_system created successfully completed"
      else
        echo "[ERROR] Snapshot backup .geoip_databases failed:"
        echo "$_return"
        exit 1
      fi
      sleep 5
    }

    if [[ "$_cert_enable" == "tls_disable" ]]; then
      _create_repo
    elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _create_repo_tls
    fi
    echo "[INFO] Checking if any snapshot is in running"
    _query_snapshot_running
    _snapshot_system $_backup_prefix
    _snapshot seasons $_backup_prefix
    _snapshot series_titles $_backup_prefix
    _snapshot wfs $_backup_prefix
    _snapshot site_titles $_backup_prefix
    _snapshot master_titles $_backup_prefix
    _snapshot history_logs $_backup_prefix
  fi
}

function es_restore(){
  local _cert_enable _es_instance _restore_timestamp _exclude_metrics _namespace _es_pod _es_container _es_kubectl _snapshot_result _return _restore_snapshot _snapshots_to_restore _restore_timestamp_cut _all_indices_amount _indice_restore_done
  _cert_enable=$1
  _es_instance=$2
  _restore_timestamp=$3
  _exclude_metrics=$4
  _namespace=${CMS_NAMESPACE}
  _es_pod="cms-es-${_es_instance}-master-0"
  _es_container="cms-es-${_es_instance}-master"
  _es_kubectl="kubectl exec -i -n $_namespace $_es_pod -c $_es_container --"
  
  if [[ -z "$_es_instance" ]] || [[ -z "$_restore_timestamp" ]]; then
    echo "Please specific the target elasticsearch: logging or application; and snapshot name: prefix_name_timestamp or timestamp"
    exit
  fi
  function _close_indice(){
    _indice="$1"
    if [[ "$_cert_enable" == "tls_disable" ]]; then
      _return=$($_es_kubectl curl -w %{http_code} -s -XPOST "localhost:9200/$_indice/_close?pretty")
    elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _return=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -w %{http_code} -XPOST "https://localhost:9200/'''$_indice'''/_close?pretty"')
    fi
    if echo "$_return"|tail -1|grep -q "200" ; then
      :
    else
      echo "[ERROR] Close index $_indice failed:"
      echo "$_return"
      exit 1
    fi
  }
  function _restore(){
    _restore_snapshot="$1"
    if [[ "$_cert_enable" == "tls_disable" ]]; then
      _return=$($_es_kubectl curl -w %{http_code} -s -XPOST -H 'Content-Type: application/json' "localhost:9200/_snapshot/cms_es_snap_repo/$_restore_snapshot/_restore?pretty" -d '
        {
          "ignore_unavailable": true,
          "include_global_state": false,
          "include_aliases": true
        }' )
    elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _return=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -w %{http_code} -XPOST -H "Content-Type: application/json" "https://localhost:9200/_snapshot/cms_es_snap_repo/'''$_restore_snapshot'''/_restore?pretty" -d "
        {
          \"ignore_unavailable\": true,
          \"include_global_state\": false,
          \"include_aliases\": true
        }" ' )
    fi
    if echo "$_return"|tail -1|grep -q "200" ; then
      echo "[INFO] Snapshot $_restore_snapshot restore applied"
    else
      echo "[ERROR] Snapshot $_restore_snapshot restore failed:"
      echo "$_return"
      exit 1
    fi
    sleep 5
  }
  function _restore_system(){
    _restore_snapshot="$1"
    if [[ "$_cert_enable" == "tls_disable" ]]; then
      _return=$($_es_kubectl curl -w %{http_code} -s -XPOST -H 'Content-Type: application/json' "localhost:9200/_snapshot/cms_es_snap_repo/$_restore_snapshot/_restore?pretty" -d '
        {
          "ignore_unavailable": true,
          "include_global_state": true,
          "include_aliases": true
        }' )
    elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _return=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -w %{http_code} -XPOST -H "Content-Type: application/json" "https://localhost:9200/_snapshot/cms_es_snap_repo/'''$_restore_snapshot'''/_restore?pretty" -d "
        {
          \"ignore_unavailable\": true,
          \"include_global_state\": true,
          \"include_aliases\": true
        }" ' )
    fi
    if echo "$_return"|tail -1|grep -q "200" ; then
      echo "[INFO] Snapshot $_restore_snapshot restore applied"
    else
      echo "[ERROR] Snapshot $_restore_snapshot restore failed:"
      echo "$_return"
      exit 1
    fi
    sleep 5
  }
  
  user_confirm "The elasticsaerch snapshots restore for \"$_es_instance\" is being launched. Any existing indices could be wiped out."
  
  if [[ "$_cert_enable" == "tls_disable" ]]; then
    _create_repo
    _snapshot_result=$(es_query tls_disable "$_es_instance")
  elif [[ "$_cert_enable" == "tls_enable" ]]; then
    _create_repo_tls
    _snapshot_result=$(es_query tls_enable "$_es_instance")
  fi

  #option input as sample "20220101_105959"
  if echo "$_restore_timestamp"| grep -qEw '[0-9]{8}_[0-9]{6}' ; then
    _snapshots_to_restore=$(echo "$_snapshot_result"| grep "$_restore_timestamp"| awk '{print $3}'|cut -f2 -d\")
  #option might be input as sample "backup_before_upgrade_20211014_010103"
  elif echo "$_snapshot_result"| grep -q '"snapshot" : "'"${_restore_timestamp}_" ; then
    _snapshots_to_restore=$(echo "$_snapshot_result"| grep '"snapshot" : "'"$_restore_timestamp"| awk '{print $3}'|cut -f2 -d\")
  #option might be input as sample "manual_20211014_010103_cms-application-logs"
  elif echo "$_snapshot_result"| grep -qw "$_restore_timestamp" ; then
    _restore_timestamp_cut=$(echo "$_restore_timestamp"| grep -Eo '[0-9]{8}_[0-9]{6}')
    _snapshots_to_restore=$(echo "$_snapshot_result"| grep "$_restore_timestamp_cut"| awk '{print $3}'|cut -f2 -d\")
  else
    echo "[ERROR] Please input the snapshot to restore, using timestamp with formatting: YYYYmmdd_HHMMSS, you could query the snapshot backup to get the results"
    exit
  fi

  _snapshot_result_restore=$(echo "$_snapshot_result"|grep $(echo "$_restore_timestamp"| grep -Eo '[0-9]{8}_[0-9]{6}') -A1)
  if [[ $(echo "$_snapshot_result_restore"| grep '"state" :'| grep -v SUCCESS| wc -l) -gt 0 ]]; then
    echo "[ERROR] Not all the snapshot backups are SUCCESS, restore is not to be launched. Bellow is the snapshot backup found:"
    echo "$_snapshot_result_restore"
    exit
  fi

  if [[ "$_es_instance" == "logging" ]] && [[ -z "$_exclude_metrics" ]]; then
    if [[ $(echo "$_snapshot_result_restore"| grep '"snapshot" :'| grep -e _cms-system-metrics -e _cms-application-logs -e _cms-application-metrics -e _cms-application-server-metrics -e _cms-default -e _kibana | wc -l) -ne 6 ]]; then
      echo "[ERROR] The snapshot amounts is not matched with all the indices, restore is not to be launched. Bellow is the snapshot backup found:"
      echo "$_snapshot_result_restore"
      exit
    fi
    if [[ "$_cert_enable" == "tls_disable" ]]; then
      _all_indices=$($_es_kubectl curl -s localhost:9200/_cat/indices|grep -e cms-system-metrics -e cms-application-logs -e cms-application-metrics -e cms-application-server-metrics -e cms-default -e \.kibana -e \.apm -e \.tasks -e \.async-search| awk '$2 == "open" {print $3}'|sort)
    elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _all_indices=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD https://localhost:9200/_cat/indices'|grep -e cms-system-metrics -e cms-application-logs -e cms-application-metrics -e cms-application-server-metrics -e cms-default -e \.kibana -e \.apm -e \.tasks -e \.async-search| awk '$2 == "open" {print $3}'|sort)
    fi
  elif [[ "$_es_instance" == "logging" ]] && [[ "$_exclude_metrics" == '--no-metrics' ]]; then
    if [[ $(echo "$_snapshot_result_restore"| grep '"snapshot" :'| grep -e _cms-application-logs -e _cms-default -e _kibana | wc -l) -ne 3 ]]; then
      echo "[ERROR] The snapshot amounts is not matched with all the indices, restore is not to be launched. Bellow is the snapshot backup found:"
      echo "$_snapshot_result_restore"
      exit
    fi
    if [[ "$_cert_enable" == "tls_disable" ]]; then
      _all_indices=$($_es_kubectl curl -s localhost:9200/_cat/indices|grep -e cms-application-logs -e cms-default -e \.kibana -e \.apm -e \.tasks -e \.async-search| awk '$2 == "open" {print $3}'|sort)
    elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _all_indices=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD https://localhost:9200/_cat/indices'|grep -e cms-application-logs -e cms-default -e \.kibana -e \.apm -e \.tasks -e \.async-search| awk '$2 == "open" {print $3}'|sort)
    fi
    _snapshots_to_restore=$(echo "$_snapshots_to_restore"|grep -v metrics)
  elif [[ "$_es_instance" == "application" ]]; then
    if [[ $(echo "$_snapshot_result_restore"| grep '"snapshot" :'| grep -e _wfs -e _seasons -e _history_logs -e _master_titles -e _site_titles -e _series_titles -e _system | wc -l) -ne 7 ]]; then
      echo "[ERROR] The snapshot amounts is not matched with all the indices, restore is not to be launched. Bellow is the snapshot backup found:"
      echo "$_snapshot_result_restore"
      exit
    fi
    if [[ "$_cert_enable" == "tls_disable" ]]; then
      _all_indices=$($_es_kubectl curl -s localhost:9200/_cat/indices|grep -e wfs -e seasons -e history_logs -e master_titles -e site_titles -e series_titles| awk '$2 == "open" {print $3}'|sort)
    elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _all_indices=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD https://localhost:9200/_cat/indices'|grep -e wfs -e seasons -e history_logs -e master_titles -e site_titles -e series_titles| awk '$2 == "open" {print $3}'|sort)
    fi
  fi

  for _i in $_all_indices; do
    echo "[INFO] Closing index: cms-es-$_es_instance/${_i}"
    _close_indice $_i
  done

  for _j in $_snapshots_to_restore; do
    echo "[INFO] Applying restore from snapshot cms-es-$_es_instance/$_j .."
    if [[ "$_j" =~ "system" ]] || [[ "$_j" =~ "kibana" ]]; then
      _restore_system $_j
    else
      _restore $_j
    fi
  done

  #Check if restore completed
  if [[ "$_cert_enable" == "tls_disable" ]]; then
    _all_indices_restore=$(
    for _k in $_snapshots_to_restore; do
      $_es_kubectl curl -s "localhost:9200/_snapshot/cms_es_snap_repo/${_k}?pretty&filter_path=snapshots.indices" |grep -v -e '\{' -e '\}' -e '\[' -e '\]'|cut -f2 -d\"
    done |cut -d\" -f4 )
  elif [[ "$_cert_enable" == "tls_enable" ]]; then
    _all_indices_restore=$(
    for _k in $_snapshots_to_restore; do
      $_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD "https://localhost:9200/_snapshot/cms_es_snap_repo/'''${_k}'''?pretty&filter_path=snapshots.indices"' |grep -v -e '\{' -e '\}' -e '\[' -e '\]'|cut -f2 -d\"
    done |cut -d\" -f4 )
  fi
  _all_indices_amount=$(echo "$_all_indices_restore"|wc -l)

  echo "Checking if all snapshot restore completed .."
  while true ; do
    if [[ "$_cert_enable" == "tls_disable" ]]; then
      _all_indices_raw=$($_es_kubectl curl -s "localhost:9200/_cat/indices")
    elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _all_indices_raw=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD "https://localhost:9200/_cat/indices?expand_wildcards=all"')
    fi
    _indice_restore_done=0
    for _l in $_all_indices_restore; do
      _indice_restore_done=$((_indice_restore_done + $(echo "$_all_indices_raw"|awk '$3 == "'$_l'" && $1 == "green" && $2 == "open" {print}'|wc -l) ))
    done
    if [[ $_indice_restore_done -eq $_all_indices_amount ]]; then
      echo "[INFO] All snapshot restore completed"
      break
    else
      sleep 15
    fi
  done
    #Remove un-open indices
    #

}

function es_remove(){
  #es instance name: logging, application
  local _cert_enable _es_instance _namespace _es_pod _es_container _es_kubectl _query_snapshot _es_snapshot_to_remove
  _cert_enable=$1
  _es_instance=$2
  _es_snapshot_to_remove=$3
  _namespace=${CMS_NAMESPACE}
  _es_pod="cms-es-${_es_instance}-master-0"
  _es_container="cms-es-${_es_instance}-master"
  _es_kubectl="kubectl exec -i -n $_namespace $_es_pod -c $_es_container --"
  if [[ -z "$_es_instance" ]] ; then
    echo "Please specific the target elasticsearch: logging or application"
    exit
  fi
  
  set +e
  if echo "$_es_snapshot_to_remove"| grep -qE '[0-9]{8}_[0-9]{6}_' ; then
    echo "[ERROR] please input the snapshot name with format: prefix_name_<timestamp>, and not using snapshot full name"
    exit
  else
    if [[ "$_cert_enable" == "tls_disable" ]]; then
      _create_repo
      _query_target_snapshot=$($_es_kubectl curl -s localhost:9200/_snapshot/cms_es_snap_repo/*${_es_snapshot_to_remove}"*?pretty&filter_path=snapshots.snapshot")
    elif [[ "$_cert_enable" == "tls_enable" ]]; then
      _create_repo_tls
      _query_target_snapshot=$($_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD https://localhost:9200/_snapshot/cms_es_snap_repo/*'''$_es_snapshot_to_remove'''"*?pretty&filter_path=snapshots.snapshot"')
    fi
    if echo "$_query_target_snapshot"|grep -q "snapshot_missing_exception"; then
      echo "[WARN] The snapshot specified in the command is not found"
      exit
    else
      echo "[INFO] Following snapshot backup are found and will be removed:"
      echo "$_query_target_snapshot"|grep -w "\"snapshot\" \:"|awk '{print $3}'
      if [[ "$_cert_enable" == "tls_disable" ]]; then
        for i in $(echo "$_query_target_snapshot"|grep '"snapshot" :'|cut -d\" -f4); do
          #$_es_kubectl curl -s -XDELETE localhost:9200/_snapshot/cms_es_snap_repo/*$_es_snapshot_to_remove*?pretty
          _snap_delete_return=$($_es_kubectl curl -s -w "%{http_code}" -XDELETE localhost:9200/_snapshot/cms_es_snap_repo/$i?pretty)
          if [[ ${_snap_delete_return: -3} -eq 200 ]]; then
            echo "[INFO] snapshot $i is deleted"
          else
            echo "[ERROR] failed to delete snapshot $i"
            echo "${_snap_delete_return%???}"
            exit 1
          fi
        done
      elif [[ "$_cert_enable" == "tls_enable" ]]; then
        $_es_kubectl bash -c 'curl -s -k -u $ELASTIC_USERNAME:$ELASTIC_PASSWORD -XDELETE https://localhost:9200/_snapshot/cms_es_snap_repo/*'''$_es_snapshot_to_remove'''*?pretty'
      fi
    fi
  fi
  set -e
}
