function cleanup(){
#########################
# Function: cleanup
# To destroy the whole GKE cluster
#########################

   trap 'echo "[Error] Scripts failed when running function [lib/${FUNCNAME[0]}] - error line: $LINENO, error cmd: $BASH_COMMAND"' ERR

   CMS_NAMESPACE=$(grep "^cms_namespace: " ${PRODUCTSVAR_FILE}|awk -F ':' '{print $2}'|sed -e 's/"//g' -e 's/"//g')
   
   # Remove all CMS components
   [[ -n "$(timeout 20 kubectl get svc -n $CMS_NAMESPACE)" ]] && reset_products all <<< Yes
     
   reset_function_timer
   cd $SCRIPTPATH

   ## Ensure to use the correct resource group name
   ##Use az to check whether the resource group with legacy resource group name exist
   ##If exist, use this legacy resource group name, otherwise, use the new formated resource group name
   #set_azure_resource_group

   beginLogging "Start destroying Cloud K8S cluster."

   # Disable exit on error
   set +e

    if [[ ${CLOUDPLATFORM} == "GCP" ]];then
        TF_DIR="tf-gke"
    else
        TF_DIR="tf-aks"
    fi

   # Ensure any existing logs are owned by current user
   if [[ -f $SCRIPTPATH/$TF_DIR/terraform.tfstate ]];then
      _file_owner=$(ls -la $SCRIPTPATH/$TF_DIR/terraform.tfstate|awk '{print $3}')
      if [[ $(whoami > /dev/null 2>&1; echo $?) -eq 0 ]]; then
        _current_user=$(whoami 2>&1)
      else
        _current_user=$(id -u)
      fi
      if [[ "${_file_owner}" != "${_current_user}" ]];then
        user_confirm "Ensure all files and folders under \"$SCRIPTPATH/$TF_DIR\" are owned by current user [$_current_user] before continue."
      fi
   fi

   [ -f $LOG.terraform.cleanup ] && mv -f $LOG.terraform.cleanup $LOG.terraform.cleanup.last

   # Delete all LoadBalancer type services to remove all Cloud Load Balancer resource 
   echo "[Info] Delete all LoadBalancer services."
   LB_SERVICES=$(timeout 5 kubectl get svc -n $CMS_NAMESPACE| grep " LoadBalancer "| awk '{print $1}')
   for svc in $LB_SERVICES
   do
     kubectl delete svc -n $CMS_NAMESPACE $svc
   done

   echo "[Info] All LoadBalancer services deleted."

   #echo "[Info] Delete all CMS PVCs and PVs."
   #timeout 10 kubectl get pvc -n $CMS_NAMESPACE|awk '{print $1}'|grep -v NAME| xargs kubectl delete pvc -n $CMS_NAMESPACE
   #timeout 10 kubectl get pv|grep " $CMS_NAMESPACE/" |awk '{print $1}'|grep -v NAME| xargs kubectl delete pv -n $CMS_NAMESPACE

   (set +e; cat $CMSCONF; grep -w -e ^setup_trafficmanager_peer -e ^remote_resource_group -e ^remote_cluster_name -e ^remote_existing_vnet_name -e ^remote_existing_vnet_resource_group $CMSGEOCONF; set +e) > $CMSCONF_COMBINE

   TF_VERSION_MAJOR=$(/usr/sbin/terraform -v|grep -o v[0-9]|grep -o [0-9])

   # Start destroying the Cloud Resources by terraform
   cd $TERRAFORM_FOLDER
   /usr/sbin/terraform init -upgrade|& tee -a $LOG.terraform.cleanup
   if [ ${PIPESTATUS[0]} -ne 0 ];then
      echo "[Error] Terraform init failed!"
      echo "Check $LOG.terraform.cleanup for more error details."
      exit 1
   fi
   /usr/sbin/terraform refresh -var-file=$CMSCONF_COMBINE |& tee -a $LOG.terraform.cleanup
   if [ ${PIPESTATUS[0]} -ne 0 ];then
      echo "[Error] Terraform refresh failed!"
      echo "Check $LOG.terraform.cleanup for more error details."
      exit 1
   fi

   if [[ $TF_VERSION_MAJOR -gt 0 ]]; then
     echo [INFO] Terraform major version is $TF_VERSION_MAJOR, running destroy with apply subcommand.
     /usr/sbin/terraform apply -destroy -auto-approve -var-file=$CMSCONF_COMBINE |& tee -a $LOG.terraform.cleanup
   else
     echo [INFO] Terraform major version is $TF_VERSION_MAJOR, running destroy with destroy subcommand.
     /usr/sbin/terraform destroy -force -var-file=$CMSCONF_COMBINE |& tee -a $LOG.terraform.cleanup
   fi

   if [ ${PIPESTATUS[0]} -ne 0 ];then
      echo "[Error] Terraform destroy failed!"
      echo "Check $LOG.terraform.cleanup for more error details."
      exit 1
   fi
    
   # Enable exit on error
   set -e
   
   # Remove the env file since the cluster has been destroyed and the env is not valid anymore
   rm -f $CLOUD_ENV

   running_time
}
