function prepare_images(){
#########################
# Function: prepare_images <cms|*.tar|*.tgz>
# Extra all docker images from the container packages and push the images to registry
#########################

  trap 'echo "[Error] Scripts failed when running function [lib/${FUNCNAME[0]}] - error line: $LINENO, error cmd: $BASH_COMMAND"' ERR

  help_message="
  This prepare-image function pushes images to Container Image Registry.
  \n-------------------------------------------------
  \nUsage: $0 image <cms|*.tar|*.tgz>
  \n
  \nAvailable parameters:
  \n  cms      : load all images CMS container packages and push images to Container Image Registry
  \n  cms load : Only load all images CMS container packages into this bootstrap node machine
  \n  cms push : Only push all images CMS container images to Container Image Registry
  \n  *.tar|tgz: load all images from speicific container package and push images to Container Image Registry
  \n
  \nExamples:
  \n  $0 image cms
  \n  $0 image testimages.tar 
  "

  IMAGES_PARALLEL_NUM=3

  reset_function_timer
  cd $SCRIPTPATH

  local _packageName=$1
  
  # Load or Push
  local _operation=$2

  local _parallel_num=$3
  if [[ -n "$_parallel_num" ]];then
    IMAGES_PARALLEL_NUM=$_parallel_num
  fi

  case $_packageName in
      cms ) _type=CMS; break;;
      *.tar|*.tgz )  _type=PACKAGE; break;;
      * ) echo -e $help_message; exit 1;;
  esac
  
  beginLogging "Start Preparing images."

  if [[ ${CLOUDPLATFORM} == "GCP" ]]; then
    # Set GCR permissions
    echo "[INFO] Setting GCR Permissions."
    sudo gcloud auth configure-docker $GCP_GCR	  #add gcloud bin path to /etc/sudoers
    #IMAGE_REGISTRY="$GCP_GCR/$GCP_PROJECT"
  fi

  if [[ ${CLOUDPLATFORM} == "AZURE" ]] && [[ -z "$IMAGE_REGISTRY" ]]; then

    if [[ -z "$IMAGE_REGISTRY" ]] && [[ -z "$ACR_NAME" ]]; then
      echo "[ERROR] Both image_registry and acr_name are empty, make sure one of them has proper value provided in cms.var file."
      exit 1
    fi

    # Prepare the ACR
    echo "[INFO] Preparing and fetching ACR server info."
    #az group create --name $CLUSTER_NAME-cms-resourcegroup --location $AZURE_REGION
    #az acr create -g $CLUSTER_NAME-cms-resourcegroup --name $ACR_NAME --sku $ACR_SKU
    #AZURE_ACR=$(az acr list -g $CLUSTER_NAME-cms-resourcegroup -o table --query [].loginServer|grep -i $ACR_NAME|tail -1)
    if [[ -n "${ACR_TAGS[@]}" ]]; then
      ACR_TAGS_OPTIONS=$(echo '--tags '"${ACR_TAGS[@]}" )
    else
      ACR_TAGS_OPTIONS=""
    fi
    sudo az group create --name $ACR_RESOURCEGROUP --location $AZURE_REGION
    echo sudo az acr create -g $ACR_RESOURCEGROUP --name $ACR_NAME --sku $ACR_SKU "$ACR_TAGS_OPTIONS" > acr_create.command.temp
    cat acr_create.command.temp|sh
    rm -f acr_create.command.temp
    AZURE_ACR=$(sudo az acr list -g $ACR_RESOURCEGROUP -o table --query [].loginServer|grep -i $ACR_NAME|tail -1)
    sudo az acr login --name $AZURE_ACR
    IMAGE_REGISTRY="$AZURE_ACR"
  fi

  if [[ -z "$IMAGE_REGISTRY_INSTANCES" ]] || [[ "$IMAGE_REGISTRY_INSTANCES" == "[]" ]]; then
    IMAGE_REGISTRY_INSTANCES=["$IMAGE_REGISTRY"]
  fi

  image_registries="$(echo $IMAGE_REGISTRY_INSTANCES | sed -e 's/\[//' -e 's/]//' -e 's/,/ /g')"
  echo "[Info] Pushing images to image_registries [$image_registries]."
  
  # Operation for CMS image packages
  if [[ $_type == "CMS" ]]; then
    
    #Load CMS images into this bootstrap node machine
    if [[ -z "$_operation" ]] || [[ "$_operation" == "load" ]]; then
      check_packages "$CMS_IMAGE_PACKAGES"
      
      # Clean up the information for loaded images
      cat /dev/null > ${SCRIPTPATH}/loaded_cms_images.txt
  
      pids=""	
  
      # Load images from the container packages into bastion machine
      cd ${SCRIPTPATH}
      for _package in ${CMS_IMAGE_PACKAGES}
      do
        sleep 2
        (packagename=$(ls -rt packages/${_package} |tail -1)
        echo "[Info] Load images from $packagename."
        if [[  $(sudo docker load -i $packagename >> ${SCRIPTPATH}/loaded_cms_images.txt 2>&1; echo $?) -ne 0 ]]; then
          echo "[Error] Failed to load images from $packagename by docker load command."
          exit 1
        fi
        )&
        pids="$! $pids"
      done
  
      #wait
      sleep 2;
      echo "[Info] Waiting for all CMS images to be loaded into this machine"
      for PID in $pids
      do 
        while [ -d /proc/$PID ]
        do
          printf "."
      	sleep 1
        done 
      done
      echo -e "\n[Info] All CMS images loaded."
    fi
    
    # Push the images to registry after loaded
    if [[ ! -f ${SCRIPTPATH}/loaded_cms_images.txt ]]; then
      echo "[Error] Make sure to run image cms load before running push command."
      exit 1
    fi
    if [[ -z "$_operation" ]] || [[ "$_operation" == "push" ]]; then
      echo -e "\n[Info] Images To Be Pushed:\n=================================================================="
      cat ${SCRIPTPATH}/loaded_cms_images.txt | sort | awk -F ': ' '{print "  "NR"\t", $2}'
      echo -e "==================================================================\n\n"
      
      # split the image list
      images_list=$(cat ${SCRIPTPATH}/loaded_cms_images.txt | sort | awk -F ': ' '{print $2}')
      splited_images=$(split_list "$images_list" $IMAGES_PARALLEL_NUM)
      #echo -e "[DEBUG] splited_images:\n$splited_images"

      for image_slice in $splited_images
      do
        for _image in $(echo $image_slice | tr "+++" " ")
        do
          image=${_image##*/}
          for registry in $image_registries; do
            (
            echo "[Info] Pushing image $image to Container Image Registry [$registry]."
            sudo docker tag $image $registry/$image
            sudo docker push $registry/$image
            )&
          done
        done
        wait
      done
      echo "[Info] Complete pushing all CMS images."
    fi

  fi

  # Operation for single package
  if [[ $_type == "PACKAGE" ]]; then
    
    check_packages $_packageName

    # Clean up the information for loaded images
    cat /dev/null > ${SCRIPTPATH}/loaded_images.txt

    # Load images from the container packages into bastion machine
    cd ${SCRIPTPATH}/packages
    echo "[Info] Load images from $_packageName."
    if [[  $(sudo docker load -i $_packageName >> ${SCRIPTPATH}/loaded_images.txt 2>&1; echo $?) -ne 0 ]]; then
      echo "[Error] Failed to load images from $packagename by docker load command."
      exit 1
    fi
     
    echo -e "\n[Info] Images To Be Pushed:\n=================================================================="
    cat ${SCRIPTPATH}/loaded_images.txt | sort | awk -F ': ' '{print "  "NR"\t", $2}'
    echo -e "==================================================================\n\n"

    for _image in $(cat ${SCRIPTPATH}/loaded_images.txt | sort | awk -F ': ' '{print $2}')
    do
      image=${_image##*/}
      for registry in $image_registries; do
        (
        echo "[Info] Pushing image $image to Container Image Registry [$registry]."
        sudo docker tag $image $registry/$image
        sudo docker push $registry/$image
        )&
      done
      wait
    done
    echo "[Info] Complete pushing images."
  fi

  #wait

  # Change back to previous folder
  cd - > /dev/null
  running_time
}
