terraform {
  required_providers {
    azurerm = {
      source  = "hashicorp/azurerm"
      version = "2.95.0"
    }
  }

  #The backend block will be uncomment when package as file terraform-scripts-aks-ado-pipeline.tar.gz.
  #It's used by ADO pipelines. Please keep "##" at the begining of block lines under other scenarios.

  backend "azurerm" {
    storage_account_name = "adoterraformstorage"
    container_name       = "terraform-aks"
    key                  = "terraform.tfstate"

    # rather than defining this inline, the Access Key can also be sourced
    # from an Environment Variable - more information is available below.
    access_key = "__SAKEY__"
  }  

}
