#!/bin/bash

QUERY=$1
RG=$2
RC=$3

if [[ "$QUERY" != "networkSecurityGroup" ]]; then
  if [[ $RG == *"-cms-resourcegroup" ]] ; then
    #old style rg name
    k8s_name="${RC}-cms-cluster"
  else
    #new style rg name
    k8s_name=${RC}
  fi
fi

function query() {
  list_command=$1
  count=0
  while true; do
    list_out=$(eval $list_command)
    if [[ -n "$list_out" ]] || [ $count -gt 40 ]; then
      break
    else
      sleep 30
      ((++count))
    fi
  done
  if [[ -z "$list_out" ]]; then
    echo "Failed to get the result for $to_list with command:"
    echo "$list_command"
    exit 1
  else
    printf "$list_out"
  fi
}

case $QUERY in
  "common")
      node_rg=$(az aks show -n ${k8s_name} -g ${RG} --query nodeResourceGroup --output tsv)
      location=$(az group show -g ${RG} --query location --output tsv)
      printf '{\"node_resource_group\":\"'$node_rg'\", \"location\":\"'$location'\"}'
      ;;
  "private_dns_zone")
      node_rg=$(az aks show -n ${k8s_name} -g ${RG} --query nodeResourceGroup --output tsv)
      private_dns_zone_name=$(az network private-dns zone list -g ${node_rg} --query [:1].name --output tsv)
      printf '{\"private_dns_zone_name\":\"'$private_dns_zone_name'\", \"node_resource_group\":\"'$node_rg'\"}'
      ;;
  "virtualNetworks")
      vnet_name=$(az network vnet list -g ${RG} --query [:1].name --output tsv)
      vnet_id=$(az network vnet list -g ${RG} --query [:1].id --output tsv)
      printf '{\"vnet_name\":\"'$vnet_name'\", \"vnet_id\":\"'$vnet_id'\"}'
      ;;
  "publicIPAddresses")
      public_ip_id=$(az network public-ip show -n ${RC}-ext-ip -g ${RG} --query id --output tsv)
      printf {\"public_ip_id\":\"$public_ip_id\"}
      ;;
  "networkSecurityGroup")
      NSG_NAME=$(query "az network nsg list -o table|grep -i $RG|awk '{print \$2}' ")
      printf {\"nsg_name\":\"$NSG_NAME\"}
      ;;
esac
