#This file manages high level resources used by the deployment


# Configure the Microsoft Azure Provider
provider "azurerm" {
    subscription_id = var.subscription_id
    client_id       = var.client_id
    client_secret   = var.client_secret
    tenant_id       = var.tenant_id
    partner_id      = var.partner_id
    storage_use_azuread = true
    features {}
    #version = "1.44.0"
}

# all resources will be created under the following resource group
resource "azurerm_resource_group" "cms_rg" {
    #name     = "${var.cluster_name}-cms-resourcegroup"
    name     = var.ado_pipeline ?  "rg-${var.cluster_name}" : var.resource_group_name
    location = var.azure_region

    tags = var.custom_tags

}

#set locals that will be used to merge values into the config in a provider independent way
