# this file manages the geo related resource created as part of the deployment

#Get remote resources
data "external" "r_common" {
  count = var.setup_trafficmanager_peer ? 1 : 0
  program = [
    "bash",
    "${path.cwd}/scripts/az_get.sh",
    "common",
    var.remote_resource_group,
    var.remote_cluster_name
  ]
}
data "external" "r_private_dns_zone" {
  count = var.setup_trafficmanager_peer ? 1 : 0
  program = [
    "bash",
    "${path.cwd}/scripts/az_get.sh",
    "private_dns_zone",
    var.remote_resource_group,
    var.remote_cluster_name
  ]
}
data "external" "r_virtual_network" {
  count = var.setup_trafficmanager_peer && (var.remote_existing_vnet_resource_group == "") ? 1 : 0
  program = [
    "bash",
    "${path.cwd}/scripts/az_get.sh",
    "virtualNetworks",
    var.remote_resource_group,
    var.remote_cluster_name,
    ""
  ]
}
data "external" "r_virtual_network_existing" {
  count = var.setup_trafficmanager_peer && (var.remote_existing_vnet_resource_group != "") ? 1 : 0
  program = [
    "bash",
    "${path.cwd}/scripts/az_get.sh",
    "virtualNetworks",
    var.remote_existing_vnet_resource_group,
    var.remote_cluster_name,
    var.remote_existing_vnet_name
  ]
}
data "external" "virtual_network_existing" {
  count = var.existing_virtual_network_name == "" ? 0 : 1
  program = [
    "bash",
    "${path.cwd}/scripts/az_get.sh",
    "virtualNetworks",
    var.existing_vnet_resource_group_name,
    var.cluster_name,
    var.existing_virtual_network_name
  ]
}
data "external" "r_public_ip" {
  count = var.setup_trafficmanager_peer ? 1 : 0
  program = [
    "bash",
    "${path.cwd}/scripts/az_get.sh",
    "publicIPAddresses",
    var.remote_resource_group,
    var.remote_cluster_name
  ]
}

# Create Traffic Manager Profile
resource "azurerm_traffic_manager_profile" "geo-tm" {
  count = var.setup_trafficmanager_peer ? 1 : 0
  name                   = var.remote_cluster_name
  resource_group_name    = var.remote_resource_group
  traffic_routing_method = "Priority"

  dns_config {
    relative_name = var.remote_cluster_name
    ttl           = 100
  }
  monitor_config {
    protocol                     = "http"
    port                         = 8555
    path                         = "/services/cms/health"
    interval_in_seconds          = 30
    timeout_in_seconds           = 9
    tolerated_number_of_failures = 3
  }
}

# Create Traffic Manager endpoints
resource "azurerm_traffic_manager_azure_endpoint" "primary" {
  count              = var.setup_trafficmanager_peer ? 1 : 0
  name               = "${var.cluster_name}-primary"
  profile_id         = azurerm_traffic_manager_profile.geo-tm[0].id
  weight             = 100
  priority           = 1
  target_resource_id = data.external.r_public_ip[0].result.public_ip_id
}
resource "azurerm_traffic_manager_azure_endpoint" "secondary" {
  count              = var.setup_trafficmanager_peer ? 1 : 0
  name               = "${var.cluster_name}-secondary"
  profile_id         = azurerm_traffic_manager_profile.geo-tm[0].id
  weight             = 100
  priority           = 5
  target_resource_id = azurerm_public_ip.ext_ip.id
}

# Create Vnet Peerings
resource "azurerm_virtual_network_peering" "primary-secondary" {
  count                     = var.setup_trafficmanager_peer ? 1 : 0
  name                      = "primary-secondary"
  resource_group_name       = var.remote_existing_vnet_resource_group == "" ? var.remote_resource_group : var.remote_existing_vnet_resource_group
  virtual_network_name      = var.remote_existing_vnet_name == "" ? data.external.r_virtual_network[0].result.vnet_name : var.remote_existing_vnet_name
  remote_virtual_network_id = var.existing_virtual_network_name == "" ? azurerm_virtual_network.cms_network[0].id : data.external.virtual_network_existing[0].result.vnet_id
}
resource "azurerm_virtual_network_peering" "secondary-primary" {
  count                     = var.setup_trafficmanager_peer ? 1 : 0
  name                      = "secondary-primary"
  resource_group_name       = var.existing_vnet_resource_group_name == "" ? azurerm_resource_group.cms_rg.name : var.existing_vnet_resource_group_name
  virtual_network_name      = var.existing_virtual_network_name == "" ? azurerm_virtual_network.cms_network[0].name : var.existing_virtual_network_name
  remote_virtual_network_id = var.remote_existing_vnet_name == "" ? data.external.r_virtual_network[0].result.vnet_id : data.external.r_virtual_network_existing[0].result.vnet_id
}

# Create Private DNS Network Link
resource "azurerm_private_dns_zone_virtual_network_link" "primary-secondary" {
  count                 = var.setup_trafficmanager_peer && var.setup_private_aks ? 1 : 0
  name                  = "primary-secondary"
  resource_group_name   = data.external.r_common[0].result.node_resource_group
  private_dns_zone_name = data.external.r_private_dns_zone[0].result.private_dns_zone_name
  virtual_network_id    = var.existing_virtual_network_name == "" ? azurerm_virtual_network.cms_network[0].id : data.external.virtual_network_existing[0].result.vnet_id
}
resource "azurerm_private_dns_zone_virtual_network_link" "secondary-primary" {
  count                 = var.setup_trafficmanager_peer && var.setup_private_aks ? 1 : 0
  name                  = "secondary-primary"
  resource_group_name   = azurerm_kubernetes_cluster.cms_aks.node_resource_group
  private_dns_zone_name = join(".", slice(split(".", azurerm_kubernetes_cluster.cms_aks.private_fqdn), 1, length(split(".", azurerm_kubernetes_cluster.cms_aks.private_fqdn))))
  virtual_network_id    = var.remote_existing_vnet_name == "" ? data.external.r_virtual_network[0].result.vnet_id : data.external.r_virtual_network_existing[0].result.vnet_id
}
