#===================================================
# Common variables for cloud deployment
#===================================================
variable "existing_vnet_resource_group_name" {
    description = "The resource group name of the existing virtual network."
    default     = ""
}

variable "existing_virtual_network_name" {
  description = "Use can deploy CMS into an existing virtual network within an existing resrouce group."
  default     = ""
}

variable "with_existing_azure_file_private_dns_zone" {
  description = "Is there an existing private dns zone privatelink.file.core.windows.net connected to the existing vnet?"
  default     = false
}

variable "custom_route_table_routes" {
  type = list(object({
    name = string,
    address_prefix = string,
    next_hop_type = string,
    next_hop_in_ip_address = string
  }))
  default = []
}

variable "setup_private_aks" {
  description = "Setup AKS as private cluster or not."
  default     = false
}

variable "setup_bastion_peering" {
  description = "Setup network peering between bastion and cms or not."
  default     = false
}

variable "bastion_resource_group_name" {
  description = "Resrouce group name of the bastion VM."
  default     = ""
}

variable "bastion_vnet_name" {
  description = "Virtual network name of the bastion VM."
  default     = ""
}

variable "cluster_name" {
    description = "Textual Name of this CMS cluster to be deployed, every concurrent deployment needs a unique cluster name."
}

variable "resource_group_name" {
    description = "Textual Name of azure resource group to be deployed, every concurrent deployment needs a unique resource group name."
    default     = "rg-cmsaks-default"
}

variable "dev_mode" {
  description = "True to run in development mode with smaller/cheaper instance types. Set this to true when deploy CMS for production."
  default     = false
}

variable "cms_type" {
    description = "Type of CMS deploy, valid values are enterprise and compact, should in lower-case. Just a variable threshold here, not in used in the tf files."
}

variable "external_whitelist" {
  description = "Networks to allow external connectivity from, mainly for UI access, fill with cidr format. Replace with corporate public IP address range from corporate Nat/gateway."
  default     = []
}

variable "bastion_vm_public_ip" {
  description = "The public network IP of the bastion VM. Limit the access to kubeapi from this IP only."
  default     = "10.254.254.254"
}

variable "cms_node_count" {
  description = "Node amount in the APP node pool."
  default     = 3
}

#variable "db_node_count" {
#  description = "Node amount in the DB node pool."
#  default     = 2
#}

#===================================================
# Azure specific variables
#===================================================
variable "create_ddos_protect_plan" {
  description = "Create ddos protect plan and bind it to CMS Virtual Network."
  default     = false
}

variable "custom_tags" {
    description = "customized tags for resources."
    default = {
      "Environment" = "Dev"
      "Owner" = "CMS, PDU"
    }
}

# Azure Details - where and how to create the install
variable "azure_region" {
    description = "Azure region to launch VMs into."
    #default = "westeurope"
    default = "westus"
}

variable "availability_zones" {
    description = "Zones in the region to launch VMs into."
    #default = [1,2,3]
    default = []
}

variable "subscription_id" {
    description = "Resources will be created under this Azure subscription."
}

variable "tenant_id" {
    description = "Resources will be created under this Azure tenant."
}

variable "client_id" {
    description = "Client ID used for Azure Resource Managerment API access."
}

variable "client_secret" {
    description = "Client Secret used for Azure Resource Managerment API access."
}

variable "partner_id" {
    description = "A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution."
    default = "c65a7e1e-995f-499b-8da5-56874db5d7c9"
}

variable "k8s_version" {
  description = "Version of Kubernetes used for the AKS managed cluster and Agents."
  default     = "1.18.17"
}

variable "cms_nodes_k8s_version" {
  description = "Version of Kubernetes used for cms nodes, set it to empty will deploy cms nodes with same version from k8s_version variable."
  default     = ""
}

# Node Definitions
variable "default_node_count" {
  description = "Node amount in the default node pool."
  default     = 3
}

variable "default_vm_size" {
  description = "Node vm size of nodes in the default node pool."
  default     = "Standard_D4s_v3"
}

variable "default_disk_size_gb" {
  description = "Disk size of node in the default node pool, in unit GB."
  default     = "30"
}

variable "cms_vm_size" {
  description = "Node vm size of nodes in the APP node pool."
  default     = "Standard_D8s_v3"
}

variable "cms_disk_size_gb" {
  description = "Disk size of node in the APP node pool, in unit GB. Only for OS and images, not for any CMS content or DB data."
  default     = "80"
}

variable "use_spot_vm" {
  description = "Use Azure Spot VM to save cost."
  default     = false
}

variable "cms_spot_vm_size" {
  description = "Spot vm size of nodes in the APP node pool."
  default     = ""
}

variable "cms_spot_disk_size_gb" {
  description = "Disk size of node in the APP node pool, in unit GB. Only for OS and images, not for any CMS content or DB data."
  default     = "64"
}

variable "cms_spot_max_price" {
  description = "In US dollars (USD) using up to five decimal places. For example, the value 0.98765 would be a max price of $0.98765 USD per hour. If you set the max price to -1, the instance won't be evicted based on price. As long as there's capacity and quota available, the price for the instance will be the lower price of either the current price for a Spot instance or for a standard instance."
  default     = "-1"
}


#variable "db_vm_size" {
#  description = "Node vm size of nodes in the DB node pool."
#  default     = "Standard_D2_v2"
#}

#variable "db_disk_size_gb" {
#  description = "Disk size of node in the DB node pool, in unit GB. Only for OS and images, not for any CMS content or DB data."
#  default     = "80"
#}

# Networking Defaults
variable "vnet_cidr" {
    description = "The CIDR to use when creating the virtual network. This network will be subnetted, should not use 10.0.0.0/16."
    default = "10.1.0.0/16"
}

variable "cms_private_cidr" {
    description = "The CIDR of the Subnet to create within the VNET. All VMs are created in this subnet, which is broken up into smaller subnets for each availability zone. Must be a valid subnet of the VNET cidr."
    default = "10.1.1.0/24"
}

variable "cms_storage_private_cidr" {
    description = "The CIDR of the Subnet to create within the VNET for storage-account private endpoint. Must be a valid subnet of the VNET cidr."
    default = "10.1.2.0/28"
}

variable "aks_sku_tier" {
    description = "The SKU Tier that should be used for this Kubernetes Cluster. Possible values are Free and Paid (which includes the Uptime SLA). Defaults to Free."
    default = "Free"
}

variable "kubernetes_service_cidr" {
    description = "The Service CIDR to use when creating the AKS."
    default = "10.253.0.0/20"
}

variable "kubernetes_pod_cidr" {
    description = "The POD CIDR to use when creating the AKS."
    default = "10.254.0.0/20"
}

variable "kubernetes_docker_bridge_cidr" {
    description = "The docker bridge CIDR to use when creating the AKS."
    default = "172.10.0.1/20"
}

variable "azure_lb_sku" {
    description = "SKU for Azure LB (Basic/Standard). Standard has additional cost. Standard Load Balancer is required for availability zone."
    default = "Standard"
}


# Azure Storage Account
# Note: 
# The Name of storage_account is created automatically by the scripts combined with the cluster_name and "-storage", all "-" in this whole combined string will be removed.
# This name must be unique across the entire Azure service, not just within the resource group.

variable "account_tier" {
    description = "Defines the Tier to use for this storage account. Valid options are Standard and Premium. For BlockBlobStorage and FileStorage accounts only Premium is valid. Changing this forces a new resource to be created."
    default = "Standard"
}

variable "sa_min_tls_version" {
    description = "The minimum supported TLS version for the storage account. Possible values are TLS1_0, TLS1_1, and TLS1_2."
    default = "TLS1_2"
}

variable "enable_sa_network_rules" {
    description = "To enable the networking rules for storage account or not."
    default = true
}

variable "account_replication_type" {
    description = "Defines the type of replication to use for this storage account. Valid options are LRS, GRS, RAGRS and ZRS."
    default = "LRS"
}

variable "account_kind" {
    description = "Defines the Kind of account. Valid options are BlobStorage, BlockBlobStorage, FileStorage, Storage and StorageV2. Changing this forces a new resource to be created. Defaults to StorageV2."
    default = "StorageV2"
}

variable "access_tier" {
    description = "Defines the access tier for BlobStorage, FileStorage and StorageV2 accounts. Valid options are Hot and Cool, defaults to Hot."
    default = "Hot"
}

variable "storageclass_sku" {
    description = "Define the Storage Class type, possible values are Standard_LRS and Premium_LRS. For more details, refer to https://docs.microsoft.com/en-us/azure/aks/azure-files-dynamic-pv#create-a-storage-class."
    default = "Standard_LRS"
}

variable "use_azure_blob_storage" {
    description = "Use azure-blob container storage as NAS share."
    default = false
}

variable "use_azure_file_storage" {
    description = "Use azure-file storage as NAS share."
    default = true
}

#===================================================
# GCP specific variables
#===================================================
variable "master_version" {
  description = "The minimum Kubernetes version running in the cluster."
  default     = "1.17"
}

variable "project" {
  description = "Project ID on GCP for the CMS deployment."
  default     = "tvaas-poc"
}

variable "region" {
  description = "The GCP location for the CMS deployment."
  default = "us-west1"
}

variable "node_zones" {
  description = "The expected Zones within the region where the node instances will be created at."
  default = ["us-west1-a", "us-west1-b", "us-west1-c"]
}

variable "gcr" {
  description = "The GCP docker image registry."
  default = "gcr.io"
}

variable "bastion_gcp_vpc_name" {
  description = "The GCP VPC network to which the bastion VM belong."
  default = "bastion"
}

variable "cms_vpc_name" {
  description = "The CIDR of the VPC to be created for the CMS deployment."
  default     = "cms-network"
}

variable "cms_gke_subnet" {
  description = "The CIDR of the Subnet to create within the VPC. All VMs are created in this subnet, which is broken up into smaller subnets for each availability zone. Must be a valid subnet of the VPC cidr."
  default     = "10.1.1.0/24"
}

variable "pod_subnet_cidr" {
  description = "The CIDR of the POD Subnet to create as secondary ip range in the cms gke vpc subnet."
  default     = "10.8.0.0/14"
}

variable "svc_subnet_cidr" {
  description = "The CIDR of the Service Subnet to create as secondary ip range in the cms gke vpc subnet."
  default     = "10.1.32.0/20"
}

variable "app_machine_type" {
  description = "Machine type for nodes to deploy cms applications."
  default     = "n1-standard-1"
}

variable "db_machine_type" {
  description = "Machine type for nodes to deploy postgresql instance."
  default     = "n1-standard-1"
}

variable "fielstore_size" {
  description = "Amount of GB of disk space to alloate to filestore. Minimum is 1024."
  default     = "1024"
}



#===================================================
# Dummy variables to suit the cms.var file
#===================================================
variable "pg_disk_size" {
  description = "Amount of GB of disk space to alloate to disk for Postgresql."
  default     = ""
}

variable "cms_namespace" {
  description = "CMS Namespace."
  default     = ""
}

variable "cluster_role" {
  description = "cluster_role"
  default     = ""
}

variable "existing_aks_resource_group_name" {
  description = "existing_aks_resource_group_name"
  default     = ""
}

variable "cms_timezone" {
  description = "cms_timezone"
  default     = ""
}

variable "internal_ct_enabled" {
  description = "internal_ct_enabled"
  default     = ""
}

variable "image_registry" {
  description = "image_registry"
  default     = ""
}

variable "image_registry_instances" {
  description = "image_registry_instances"
  default     = ""
}

variable "external_vip" {
  description = "external_vip"
  default     = ""
}

variable "internal_vip" {
  description = "internal_vip"
  default     = ""
}

variable "core_vip" {
  description = "core_vip"
  default     = ""
}

variable "nas_server_ip" {
  description = "nas_server_ip"
  default     = ""
}

variable "nas_share" {
  description = "nas_share"
  default     = ""
}

variable "content_nas_server_ip" {
  description = "content_nas_server_ip"
  default     = ""
}

variable "content_nas_share" {
  description = "content_nas_share"
  default     = ""
}

variable "content_nas_size" {
  description = "content_nas_size"
  default     = ""
}

variable "backup_nas_server_ip" {
  description = "backup_nas_server_ip"
  default     = ""
}

variable "backup_nas_share" {
  description = "backup_nas_share"
  default     = ""
}

variable "cloud_platform" {
  description = "cloud_platform"
  default     = ""
}

variable "ftp_enable" {
  description = "ftp_enable"
  default     = ""
}

variable "ftp_passiveportMin" {
  description = "ftp_passiveportMin"
  default     = ""
}

variable "ftp_passiveportMax" {
  description = "ftp_passiveportMax"
  default     = ""
}

variable "ftp_user" {
  description = "ftp_user"
  default     = ""
}

variable "ftp_password" {
  description = "ftp_password"
  default     = ""
}

variable "tag_environment" {
    description = "tag_environment"
    default = ""
}

variable "acr_name" {
  description = "acr_name"
  default     = ""
}

variable "image_pull_user" {
    description = "image_pull_user"
    default = ""
}

variable "image_pull_password" {
  description = "image_pull_password"
  default     = ""
}

variable "run_filebeat_as_user_id" {
    description = "The user id running filebeat"
    default = ""
}

variable "run_filebeat_as_group_id" {
  description = "The group id running filebeat"
  default     = ""
}

variable "cms_tomcat_umask" {
  description = "The umask applies to filemanager / imagemagick / ffmpeg / fileuploader containers through 'UMASK' environment variable."
  default     = ""
}

variable "cms_admin_service_account_name" {
  description = "dummy variable."
  default     = ""
}

variable "elasticstack_manage_user" {
  description = "dummy variable."
  default     = ""
}

variable "elasticstack_manage_password" {
  description = "dummy variable."
  default     = ""
}

variable "elasticstack_monitor_user" {
  description = "dummy variable."
  default     = ""
}

variable "elasticstack_monitor_password" {
  description = "dummy variable."
  default     = ""
}

variable "apparmor_profile_name" {
  description = "dummy variable."
  default     = ""
}

variable "limited_deployment" {
  description = "dummy variable."
  default     = false
}

variable "allow_root_user_for_init_container" {
  description = "dummy variable."
  default     = true
}

variable "allow_host_path" {
  description = "dummy variable."
  default     = true
}

variable "pod_security_policy_name" {
  description = "dummy variable."
  default     = ""
}

variable "storageclass_name" {
  description = "dummy variable."
  default     = ""
}

variable "setup_trafficmanager_peer" {
  description = "dummy variable."
  default     = false
}

variable "remote_cluster_name" {
  description = "dummy variable."
  default     = ""
}

variable "remote_resource_group" {
  description = "dummy variable."
  default     = ""
}

variable "remote_existing_vnet_resource_group" {
  description = "Remote cluster Azure resource group name of existing vnet."
  default     = ""
}

variable "remote_existing_vnet_name" {
  description = "Remote cluster Azure network name of existing vnet."
  default     = ""
}

variable "additional_external_cidr_to_8443" {
  description = "Additional cidr for public access to port 8443 besides IP ranges from external_whitelist."
  default     = []
}

variable "ado_pipeline" {
  type = bool
  description = "The variable that identify tf-scripts running in an ADO pipeline."
  default     = false
}

variable "k8s_platform" {
  description = "dummy variable."
  default     = ""
}

variable "allow_webhook" {
  description = "dummy variable."
  default     = true
}

variable "allow_create_node_label" {
  description = "dummy variable."
  default     = true
}

variable "k8s_cluster_domain" {
  description = "dummy variable."
  default     = "cluster.local"
}

variable "cms_adi_server_extra_labels" {
  description = "extra labels for cms_adi_server component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_workflow_extra_labels" {
  description = "extra labels for cms_workflow component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_metadata_manager_extra_labels" {
  description = "extra labels for cms_metadata_manager component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_epg_extra_labels" {
  description = "extra labels for cms_epg component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_ftp_extra_labels" {
  description = "extra labels for cms_ftp component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_monitoring_extra_labels" {
  description = "extra labels for cms_monitoring component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_filemanager_extra_labels" {
  description = "extra labels for cms_filemanager component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_filemanager_heavy_extra_labels" {
  description = "extra labels for cms_filemanager_heavy component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_content_access_extra_labels" {
  description = "extra labels for cms_content_access component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_user_portal_extra_labels" {
  description = "extra labels for cms_user_portal component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_ui_extra_labels" {
  description = "extra labels for cms_ui component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_ct_manager_extra_labels" {
  description = "extra labels for cms_ct_manager component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_imagemagick_extra_labels" {
  description = "extra labels for cms_imagemagick component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_ffmpeg_extra_labels" {
  description = "extra labels for cms_ffmpeg component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_fileuploader_extra_labels" {
  description = "extra labels for cms_fileuploader component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_watchfolder_extra_labels" {
  description = "extra labels for cms_watchfolder component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_oauth_extra_labels" {
  description = "extra labels for cms_oauth component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_snmp_subagent_extra_labels" {
  description = "extra labels for cms_snmp_subagent component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_swagger_ui_extra_labels" {
  description = "extra labels for cms_swagger_ui component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_postgresql_extra_labels" {
  description = "extra labels for cms_postgresql component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_pg_metadata_manager_extra_labels" {
  description = "extra labels for cms_pg_metadata_manager component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_pg_workflow_extra_labels" {
  description = "extra labels for cms_pg_workflow component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_pg_epg_extra_labels" {
  description = "extra labels for cms_pg_epg component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_postgresql_metrics_extra_labels" {
  description = "extra labels for cms_postgresql_metrics component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_etcd_extra_labels" {
  description = "extra labels for cms_etcd component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_webhook_extra_labels" {
  description = "extra labels for cms_webhook component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_elastalert_extra_labels" {
  description = "extra labels for cms_elastalert component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_elasticsearch_extra_labels" {
  description = "extra labels for cms_elasticsearch component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_esLogging_extra_labels" {
  description = "extra labels for cms_esLogging component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_esApplication_extra_labels" {
  description = "extra labels for cms_esApplication component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_esLogging_purge_extra_labels" {
  description = "extra labels for cms_esLogging_purge component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_haproxy_extra_labels" {
  description = "extra labels for cms_haproxy component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_kibana_extra_labels" {
  description = "extra labels for cms_kibana component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_metricbeat_extra_labels" {
  description = "extra labels for cms_metricbeat component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_filebeat_extra_labels" {
  description = "extra labels for cms_filebeat component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_logstash_extra_labels" {
  description = "extra labels for cms_logstash component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_nfs_extra_labels" {
  description = "extra labels for cms_nfs component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_rabbitmq_extra_labels" {
  description = "extra labels for cms_rabbitmq component."
  default = {
    "Environment" = "Prod"
  }
}

variable "cms_redis_extra_labels" {
  description = "extra labels for cms_redis component."
  default = {
    "Environment" = "Prod"
  }
}

variable "user_modified_storageclass" {
  description = "user_modified_storageclass"
  default     = ""
}

variable "db_local_volume_prefix" {
  description = "db_local_volume_prefix"
  default     = ""
}

variable "cluster_api_server_url" {
  description = "cluster_api_server_url"
  default     = ""
}
