resource "azurerm_storage_account" "blobstorageaccount" {
  count =  var.use_azure_blob_storage ? 1 : 0
  # The name must conform to the following pattern: '^[a-zA-Z0-9]*$ and less than 24 charaters. 
  # This name must be unique across the entire Azure service, not just within the resource group.
  name                     = substr(replace("blob${var.cluster_name}-storage","-",""),0,23)
  resource_group_name      = azurerm_resource_group.cms_rg.name
  location                 = var.azure_region
  # Add dev_mode for account_tier
  account_tier             = var.account_tier
  account_replication_type = var.account_replication_type
  account_kind             = var.account_kind
  access_tier              = var.access_tier
  #enable_file_encryption   = "false"
  min_tls_version          = var.sa_min_tls_version

  shared_access_key_enabled  = false

  # In order to run the terraform scripts to create blob-containers,
  # it is necessary to enable the public network access.
  # User can manually disable this option from auzre-portal later on.
  #public_network_access_enabled = false

  # Need to enable the hns and nfsv3 for using SC azureblob-nfs-premium
  is_hns_enabled = true
  nfsv3_enabled  = true
  sftp_enabled  = true

  dynamic "network_rules" {
    for_each = var.enable_sa_network_rules ? ["yes"] : []
    content {
      default_action             = "Deny"
      virtual_network_subnet_ids = [azurerm_subnet.cms_subnet.id]
      # Need to ensure the bastion_vm_public_ip is added for creating or deleting containers
      # For ADO pipeline running, may need to use az cli/API to add the dynamic pipeline agent's ip into ip_rules
      ip_rules = split(",", (replace(join(",", (var.bastion_vm_public_ip == "" ? var.external_whitelist : concat(["${var.bastion_vm_public_ip}/32"], var.external_whitelist))), "/32", "")))
    }
  }
 
  tags = var.custom_tags
}

resource "azurerm_storage_container" "backuprestore" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "backup-restore"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

resource "azurerm_storage_container" "cmsconf" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "cms-conf"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

resource "azurerm_storage_container" "cmscontent" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "cms-content"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

resource "azurerm_storage_container" "cmsmmcontent" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "cms-mm-content"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

resource "azurerm_storage_container" "cmsplugin" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "cms-plugin"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

resource "azurerm_storage_container" "cmsserviceclient" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "cms-service-client"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

resource "azurerm_storage_container" "cmssyncutils" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "cms-sync-utils"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

resource "azurerm_storage_container" "cmsworkflowruntime" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "cms-workflow-runtime"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

resource "azurerm_storage_container" "cmswatchfolderruntime" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "cms-watchfolder-runtime"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

resource "azurerm_storage_container" "cmscliplugin" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "cmscli-plugin"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

resource "azurerm_storage_container" "cmsesappsnapshot" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "cms-es-application-snapshot"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

resource "azurerm_storage_container" "cmseslogsnapshot" {
  count =  var.use_azure_blob_storage ? 1 : 0
  name                  = "cms-es-logging-snapshot"
  storage_account_name  = azurerm_storage_account.blobstorageaccount[0].name
  # Possible values are blob, container or private. Defaults to private
  container_access_type = "private"
}

output "OUTPUT_BLOB_STORAGEACCOUNT_NAME" {
  depends_on = [azurerm_storage_account.blobstorageaccount]
  value = var.use_azure_blob_storage ? (azurerm_storage_account.blobstorageaccount[0].name) : ""
}


