# elasticsearch

[elasticsearch]cms elasticsearch server.

## TL;DR;

```bash
$ helm install helm_repo/cms-elasticsearch
```

## Introduction


## Prerequisites

- Kubernetes 1.4+ with Beta APIs enabled
- PV provisioner support in the underlying infrastructure

## Installing the Chart

To install the chart with the release name `my-release`:

```bash
$ helm install --name my-release helm_repo/cms-elasticsearch
```

Test command
```bash
$ cd /root/cms-container-elasticsearch/chart
$ helm install --tls --host=localhost:30010 --name=myelasticsearch --values=cms-elasticsearch-values.yaml --debug ./cms-elasticsearch
```

> **Tip**: List all releases using `helm list`

## Uninstalling the Chart

To uninstall/delete the `my-release` deployment:

```bash
$ helm delete my-release
```

The command removes all the Kubernetes components associated with the chart and deletes the release.


## Configuration

The following tables lists the configurable parameters of the elasticsearch chart and their default values.

|                   Parameter                   |                                                                                Description                                                                                |                            Default                            |
|-----------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------|
| `esJavaOpts`                        | Java options for Elasticsearch. This is where you should configure the jvm heap size | `-Xmx1g -Xms1g`                                                         |
| `replicas`        | Kubernetes replica count for the statefulset (i.e. how many pods)                                                                                                                      | `3`                                                         |
| `esMajorVersion`        | Used to set major version specific configuration. If you are using a custom image and not running the default Elasticsearch version you will need to set this to the version you are running (e.g. esMajorVersion: 6)                                                                                                                      | `6`                                                         |
| `resources`                        | Allows you to set the [resources](https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/) for the statefulset                                                                                                                                                                                | `requests.cpu: 1000m`<br>`requests.memory: 2Gi`<br>`limits.cpu: 1000m`<br>`limits.memory: 2Gi`                            |
| `volumeClaimTemplate`              | Configuration for the [volumeClaimTemplate for statefulsets](https://kubernetes.io/docs/concepts/workloads/controllers/statefulset/#stable-storage). You will want to adjust the storage (default `50Gi`) and the `storageClassName` if you are using a different storage class                                             | `accessModes: [ "ReadWriteOnce" ]`<br>`resources.requests.storage: 50Gi`                                                  |

## NetworkPolicy


## Persistence


### Existing PersistentVolumeClaim

