{{/* vim: set filetype=mustache: */}}
{{/*
Expand the name of the chart.
*/}}
{{- define "cms-logstash.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "cms-logstash.fullname" -}}
{{- if .Values.fullnameOverride -}}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- $name := default .Chart.Name .Values.nameOverride -}}
{{- if contains $name .Release.Name -}}
{{- .Release.Name | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" -}}
{{- end -}}
{{- end -}}
{{- end -}}

{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "cms-logstash.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{/*
Merge with existing alerts.yaml to handle upgrade.
*/}}
{{- define "alertsyaml" -}}
  {{- $mergedAlertsDict := dict -}}
  {{- $buildinAlertsDict := dict -}} 
  {{- $existingAlertsDict := dict -}}
  {{- if (lookup "v1" "ConfigMap" .Release.Namespace "cms-logstash-alerts") -}}
    {{- $existingAlertsString := index (lookup "v1" "ConfigMap" .Release.Namespace "cms-logstash-alerts").data "alerts.yaml" -}}
    {{- $existingAlertsList := split "- alert:" $existingAlertsString -}}
    {{- range $index,$alert := $existingAlertsList -}}
      {{- $alertcontent := fromYaml $alert -}}
      {{- if $alertcontent -}}
        {{- if hasKey $alertcontent "trap" -}}
          {{- $_ := set $existingAlertsDict (get $alertcontent "trap" | toString) $alertcontent -}}
        {{- else -}}
          {{- $_ := set $existingAlertsDict (printf "_%s" ($index|toString)) $alertcontent -}}
        {{- end -}}
      {{- end -}}
    {{- end -}}
    {{- range $index,$alert := .Values.cms_alerts_yaml -}}
      {{- $alertcontent := get $alert "alert" -}}
      {{- if $alertcontent -}}
        {{- if hasKey $alertcontent "trap" -}}
          {{- $_ := set $buildinAlertsDict (get $alertcontent "trap" | toString) $alertcontent -}}
        {{- else -}}
          {{- $_ := set $buildinAlertsDict (printf "_%s" ($index|toString)) $alertcontent -}}
        {{- end -}}
      {{- end -}}
    {{- end -}}  
    {{- $_ := mergeOverwrite $mergedAlertsDict $existingAlertsDict $buildinAlertsDict -}}
    {{- range $index,$trap_id := (keys $mergedAlertsDict | sortAlpha) }}
{{ print "- alert:" | indent 4 }}
{{ toYaml (get $mergedAlertsDict ($trap_id | toString))|indent 8 }}
    {{- end -}} 
  {{- else -}}
    {{- toYaml .Values.cms_alerts_yaml | indent 4 -}}
  {{- end -}}
{{- end -}}