# cms-ftp

[cms-ftp]CMS FTP service, running deployment on cms-ftp image with replicas set to 1, mounting pvc-content

## TL;DR;


## 1. Enabling the FTP service
## 2. expanding the FTP service port ranges
## 3. expanding deployment pods

# 1. To enable the FTP service, create base64 password code for the ftp user, set "enable=true", then update them into the products-var.yaml file and deploy using deploy-cms.sh to update the release "cms-ftp-0"
```bash
# echo "PASSWORDSTRING"|base64
# vi /opt/cms/ConfigBundle/products-var.yaml
  cms_ftp:
    enable=true
    passiveportMin: 10000
    passiveportMax: 10099
    user: cms
    uid: 2000
    gid: 2000
    password_b64: Y21zMTIzNA==
# /opt/cms/deploy-cms.sh deploy -n cms-ftp-0 -c cms-ftp -v 9.0.0 

```
# 2. To expand the FTP service port ranges, update the passiveportMin and passiveportMax. Deploy using deploy-cms.sh to update the release "cms-ftp-0"
```bash
# vi /opt/cms/ConfigBundle/products-var.yaml
  cms_ftp:
    enable=true
    passiveportMin: 10000
    passiveportMax: 10199
# /opt/cms/deploy-cms.sh deploy -n cms-ftp-0 -c cms-ftp -v 9.0.0 

```
# 3. To expanding deployment pods, eg deploy a new release "cms-ftp-1". Set the enable=true and new ports range in products-var.yaml, others values need to keep the same as original release "cms-ftp-0" 
```bash
# vi /opt/cms/ConfigBundle/products-var.yaml
  cms_ftp:
    enable=true
    passiveportMin: 10200
    passiveportMax: 10299
# /opt/cms/deploy-cms.sh deploy -n cms-ftp-1 -c cms-ftp -v 9.0.0 
```

## Configuration

The following tables lists the configurable parameters of the cms-container-tools chart and their default values.

|           Parameter           |                Description                          |           Default            |
|-------------------------------|--------------------------------------------------   |------------------------------|
| `image.repository`            | Dock image repository                               | `""`                         |
| `image.tag`                   | Dock image tag                                      | `latest`                     |
| `image.PullPolicy`            | Image pull policy                                   | `IfNotPresent`               |
| `resources.requests.memory`   | Resource memory request                             | `100M`                       |
| `resources.requests.cpu`      | Resource cpu request                                | `30m`                        |
| `resources.limits.memory`     | Resource memory limit                               | `2Gi`                        |
| `resources.limits.cpu`        | Resource cpu limit                                  | `2000m`                      |
| `enable`                      | Control whether to enable the service: true,false   | `false`                      |
| `passiveportMin`              | The passive minimal port: number                    | `10000`                      |
| `passiveportMax`              | The passive maxmum port: number                     | `10099`                      |
| `user`                        | The user account name to access ftp service: string | `cms`                        |
| `uid`                         | The uid for the user account: number                | `2000`                       |
| `gid`                         | The uid for the user account: number                | `2000`                       |
| `password_b64`                | The password coded by base64: base64 code           | `false`                      |
| `contentmount`                | The mountpoint for pvc-content: path                | `/content`                   |

## NetworkPolicy

## Persistence

### Existing PersistentVolumeClaim

