# metricbeat

[metricbeat]cms metricbeat server.

## TL;DR;

```bash
$ helm install helm_repo/cms-metricbeat
```

## Introduction


## Prerequisites

- Kubernetes 1.4+ with Beta APIs enabled
- PV provisioner support in the underlying infrastructure

## Installing the Chart

To install the chart with the release name `my-release`:

```bash
$ helm install --name my-release helm_repo/cms-metricbeat
```

Test command
```bash
$ cd /root/cms-container-metricbeat/chart
$ helm install --tls --host=localhost:30010 --name=mymetricbeat --values=cms-metricbeat-values.yaml --debug ./cms-metricbeat
```

> **Tip**: List all releases using `helm list`

## Uninstalling the Chart

To uninstall/delete the `my-release` deployment:

```bash
$ helm delete my-release
```

The command removes all the Kubernetes components associated with the chart and deletes the release.


## Configuration

The following tables lists the configurable parameters of the metricbeat chart and their default values.

|                   Parameter                   |                                                                                Description                                                                                |                            Default                            |
|-----------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------|
| `daemonset.hostNetworking`     | Enable Metricbeat DaemonSet to use `hostNetwork`                                                                                                                             | `false`                              |
| `imageTag`                     | The Metricbeat Docker image tag                                                                                                                                              | `6.8.13-oss`                              |
| `image`                        | The Metricbeat Docker image                                                                                                                                                  | `docker.elastic.co/beats/metricbeat` |
| `livenessProbe`                | Parameters to pass to liveness [probe][] checks for values such as timeouts and thresholds                                                                                   | see [values.yaml][]                  |
| `readinessProbe`               | Parameters to pass to readiness [probe][] checks for values such as timeouts and thresholds                                                                                  | see [values.yaml][]                  |
| `rootcert`               | Root certificate                                                                                  | null                  |
| `cert`               | Certificate                                                                                  | null                  |
| `key`               | Key file                                                                                  | null                  |
## NetworkPolicy


## Persistence


### Existing PersistentVolumeClaim

