{{/* vim: set filetype=mustache: */}}
{{/*
Expand the name of the chart.
*/}}
{{- define "stolon.name" -}}
{{- $name := default .Chart.Name .Values.nameOverride -}}
{{- if contains $name .Release.Name -}}
{{- .Release.Name | trunc 55 | trimSuffix "-" -}}
{{- else -}}
{{- printf "%s-%s" .Release.Name $name | trunc 55 | trimSuffix "-" -}}
{{- end -}}
{{- end -}}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "stolon.fullname" -}}
{{- if .Values.fullnameOverride -}}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- $name := default .Chart.Name .Values.nameOverride -}}
{{- if contains $name .Release.Name -}}
{{- .Release.Name | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" -}}
{{- end -}}
{{- end -}}
{{- end -}}

{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "stolon.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" -}}
{{- end -}}


{{/* Create the name of the service account to use */}}
{{- define "stolon.serviceAccountName" -}}
    {{ default "default" .Values.serviceAccount.name }}
{{- end -}}

{{- define "stolon.clusterName" -}}
{{- if eq .Release.Name "cms-pg-metadata-manager" -}}
    {{- .Values.cmsClusterName | trunc 63 | trimSuffix "-" -}}
{{- else if eq .Release.Name "cms-pg-workflow" -}}
    {{- .Values.wfsClusterName | trunc 63 | trimSuffix "-" -}}
{{- else if eq .Release.Name "cms-pg-epg" -}}
    {{- .Values.epgClusterName | trunc 63 | trimSuffix "-" -}}
{{- else -}} 
    {{- template "stolon.fullname" . -}}
{{- end -}}
{{- end -}}

{{- define "stolon.nodeSelector" -}}
{{- if eq .Release.Name "cms-pg-metadata-manager" -}}
    {{- .Values.cmsdbNodeSelector -}}
{{- else if eq .Release.Name "cms-pg-workflow" -}}
    {{- .Values.wfdbNodeSelector -}}
{{- else if eq .Release.Name "cms-pg-epg" -}}
    {{- .Values.epgdbNodeSelector -}}
{{- else -}} 
    {{- .Values.cmsdbNodeSelector -}}
{{- end -}}
{{- end -}}

{{- define "stolon.keeper.resources" -}}
{{- if eq .Release.Name "cms-pg-metadata-manager" -}}
    {{ toYaml .Values.cmskeeper.resources }}
{{- else if eq .Release.Name "cms-pg-workflow" -}}
    {{ toYaml .Values.wfskeeper.resources -}}
{{- else if eq .Release.Name "cms-pg-epg" -}}
    {{ toYaml .Values.epgkeeper.resources }}
{{- else -}} 
    {{ toYaml .Values.keeper.resources }}
{{- end -}}
{{- end -}}

{{- define "stolon.keeper.storage" -}}
{{- if eq .Release.Name "cms-pg-metadata-manager" -}}
    {{ .Values.cmskeeper.storage }}
{{- else if eq .Release.Name "cms-pg-workflow" -}}
    {{ .Values.wfskeeper.storage -}}
{{- else if eq .Release.Name "cms-pg-epg" -}}
    {{ .Values.epgkeeper.storage }}
{{- else -}}
    {{ .Values.keeper.storage }}
{{- end -}}
{{- end -}}

{{- define "stolon.proxy.service" -}}
{{- if eq .Release.Name "cms-pg-metadata-manager" -}}
    {{ .Values.service.cmsServiceName }}
{{- else if eq .Release.Name "cms-pg-workflow" -}}
    {{ .Values.service.wfsServiceName }}
{{- else if eq .Release.Name "cms-pg-epg" -}}
    {{ .Values.service.epgServiceName }}
{{- else -}} 
    {{ .Values.service.cmsServiceName }}
{{- end -}}
{{- end -}}

{{- define "stolon.keeper.replicaCount" -}}
{{- if eq .Release.Name "cms-pg-metadata-manager" -}}
    {{ .Values.cmskeeper.replicaCount }}
{{- else if eq .Release.Name "cms-pg-workflow" -}}
    {{ .Values.wfskeeper.replicaCount }}
{{- else if eq .Release.Name "cms-pg-epg" -}}
    {{ .Values.epgkeeper.replicaCount }}
{{- else -}} 
    {{ .Values.keeper.replicaCount }}
{{- end -}}
{{- end -}}

{{- define "pg.backup.storage" -}}
{{- if eq .Release.Name "cms-pg-metadata-manager" -}}
    {{ .Values.backupdata.cmsBackupFolder }}
{{- else if eq .Release.Name "cms-pg-workflow" -}}
    {{ .Values.backupdata.wfBackupFolder -}}
{{- else if eq .Release.Name "cms-pg-epg" -}}
    {{ .Values.backupdata.epgBackupFolder }}
{{- else -}}
    {{ .Values.backupdata.backupFolder }}
{{- end -}}
{{- end -}}