# nfs

[nfs]cms nfs server.

## TL;DR;

```bash
$ helm install helm_repo/cms-nfs
```

## Introduction


## Prerequisites

- Kubernetes 1.4+ with Beta APIs enabled
- PV provisioner support in the underlying infrastructure

## Installing the Chart

To install the chart with the release name `my-release`:

```bash
$ helm install --name my-release helm_repo/cms-nfs
```

Test command
```bash
$ cd /root/cms-container-cms-nfs/chart
$ helm install --tls --host=localhost:30010 --name=mycms-nfs --values=cms-nfs-values.yaml --debug ./cms-nfs
```

> **Tip**: List all releases using `helm list`

## Uninstalling the Chart

To uninstall/delete the `my-release` deployment:

```bash
$ helm delete my-release
```

The command removes all the Kubernetes components associated with the chart and deletes the release.


## Configuration

The following tables lists the configurable parameters of the nfs chart and their default values.

|                   Parameter                   |                                                                                Description                                                                                |                            Default                            |
|-----------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------|
| `nfs.server`                      | Hostname of the NFS server                  | null (ip or hostname)                                     |
| `nfs.path`                        | Basepath of the mount point to be used      | `/ifs/kubernetes`                                         |
| `storageClass.name`               | Name of the storageClass                    | `nfs-client`                                              |
| `nfs.mountOptions`                | Mount options (e.g. 'nfsvers=3')            | null                                                      |
| `replicaCount`                    | Number of provisioner instances to deployed | `1`                                                         |
| `storageClass.reclaimPolicy`    | Method used to reclaim an obsoleted volume                 | `Delete` 	                              |
| `storageClass.archiveOnDelete`    | Archive pvc when deleting                   | `true` 	                                              |
| `resources`                       | Resources required (e.g. CPU, memory)       | `{}`                                                      |
| `storageClass.defaultClass`       | Set as the default StorageClass             | `false`	                                              |
| `nodeSelector`                    | Node labels for pod assignment              | `{}`                                                      |


## NetworkPolicy


## Persistence


### Existing PersistentVolumeClaim

