{{/* vim: set filetype=mustache: */}}
{{/*
Expand the name of the chart.
*/}}
{{- define "cms-geo-essync.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "cms-geo-essync.fullname" -}}
{{- if .Values.fullnameOverride -}}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- $name := default .Chart.Name .Values.nameOverride -}}
{{- if contains $name .Release.Name -}}
{{- .Release.Name | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" -}}
{{- end -}}
{{- end -}}
{{- end -}}

{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "cms-geo-essync.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{- define "sync.mainClass" -}}
{{- if eq .Release.Name "cms-geo-essync-title" -}}
    {{- .Values.titleMain -}}
{{- else if eq .Release.Name "cms-geo-essync-wo" -}}
    {{- .Values.workflowMain -}}
{{- else -}}
    {{- .Values.titleMain -}}
{{- end -}}
{{- end -}}

{{- define "syncContainer.name" -}}
{{- if eq .Release.Name "cms-geo-essync-title" -}}
    {{- .Values.titleSyncContainerName -}}
{{- else if eq .Release.Name "cms-geo-essync-wo" -}}
    {{- .Values.woSyncContainerName -}}
{{- else -}}
    {{- .Values.titleSyncContainerName -}}
{{- end -}}
{{- end -}}
